/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.pcs.formplugin.web.costallot;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ObjectConverter;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.ShowType;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.events.SetFilterEvent;
import kd.bos.form.field.events.BeforeFilterF7SelectEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.list.BillList;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.util.CollectionUtils;
import kd.swc.hsbp.business.cost.CostHelper;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.common.enums.CalPayrollTaskStateEnum;
import kd.swc.hsbp.common.util.SWCObjectUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hsbp.formplugin.web.SWCDataBaseList;
import kd.swc.pcs.business.costallot.CostAllotDetailHelper;
import kd.swc.pcs.business.costallot.helper.AllotDetailHelper;
import kd.swc.pcs.business.costallot.helper.CostAllotHelper;
import kd.swc.pcs.business.costmap.service.CostItemMapService;
import kd.swc.pcs.formplugin.web.costallot.CostAllotBillList;

public class CostAllotTaskList
extends SWCDataBaseList {
    private static final Log LOGGER = LogFactory.getLog(CostAllotBillList.class);
    private static final String TASK_TYPE_HIS = "2";

    public void setFilter(SetFilterEvent args) {
        super.setFilter(args);
        args.setOrderBy("modifytime desc,createtime desc,caltask.number asc");
    }

    public void beforeBindData(EventObject arg) {
        this.getView().setVisible(Boolean.valueOf(CostHelper.isEnableCost()), new String[]{"generatecostdetail"});
    }

    public void filterColumnSetFilter(SetFilterEvent args) {
        super.filterColumnSetFilter(args);
        String fieldName = args.getFieldName();
        List filters = args.getQFilters();
        switch (fieldName) {
            case "caltask.payrollgroup.id": 
            case "caltask.payrollgroup.name": 
            case "caltask.payrollscene.id": 
            case "caltask.payrollscene.name": {
                Set payRollCalSet = SWCPermissionServiceHelper.getPayrollCalSetByPermItem((String)"1ANC8T4UC434", (String)"pcs_allottask", (String)"47150e89000000ac");
                if (payRollCalSet == null) break;
                QFilter qFilter = new QFilter("org.id", "in", (Object)payRollCalSet);
                filters.add(qFilter);
                break;
            }
        }
    }

    public void filterContainerBeforeF7Select(BeforeFilterF7SelectEvent args) {
        super.filterContainerBeforeF7Select(args);
        String fieldName = args.getFieldName();
        List filters = args.getQfilters();
        switch (fieldName) {
            case "caltask.id": 
            case "caltask.name": 
            case "caltask.number": {
                this.addCalTaskFilter(filters);
                break;
            }
            case "costadapter.id": 
            case "costadapter.name": {
                CostItemMapService service = new CostItemMapService();
                service.addCostAdapterFilter(filters, "pcs_allottask");
                break;
            }
            case "caltask.payrollgroup.id": 
            case "caltask.payrollgroup.name": 
            case "caltask.payrollscene.id": 
            case "caltask.payrollscene.name": {
                Set payRollCalSet = SWCPermissionServiceHelper.getPayrollCalSetByPermItem((String)"1ANC8T4UC434", (String)"pcs_allottask", (String)"47150e89000000ac");
                if (payRollCalSet == null) break;
                QFilter qFilter = new QFilter("org.id", "in", (Object)payRollCalSet);
                filters.add(qFilter);
                break;
            }
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        ListShowParameter listShowParameter = (ListShowParameter)this.getView().getFormShowParameter();
        if (listShowParameter.isLookUp()) {
            return;
        }
        String fieldName = args.getHyperLinkClickEvent().getFieldName();
        if (SWCStringUtils.equals((String)"caltask_name", (String)fieldName)) {
            BillList billList = (BillList)args.getHyperLinkClickEvent().getSource();
            Long costAllocationPkId = (Long)billList.getCurrentSelectedRowInfo().getPrimaryKeyValue();
            this.clickNameHyperLink(costAllocationPkId);
            args.setCancel(true);
        }
    }

    private void clickNameHyperLink(Long costAllotPkId) {
        DynamicObject calTaskObj = CostAllotHelper.getCostAllotCalTaskId((Long)costAllotPkId);
        if (SWCObjectUtils.isEmpty((Object)calTaskObj)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u3002", (String)"CostAllotTaskList_5", (String)"swc-pcs-formplugin", (Object[])new Object[0]));
            return;
        }
        long calTaskId = calTaskObj.getLong("caltask.id");
        String calTaskName = calTaskObj.getString("caltask.name");
        QFilter filter = new QFilter("caltask.id", "=", (Object)calTaskId);
        ListShowParameter showParameter = new ListShowParameter();
        ListFilterParameter listFilterParameter = new ListFilterParameter();
        listFilterParameter.setFilter(filter);
        showParameter.setListFilterParameter(listFilterParameter);
        if (calTaskName.length() >= 15) {
            calTaskName = calTaskName.substring(0, 15) + "...";
        }
        showParameter.setCaption(ResManager.loadKDString((String)"\u6210\u672c\u5206\u644a\u660e\u7ec6 - {0}", (String)"CostAllotTaskList_0", (String)"swc-pcs-formplugin", (Object[])new Object[]{calTaskName}));
        showParameter.setBillFormId("pcs_allotdetail");
        showParameter.setPageId(this.getView().getPageId() + costAllotPkId);
        showParameter.setCustomParam("calTaskId", (Object)calTaskId);
        showParameter.setCustomParam("calTaskName", (Object)calTaskName);
        showParameter.setCustomParam("costAllocationPkId", (Object)costAllotPkId);
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    private void clickNameHyperLink(Collection<Long> costAllotPkIds) {
        DynamicObject[] calTaskObjs = CostAllotHelper.getCostAllotCalTaskIds(costAllotPkIds);
        if (SWCObjectUtils.isEmpty((Object)calTaskObjs)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6570\u636e\u5df2\u4e0d\u5b58\u5728\uff0c\u8bf7\u5237\u65b0\u9875\u9762\u3002", (String)"CostAllotTaskList_5", (String)"swc-pcs-formplugin", (Object[])new Object[0]));
            return;
        }
        ArrayList calTaskIds = Lists.newArrayListWithExpectedSize((int)calTaskObjs.length);
        ArrayList calTaskNames = Lists.newArrayListWithExpectedSize((int)calTaskObjs.length);
        for (DynamicObject calTaskObj : calTaskObjs) {
            calTaskIds.add(calTaskObj.getLong("caltask.id"));
            calTaskNames.add(calTaskObj.getString("caltask.name"));
        }
        ListShowParameter showParameter = new ListShowParameter();
        ListFilterParameter listFilterParameter = new ListFilterParameter();
        showParameter.setListFilterParameter(listFilterParameter);
        showParameter.setBillFormId("pcs_allotdetail");
        showParameter.setPageId(this.getView().getPageId() + UUID.randomUUID().toString());
        showParameter.setCustomParam("calTaskIds", (Object)calTaskIds);
        showParameter.setCustomParam("caltaskName", (Object)calTaskNames);
        showParameter.setCustomParam("costAllocationPkIds", costAllotPkIds);
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        FormOperate formOperate = (FormOperate)args.getSource();
        String opKey = formOperate.getOperateKey();
        boolean idConfirm = Boolean.parseBoolean(formOperate.getOption().getVariableValue("confirm", String.valueOf(false)));
        if (idConfirm) {
            return;
        }
        switch (opKey) {
            case "generatecostdetail": {
                boolean enableCost = CostHelper.isEnableCost();
                if (!enableCost) {
                    args.setCancel(true);
                    this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6210\u672c\u5f00\u5173\u672a\u5f00\u542f\u3002", (String)"CostAllotTaskList_1", (String)"swc-pcs-formplugin", (Object[])new Object[0]));
                    return;
                }
                CostAllotDetailHelper.openCostTaskGenerateScheme((IFormView)this.getView(), (String)((Object)((Object)this)).getClass().getName());
                break;
            }
            case "generatecostrecord": {
                this.openCostRecord(Lists.newArrayList());
                break;
            }
        }
    }

    private void openCostRecord(List<Long> costAllotDetailRecordId) {
        ListShowParameter showParameter = new ListShowParameter();
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setBillFormId("pcs_costrecord");
        showParameter.setCustomParam("recordids", (Object)SerializationUtils.toJsonString(costAllotDetailRecordId));
        showParameter.setCaption(ResManager.loadKDString((String)"\u6210\u672c\u5206\u644a\u8ba1\u7b97\u62a5\u544a", (String)"CostAllotTaskList_4", (String)"swc-pcs-formplugin", (Object[])new Object[0]));
        ListFilterParameter listFilterParameter = showParameter.getListFilterParameter();
        QFilter qFilter = new QFilter("recordtype", "in", (Object)"1");
        listFilterParameter.setFilter(qFilter);
        showParameter.setListFilterParameter(listFilterParameter);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    public void closedCallBack(ClosedCallBackEvent args) {
        String actId = args.getActionId();
        Object returnData = args.getReturnData();
        switch (actId) {
            case "pcs_costallottaskscheme": {
                if (returnData == null) {
                    return;
                }
                Map map = (Map)returnData;
                if (map.containsKey("isChange")) {
                    ListShowParameter showParameter = new ListShowParameter();
                    showParameter.setBillFormId("pcs_costallocation");
                    showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                    List setUpdateTaskIds = (List)map.get("setUpdateTaskIds");
                    if (setUpdateTaskIds != null) {
                        ArrayList taskIdLongs = Lists.newArrayListWithExpectedSize((int)setUpdateTaskIds.size());
                        setUpdateTaskIds.forEach(ele -> taskIdLongs.add(ObjectConverter.convert((Object)ele, Long.class, (boolean)false)));
                        showParameter.getListFilterParameter().setFilter(new QFilter("caltask.id", "in", (Object)taskIdLongs));
                    }
                    this.getView().showForm((FormShowParameter)showParameter);
                    return;
                }
                IPageCache pageCache = this.getView().getPageCache();
                pageCache.put("salaryfilenumber", String.valueOf(map.get("calpersoncount")));
                Collection calTaskIds = (Collection)map.get("caltaskids");
                if (!CollectionUtils.isNotEmpty((Collection)calTaskIds)) break;
                pageCache.put("caltaskids", SerializationUtils.toJsonString((Object)calTaskIds));
                this.dealCostAllotDetails(calTaskIds);
                break;
            }
            case "pcs_costallotdetailprog": {
                if (returnData instanceof Map) {
                    Map returnDataMap = (Map)returnData;
                    String operationKey = String.valueOf(returnDataMap.get("operationkey"));
                    if ("viewrecord".equals(operationKey)) {
                        List costAllotDetailRecordIds = (List)returnDataMap.get("costallotdetailrecordids");
                        this.openCostRecord(costAllotDetailRecordIds);
                    } else if ("viewresult".equals(operationKey)) {
                        List costAllotDetailIds = (List)returnDataMap.get("costAllotDetailId");
                        this.clickNameHyperLink(costAllotDetailIds);
                    }
                }
                this.getView().invokeOperation("refresh");
                break;
            }
        }
    }

    private void dealCostAllotDetails(Collection<?> calTaskIds) {
        LOGGER.info("costallotconfirmCallBack begin 1-1");
        long userId = RequestContext.get().getCurrUserId();
        boolean hasPerm = SWCPermissionServiceHelper.hasPerm((long)userId, (String)"1ANC8T4UC434", (String)"pcs_allottask", (String)"0=KX5+RE6N4W");
        if (!hasPerm) {
            LOGGER.info("generatecostdetail no perm");
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u64cd\u4f5c\u6743\u9650\u3002", (String)"CostAllotTaskList_2", (String)"swc-pcs-formplugin", (Object[])new Object[0]));
            return;
        }
        IPageCache pageCache = this.getView().getPageCache();
        ArrayList calTaskIdsLong = Lists.newArrayListWithExpectedSize((int)calTaskIds.size());
        calTaskIds.forEach(ele -> calTaskIdsLong.add(ObjectConverter.convert((Object)ele, Long.class, (boolean)false)));
        Map taskDys = CostAllotHelper.checkGenerateAllotPerm((Collection)calTaskIdsLong);
        if (taskDys == null || taskDys.isEmpty()) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6743\u9650\u5185\u65e0\u53ef\u751f\u6210\u5206\u644a\u660e\u7ec6\u7684\u6838\u7b97\u8bb0\u5f55\u3002", (String)"CostAllotTaskList_7", (String)"swc-pcs-formplugin", (Object[])new Object[0]));
            return;
        }
        pageCache.put("caltaskids", SerializationUtils.toJsonString(taskDys.keySet()));
        AllotDetailHelper allotDetailHelper = new AllotDetailHelper();
        allotDetailHelper.dealCostAllotDeatail(this.getView(), ((Object)((Object)this)).getClass().getName(), "1", "");
    }

    private void addCalTaskFilter(List<QFilter> filters) {
        Set payRollCalSet = SWCPermissionServiceHelper.getPayrollCalSetByPermItem((String)"1ANC8T4UC434", (String)"pcs_allottask", (String)"47150e89000000ac");
        if (payRollCalSet != null) {
            QFilter payRollCalFilter = new QFilter("org.id", "in", (Object)payRollCalSet);
            filters.add(payRollCalFilter);
        }
        filters.add(new QFilter("taskstatus", "not in", (Object)new String[]{CalPayrollTaskStateEnum.CREATE.getCode(), CalPayrollTaskStateEnum.UNCAL.getCode(), CalPayrollTaskStateEnum.DISUSED.getCode(), CalPayrollTaskStateEnum.CALPROCESSING.getCode()}));
        filters.add(new QFilter("tasktype", "!=", (Object)TASK_TYPE_HIS));
    }
}

