/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.pcs.formplugin.web.costcfg;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.AbstractFormDataModel;
import kd.bos.entity.datamodel.TableValueSetter;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IClientViewProxy;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.SessionManager;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.HasPermOrgResult;
import kd.swc.hsbp.business.historynew.BaseDataHisHelper;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.common.cache.SWCPageCache;
import kd.swc.hsbp.common.util.SWCListUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hsbp.formplugin.web.SWCDataBaseEdit;
import kd.swc.pcs.business.costcfg.CostCfgHelper;
import kd.swc.pcs.business.costcommon.CostCommonHelper;

public class CostCfgEdit
extends SWCDataBaseEdit {
    private static final Log logger = LogFactory.getLog(CostCfgEdit.class);
    private static final String KEY_HIDEKEYANDVALUE = "hidekeyandvalue";
    private static final String KEY_HIDETYPEKEYANDVALUE = "hidetypekeyandvalue";
    private static final String KEY_COSTSEGSTORE = "costsegstore";
    private static final String KEY_COSTTYPESEGSTORE = "costtypesegstore";
    private static final String KEY_OPERATEENTRYENTITY = "operateentryentity";
    private static final String KEY_ISNEWENTRY = "isNewEntry";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addItemClickListeners(new String[]{"advcontoolbarap", "advcontoolbaraptype"});
    }

    public void afterCreateNewData(EventObject e) {
        this.initCostCfgForm();
        this.setCostCfgStruValue();
    }

    public void afterLoadData(EventObject e) {
        this.initCostCfgForm();
        this.setCostCfgStruValue();
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        String opKey;
        FormOperate formOperate = (FormOperate)args.getSource();
        switch (opKey = formOperate.getOperateKey()) {
            case "save": {
                boolean checkPermFlag = this.checkPermBeforeDoSave(args, opKey);
                if (!checkPermFlag) {
                    return;
                }
                this.checkData(args, formOperate, opKey);
                break;
            }
            case "submit": 
            case "confirmchange": 
            case "donothing_confirmchange": {
                this.checkData(args, formOperate, opKey);
                break;
            }
            case "newcalcostentry": {
                this.addCostCfgEntryTool(args);
                break;
            }
            case "newcosttypeentry": {
                this.addCostTypeEntryTool(args);
                break;
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        String operateKey;
        super.afterDoOperation(e);
        switch (operateKey = e.getOperateKey()) {
            case "save": 
            case "submit": {
                this.updateList();
                break;
            }
            case "cost_edit": {
                this.editCostStruCfg("costcfgentryentity", KEY_HIDEKEYANDVALUE, KEY_COSTSEGSTORE, true);
                break;
            }
            case "costtype_edit": {
                this.editCostStruCfg("costcfgtypeentryentity", KEY_HIDETYPEKEYANDVALUE, KEY_COSTTYPESEGSTORE, true);
                break;
            }
        }
        this.initCostCfgForm();
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        String actId;
        switch (actId = closedCallBackEvent.getActionId()) {
            case "pcs_showdimension": {
                this.dealDimensionCallBack(closedCallBackEvent);
                break;
            }
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        if (MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
            String callBackId;
            switch (callBackId = messageBoxClosedEvent.getCallBackId()) {
                case "costcfgproportionconfirm": {
                    SWCPageCache swcPageCache = new SWCPageCache(this.getView());
                    String operaKey = (String)swcPageCache.get("operakey", String.class);
                    if (!this.checkPerm(operaKey)) {
                        return;
                    }
                    if (!SWCStringUtils.isNotEmpty((String)operaKey)) break;
                    this.invokeSaveOperation(operaKey);
                    break;
                }
            }
        }
    }

    private boolean checkPerm(String operaKey) {
        String permItemId = "47156aff000000ac";
        switch (operaKey) {
            case "save": {
                long id = this.getView().getModel().getDataEntity().getLong("id");
                if (id == 0L) {
                    permItemId = "47156aff000000ac";
                    break;
                }
                permItemId = "4715a0df000000ac";
                break;
            }
            case "submit": {
                permItemId = "804f6478000000ac";
                break;
            }
        }
        String entityId = this.getView().getEntityId();
        HasPermOrgResult permOrgs = SWCPermissionServiceHelper.getPermOrgs((String)"38", (String)"1ANC8T4UC434", (String)entityId, (String)permItemId);
        if (permOrgs != null && !permOrgs.hasAllOrgPerm()) {
            List hasPermOrgs = permOrgs.getHasPermOrgs();
            logger.info("CostCfgEdit checkPerm getPermOrgs :{}", (Object)hasPermOrgs);
            long orgId = this.getModel().getDataEntity().getLong("createorg.id");
            if (!hasPermOrgs.contains(orgId)) {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u64cd\u4f5c\u6743\u9650\u3002", (String)"CostCfgEdit_12", (String)"swc-pcs-formplugin", (Object[])new Object[0]));
                return false;
            }
        }
        return true;
    }

    private boolean validateCostCfgEntryInfo(DynamicObject costCfgDy) {
        String name = costCfgDy.getDataEntityType().getName();
        if ("pcs_costitemcfg".equals(name)) {
            return this.validateCostItemCfgEntryInfo();
        }
        if ("pcs_costdeptcfg".equals(name)) {
            return this.validateCostDeptCfgEntryInfo();
        }
        DynamicObjectCollection costCfgEntryDy = this.getModel().getEntryEntity("costcfgentryentity");
        if (costCfgEntryDy.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u6210\u672c\u8bbe\u7f6e\u201d\u3002", (String)"CostCfgEdit_11", (String)"swc-pcs-formplugin", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    private boolean validateCostItemCfgEntryInfo() {
        DynamicObjectCollection costCfgEntryDy = this.getModel().getEntryEntity("costcfgentryentity");
        DynamicObjectCollection costCfgTypeEntryDy = this.getModel().getEntryEntity("costcfgtypeentryentity");
        if (costCfgEntryDy.isEmpty() && costCfgTypeEntryDy.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u6210\u672c\u8bbe\u7f6e\u201d\u6216\u201c\u4f18\u5148\u6210\u672c\u8bbe\u7f6e\u201d\u3002", (String)"CostCfgEdit_3", (String)"swc-pcs-formplugin", (Object[])new Object[0]));
            return false;
        }
        boolean costCfgFlag = this.validatorEntryInfo(costCfgEntryDy, "calcostproportion", "coststrucfgvalue", "1");
        if (!costCfgFlag) {
            return false;
        }
        return this.validatorEntryInfo(costCfgTypeEntryDy, "costcfgtypeproportion", "coststrutypecfgvalue", "2");
    }

    private boolean validateCostDeptCfgEntryInfo() {
        DynamicObjectCollection costCfgEntryDy = this.getModel().getEntryEntity("costcfgentryentity");
        DynamicObjectCollection costCfgTypeEntryDy = this.getModel().getEntryEntity("costcfgtypeentryentity");
        if (costCfgEntryDy.isEmpty() && costCfgTypeEntryDy.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u6210\u672c\u8bbe\u7f6e\u201d\u6216\u201c\u515c\u5e95\u6210\u672c\u8bbe\u7f6e\u201d\u3002", (String)"CostCfgEdit_4", (String)"swc-pcs-formplugin", (Object[])new Object[0]));
            return false;
        }
        return this.validatorEntryInfo(costCfgEntryDy, "calcostproportion", "coststrucfgvalue", "1");
    }

    private boolean validatorEntryInfo(DynamicObjectCollection costCfgTypeEntryDy, String proportionKey, String valueKey, String entryEntityType) {
        String entryEntityName = "";
        switch (entryEntityType) {
            case "1": {
                entryEntityName = ResManager.loadKDString((String)"\u201c\u6210\u672c\u8bbe\u7f6e\u201d", (String)"CostCfgEdit_5", (String)"swc-pcs-formplugin", (Object[])new Object[0]);
                break;
            }
            case "2": {
                entryEntityName = ResManager.loadKDString((String)"\u201c\u4f18\u5148\u6210\u672c\u8bbe\u7f6e\u201d", (String)"CostCfgEdit_6", (String)"swc-pcs-formplugin", (Object[])new Object[0]);
                break;
            }
            case "3": {
                entryEntityName = ResManager.loadKDString((String)"\u201c\u515c\u5e95\u6210\u672c\u8bbe\u7f6e\u201d", (String)"CostCfgEdit_7", (String)"swc-pcs-formplugin", (Object[])new Object[0]);
                break;
            }
        }
        for (int i = 0; i < costCfgTypeEntryDy.size(); ++i) {
            DynamicObject costCfgEntryDy = (DynamicObject)costCfgTypeEntryDy.get(i);
            BigDecimal costCfgTypeProportion = costCfgEntryDy.getBigDecimal(proportionKey);
            String costStruTypeCfgValue = costCfgEntryDy.getString(valueKey);
            if (costStruTypeCfgValue.isEmpty()) {
                String errorInfo = ResManager.loadKDString((String)"\u8bf7\u586b\u5199{0}\u7b2c{1}\u884c:\u201c\u6210\u672c\u7ef4\u5ea6\u7ec4\u5408\u503c\u201d\u3002", (String)"CostCfgEdit_8", (String)"swc-pcs-formplugin", (Object[])new Object[]{entryEntityName, i + 1});
                this.getView().showTipNotification(errorInfo);
                return false;
            }
            if (BigDecimal.ZERO.compareTo(costCfgTypeProportion) != 0) continue;
            String errorInfo = ResManager.loadKDString((String)"\u8bf7\u586b\u5199{0}\u7b2c{1}\u884c:\u201c\u767e\u5206\u6bd4(%)\u201d\u3002", (String)"CostCfgEdit_10", (String)"swc-pcs-formplugin", (Object[])new Object[]{entryEntityName, i + 1});
            this.getView().showTipNotification(errorInfo);
            return false;
        }
        return true;
    }

    private void initCostCfgForm() {
        List sortedDimensionList;
        Object costStruIdObj;
        this.setCostCfgEntryEnable();
        boolean hisPage = BaseDataHisHelper.isHisPage((IFormView)this.getView());
        if (hisPage) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_revise"});
        }
        String billName = this.getModel().getDataEntityType().getName();
        Long costTypeId = CostCommonHelper.getCostCfgTypeIdByFormId((String)billName);
        long costStruId = this.getView().getModel().getDataEntity().getLong("coststru.id");
        if (costStruId == 0L && (costStruIdObj = this.getView().getFormShowParameter().getCustomParam("coststruid")) != null) {
            costStruId = Long.parseLong(String.valueOf(costStruIdObj));
        }
        if (SWCListUtils.isEmpty((List)(sortedDimensionList = CostCfgHelper.getSortedDimensionList((Long)costStruId, (Long)costTypeId, (String)"COST")))) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"advcalcostcfg"});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{"advcalcostcfg"});
        }
    }

    private void checkProportion(BeforeDoOperationEventArgs args, String opKey) {
        BigDecimal costCfgTotal = BigDecimal.ZERO;
        boolean validateFlag = this.validateCostCfgEntryInfo(this.getModel().getDataEntity());
        if (validateFlag) {
            DynamicObjectCollection costCfgEntryColl = this.getModel().getEntryEntity("costcfgentryentity");
            for (int i = 0; i < costCfgEntryColl.size(); ++i) {
                BigDecimal calCostProportion = ((DynamicObject)costCfgEntryColl.get(i)).getBigDecimal("calcostproportion");
                if (BigDecimal.ZERO.compareTo(calCostProportion) == 0) {
                    args.setCancel(true);
                    String errorInfo = ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u6210\u672c\u8bbe\u7f6e\u201d\u7b2c{0}\u884c:\u201c\u767e\u5206\u6bd4(%)\u201d\u3002", (String)"CostCfgEdit_16", (String)"swc-pcs-formplugin", (Object[])new Object[]{i + 1});
                    this.getView().showTipNotification(errorInfo);
                    return;
                }
                costCfgTotal = costCfgTotal.add(calCostProportion);
            }
        } else {
            args.setCancel(true);
            return;
        }
        if (costCfgTotal.compareTo(new BigDecimal(100)) < 0) {
            List sortedDimensionList;
            String billName = this.getModel().getDataEntityType().getName();
            Long costTypeId = CostCommonHelper.getCostCfgTypeIdByFormId((String)billName);
            long costStruId = this.getView().getModel().getDataEntity().getLong("coststru.id");
            if (costStruId != 0L && SWCListUtils.isEmpty((List)(sortedDimensionList = CostCfgHelper.getSortedDimensionList((Long)costStruId, (Long)costTypeId, (String)"COST")))) {
                this.invokeSaveOperation(opKey);
                args.setCancel(true);
                return;
            }
            args.setCancel(true);
            FormOperate formOperate = (FormOperate)args.getSource();
            Map variables = formOperate.getOption().getVariables();
            SWCPageCache swcPageCache = new SWCPageCache(this.getView());
            swcPageCache.put("operakey", (Object)opKey);
            swcPageCache.put("variables", (Object)variables);
            this.getView().showConfirm(ResManager.loadKDString((String)"\u6210\u672c\u8bbe\u7f6e\u767e\u5206\u6bd4\u603b\u548c\u5c0f\u4e8e100%\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u7ee7\u7eed\uff1f", (String)"CostCfgEdit_2", (String)"swc-pcs-formplugin", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("costcfgproportionconfirm"));
        } else if (costCfgTotal.compareTo(new BigDecimal(100)) > 0) {
            args.setCancel(true);
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6210\u672c\u8bbe\u7f6e\u767e\u5206\u6bd4\u5927\u4e8e100%\uff0c\u8bf7\u66f4\u6b63\u540e\u91cd\u65b0\u4fdd\u5b58\u3002", (String)"CostCfgEdit_17", (String)"swc-pcs-formplugin", (Object[])new Object[0]));
        }
    }

    private void invokeSaveOperation(String operaKey) {
        OperateOption option = OperateOption.create();
        option.setVariableValue("confirm", "true");
        this.getView().getPageCache().put("confirmShow", "1");
        this.getView().invokeOperation(operaKey, option);
    }

    private void updateList() {
        IFormView parentView = this.getView().getParentView();
        if (parentView == null) {
            return;
        }
        parentView.invokeOperation("refresh");
        this.getView().sendFormAction(parentView);
    }

    private void setCostCfgEntryEnable() {
        BigDecimal hundred;
        DynamicObject dynamicObject;
        BigDecimal costCfgBigDecimal;
        DynamicObject costCfgDy = this.getModel().getDataEntity();
        boolean isAllowedSplit = costCfgDy.getBoolean("sourcetype.isallowedsplit");
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("costcfgentryentity");
        if (!isAllowedSplit && entryEntity.size() == 1 && (costCfgBigDecimal = (dynamicObject = (DynamicObject)entryEntity.get(0)).getBigDecimal("calcostproportion")).compareTo(hundred = new BigDecimal(100)) == 0) {
            this.getView().setEnable(Boolean.FALSE, 0, new String[]{"calcostproportion"});
        }
    }

    private void editCostStruCfg(String operateEntryEntity, String keyAndValue, String costSegStoreKey, boolean isNeedQueryFlag) {
        long costStruId = this.getModel().getDataEntity().getLong("costadapter.coststru.id");
        String billName = this.getModel().getDataEntityType().getName();
        String costType = this.getCostType(operateEntryEntity, billName);
        Long costTypeId = CostCommonHelper.getCostCfgTypeIdByFormId((String)billName);
        List dimensionObjList = CostCfgHelper.getSortedDimensionList((Long)costStruId, (Long)costTypeId, (String)costType);
        if (CollectionUtils.isEmpty((Collection)dimensionObjList)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u65e0\u53ef\u7528\u7ef4\u5ea6\u3002", (String)"CostCfgEdit_9", (String)"swc-pcs-formplugin", (Object[])new Object[0]));
            return;
        }
        JSONObject pageCacheData = null;
        if (isNeedQueryFlag) {
            pageCacheData = this.getSegStoreInfo(costStruId, operateEntryEntity, keyAndValue, costSegStoreKey);
        }
        JSONObject paramJSONObject = new JSONObject();
        paramJSONObject.put("returnData", (Object)pageCacheData);
        paramJSONObject.put("costStruId", (Object)costStruId);
        paramJSONObject.put("costBizObjId", (Object)costTypeId);
        paramJSONObject.put("costType", (Object)costType);
        DynamicObject source = this.getModel().getDataEntity().getDynamicObject("source");
        paramJSONObject.put("entityName", (Object)(source == null ? "" : source.getDataEntityType().getName()));
        paramJSONObject.put("sourceId", (Object)this.getModel().getDataEntity().getLong("source.id"));
        FormShowParameter parameter = CostCfgHelper.getDimensionFormShowParameter((JSONObject)paramJSONObject);
        parameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "pcs_showdimension"));
        this.getView().showForm(parameter);
        SWCPageCache pageCache = new SWCPageCache(this.getView());
        pageCache.put(KEY_OPERATEENTRYENTITY, (Object)operateEntryEntity);
        pageCache.put(KEY_ISNEWENTRY, (Object)(!isNeedQueryFlag ? 1 : 0));
    }

    private String getCostType(String operateEntryEntity, String billName) {
        String costType = "costcfgentryentity".equals(operateEntryEntity) ? "COST" : ("pcs_costitemcfg".equals(billName) ? "PRIORITY" : ("pcs_costdeptcfg".equals(billName) ? "DEFAULT" : "COST"));
        return costType;
    }

    private JSONObject getSegStoreInfo(long costStruId, String operateEntryEntity, String keyAndValue, String costSegStoreKey) {
        IClientViewProxy proxy = (IClientViewProxy)this.getView().getService(IClientViewProxy.class);
        int focusRow = proxy.getEntryState(operateEntryEntity).getFocusRow();
        if (focusRow == -1) {
            return null;
        }
        SWCPageCache pageCache = new SWCPageCache(this.getView());
        DynamicObject costCfgEntry = (DynamicObject)this.getModel().getEntryEntity(operateEntryEntity).get(focusRow);
        String jsonStr = costCfgEntry.getString(keyAndValue);
        if (!jsonStr.isEmpty()) {
            JSONObject parseObject = JSONObject.parseObject((String)jsonStr);
            pageCache.put("returnData", (Object)parseObject);
            return parseObject;
        }
        DynamicObject costSegStoreDy = costCfgEntry.getDynamicObject(costSegStoreKey);
        if (costSegStoreDy == null) {
            return null;
        }
        Map baseDataPropMap = CostCfgHelper.getBaseDatapropMap((long)costStruId);
        Map<String, Object> returnDataMap = this.setReturnDataMap(costSegStoreDy, baseDataPropMap);
        JSONObject returnDataJson = new JSONObject(returnDataMap);
        pageCache.put("returnData", (Object)returnDataJson);
        return returnDataJson;
    }

    private Map<String, Object> setReturnDataMap(DynamicObject costSegStoreDy, Map<String, Long> baseDataPropMap) {
        HashMap<String, Object> returnDataMap = new HashMap<String, Object>(16);
        for (int i = 1; i <= 30; ++i) {
            Long costDimensionId;
            String propertyName = "segment" + i;
            String segmentValue = costSegStoreDy.getString(propertyName);
            if (segmentValue == null || (costDimensionId = baseDataPropMap.get(Integer.toString(i))) == null) continue;
            returnDataMap.put(String.valueOf(costDimensionId), segmentValue);
        }
        return returnDataMap;
    }

    private void dealDimensionCallBack(ClosedCallBackEvent closedCallBackEvent) {
        Object returnData = closedCallBackEvent.getReturnData();
        if (returnData instanceof Map) {
            Map returnMap = (Map)returnData;
            JSONObject returnDataJson = new JSONObject(returnMap);
            SWCPageCache pageCache = new SWCPageCache(this.getView());
            pageCache.put("returnData", (Object)returnDataJson);
            String entryEntityKey = (String)pageCache.get(KEY_OPERATEENTRYENTITY, String.class);
            this.setCostEntryInfo(returnDataJson, pageCache, entryEntityKey);
            this.setCostEntryEnable(entryEntityKey);
        }
    }

    private void setCostEntryEnable(String entryEntity) {
        boolean isAllowedSplit = this.getModel().getDataEntity().getBoolean("sourcetype.isallowedsplit");
        if (!isAllowedSplit) {
            DynamicObjectCollection entryCollection = this.getView().getModel().getEntryEntity(entryEntity);
            if (SWCStringUtils.equals((String)entryEntity, (String)"costcfgentryentity")) {
                ((DynamicObject)entryCollection.get(0)).set("calcostproportion", (Object)new BigDecimal(100));
            }
            this.getView().setEnable(Boolean.FALSE, 0, new String[]{"calcostproportion"});
            this.getView().updateView(entryEntity);
        }
    }

    private void setCostEntryInfo(JSONObject returnDataJson, SWCPageCache pageCache, String entryEntity) {
        boolean flag = SWCStringUtils.equals((String)entryEntity, (String)"costcfgentryentity");
        String valueKey = flag ? "coststrucfgvalue" : "coststrutypecfgvalue";
        String hideValueKey = flag ? KEY_HIDEKEYANDVALUE : KEY_HIDETYPEKEYANDVALUE;
        int currentRowIndex = this.getModel().getEntryCurrentRowIndex(entryEntity);
        DynamicObjectCollection entryEntityCollection = this.getModel().getEntryEntity(entryEntity);
        String jsonObject = (String)pageCache.get("dimensionNameValCache", String.class);
        Boolean isNewEntryFlag = (Boolean)pageCache.get(KEY_ISNEWENTRY, Boolean.class);
        if (isNewEntryFlag.booleanValue()) {
            TableValueSetter vs = new TableValueSetter(new String[0]);
            vs.addField(valueKey, new Object[0]);
            vs.addField(hideValueKey, new Object[0]);
            vs.addRow(new Object[]{jsonObject, returnDataJson});
            AbstractFormDataModel model = (AbstractFormDataModel)this.getView().getModel();
            model.beginInit();
            model.batchCreateNewEntryRow(entryEntity, vs);
            model.endInit();
            this.getView().updateView(entryEntity);
        } else {
            ((DynamicObject)this.getModel().getEntryEntity(entryEntity).get(currentRowIndex)).set(valueKey, (Object)jsonObject);
            ((DynamicObject)this.getModel().getEntryEntity(entryEntity).get(currentRowIndex)).set(hideValueKey, (Object)returnDataJson);
            this.getView().updateView(entryEntity, currentRowIndex);
        }
    }

    private void addCostTypeEntryTool(BeforeDoOperationEventArgs e) {
        DynamicObjectCollection costCfgTypeEntryColl = this.getModel().getEntryEntity("costcfgtypeentryentity");
        String name = this.getModel().getDataEntity().getDataEntityType().getName();
        if ("pcs_costdeptcfg".equals(name)) {
            if (costCfgTypeEntryColl.size() >= 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u5141\u8bb8\u8bbe\u7f6e\u4e00\u4e2a\u515c\u5e95\u6210\u672c\u8bbe\u7f6e\u3002", (String)"CostCfgEdit_20", (String)"swc-pcs-formplugin", (Object[])new Object[0]));
                e.setCancel(true);
                return;
            }
        } else if ("pcs_costitemcfg".equals(name) && costCfgTypeEntryColl.size() >= 1) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u53ea\u5141\u8bb8\u8bbe\u7f6e\u4e00\u4e2a\u4f18\u5148\u6210\u672c\u8bbe\u7f6e\u3002", (String)"CostCfgEdit_23", (String)"swc-pcs-formplugin", (Object[])new Object[0]));
            e.setCancel(true);
            return;
        }
        this.editCostStruCfg("costcfgtypeentryentity", KEY_HIDETYPEKEYANDVALUE, KEY_COSTTYPESEGSTORE, false);
    }

    private void addCostCfgEntryTool(BeforeDoOperationEventArgs e) {
        DynamicObject costCfgDy = this.getModel().getDataEntity();
        boolean isAllowedSplit = costCfgDy.getBoolean("sourcetype.isallowedsplit");
        DynamicObjectCollection costCfgEntryColl = this.getModel().getEntryEntity("costcfgentryentity");
        if (!isAllowedSplit && costCfgEntryColl.size() >= 1) {
            String sourceTypeName = costCfgDy.getString("sourcetype.name");
            this.getView().showTipNotification(ResManager.loadKDString((String)"{0}\u4e0d\u652f\u6301\u6210\u672c\u5206\u62c6\uff0c\u8bf7\u8c03\u6574\u8bbe\u7f6e\u540e\u91cd\u65b0\u4fdd\u5b58\u3002", (String)"CostCfgEdit_1", (String)"swc-pcs-formplugin", (Object[])new Object[]{sourceTypeName}));
        } else {
            this.editCostStruCfg("costcfgentryentity", KEY_HIDEKEYANDVALUE, KEY_COSTSEGSTORE, false);
        }
    }

    private void setCostCfgStruValue() {
        this.setCostCfgValueByType("costcfgentryentity");
        String billName = this.getModel().getDataEntityType().getName();
        if ("pcs_costitemcfg".equals(billName) || "pcs_costdeptcfg".equals(billName)) {
            this.setCostCfgValueByType("costcfgtypeentryentity");
        }
    }

    private void setCostCfgValueByType(String entityKey) {
        DynamicObjectCollection entryEntity = this.getView().getModel().getEntryEntity(entityKey);
        if (CollectionUtils.isEmpty((Collection)entryEntity)) {
            return;
        }
        String billName = this.getModel().getDataEntityType().getName();
        Long costTypeId = CostCommonHelper.getCostCfgTypeIdByFormId((String)billName);
        String costType = this.getCostType(entityKey, billName);
        long costStruId = this.getModel().getDataEntity().getLong("costadapter.coststru.id");
        DynamicObjectCollection dimensionEntryColl = CostCommonHelper.getCostStruDimById((long)costStruId);
        DynamicObjectCollection needShowDimensionEntryColl = CostCfgHelper.getNeedShowDimensionColl((Long)costTypeId, (String)costType, (DynamicObjectCollection)dimensionEntryColl);
        List segmentStoreIds = CostCfgHelper.getSegmentStoreIds((String)entityKey, (IFormView)this.getView());
        Map constEntryIdMap = CostCommonHelper.getCostSegStoreIdMap((List)segmentStoreIds);
        Map constQueryResultMap = CostCommonHelper.getConstNeedQueryDbMap((Map)constEntryIdMap, (DynamicObjectCollection)needShowDimensionEntryColl);
        Map baseDataValueMap = CostCommonHelper.getBaseDataValueMap((Map)constQueryResultMap);
        String segmentKey = "costcfgentryentity".equals(entityKey) ? KEY_COSTSEGSTORE : KEY_COSTTYPESEGSTORE;
        String costStruCfgValueKey = "costcfgentryentity".equals(entityKey) ? "coststrucfgvalue" : "coststrutypecfgvalue";
        for (DynamicObject costCfgEntry : entryEntity) {
            DynamicObject costSegStoreDy = costCfgEntry.getDynamicObject(segmentKey);
            if (costSegStoreDy == null) continue;
            CostCfgHelper.setCostCfgValue((DynamicObjectCollection)needShowDimensionEntryColl, (Map)baseDataValueMap, (DynamicObject)costCfgEntry, (DynamicObject)costSegStoreDy, (String)costStruCfgValueKey);
        }
    }

    private boolean isAllowedSplit() {
        DynamicObject costCfgDy = this.getModel().getDataEntity();
        boolean isAllowedSplit = costCfgDy.getBoolean("sourcetype.isallowedsplit");
        DynamicObjectCollection entryEntity = this.getModel().getEntryEntity("costcfgentryentity");
        if (!isAllowedSplit) {
            if (entryEntity.size() == 1) {
                BigDecimal hundred;
                DynamicObject dynamicObject = (DynamicObject)entryEntity.get(0);
                BigDecimal costCfgBigDecimal = dynamicObject.getBigDecimal("calcostproportion");
                if (costCfgBigDecimal.compareTo(hundred = new BigDecimal(100)) < 0) {
                    String sourceTypeName = costCfgDy.getString("sourcetype.name");
                    this.getView().showTipNotification(ResManager.loadKDString((String)"{0}\u4e0d\u652f\u6301\u6210\u672c\u5206\u62c6\uff0c\u767e\u5206\u6bd4\u5fc5\u987b\u4e3a100%\u3002", (String)"CostCfgEdit_18", (String)"swc-pcs-formplugin", (Object[])new Object[]{sourceTypeName}));
                    return false;
                }
            } else if (entryEntity.size() > 1) {
                String sourceTypeName = costCfgDy.getString("sourcetype.name");
                this.getView().showTipNotification(ResManager.loadKDString((String)"{0}\u4e0d\u652f\u6301\u6210\u672c\u5206\u62c6\uff0c\u8bf7\u8c03\u6574\u8bbe\u7f6e\u540e\u91cd\u65b0\u4fdd\u5b58\u3002", (String)"CostCfgEdit_1", (String)"swc-pcs-formplugin", (Object[])new Object[]{sourceTypeName}));
                return false;
            }
        }
        return true;
    }

    private void checkData(BeforeDoOperationEventArgs args, FormOperate formOperate, String opKey) {
        boolean flag = this.isAllowedSplit();
        if (flag) {
            boolean idConfirm = Boolean.parseBoolean(formOperate.getOption().getVariableValue("confirm", String.valueOf(false)));
            if (!args.isCancel() && !idConfirm) {
                this.checkProportion(args, opKey);
            }
        } else {
            args.setCancel(true);
        }
    }

    private boolean checkPermBeforeDoSave(BeforeDoOperationEventArgs args, String opKey) {
        if ("save".equals(opKey)) {
            FormShowParameter parentViewParameter = SessionManager.getCurrent().getFormShowParameter(this.getView().getFormShowParameter().getParentPageId());
            if (!args.isCancel() && parentViewParameter != null && parentViewParameter.isCancelDataRight()) {
                this.getView().showConfirm(ResManager.loadKDString((String)"\u5bf9\u4e0d\u8d77\uff0c\u60a8\u7684\u6570\u636e\u6743\u9650\u5df2\u53d1\u751f\u53d8\u66f4\uff0c\u65e0\u6cd5\u7ee7\u7eed\u64cd\u4f5c\uff0c\u8bf7\u91cd\u65b0\u6253\u5f00\u9875\u9762\u3002", (String)"CostCfgEdit_19", (String)"swc-pcs-formplugin", (Object[])new Object[0]), MessageBoxOptions.OK);
                args.setCancel(true);
                return false;
            }
            if (!this.checkPerm(opKey)) {
                args.setCancel(true);
                return false;
            }
        }
        return true;
    }
}

