/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.pcs.formplugin.web.costcfg.dataimport;

import java.io.InputStream;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.Image;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.IListView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.HasPermOrgResult;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.hr.hbp.business.service.diff.HRPlugInProxyFactory;
import kd.hr.hbp.business.service.diff.HRPluginProxy;
import kd.hr.hbp.common.util.HRStringUtils;
import kd.sdk.swc.pcs.business.extpoint.costcfg.ICostCfgImportExtService;
import kd.sdk.swc.pcs.common.events.CostCfgEvent;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.common.cache.SWCPageCache;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.pcs.business.costcfg.CostCfgExportHelper;
import kd.swc.pcs.business.costcfg.CostCfgHelper;
import kd.swc.pcs.business.costcfg.CostCfgImportExtService;
import kd.swc.pcs.business.costcfg.dataimport.CostCfgImportConfig;
import kd.swc.pcs.business.costcfg.dataimport.CostCfgImportParamEntity;
import kd.swc.pcs.business.costcfg.dataimport.helper.CostCfgImportHelper;
import kd.swc.pcs.business.costcfg.dataimport.strategy.CostCfgImportStrategy;
import kd.swc.pcs.business.costcfg.service.CostCfgImportService;
import kd.swc.pcs.business.costcommon.CostCommonHelper;
import kd.swc.pcs.business.costcommon.CostExportCommonHelper;
import kd.swc.pcs.business.costthread.CostCfgResolveThread;
import kd.swc.pcs.common.constants.CostCfgImportConstants;
import kd.swc.pcs.common.constants.CostExportConstants;
import org.apache.commons.lang.StringUtils;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class CostCfgStartImportPlugin
extends AbstractFormPlugin
implements UploadListener,
BeforeF7SelectListener {
    protected static final Log logger = LogFactory.getLog(CostCfgStartImportPlugin.class);
    public static final String SWC_PCS_FORMPLUGIN = "swc-pcs-formplugin";

    public void initialize() {
        this.addClickListeners(new String[]{"btnok", "btndownload", "btnresetfile"});
        Image label = (Image)this.getControl("btnupload");
        label.addUploadListener((UploadListener)this);
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit costAdaptionEdit = (BasedataEdit)this.getView().getControl("costadaption");
        costAdaptionEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        this.getView().setVisible(Boolean.FALSE, new String[]{"filepanel"});
        this.getView().setEnable(Boolean.FALSE, new String[]{"keyfields"});
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        String billName = this.getView().getParentView().getFormShowParameter().getCaption();
        Label title = (Label)this.getView().getControl("title");
        title.setText(billName);
    }

    public void click(EventObject evt) {
        switch (((Control)evt.getSource()).getKey()) {
            case "btnok": {
                this.importData();
                break;
            }
            case "btndownload": {
                CostCfgImportService service = new CostCfgImportService();
                service.downLoadTemplate(this.getView());
                break;
            }
            case "btnresetfile": {
                this.resetFileInfo();
                break;
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent event) {
        String propertyName = event.getProperty().getName();
        if (HRStringUtils.equals((String)"costadaption", (String)propertyName)) {
            this.addCostAdaptionFilter(event);
            logger.info("CostCfgStartImportPlugin beforeF7Select CustomFilters :{}", (Object)event.getCustomQFilters());
        }
    }

    public void upload(UploadEvent evt) {
        Object[] urls = evt.getUrls();
        if (urls.length > 0) {
            IFormView view = this.getView();
            String url = (String)urls[0];
            view.setVisible(Boolean.TRUE, new String[]{"filepanel"});
            view.setVisible(Boolean.FALSE, new String[]{"uploadpanel"});
            IDataModel model = this.getModel();
            model.setValue("filename", (Object)url.substring(url.lastIndexOf(47) + 1));
            model.setValue("filepath", (Object)url);
            logger.info("** costcfgimport upload url :{}", (Object)url);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        Map returnData;
        String isSuccess;
        String actId = closedCallBackEvent.getActionId();
        Object returnDataObj = closedCallBackEvent.getReturnData();
        if (ObjectUtils.isEmpty((Object)returnDataObj)) {
            return;
        }
        if ("pcs_costcfgimportprog".equals(actId) && "true".equals(isSuccess = (String)(returnData = (Map)returnDataObj).get("issuccess"))) {
            this.getView().returnDataToParent((Object)returnData);
            this.getView().close();
        }
    }

    private void resetFileInfo() {
        this.getModel().setValue("filename", (Object)"");
        this.getModel().setValue("filepath", (Object)"");
        this.getView().setVisible(Boolean.FALSE, new String[]{"filepanel"});
        this.getView().setVisible(Boolean.TRUE, new String[]{"uploadpanel"});
    }

    private void importData() {
        String billFormId;
        long userId = RequestContext.get().getCurrUserId();
        boolean hasPerm = SWCPermissionServiceHelper.hasPerm((long)userId, (String)"1ANC8T4UC434", (String)(billFormId = this.getBillFormId()), (String)"4730fc9f000003ae");
        if (!hasPerm) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6ca1\u6709\u64cd\u4f5c\u6743\u9650\u3002", (String)"CostCfgStartImportPlugin_0", (String)SWC_PCS_FORMPLUGIN, (Object[])new Object[0]));
            return;
        }
        String url = this.getModel().getDataEntity().getString("filepath");
        if (StringUtils.isBlank((String)url)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u4e0a\u4f20\u6570\u636e\u6587\u4ef6\u540e\u64cd\u4f5c\u3002", (String)"CostCfgStartImportPlugin_1", (String)SWC_PCS_FORMPLUGIN, (Object[])new Object[0]));
            return;
        }
        long costAdaptionId = this.getView().getModel().getDataEntity().getLong("costadaption.id");
        if (costAdaptionId == 0L) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u201c\u4eba\u529b\u6210\u672c\u7ef4\u5ea6\u65b9\u6848\u201d\uff0c\u518d\u5f00\u59cb\u5bfc\u5165\u3002", (String)"CostCfgStartImportPlugin_10", (String)SWC_PCS_FORMPLUGIN, (Object[])new Object[0]));
            return;
        }
        try {
            this.handleCostCfgImport();
        }
        catch (Exception e) {
            logger.error("CostCfgStartImportPlugin importData error :", (Throwable)e);
            this.updateProgress("false");
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5bfc\u5165\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"CostCfgStartImportPlugin_11", (String)SWC_PCS_FORMPLUGIN, (Object[])new Object[0]));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleCostCfgImport() {
        Sheet sheetAt;
        Map costCfgHeaders;
        InputStream in;
        Workbook wb;
        block8: {
            CostCfgImportService service;
            String errorMessage;
            block7: {
                wb = null;
                in = null;
                FileService fileService = FileServiceFactory.getAttachmentFileService();
                String url = this.getModel().getDataEntity().getString("filepath");
                in = fileService.getInputStream(url);
                wb = WorkbookFactory.create((InputStream)in);
                if (wb != null) break block7;
                CostExportCommonHelper.closeSafely((Workbook)wb);
                CostExportCommonHelper.closeSafely((InputStream[])new InputStream[]{in});
                return;
            }
            String billFormId = this.getBillFormId();
            long costAdaptionId = this.getView().getModel().getDataEntity().getLong("costadaption.id");
            costCfgHeaders = CostCfgExportHelper.getExportColumnMap((String)billFormId, (Long)costAdaptionId);
            CostCfgImportExtService extService = new CostCfgImportExtService();
            CostCfgEvent event = new CostCfgEvent(billFormId, new LinkedHashMap(costCfgHeaders));
            HRPluginProxy hrPluginProxy = HRPlugInProxyFactory.create((Object)extService, ICostCfgImportExtService.class, (String)"kd.sdk.swc.pcs.business.extpoint.costcfg.ICostCfgImportExtService#setCostCfgImportField", null);
            hrPluginProxy.callReplaceIfPresent(proxy -> {
                proxy.setCostCfgImportField(event);
                return null;
            });
            LinkedHashMap newCostCfgHeaders = event.getCostCfgHeaders();
            if (!CollectionUtils.isEmpty((Map)newCostCfgHeaders)) {
                costCfgHeaders = newCostCfgHeaders;
            }
            if (!SWCStringUtils.isNotEmpty((String)(errorMessage = (service = new CostCfgImportService()).validatorImportData(costCfgHeaders, sheetAt = wb.getSheetAt(0))))) break block8;
            this.getView().showErrorNotification(errorMessage);
            CostExportCommonHelper.closeSafely((Workbook)wb);
            CostExportCommonHelper.closeSafely((InputStream[])new InputStream[]{in});
            return;
        }
        try {
            this.openImportProgressBar(this.getView());
            RequestContext requestContext = RequestContext.get();
            Map finalCostCfgHeaders = costCfgHeaders;
            ThreadPools.executeOnce((String)"IMPORT_COST_CFG_EXCEL_POOL_ASYNC", () -> {
                RequestContext.copyAndSet((RequestContext)requestContext);
                logger.info("CostCfgStartImportPlugin clearCache begin 1");
                this.clearCache();
                CostCfgImportConfig costCfgImportConfig = new CostCfgImportConfig();
                CostCfgImportParamEntity costCfgImportParamEntity = this.initParamEntity();
                costCfgImportParamEntity.setColumnKeyAndColumnNameMap(finalCostCfgHeaders);
                costCfgImportConfig.setCostCfgImportParamEntity(costCfgImportParamEntity);
                logger.info("CostCfgStartImportPlugin initParamEntity end 2");
                int lastRowNum = sheetAt.getLastRowNum() - 1;
                costCfgImportConfig.setTotalRows(lastRowNum);
                CostCfgResolveThread resolveTask = new CostCfgResolveThread(RequestContext.get(), costCfgImportConfig);
                CostExportConstants.COST_CFG_IMPORT_RESOLVE_POOL.submit((Callable)resolveTask);
                logger.info("CostCfgStartImportPlugin importCostCfgData begin 2");
                this.importCostCfgData(costCfgImportConfig);
                logger.info("CostCfgStartImportPlugin handleCostCfgImport end 4");
            });
        }
        catch (Exception e) {
            try {
                logger.error("CostCfgStartImportPlugin handleCostCfgImport error :", (Throwable)e);
            }
            catch (Throwable throwable) {
                CostExportCommonHelper.closeSafely(wb);
                CostExportCommonHelper.closeSafely((InputStream[])new InputStream[]{in});
                throw throwable;
            }
            CostExportCommonHelper.closeSafely(wb);
            CostExportCommonHelper.closeSafely((InputStream[])new InputStream[]{in});
        }
        CostExportCommonHelper.closeSafely((Workbook)wb);
        CostExportCommonHelper.closeSafely((InputStream[])new InputStream[]{in});
    }

    private void clearCache() {
        SWCPageCache pageCache = new SWCPageCache(this.getView());
        pageCache.remove("url");
        pageCache.remove("progress");
        pageCache.remove("issuccess");
    }

    private CostCfgImportParamEntity initParamEntity() {
        String billFormId = this.getBillFormId();
        Long costCfgTypeId = CostCommonHelper.getCostCfgTypeIdByFormId((String)billFormId);
        String url = this.getModel().getDataEntity().getString("filepath");
        String costAdaptionName = this.getView().getModel().getDataEntity().getString("costadaption.name");
        Long costAdaptionId = this.getView().getModel().getDataEntity().getLong("costadaption.id");
        Long costStruId = CostCfgExportHelper.queryCostStruByAdapter((Long)costAdaptionId);
        List mustInputColumn = CostCfgImportStrategy.getCostCfgAllMustInputColumn();
        Map costTypeNameMap = CostExportCommonHelper.getCostTypeNameMap();
        Map columnKeyAndColumnNameMap = CostCfgExportHelper.getExportColumnMap((String)billFormId, (Long)costAdaptionId);
        Map columnKeyAndQueryMap = CostCfgImportHelper.initQueryDbNameAndTypeMap((String)billFormId, (Long)costAdaptionId);
        DynamicObjectCollection costStruDimColl = CostCommonHelper.getCostStruDimById((long)costStruId);
        Map<String, DynamicObject> columnKeyAndDimensionDyMap = this.getColumnKeyAndDimensionDyMap(costStruDimColl);
        DynamicObjectCollection needShowDimensionEntryColl = CostCfgHelper.getNeedShowDimensionColl((Long)costCfgTypeId, (String)"COST", (DynamicObjectCollection)costStruDimColl);
        Map<String, DynamicObject> needShowColumnKeyAndDimensionDyMap = this.getColumnKeyAndDimensionDyMap(needShowDimensionEntryColl);
        String showDimName = this.getShowDimName(needShowColumnKeyAndDimensionDyMap);
        return new CostCfgImportParamEntity(costAdaptionId, costStruId, costCfgTypeId, url, costAdaptionName, billFormId, showDimName, mustInputColumn, costTypeNameMap, columnKeyAndColumnNameMap, columnKeyAndQueryMap, columnKeyAndDimensionDyMap, needShowColumnKeyAndDimensionDyMap);
    }

    private String getShowDimName(Map<String, DynamicObject> needShowColumnKeyAndDimensionDyMap) {
        String showDimName = "";
        if (CollectionUtils.isEmpty(needShowColumnKeyAndDimensionDyMap)) {
            return showDimName;
        }
        Collection<DynamicObject> values = needShowColumnKeyAndDimensionDyMap.values();
        DynamicObjectCollection dynamicObjects = new DynamicObjectCollection();
        dynamicObjects.addAll(values);
        return CostCfgImportHelper.getShowDimNameByShowDim((DynamicObjectCollection)dynamicObjects);
    }

    private Map<String, DynamicObject> getColumnKeyAndDimensionDyMap(DynamicObjectCollection costStruDimColl) {
        HashMap<String, DynamicObject> columnKeyAndDimensionDy = new HashMap<String, DynamicObject>(16);
        for (DynamicObject dimensionDy : costStruDimColl) {
            String storageSetNumber = dimensionDy.getString("storageset.number");
            columnKeyAndDimensionDy.put("segment" + storageSetNumber, dimensionDy);
        }
        return columnKeyAndDimensionDy;
    }

    private void importCostCfgData(CostCfgImportConfig conf) {
        try {
            int timeout = 0;
            LinkedBlockingQueue dataQueue = conf.getDataQueues();
            while (!(conf.isResolveEnd() && dataQueue.isEmpty() || timeout > 5)) {
                this.isNeedSleep(conf);
                List rowDataList = new ArrayList<Map>(10);
                Map rowDataMap = (Map)dataQueue.poll(1L, TimeUnit.MINUTES);
                if (CollectionUtils.isEmpty((Map)rowDataMap)) {
                    logger.info("...read...null");
                    ++timeout;
                    this.sleep(5);
                    continue;
                }
                timeout = 0;
                rowDataList.add(rowDataMap);
                dataQueue.drainTo(rowDataList, 499);
                rowDataList = rowDataList.stream().filter(data -> !data.isEmpty()).collect(Collectors.toList());
                CostCfgImportService.importCostCfgData((CostCfgImportConfig)conf, rowDataList);
                this.updateProgress(conf, false);
            }
            this.uploadErrorInfo(conf);
            this.updateProgress(conf, true);
        }
        catch (InterruptedException e) {
            logger.error("CostCfgStartImportPlugin importCostCfgData error...", (Throwable)e);
        }
    }

    private void isNeedSleep(CostCfgImportConfig conf) {
        int totalRows = conf.getTotalRows();
        if (totalRows >= 500) {
            LinkedBlockingQueue dataQueues;
            for (int i = 0; i < 5 && (dataQueues = conf.getDataQueues()).size() < 500 && !conf.isResolveEnd(); ++i) {
                this.sleep(4);
            }
        } else {
            LinkedBlockingQueue dataQueues;
            for (int i = 0; i < 10 && (dataQueues = conf.getDataQueues()).size() < totalRows && !conf.isResolveEnd(); ++i) {
                this.sleep(2);
            }
        }
    }

    private void sleep(int seconds) {
        try {
            Thread.sleep((long)seconds * 1000L);
        }
        catch (InterruptedException e) {
            logger.error((Throwable)e);
        }
    }

    private void updateProgress(String flag) {
        SWCPageCache pageCache = new SWCPageCache(this.getView());
        pageCache.put("progress", (Object)CostCfgImportConstants.DOUBLE_HUNDRED);
        pageCache.put("issuccess", (Object)flag);
        pageCache.saveChanges();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void uploadErrorInfo(CostCfgImportConfig conf) {
        block8: {
            List costCfgErrorList = conf.getErrorList();
            if (!CollectionUtils.isEmpty((Collection)costCfgErrorList)) {
                Iterator iterator = costCfgErrorList.iterator();
                while (iterator.hasNext()) {
                    Map next = (Map)iterator.next();
                    if (next.containsKey("errorMessage")) continue;
                    iterator.remove();
                }
            }
            if (CollectionUtils.isEmpty((Collection)costCfgErrorList)) {
                this.updateProgress("true");
                return;
            }
            XSSFWorkbook workbook = null;
            SXSSFWorkbook wb = null;
            try {
                CostCfgImportParamEntity costCfgImportParamEntity = conf.getCostCfgImportParamEntity();
                String url = costCfgImportParamEntity.getUrl();
                FileService fileService = FileServiceFactory.getAttachmentFileService();
                workbook = new XSSFWorkbook(fileService.getInputStream(url));
                wb = new SXSSFWorkbook(CostExportConstants.ROW_ACCESS_WINDOWS_SIZE);
                Map costCfgHeaders = costCfgImportParamEntity.getColumnKeyAndColumnNameMap();
                String costCfgSheetName = ResManager.loadKDString((String)"\u6210\u672c\u8bbe\u7f6e", (String)"CostCfgStartImportPlugin_12", (String)SWC_PCS_FORMPLUGIN, (Object[])new Object[0]);
                LinkedHashMap<String, String> errorCostCfgHeaders = this.addExportErrorHeader(costCfgHeaders);
                SXSSFSheet costCfgSheet = this.createCostCfgSheet(wb, errorCostCfgHeaders, costCfgSheetName);
                logger.info("CostCfgStartImportPlugin write2ExportContent begin 6-3");
                CostExportCommonHelper.write2ExportContent((SXSSFSheet)costCfgSheet, (Integer)1, (List)costCfgErrorList, errorCostCfgHeaders);
                logger.info("CostCfgStartImportPlugin write2ExportContent end 6-4");
                String exportFileName = this.getExportErrorFileName();
                CostCfgImportService service = new CostCfgImportService();
                service.flushAll(wb, exportFileName, this.getView());
                logger.info("CostCfgStartImportPlugin flushAll end 6-4");
                CostExportCommonHelper.closeSafely((Workbook)workbook);
            }
            catch (Exception e) {
                logger.error("CostCfgStartImportPlugin uploadErrorInfo error\uff1a ", (Throwable)e);
                break block8;
            }
            finally {
                CostExportCommonHelper.closeSafely(workbook);
                CostExportCommonHelper.closeSafely(wb);
            }
            CostExportCommonHelper.closeSafely((SXSSFWorkbook)wb);
        }
    }

    private String getExportErrorFileName() {
        IFormView parentView = this.getView().getParentView();
        String billName = parentView.getFormShowParameter().getCaption();
        return String.format(Locale.ROOT, ResManager.loadKDString((String)"%s\u5bfc\u5165\u9519\u8bef\u4fe1\u606f", (String)"CostCfgStartImportPlugin_5", (String)SWC_PCS_FORMPLUGIN, (Object[])new Object[0]), billName);
    }

    private LinkedHashMap<String, String> addExportErrorHeader(Map<String, String> costCfgHeaders) {
        LinkedHashMap<String, String> errorCostCfgHeaders = new LinkedHashMap<String, String>(16);
        errorCostCfgHeaders.put("errorMessage", ResManager.loadKDString((String)"\u9519\u8bef\u4fe1\u606f", (String)"CostCfgStartImportPlugin_6", (String)SWC_PCS_FORMPLUGIN, (Object[])new Object[0]));
        errorCostCfgHeaders.putAll(costCfgHeaders);
        return errorCostCfgHeaders;
    }

    private String getBillFormId() {
        IFormView parentView = this.getView().getParentView();
        IListView listView = (IListView)parentView;
        return listView.getBillFormId();
    }

    private SXSSFSheet createCostCfgSheet(SXSSFWorkbook wb, Map<String, String> costCfgHeaders, String sheetName) {
        SXSSFSheet sheet = wb.createSheet(sheetName);
        sheet.setRandomAccessWindowSize(-1);
        CostExportCommonHelper.write2ExportHead((SXSSFSheet)sheet, costCfgHeaders);
        return sheet;
    }

    private void openImportProgressBar(IFormView view) {
        SWCPageCache pageCache = new SWCPageCache(view);
        pageCache.put("progress", (Object)CostCfgImportConstants.DOUBLE_ZERO);
        pageCache.saveChanges();
        FormShowParameter para = new FormShowParameter();
        para.setFormId("pcs_costcfgimportprog");
        IListView listView = (IListView)view.getParentView();
        String costCfgName = listView.getFormShowParameter().getCaption();
        para.setCustomParam("title", (Object)ResManager.loadKDString((String)"{0}\u5bfc\u5165\u8fdb\u5ea6", (String)"CostCfgStartImportPlugin_13", (String)SWC_PCS_FORMPLUGIN, (Object[])new Object[]{costCfgName}));
        para.getOpenStyle().setShowType(ShowType.Modal);
        String pageId = view.getPageId();
        para.setCustomParam("pageId", (Object)pageId);
        para.setCaption(ResManager.loadKDString((String)"\u5bfc\u5165\u8fdb\u5ea6\u6761", (String)"CostCfgStartImportPlugin_14", (String)SWC_PCS_FORMPLUGIN, (Object[])new Object[0]));
        para.setCloseCallBack(new CloseCallBack((IFormPlugin)this, "pcs_costcfgimportprog"));
        view.showForm(para);
    }

    private void updateProgress(CostCfgImportConfig con, boolean flag) {
        int progress = 0;
        int total = con.getTotalRows();
        int finishCount = con.getDealRows();
        if (flag) {
            progress = 100;
        } else if (total != 0) {
            progress = new BigDecimal(String.valueOf(finishCount)).divide(new BigDecimal(String.valueOf(total)), 2, 4).multiply(new BigDecimal("100")).intValue();
            if (progress == 100) {
                progress = 99;
            }
        } else {
            progress = 100;
        }
        int saveExcelRows = con.getSaveExcelRows();
        SWCPageCache pageCache = new SWCPageCache(this.getView());
        pageCache.put("progress", (Object)progress);
        pageCache.put("importexceltotalrow", (Object)total);
        pageCache.put("importexcelsaverow", (Object)saveExcelRows);
    }

    private String getParentBillFormId() {
        IListView listView = (IListView)this.getView().getParentView();
        return listView.getBillFormId();
    }

    private void addCostAdaptionFilter(BeforeF7SelectEvent event) {
        String parentBillFormId = this.getParentBillFormId();
        long currUserId = RequestContext.get().getCurrUserId();
        QFilter baseDataRuleFilter = SWCPermissionServiceHelper.getDataRuleForBdProp((long)currUserId, (String)"1ANC8T4UC434", (String)parentBillFormId, (String)"costadapter", (String)"47156aff000000ac");
        HasPermOrgResult hasPermOrgResult = SWCPermissionServiceHelper.getPermOrgs((String)"38", (String)"1ANC8T4UC434", (String)parentBillFormId, (String)"47150e89000000ac");
        QFilter adaptionBaseDataBuFilter = null;
        if (hasPermOrgResult != null && !hasPermOrgResult.hasAllOrgPerm()) {
            List hasPermOrgs = hasPermOrgResult.getHasPermOrgs();
            if (!CollectionUtils.isEmpty((Collection)hasPermOrgs)) {
                adaptionBaseDataBuFilter = BaseDataServiceHelper.getBaseDataFilter((String)"lcs_costadaption", (List)hasPermOrgs, (boolean)true);
            }
            CostCfgHelper.addCostStruFilter((BeforeF7SelectEvent)event, (IFormView)this.getView(), (List)hasPermOrgs);
        }
        CostCfgHelper.addBaseDataAndBuFilter((BeforeF7SelectEvent)event, (QFilter)baseDataRuleFilter, adaptionBaseDataBuFilter);
        logger.info("CostCfgStartImportPlugin addCostAdaptionFilter CustomFilters:{}", (Object)event.getCustomQFilters());
    }
}

