/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.pcs.formplugin.web.costmap;

import java.util.Date;
import java.util.EventObject;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.CloseCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.swc.hsbp.business.historynew.BaseDataHisHelper;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.business.tab.UpdateTabNameHelper;
import kd.swc.hsbp.common.cache.SWCPageCache;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.formplugin.web.SWCDataBaseEdit;
import kd.swc.pcs.business.costmap.service.CostItemMapService;

public class CostPayRollGroupMapEdit
extends SWCDataBaseEdit
implements BeforeF7SelectListener {
    private static final Log logger = LogFactory.getLog(CostPayRollGroupMapEdit.class);
    private CostItemMapService costItemMapService = new CostItemMapService();

    public void registerListener(EventObject e) {
        super.registerListener(e);
        BasedataEdit hrOrgEdit = (BasedataEdit)this.getView().getControl("hrorg");
        hrOrgEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit payRollCalEdit = (BasedataEdit)this.getView().getControl("payrollcal");
        payRollCalEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit sourceEdit = (BasedataEdit)this.getView().getControl("source");
        sourceEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit salaryItemEdit = (BasedataEdit)this.getView().getControl("salaryitem");
        salaryItemEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        BasedataEdit costItemEdit = (BasedataEdit)this.getView().getControl("costitem");
        costItemEdit.addBeforeF7SelectListener((BeforeF7SelectListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        long costMapObjId = this.costItemMapService.getCostMapObjId("hsas_payrollgrp");
        this.getView().getModel().setValue("mapobj", (Object)costMapObjId);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        String salaryItemName = this.getView().getModel().getDataEntity().getString("salaryitem.name");
        UpdateTabNameHelper.updateTabNameBySuffixValue((IFormView)this.getView(), (String)salaryItemName);
    }

    public void afterBindData(EventObject eventObject) {
        super.afterBindData(eventObject);
        boolean isHisVersionFlag = BaseDataHisHelper.isHisPage((IFormView)this.getView());
        if (isHisVersionFlag) {
            this.getView().setEnable(Boolean.FALSE, new String[]{"salaryitem", "hrorg", "payrollcal", "source"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"bar_revise"});
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String key;
        switch (key = e.getProperty().getName()) {
            case "payrollcal": {
                this.costItemMapService.orgChange(e, "source", this.getView());
                this.costItemMapService.orgChange(e, "salaryitem", this.getView());
                this.costItemMapService.orgChange(e, "costitem", this.getView());
                break;
            }
            case "source": {
                this.costItemMapService.orgChange(e, "salaryitem", this.getView());
                this.costItemMapService.orgChange(e, "costitem", this.getView());
                break;
            }
            case "hrorg": {
                this.costItemMapService.orgChange(e, "costitem", this.getView());
                break;
            }
            case "salaryitem": {
                this.getView().getModel().setValue("costitem", null);
                break;
            }
        }
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        String baseDataName;
        switch (baseDataName = beforeF7SelectEvent.getProperty().getName()) {
            case "salaryitem": {
                this.addSalaryItemF7Filter(beforeF7SelectEvent);
                break;
            }
            case "source": {
                ListShowParameter param = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                this.addSourceFilter(beforeF7SelectEvent, baseDataName, param);
                break;
            }
            case "payrollcal": {
                Set payRollCalSet = SWCPermissionServiceHelper.getPayrollCalSetByPermItem((String)"1ANC8T4UC434", (String)"pcs_costpayrollgroupmap", (String)"47150e89000000ac");
                if (payRollCalSet == null) break;
                QFilter payRollCalFilter = new QFilter("id", "in", (Object)payRollCalSet);
                beforeF7SelectEvent.addCustomQFilter(payRollCalFilter);
                break;
            }
            case "hrorg": {
                ListShowParameter params = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
                params.setCloseCallBack(new CloseCallBack((IFormPlugin)this, baseDataName));
                break;
            }
            case "costitem": {
                this.addCostItemF7Filter(beforeF7SelectEvent);
                break;
            }
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        Date firstbsed = this.getView().getModel().getDataEntity().getDate("source.firstbsed");
        Date bsed = this.getView().getModel().getDataEntity().getDate("bsed");
        if (firstbsed != null && bsed != null && SWCDateTimeUtils.dayBefore((Date)bsed, (Date)firstbsed)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u751f\u6548\u65e5\u671f\u5e94\u665a\u4e8e\u6216\u7b49\u4e8e\u85aa\u8d44\u6838\u7b97\u7ec4\u7684\u6700\u65e9\u751f\u6548\u65e5\u671f\u3002", (String)"CostPayRollGroupMapEdit_13", (String)"swc-pcs-formplugin", (Object[])new Object[0]));
            args.setCancel(true);
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        this.costItemMapService.updateParentView(args, this.getView());
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String billName = this.getModel().getDataEntityType().getName();
        if ("pcs_costpayrollgroupmap".equals(billName)) {
            this.costItemMapService.costMapCloseCallBack(closedCallBackEvent, this.getView(), CostPayRollGroupMapEdit.class.getName());
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        super.confirmCallBack(messageBoxClosedEvent);
        if (MessageBoxResult.Yes.equals((Object)messageBoxClosedEvent.getResult())) {
            String callBackId = messageBoxClosedEvent.getCallBackId();
            if ("payrollcal".equals(callBackId)) {
                this.getView().getModel().setValue("source", null);
                this.getView().getModel().setValue("salaryitem", null);
            } else if ("hrorg".equals(callBackId)) {
                this.getView().getModel().setValue("costitem", null);
            } else if ("source".equals(callBackId)) {
                this.getView().getModel().setValue("salaryitem", null);
            }
            SWCPageCache swcPageCache = new SWCPageCache(this.getView());
            Long newValue = (Long)swcPageCache.get("newValue", Long.class);
            this.getView().getModel().setValue(callBackId, (Object)newValue);
        }
    }

    private void addSalaryItemF7Filter(BeforeF7SelectEvent beforeF7SelectEvent) {
        long payRollCalOrgId = this.getView().getModel().getDataEntity().getLong("payrollcal.id");
        if (payRollCalOrgId == 0L) {
            String errorMsg = ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u7b97\u53d1\u85aa\u7ba1\u7406\u7ec4\u7ec7\u201d\u3002", (String)"CostPayRollGroupMapEdit_2", (String)"swc-pcs-formplugin", (Object[])new Object[0]);
            this.getView().showTipNotification(errorMsg);
            beforeF7SelectEvent.setCancel(true);
            return;
        }
        long payrollGroupId = this.getView().getModel().getDataEntity().getLong("source.id");
        if (payrollGroupId == 0L) {
            String errorMsg = ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u85aa\u8d44\u6838\u7b97\u7ec4\u201d\u3002", (String)"CostPayRollGroupMapEdit_14", (String)"swc-pcs-formplugin", (Object[])new Object[0]);
            this.getView().showTipNotification(errorMsg);
            beforeF7SelectEvent.setCancel(true);
            return;
        }
        long id = this.getView().getModel().getDataEntity().getLong("id");
        if (id == 0L) {
            id = this.getView().getModel().getDataEntity().getLong("boid");
        }
        long hrOrgId = this.getView().getModel().getDataEntity().getLong("hrorg.id");
        Set calExistSalaryItemIdList = this.costItemMapService.getGroupDBExistSalaryItemIdList(hrOrgId, payRollCalOrgId, payrollGroupId, id, "hsas_payrollgrp");
        QFilter qFilter = new QFilter("datatype", "=", (Object)1020L);
        long countryId = this.getView().getModel().getDataEntity().getLong("source.country.id");
        qFilter.and(new QFilter("country.id", "=", (Object)countryId));
        if (!calExistSalaryItemIdList.isEmpty()) {
            qFilter.and(new QFilter("id", "not in", (Object)calExistSalaryItemIdList));
        }
        QFilter areaTypeFilter = new QFilter("areatype", "=", (Object)"1");
        areaTypeFilter.and(new QFilter("id", "not in", (Object)calExistSalaryItemIdList));
        areaTypeFilter.and(new QFilter("datatype", "=", (Object)1020L));
        qFilter.or(areaTypeFilter);
        logger.info("CostPayRollGroupMapEdit addSalaryItemF7Filter : {}", (Object)qFilter);
        beforeF7SelectEvent.addCustomQFilter(qFilter);
    }

    private void addSourceFilter(BeforeF7SelectEvent beforeF7SelectEvent, String baseDataName, ListShowParameter param) {
        long payRollCalId = this.getModel().getDataEntity().getLong("payrollcal.id");
        if (payRollCalId == 0L) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u586b\u5199\u201c\u7b97\u53d1\u85aa\u7ba1\u7406\u7ec4\u7ec7\u201d\u3002", (String)"CostPayRollGroupMapEdit_10", (String)"swc-pcs-formplugin", (Object[])new Object[0]));
            beforeF7SelectEvent.setCancel(true);
            return;
        }
        QFilter bizOrgFilter = new QFilter("org.id", "=", (Object)payRollCalId);
        logger.info("CostPayRollGroupMapEdit addSourceFilter : {}", (Object)bizOrgFilter);
        param.getListFilterParameter().getQFilters().add(bizOrgFilter);
        param.setCloseCallBack(new CloseCallBack((IFormPlugin)this, baseDataName));
    }

    private void addCostItemF7Filter(BeforeF7SelectEvent beforeF7SelectEvent) {
        long payrollGroupId = this.getView().getModel().getDataEntity().getLong("source.id");
        if (payrollGroupId == 0L) {
            String errorMsg = ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u85aa\u8d44\u6838\u7b97\u7ec4\u201d\u3002", (String)"CostPayRollGroupMapEdit_14", (String)"swc-pcs-formplugin", (Object[])new Object[0]);
            this.getView().showTipNotification(errorMsg);
            beforeF7SelectEvent.setCancel(true);
            return;
        }
        long salaryItemId = this.getView().getModel().getDataEntity().getLong("salaryitem.id");
        if (salaryItemId == 0L) {
            String errorMsg = ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u201c\u85aa\u916c\u9879\u76ee\u201d\u3002", (String)"CostPayRollGroupMapEdit_15", (String)"swc-pcs-formplugin", (Object[])new Object[0]);
            this.getView().showTipNotification(errorMsg);
            beforeF7SelectEvent.setCancel(true);
            return;
        }
        String areaType = this.getView().getModel().getDataEntity().getString("salaryitem.areatype");
        if ("1".equals(areaType)) {
            QFilter areaTypeQFilter = new QFilter("areatype", "=", (Object)"1");
            beforeF7SelectEvent.addCustomQFilter(areaTypeQFilter);
        } else if ("2".equals(areaType)) {
            long countryId = this.getView().getModel().getDataEntity().getLong("salaryitem.country.id");
            QFilter qFilter = new QFilter("country", "=", (Object)countryId);
            beforeF7SelectEvent.addCustomQFilter(qFilter);
        }
    }
}

