/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.pcs.formplugin.web.costsetup;

import java.util.EventObject;
import java.util.HashMap;
import java.util.Locale;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.BosErrorCode;
import kd.bos.exception.KDException;
import kd.bos.form.control.Button;
import kd.bos.form.control.Control;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.swc.hsbp.business.servicehelper.SWCSalaryParameterServiceHelper;
import kd.swc.hsbp.common.cache.ISWCAppCache;
import kd.swc.hsbp.common.cache.SWCAppCache;

public class CostToolPlugin
extends AbstractFormPlugin {
    private static final String IS_OPEN_COST_RECORD = "isopencostrecord";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        Button openControl = (Button)this.getControl("openrecord");
        openControl.addClickListener((ClickListener)this);
        Button closeControl = (Button)this.getControl("closerecord");
        closeControl.addClickListener((ClickListener)this);
    }

    public void click(EventObject evt) {
        String key;
        super.click(evt);
        Control control = (Control)evt.getSource();
        switch (key = control.getKey()) {
            case "openrecord": {
                this.setRecordValue(true);
                break;
            }
            case "closerecord": {
                this.setRecordValue(false);
                break;
            }
        }
    }

    private void setRecordValue(boolean flag) {
        boolean isSuccess = true;
        try {
            HashMap<String, Boolean> paramMap = SWCSalaryParameterServiceHelper.getSalaryParam((long)1010L);
            if (paramMap == null) {
                paramMap = new HashMap<String, Boolean>(16);
            }
            paramMap.put("enablerecord", flag);
            SWCSalaryParameterServiceHelper.setSalaryParam((long)1010L, paramMap);
            ISWCAppCache appCache = SWCAppCache.get((String)IS_OPEN_COST_RECORD);
            appCache.put(IS_OPEN_COST_RECORD, paramMap);
        }
        catch (Exception e) {
            isSuccess = false;
            throw new KDException((Throwable)e, BosErrorCode.sQL, new Object[]{String.format(Locale.ROOT, "Error:%s", e.getMessage())});
        }
        finally {
            if (isSuccess) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u65e5\u5fd7\u5f00\u5173\u8bbe\u7f6e\u6210\u529f\u3002", (String)"CostToolPlugin_0", (String)"swc-pcs-formplugin", (Object[])new Object[0]));
            } else {
                this.getView().showErrorNotification(ResManager.loadKDString((String)"\u65e5\u5fd7\u5f00\u5173\u8bbe\u7f6e\u5931\u8d25\u3002", (String)"CostToolPlugin_1", (String)"swc-pcs-formplugin", (Object[])new Object[0]));
            }
        }
    }
}

