/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.pcs.business.costallot;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.list.column.AmountColumnDesc;
import kd.bos.entity.list.column.ColumnDesc;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.hr.hbp.business.bgtask.HRBackgroundTaskHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.pcs.business.costallot.CostSplitHelper;
import kd.swc.pcs.business.costallot.service.CostBuildAllotBillService;
import kd.swc.pcs.business.costcfg.CostSetUpHelper;
import kd.swc.pcs.common.constants.OperateTypeEnum;

public class CostAllotDetailHelper {
    private static final Log LOGGER = LogFactory.getLog(CostAllotDetailHelper.class);
    private static final String PCS_ALLOTDETAILENTRY = "pcs_allotdetailentry";
    private static final String FILTRATION_UNDERLINE = "_";
    private static final String[] FILTRATION_BASICFIELD = new String[]{"id", "allotbillstatus", "allotbillno", "allotbill", "isadjustment"};

    public static DynamicObject queryCostAllotByPkId(String selectProperties, Long allotDetailId) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("pcs_allotdetail");
        return helper.queryOne(selectProperties, (Object)allotDetailId);
    }

    public static DynamicObjectCollection queryAllotDetailBillList(String selectProperties, List<Long> calTaskList) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("pcs_allotdetail");
        QFilter qFilter = new QFilter("caltask", "in", calTaskList);
        qFilter.and(new QFilter("allotbillstatus", "=", (Object)"B"));
        return helper.queryOriginalCollection(selectProperties, new QFilter[]{qFilter});
    }

    public static boolean isExistsAdjustment(Long allotDetailId) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("pcs_allotdetail");
        return helper.isExists(new QFilter[]{new QFilter("parentid", "=", (Object)allotDetailId)});
    }

    public static DynamicObject queryCostAllotByPkId(Long allotDetailId) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("pcs_allotdetail");
        return helper.queryOne((Object)allotDetailId);
    }

    public static DynamicObject copyWholeAllotDetail2Balance(DynamicObject allotDetail) {
        SWCDataServiceHelper allotDetailHelper = new SWCDataServiceHelper("pcs_allotdetail");
        DynamicObject allotDetailCopied = allotDetailHelper.generateEmptyDynamicObject();
        DataEntityPropertyCollection properties = allotDetail.getDataEntityType().getProperties();
        List<String> filterFiledList = Arrays.asList(FILTRATION_BASICFIELD);
        for (IDataEntityProperty prop : properties) {
            String propName = prop.getName();
            if (filterFiledList.contains(propName) || propName.contains(FILTRATION_UNDERLINE)) continue;
            allotDetailCopied.set(propName, allotDetail.get(propName));
        }
        Long userId = RequestContext.get().getCurrUserId();
        Date currentTime = new Date();
        allotDetailCopied.set("createtime", (Object)currentTime);
        allotDetailCopied.set("creator", (Object)userId);
        allotDetailCopied.set("modifier", (Object)userId);
        allotDetailCopied.set("modifytime", (Object)currentTime);
        allotDetailCopied.set("adjuststatus", (Object)"1");
        allotDetailCopied.set("allotbillstatus", (Object)"A");
        allotDetailCopied.set("parentid", (Object)allotDetail.getLong("id"));
        allotDetailCopied.set("allotbill", (Object)0L);
        DynamicObjectCollection originalAllotDetailEntry = allotDetail.getDynamicObjectCollection(PCS_ALLOTDETAILENTRY);
        for (DynamicObject originalAllotDetailEntryObj : originalAllotDetailEntry) {
            DynamicObject allotDetailEntryObj = allotDetailHelper.generateEmptyEntryDynamicObject(PCS_ALLOTDETAILENTRY);
            properties = allotDetailEntryObj.getDataEntityType().getProperties();
            for (IDataEntityProperty prop : properties) {
                String propName = prop.getName();
                if ("id".equals(propName) || propName.contains(FILTRATION_UNDERLINE)) continue;
                allotDetailEntryObj.set(propName, originalAllotDetailEntryObj.get(propName));
            }
            allotDetailCopied.getDynamicObjectCollection(PCS_ALLOTDETAILENTRY).add((Object)allotDetailEntryObj);
        }
        return allotDetailCopied;
    }

    public static DynamicObject copyWholeAllotDetail2CostAdjustment(DynamicObject allotDetail) {
        SWCDataServiceHelper allotDetailHelper = new SWCDataServiceHelper("pcs_allotdetail");
        DynamicObject allotDetailCopied = allotDetailHelper.generateEmptyDynamicObject();
        DataEntityPropertyCollection properties = allotDetail.getDataEntityType().getProperties();
        List<String> filterFiledList = Arrays.asList(FILTRATION_BASICFIELD);
        for (IDataEntityProperty prop : properties) {
            String propName = prop.getName();
            if (filterFiledList.contains(propName) || propName.contains(FILTRATION_UNDERLINE) || "costsetupconst".equals(propName)) continue;
            allotDetailCopied.set(propName, allotDetail.get(propName));
        }
        Long userId = RequestContext.get().getCurrUserId();
        Date currentTime = new Date();
        allotDetailCopied.set("createtime", (Object)currentTime);
        allotDetailCopied.set("creator", (Object)userId);
        allotDetailCopied.set("modifier", (Object)userId);
        allotDetailCopied.set("modifytime", (Object)currentTime);
        allotDetailCopied.set("adjuststatus", (Object)"2");
        allotDetailCopied.set("allotbillstatus", (Object)"A");
        allotDetailCopied.set("parentid", (Object)allotDetail.getLong("id"));
        allotDetailCopied.set("allotbill", (Object)0L);
        return allotDetailCopied;
    }

    public static DynamicObject generateBalanceAllotDetail(DynamicObject allotDetail) {
        DynamicObject balanceAllotDetail = CostAllotDetailHelper.copyWholeAllotDetail2Balance(allotDetail);
        DynamicObjectCollection balanceAllotDetailEntry = balanceAllotDetail.getDynamicObjectCollection(PCS_ALLOTDETAILENTRY);
        balanceAllotDetailEntry.forEach(balanceAllotDetailEntryObj -> {
            BigDecimal assuAmount = balanceAllotDetailEntryObj.getBigDecimal("assuamount");
            BigDecimal calAmount = balanceAllotDetailEntryObj.getBigDecimal("calamount");
            assuAmount = assuAmount.negate();
            calAmount = calAmount.negate();
            balanceAllotDetailEntryObj.set("assuamount", (Object)assuAmount);
            balanceAllotDetailEntryObj.set("calamount", (Object)calAmount);
        });
        return balanceAllotDetail;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void doSaveCostAdjustment(IFormView view) {
        ArrayList<Long> allotDetailIdList = new ArrayList<Long>(10);
        try (TXHandle txHandle = null;){
            txHandle = TX.requiresNew();
            CostAllotDetailHelper.adjustAmount(view);
            Long allotDetailId = (Long)view.getFormShowParameter().getCustomParam("allotDetailId");
            DynamicObject allotDetail = CostAllotDetailHelper.queryCostAllotByPkId(allotDetailId);
            SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper("pcs_allotdetail");
            DynamicObject balanceAllotDetail = CostAllotDetailHelper.generateBalanceAllotDetail(allotDetail);
            String description = view.getModel().getDataEntity().getString("description");
            CostAllotDetailHelper.updateAllotDetail(allotDetail, serviceHelper);
            balanceAllotDetail.set("description", (Object)description);
            Object balanceAllotDetailSaved = serviceHelper.saveOne(balanceAllotDetail);
            allotDetailIdList.add(((DynamicObject)balanceAllotDetailSaved).getLong("id"));
            long costStructId = balanceAllotDetail.getLong("costadapter.coststru.id");
            Map<String, Long> costSetUpConstValMd5RefIdMapDB = CostAllotDetailHelper.queryCostSetUpConstValMd5RefIdMap(costStructId);
            Map<String, Long> setUpConstMd5RefIdMap = CostAllotDetailHelper.saveCostConst(view, costStructId, serviceHelper, costSetUpConstValMd5RefIdMapDB);
            Object[] allotDetailSavedArr = CostAllotDetailHelper.saveAllotDetail(view, allotDetail, serviceHelper, costSetUpConstValMd5RefIdMapDB, setUpConstMd5RefIdMap);
            CostAllotDetailHelper.updateDetailModifyTime(allotDetail);
            Object operateRecSavedObj = CostAllotDetailHelper.saveOperateRec(serviceHelper);
            CostAllotDetailHelper.saveAdjustmentOpDetail(serviceHelper, allotDetailIdList, allotDetailId, allotDetailSavedArr, operateRecSavedObj);
        }
        CostAllotDetailHelper.buildAllotBill(allotDetailIdList, view);
    }

    private static void adjustAmount(IFormView view) {
        DynamicObjectCollection allotDetailPageEntry = view.getModel().getDataEntity().getDynamicObjectCollection("allotdetailent");
        if (allotDetailPageEntry.size() > 1) {
            BigDecimal assBigDecimalSum = BigDecimal.ZERO;
            BigDecimal calBigDecimalSum = BigDecimal.ZERO;
            for (int i = 0; i < allotDetailPageEntry.size() - 1; ++i) {
                DynamicObject allotDetailPageDy = (DynamicObject)allotDetailPageEntry.get(i);
                BigDecimal assBigDecimal = allotDetailPageDy.getBigDecimal("realassamount");
                BigDecimal calBigDecimal = allotDetailPageDy.getBigDecimal("realcalamount");
                assBigDecimalSum = assBigDecimalSum.add(assBigDecimal);
                calBigDecimalSum = calBigDecimalSum.add(calBigDecimal);
            }
            BigDecimal assAmount = view.getModel().getDataEntity().getBigDecimal("assuamount");
            BigDecimal calAmount = view.getModel().getDataEntity().getBigDecimal("calamount");
            ((DynamicObject)allotDetailPageEntry.get(allotDetailPageEntry.size() - 1)).set("realassamount", (Object)assAmount.subtract(assBigDecimalSum));
            ((DynamicObject)allotDetailPageEntry.get(allotDetailPageEntry.size() - 1)).set("realcalamount", (Object)calAmount.subtract(calBigDecimalSum));
        }
    }

    private static void buildAllotBill(List<Long> allotDetailIdList, IFormView view) {
        try {
            if (!allotDetailIdList.isEmpty() && view.getModel().getDataEntity().getBoolean("createallotbilll")) {
                CostBuildAllotBillService costBuildAllotBillService = new CostBuildAllotBillService();
                HashMap<String, Object> filterMap = new HashMap<String, Object>(allotDetailIdList.size());
                Long costAdapterId = Long.valueOf(view.getPageCache().get("costAdapterId"));
                DynamicObject splitBillRule = CostSplitHelper.getSplitBillRuleByAdaptionId(costAdapterId);
                if (splitBillRule == null) {
                    LOGGER.error("no costAdapterId, do not build allotbill");
                    return;
                }
                filterMap.put("allotDetailIdList", allotDetailIdList);
                filterMap.put("costadaptionid", costAdapterId);
                filterMap.put("splitbillruleid", splitBillRule.getLong("id"));
                costBuildAllotBillService.buildAllotBill(filterMap);
            }
        }
        catch (Exception e) {
            LOGGER.error("build AllotBill error:{}", (Object)e.getMessage());
            view.getParentView().showErrorNotification(ResManager.loadKDString((String)"\u751f\u6210\u5206\u914d\u5355\u5931\u8d25\uff0c\u8bf7\u624b\u52a8\u91cd\u65b0\u751f\u6210\u3002", (String)"CostAllotDetailHelper_0", (String)"swc-pcs-business", (Object[])new Object[0]));
            view.sendFormAction(view.getParentView());
        }
    }

    private static void updateAllotDetail(DynamicObject allotDetail, SWCDataServiceHelper serviceHelper) {
        allotDetail.set("isadjustment", (Object)Boolean.TRUE);
        allotDetail.set("adjuststatus", (Object)"0");
        allotDetail.set("modifytime", (Object)new Date());
        long userId = RequestContext.get().getCurrUserId();
        allotDetail.set("creator", (Object)userId);
        serviceHelper.saveOne(allotDetail);
    }

    private static Map<String, Long> saveCostConst(IFormView view, long costStructId, SWCDataServiceHelper serviceHelper, Map<String, Long> costSetUpConstValMd5RefIdMapDB) {
        DynamicObjectCollection allotDetailPageEntry = view.getModel().getDataEntity().getDynamicObjectCollection("allotdetailent");
        DynamicObjectCollection costConstColl = CostAllotDetailHelper.generateConst(allotDetailPageEntry, costStructId, costSetUpConstValMd5RefIdMapDB);
        HashMap<String, Long> setUpConstMd5RefIdMap = new HashMap<String, Long>(allotDetailPageEntry.size());
        if (!costConstColl.isEmpty()) {
            serviceHelper.setEntityName("pcs_costsetupconst");
            Object[] costConstSaved = serviceHelper.save(costConstColl);
            if (costConstSaved != null) {
                for (Object costConstSavedObj : costConstSaved) {
                    DynamicObject costConst = (DynamicObject)costConstSavedObj;
                    String costStructCfgValueMd5 = costConst.getString("segmentvalmd5");
                    long costSetupConstId = costConst.getLong("id");
                    setUpConstMd5RefIdMap.put(costStructCfgValueMd5, costSetupConstId);
                }
            }
        }
        return setUpConstMd5RefIdMap;
    }

    private static Object[] saveAllotDetail(IFormView view, DynamicObject allotDetail, SWCDataServiceHelper serviceHelper, Map<String, Long> costSetUpConstValMd5RefIdMap, Map<String, Long> setUpConstMd5RefIdMap) {
        serviceHelper.setEntityName("pcs_allotdetail");
        DynamicObjectCollection allotDetailColl = new DynamicObjectCollection();
        DynamicObjectCollection allotDetailPageEntry = view.getModel().getDataEntity().getDynamicObjectCollection("allotdetailent");
        for (DynamicObject allotDetailEntObj : allotDetailPageEntry) {
            DynamicObject allotDetailCopied = CostAllotDetailHelper.copyWholeAllotDetail2CostAdjustment(allotDetail);
            String costSetUpcConstVal = allotDetailEntObj.getString("costsetupconstval");
            BigDecimal realAssAmount = allotDetailEntObj.getBigDecimal("realassamount");
            if (SWCStringUtils.isEmpty((String)costSetUpcConstVal) || realAssAmount.compareTo(BigDecimal.ZERO) == 0) {
                LOGGER.error("costSetUpcConstVal or realAssAmount is null.costSetUpcConstVal:{},realAssAmount:{}", (Object)costSetUpcConstVal, (Object)realAssAmount);
                continue;
            }
            String costStructCfgValueMd5 = SWCStringUtils.getMD5str((String)costSetUpcConstVal);
            allotDetailCopied.set("costsetupconstval", (Object)costSetUpcConstVal);
            Long costSetUpConstId = setUpConstMd5RefIdMap.get(costStructCfgValueMd5);
            Long existedCostSetUpConstId = costSetUpConstValMd5RefIdMap.get(costStructCfgValueMd5);
            if (existedCostSetUpConstId != null) {
                allotDetailCopied.set("costsetupconst", (Object)existedCostSetUpConstId);
            } else if (costSetUpConstId != null) {
                allotDetailCopied.set("costsetupconst", (Object)costSetUpConstId);
            }
            DynamicObject allotDetailEntryObj = serviceHelper.generateEmptyEntryDynamicObject(PCS_ALLOTDETAILENTRY);
            allotDetailEntryObj.set("costitem", (Object)allotDetailEntObj.getLong("costitem.id"));
            allotDetailEntryObj.set("assuamount", (Object)realAssAmount);
            allotDetailEntryObj.set("calamount", (Object)allotDetailEntObj.getBigDecimal("realcalamount"));
            allotDetailEntryObj.set("calcurrency", (Object)Long.valueOf(view.getPageCache().get("calcurrency")));
            allotDetailEntryObj.set("assucurrency", (Object)Long.valueOf(view.getPageCache().get("assucurrency")));
            DynamicObjectCollection entryColl = allotDetailCopied.getDynamicObjectCollection(PCS_ALLOTDETAILENTRY);
            entryColl.clear();
            entryColl.add((Object)allotDetailEntryObj);
            allotDetailColl.add((Object)allotDetailCopied);
        }
        return serviceHelper.save(allotDetailColl);
    }

    private static DynamicObjectCollection generateConst(DynamicObjectCollection allotDetailPageEntry, long costStructId, Map<String, Long> costSetUpConstValMd5RefIdMapDB) {
        DynamicObjectCollection costConstColl = new DynamicObjectCollection();
        ORM orm = ORM.create();
        Map<Long, String> costDimensionIdRefStorageSetNumberMap = CostAllotDetailHelper.getCostDimensionIdRefStorageSetNumberMap(costStructId);
        int createConstSize = CostAllotDetailHelper.getCreateConstSize(allotDetailPageEntry, costSetUpConstValMd5RefIdMapDB);
        DynamicObject costSetupConstObj = BusinessDataServiceHelper.newDynamicObject((String)"pcs_costsetupconst");
        long[] costSetupConstObjIds = orm.genLongIds(costSetupConstObj.getDataEntityType(), createConstSize);
        int index = 0;
        for (DynamicObject allotDetailEntObj : allotDetailPageEntry) {
            BigDecimal realAssAmount = allotDetailEntObj.getBigDecimal("realassamount");
            String costSetUpcConstVal = allotDetailEntObj.getString("costsetupconstval");
            if (realAssAmount == null || SWCStringUtils.isEmpty((String)costSetUpcConstVal)) {
                LOGGER.error("realAssAmount or costSetUpcConstVal is null,realAssAmount:{},costSetUpcConstVal:{}", (Object)realAssAmount, (Object)costSetUpcConstVal);
                continue;
            }
            String costStructCfgValueMd5 = SWCStringUtils.getMD5str((String)costSetUpcConstVal);
            Long costSetUpConstId = costSetUpConstValMd5RefIdMapDB.get(costStructCfgValueMd5);
            if (costSetUpConstId != null) continue;
            String setUpConstVal = allotDetailEntObj.getString("setupconstval");
            JSONObject parseObject = JSONObject.parseObject((String)setUpConstVal);
            DynamicObject costSetUpConstObj = CostAllotDetailHelper.createObjAndSetDefaultVal("pcs_costsetupconst");
            long costSetupConstId = costSetupConstObjIds[index++];
            costSetupConstObj.set("id", (Object)costSetupConstId);
            costSetUpConstObj.set("coststru", (Object)costStructId);
            costSetUpConstObj.set("segmentvalmd5", (Object)costStructCfgValueMd5);
            StringBuilder sb = new StringBuilder();
            for (Map.Entry<Long, String> entry : costDimensionIdRefStorageSetNumberMap.entrySet()) {
                Long costDimensionId = entry.getKey();
                String storageSetNum = entry.getValue();
                String propertyName = String.join((CharSequence)"", "segment", storageSetNum);
                Object value = parseObject.get((Object)costDimensionId.toString());
                String nameVal = "";
                if (value == null) {
                    sb.append(' ').append('.');
                } else {
                    boolean contains;
                    String valueStr = String.valueOf(value);
                    nameVal = CostSetUpHelper.getNameVal(valueStr);
                    sb.append(nameVal).append('.');
                    if (SWCStringUtils.isNotEmpty((String)valueStr) && (contains = valueStr.contains("||"))) {
                        nameVal = valueStr.substring(0, valueStr.indexOf("||"));
                    }
                }
                costSetUpConstObj.set(propertyName, (Object)nameVal);
            }
            costSetUpConstObj.set("segmentval", (Object)(sb.length() > 0 ? sb.substring(0, sb.length() - 1) : ""));
            costConstColl.add((Object)costSetUpConstObj);
        }
        return costConstColl;
    }

    private static Object saveOperateRec(SWCDataServiceHelper serviceHelper) {
        DynamicObject operateRec = CostAllotDetailHelper.createObjAndSetDefaultVal("pcs_operaterec");
        operateRec.set("operatetype", (Object)OperateTypeEnum.COST_ADJUSTMENT.getCode());
        serviceHelper.setEntityName("pcs_operaterec");
        return serviceHelper.saveOne(operateRec);
    }

    private static void saveAdjustmentOpDetail(SWCDataServiceHelper serviceHelper, List<Long> allotDetailIdList, Long allotDetailId, Object[] allotDetailSavedArr, Object operateRecSavedObj) {
        if (operateRecSavedObj == null) {
            LOGGER.error("operateRec is null");
            return;
        }
        if (allotDetailSavedArr == null || allotDetailSavedArr.length == 0) {
            return;
        }
        DynamicObjectCollection adjustmentOpDetailColl = new DynamicObjectCollection();
        for (Object allotDetailSaved : allotDetailSavedArr) {
            long allotDetailSavedId = ((DynamicObject)allotDetailSaved).getLong("id");
            allotDetailIdList.add(allotDetailSavedId);
            DynamicObject adjustmentOpDetail = CostAllotDetailHelper.createObjAndSetDefaultVal("pcs_adjustmentopdetail");
            adjustmentOpDetail.set("adjustmentoprec", operateRecSavedObj);
            adjustmentOpDetail.set("opallotdetail", (Object)allotDetailId);
            adjustmentOpDetail.set("newallotdetail", (Object)allotDetailSavedId);
            adjustmentOpDetailColl.add((Object)adjustmentOpDetail);
        }
        serviceHelper.setEntityName("pcs_adjustmentopdetail");
        serviceHelper.save(adjustmentOpDetailColl);
    }

    private static int getCreateConstSize(DynamicObjectCollection allotDetailPageEntry, Map<String, Long> costSetUpConstValMd5RefIdMap) {
        int index = 0;
        for (DynamicObject allotDetailEntObj : allotDetailPageEntry) {
            String costSetUpcConstVal = allotDetailEntObj.getString("costsetupconstval");
            String costStructCfgValueMd5 = SWCStringUtils.getMD5str((String)costSetUpcConstVal);
            Long costSetUpConstId = costSetUpConstValMd5RefIdMap.get(costStructCfgValueMd5);
            if (costSetUpConstId != null) continue;
            ++index;
        }
        return index;
    }

    public static DynamicObject querySetUpConstObjById(Long constId) {
        SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper("pcs_costsetupconst");
        return serviceHelper.queryOne("segment1,segment2,segment3,segment4,segment5,segment6,segment7,segment8,segment9,segment10,segment11,segment12,segment13,segment14,segment15,segment16,segment17,segment18,segment19,segment20,segment21,segment22,segment23,segment24,segment25,segment26,segment27,segment28,segment29,segment30", (Object)constId);
    }

    public static Map<String, Long> queryCostSetUpConstValMd5RefIdMap(long costStructId) {
        SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper("pcs_costsetupconst");
        QFilter costStruFilter = new QFilter("coststru", "=", (Object)costStructId);
        DynamicObject[] costSetUpConstArr = serviceHelper.queryOriginalArray("id,coststru,segmentvalmd5", new QFilter[]{costStruFilter});
        HashMap<String, Long> costSetUpConstValMd5RefIdMap = new HashMap<String, Long>(costSetUpConstArr.length);
        for (DynamicObject setUpConstObj : costSetUpConstArr) {
            String segmentValMd5 = setUpConstObj.getString("segmentvalmd5");
            costSetUpConstValMd5RefIdMap.put(segmentValMd5, setUpConstObj.getLong("id"));
        }
        return costSetUpConstValMd5RefIdMap;
    }

    public static String getIdVal(String segStoreValue) {
        if (SWCStringUtils.isEmpty((String)segStoreValue)) {
            return "";
        }
        return segStoreValue;
    }

    public static FormShowParameter getDimensionFormShowParameter(JSONObject paramJSONObject) {
        FormShowParameter parameter = new FormShowParameter();
        parameter.setFormId("pcs_showdimension");
        parameter.getOpenStyle().setShowType(ShowType.Modal);
        parameter.setShowTitle(true);
        parameter.setCustomParam("paramData", (Object)paramJSONObject);
        return parameter;
    }

    public static List<Long> getPkIds(DynamicObject[] dataEntities) {
        ArrayList<Long> pkIds = new ArrayList<Long>(dataEntities.length);
        for (DynamicObject dataEntity : dataEntities) {
            pkIds.add(dataEntity.getLong("id"));
        }
        return pkIds;
    }

    public static List<String> queryIsRequiredDimensionIdList(Long costStructId) {
        SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper("lcs_coststru");
        DynamicObject costStruObj = serviceHelper.queryOne("costdimension,isrequired", (Object)costStructId);
        DynamicObjectCollection entryEntity = costStruObj.getDynamicObjectCollection("dimensionentry");
        ArrayList<String> requiredFieldList = new ArrayList<String>(entryEntity.size());
        entryEntity.forEach(entry -> {
            boolean isRequired = entry.getBoolean("isrequired");
            if (isRequired) {
                requiredFieldList.add(entry.getString("costdimension.id"));
            }
        });
        return requiredFieldList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int deleteAllotTaskAndDetail(List<Long> calTaskIds) {
        int taskRows = -1;
        try (TXHandle txHandle = TX.required();){
            DynamicObject[] calTableArr;
            QFilter taskFilter = new QFilter("caltask", "in", calTaskIds);
            SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper("pcs_allottask");
            taskRows = serviceHelper.deleteByFilter(new QFilter[]{taskFilter});
            QFilter filter = new QFilter("caltask", "in", calTaskIds);
            serviceHelper = new SWCDataServiceHelper("pcs_allotdetail");
            serviceHelper.deleteByFilter(new QFilter[]{filter});
            serviceHelper = new SWCDataServiceHelper("hsas_calperson");
            QFilter qFilter = new QFilter("caltask", "in", calTaskIds);
            for (DynamicObject calTable : calTableArr = serviceHelper.query("allotstatus,id", new QFilter[]{qFilter})) {
                calTable.set("allotstatus", (Object)"A");
            }
            serviceHelper.update(calTableArr);
        }
        return taskRows;
    }

    public static Long queryAllotBillIdByAllotDetailId(Long allotDetailId) {
        SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper("pcs_allotdetail");
        DynamicObject allotDetail = serviceHelper.queryOne("allotbill", (Object)allotDetailId);
        if (allotDetail != null) {
            long allotbillId = allotDetail.getLong("allotbill");
            return allotbillId;
        }
        return null;
    }

    public static void setGridScaleField(PackageDataEvent e, String decimalFldKey, String currency, int scale) {
        if (e.getSource() instanceof AmountColumnDesc && SWCStringUtils.equals((String)((ColumnDesc)e.getSource()).getFieldProp().getName(), (String)decimalFldKey)) {
            BigDecimal decimal = e.getRowData().getBigDecimal(decimalFldKey);
            BigDecimal formatValue = CostAllotDetailHelper.getScaleFormatValue(decimal, scale);
            String formatValStr = formatValue.toPlainString();
            String formatVal = CostAllotDetailHelper.fmtMicrometer(formatValStr);
            DynamicObject currencySignDobj = e.getRowData().getDynamicObject(currency);
            if (currencySignDobj != null) {
                String currencySignStr = currencySignDobj.getString("sign");
                StringBuilder amountBuilder = new StringBuilder();
                amountBuilder.append(currencySignStr);
                amountBuilder.append(formatVal);
                e.setFormatValue((Object)amountBuilder.toString());
            }
        }
    }

    private static String fmtMicrometer(String text) {
        double number;
        DecimalFormat df;
        if (text.indexOf(46) > 0) {
            int scale = text.length() - text.indexOf(46) - 1;
            if (scale == 0) {
                df = new DecimalFormat("###,##0");
            } else if (scale == 1) {
                df = new DecimalFormat("###,##0.0");
            } else {
                StringBuilder format = new StringBuilder("#,##0.");
                for (int i = 0; i < scale; ++i) {
                    format.append('0');
                }
                df = new DecimalFormat(format.toString());
            }
        } else {
            df = new DecimalFormat("###,##0");
        }
        try {
            number = Double.parseDouble(text);
        }
        catch (Exception e) {
            number = 0.0;
        }
        return df.format(number);
    }

    private static BigDecimal getScaleFormatValue(BigDecimal value, int scale) {
        return value.setScale(scale, 4);
    }

    private static DynamicObject createObjAndSetDefaultVal(String entityName) {
        SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper(entityName);
        DynamicObject dynamicObject = serviceHelper.generateEmptyDynamicObject();
        dynamicObject.set("createtime", (Object)new Date());
        dynamicObject.set("modifytime", (Object)new Date());
        long userId = RequestContext.get().getCurrUserId();
        dynamicObject.set("creator", (Object)userId);
        dynamicObject.set("modifier", (Object)userId);
        return dynamicObject;
    }

    public static Map<Long, String> getCostDimensionIdRefStorageSetNumberMap(long costStructId) {
        SWCDataServiceHelper costStruHelper = new SWCDataServiceHelper("lcs_coststru");
        QFilter filter = new QFilter("id", "=", (Object)costStructId);
        DynamicObject queryResult = costStruHelper.queryOne("id,dimensionentry,costdimension,storageset", new QFilter[]{filter});
        DynamicObjectCollection dimensionEntry = queryResult.getDynamicObjectCollection("dimensionentry");
        HashMap<Long, String> costDimensionIdRefStorageSetNumberMap = new HashMap<Long, String>(dimensionEntry.size());
        for (DynamicObject dimensionDy : dimensionEntry) {
            long costDimensionId = dimensionDy.getLong("costdimension.id");
            String storageSetNumber = dimensionDy.getString("storageset.number");
            costDimensionIdRefStorageSetNumberMap.put(costDimensionId, storageSetNumber);
        }
        return costDimensionIdRefStorageSetNumberMap;
    }

    public static void openCostTaskGenerateScheme(IFormView view, String className) {
        FormShowParameter showParameter = new FormShowParameter();
        showParameter.getOpenStyle().setShowType(ShowType.Modal);
        showParameter.setCustomParam("calTaskId", view.getFormShowParameter().getCustomParam("calTaskId"));
        showParameter.setCustomParam("calTaskName", view.getFormShowParameter().getCustomParam("calTaskName"));
        showParameter.setFormId("pcs_costallottaskscheme");
        CloseCallBack closeCallBack = new CloseCallBack(className, "pcs_costallottaskscheme");
        showParameter.setCloseCallBack(closeCallBack);
        view.showForm(showParameter);
    }

    public static List<Long> getFileIdsByTask(Long taskId) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_calperson");
        QFilter calPersonFilter = new QFilter("caltask", "=", (Object)taskId);
        long currUserId = RequestContext.get().getCurrUserId();
        QFilter salaryFileFilter = SWCPermissionServiceHelper.getDataRuleForBdProp((long)currUserId, (String)"1ANC8T4UC434", (String)"pcs_allotdetail", (String)"salaryfile", (String)"47150e89000000ac");
        if (salaryFileFilter != null) {
            calPersonFilter.and(salaryFileFilter);
        }
        DynamicObjectCollection datas = helper.queryOriginalCollection("salaryfile.id", new QFilter[]{calPersonFilter});
        return datas.stream().map(o -> o.getLong("salaryfile.id")).collect(Collectors.toList());
    }

    public static List<DynamicObject> getCalPersonByTask(Collection<Long> taskIds, Collection<Long> salaryFileList) {
        long currUserId;
        QFilter salaryFileFilter;
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_calperson");
        QFilter calPersonFilter = taskIds.size() == 1 ? new QFilter("caltask", "=", (Object)taskIds.iterator().next()) : new QFilter("caltask", "in", taskIds);
        if (salaryFileList != null) {
            calPersonFilter.and(new QFilter("salaryfile.id", "in", salaryFileList));
        }
        if ((salaryFileFilter = SWCPermissionServiceHelper.getDataRuleForBdProp((long)(currUserId = RequestContext.get().getCurrUserId()), (String)"1ANC8T4UC434", (String)"pcs_allotdetail", (String)"salaryfile", (String)"47150e89000000ac")) != null) {
            calPersonFilter.and(salaryFileFilter);
        }
        return helper.queryOriginalCollection("fid,caltask.id,salaryfile.id", new QFilter[]{calPersonFilter});
    }

    public static void updateDetailModifyTime(DynamicObject allotDetail) {
        DynamicObject[] query;
        SWCDataServiceHelper helper = new SWCDataServiceHelper("pcs_allotdetail");
        long id = allotDetail.getLong("id");
        QFilter filter = new QFilter("id", "=", (Object)id);
        filter.or(new QFilter("parentid", "=", (Object)id));
        for (DynamicObject dy : query = helper.query("modifytime", new QFilter[]{filter})) {
            dy.set("modifytime", (Object)new Date());
        }
        helper.save(query);
    }

    public static void openProgressBallByCalTaskId(IFormView view, String calTaskIds) {
        IFormView parentView;
        HashMap<String, String> params = new HashMap<String, String>(16);
        params.putAll(view.getFormShowParameter().getCustomParams());
        params.put("caltaskids", calTaskIds);
        String mainViewId = "";
        IFormView mainView = view.getMainView();
        if (mainView != null) {
            mainViewId = mainView.getPageId();
        }
        String parentViewId = (parentView = view.getParentView()) == null ? "" : parentView.getPageId();
        String name = ResManager.loadKDString((String)"\u751f\u6210\u6210\u672c\u5206\u644a\u660e\u7ec6\u60ac\u6d6e\u7403\u4efb\u52a1", (String)"CostAllotDetailHelper_3", (String)"swc-pcs-business", (Object[])new Object[0]);
        String taskId = (String)view.getFormShowParameter().getCustomParam("taskId");
        if (SWCStringUtils.isEmpty((String)taskId)) {
            taskId = HRBackgroundTaskHelper.getInstance().createBaskgroundTask("swc_pcs_costallotdetail", name, false, mainViewId, parentViewId, params);
        }
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        HRBackgroundTaskHelper.getInstance().showBaskgroundTask(taskId);
    }
}

