/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.pcs.business.costallot.helper;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.common.constants.SWCCostConstants;
import kd.swc.pcs.business.costallot.vo.CostAllotValidateBatchResult;
import kd.swc.pcs.business.costallot.vo.CostAllotValidateResult;

public class CostAllotHelper {
    private static final Log LOGGER = LogFactory.getLog(CostAllotHelper.class);

    public static Map<Long, Set<String>> countCostSetUpEnable(Map<Long, DynamicObject> taskMap, CostAllotValidateBatchResult batchResult) {
        QFilter qFilter = new QFilter("caltask.id", "in", taskMap.keySet());
        HashSet payrollDateSet = Sets.newHashSetWithExpectedSize((int)taskMap.size());
        HashSet orgIdSet = Sets.newHashSetWithExpectedSize((int)taskMap.size());
        for (Map.Entry<Long, DynamicObject> entry : taskMap.entrySet()) {
            payrollDateSet.add(entry.getValue().getDate("payrolldate"));
            CostAllotValidateResult result = batchResult.resultOf(entry.getKey());
            DynamicObject adapter = result.getDynamicObject();
            if (adapter == null) continue;
            orgIdSet.add(adapter.getLong("createorg.id"));
        }
        if (payrollDateSet.size() == 1) {
            qFilter.and(new QFilter("belongperiod", "=", payrollDateSet.iterator().next()));
        } else {
            qFilter.and(new QFilter("belongperiod", "in", (Object)payrollDateSet));
        }
        if (!orgIdSet.isEmpty()) {
            if (orgIdSet.size() == 1) {
                qFilter.and(new QFilter("hrorg.id", "=", orgIdSet.iterator().next()));
            } else {
                qFilter.and(new QFilter("hrorg.id", "in", (Object)orgIdSet));
            }
        }
        HashMap result = Maps.newHashMapWithExpectedSize((int)taskMap.size());
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)"countCostSetUpEnable", (String)"pcs_costsetuprst", (String)"caltask.id,enable", (QFilter[])new QFilter[]{qFilter}, (String)"");
             DataSet countSet = dataSet.groupBy(new String[]{"caltask.id", "enable"}).finish();){
            for (Row row : countSet) {
                Long taskId = row.getLong("caltask.id");
                String allotStatus = row.getString("enable");
                Set allotStatusSet = result.computeIfAbsent(taskId, ky -> Sets.newHashSetWithExpectedSize((int)4));
                allotStatusSet.add(allotStatus);
            }
        }
        return result;
    }

    public static boolean isOwnCostSetUp(Long calTaskId) {
        QFilter qFilter = CostAllotHelper.getCostSetUpPartitionFilter(calTaskId);
        SWCDataServiceHelper costSetUpHelper = new SWCDataServiceHelper("pcs_costsetuprst");
        boolean flag = costSetUpHelper.isExists(new QFilter[]{qFilter});
        return flag;
    }

    private static QFilter getCostSetUpPartitionFilter(Long calTaskId) {
        SWCDataServiceHelper calTaskHelper = new SWCDataServiceHelper("hsas_calpayrolltask");
        DynamicObject calTaskDy = calTaskHelper.queryOne("payrollgroup.costadaption.id,payrolldate", new QFilter[]{new QFilter("id", "=", (Object)calTaskId)});
        Date payrollDate = calTaskDy.getDate("payrolldate");
        QFilter qFilter = new QFilter("belongperiod", "=", (Object)payrollDate);
        qFilter.and(new QFilter("caltask.id", "=", (Object)calTaskId));
        DynamicObject costAdapterObj = CostAllotHelper.queryCostAdapterIdByCalTaskId(calTaskId);
        if (costAdapterObj != null) {
            long costAdapterId = costAdapterObj.getLong("id");
            SWCDataServiceHelper adaptionHelper = new SWCDataServiceHelper("lcs_costadaption");
            DynamicObject adaptionDy = adaptionHelper.queryOne("createorg.id", new QFilter[]{new QFilter("id", "=", (Object)costAdapterId)});
            long createOrgId = adaptionDy.getLong("createorg.id");
            qFilter.and(new QFilter("hrorg.id", "=", (Object)createOrgId));
        }
        return qFilter;
    }

    public static boolean isOwnErrorCostSetUp(Long calTaskId) {
        QFilter qFilter = CostAllotHelper.getCostSetUpPartitionFilter(calTaskId);
        qFilter.and(new QFilter("enable", "=", (Object)"0"));
        SWCDataServiceHelper costSetUpHelper = new SWCDataServiceHelper("pcs_costsetuprst");
        boolean flag = costSetUpHelper.isExists(new QFilter[]{qFilter});
        return flag;
    }

    public static int isOwnCostSetUpTmp2(Long calTaskId) {
        QFilter qFilter = CostAllotHelper.getCostSetUpPartitionFilter(calTaskId);
        qFilter.and(new QFilter("enable", "=", (Object)"0"));
        SWCDataServiceHelper costSetUpHelper = new SWCDataServiceHelper("pcs_costsetuprst");
        int count = costSetUpHelper.count(new QFilter[]{qFilter});
        return count;
    }

    public static Map<Long, DynamicObject> getSalaryItemIdListByCalTaskId(Long calTaskId) {
        DynamicObject[] queryOriginalArray;
        HashMap<Long, DynamicObject> salaryItemIdRefIsCostallotCostMap = new HashMap<Long, DynamicObject>(16);
        SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper("hsas_calrule");
        DynamicObject calTaskObj = CostAllotHelper.queryCalPalRollTaskObj(calTaskId);
        Long calRuleHisId = calTaskObj.getLong("calrulev.id");
        DynamicObject calRuleHisObj = serviceHelper.queryOne("salaryitem,iscostallot", (Object)calRuleHisId);
        if (calRuleHisObj == null) {
            return salaryItemIdRefIsCostallotCostMap;
        }
        DynamicObjectCollection calRuleItemEntryColl = calRuleHisObj.getDynamicObjectCollection("calruleitementry");
        ArrayList salaryfileItemIdList = new ArrayList(calRuleItemEntryColl.size());
        calRuleItemEntryColl.forEach(calRuleItemEntry -> {
            if (calRuleItemEntry.getBoolean("iscostallot")) {
                salaryfileItemIdList.add(calRuleItemEntry.getLong("salaryitem.id"));
            }
        });
        if (salaryfileItemIdList.isEmpty()) {
            return salaryItemIdRefIsCostallotCostMap;
        }
        serviceHelper.setEntityName("hsbs_salaryitem");
        for (DynamicObject salaryfileItem : queryOriginalArray = serviceHelper.queryOriginalArray("id,name", new QFilter[]{new QFilter("id", "in", salaryfileItemIdList)})) {
            salaryItemIdRefIsCostallotCostMap.put(salaryfileItem.getLong("id"), salaryfileItem);
        }
        return salaryItemIdRefIsCostallotCostMap;
    }

    public static Map<Long, Map<Long, DynamicObject>> getSalaryItemIdListByCalTasks(Map<Long, DynamicObject> taskMap) {
        Map<Long, List<DynamicObject>> taskGroupByRuleHisId = taskMap.values().stream().collect(Collectors.groupingBy(ele -> ele.getLong("calrulev.id")));
        SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper("hsas_calrule");
        DynamicObject[] calRuleHisObjs = serviceHelper.query("fid,salaryitem,iscostallot", new QFilter[]{new QFilter("id", "in", taskGroupByRuleHisId.keySet())});
        HashMap result = Maps.newHashMapWithExpectedSize((int)taskMap.size());
        for (DynamicObject calRuleHisObj : calRuleHisObjs) {
            List<DynamicObject> tasks = taskGroupByRuleHisId.get(calRuleHisObj.getLong("id"));
            if (tasks == null) continue;
            DynamicObjectCollection calRuleItemEntryColl = calRuleHisObj.getDynamicObjectCollection("calruleitementry");
            for (DynamicObject task : tasks) {
                Map itemMap = result.computeIfAbsent(task.getLong("id"), ky -> Maps.newHashMapWithExpectedSize((int)16));
                calRuleItemEntryColl.forEach(calRuleItemEntry -> {
                    if (calRuleItemEntry.getBoolean("iscostallot")) {
                        itemMap.put(calRuleItemEntry.getLong("salaryitem.id"), calRuleItemEntry.getDynamicObject("salaryitem"));
                    }
                });
            }
        }
        return result;
    }

    public static DynamicObject queryCalPalRollTaskObj(Long calTaskId) {
        SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper("hsas_calpayrolltask");
        DynamicObject calTaskObj = serviceHelper.queryOne("calrulev.id,org.id,payrollgroup.id", (Object)calTaskId);
        return calTaskObj;
    }

    public static DynamicObject[] queryCalPalRollTaskObj(Collection<Long> calTaskIds) {
        SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper("hsas_calpayrolltask");
        return serviceHelper.query("calrulev.id,org.id,payrollgroup.id", new QFilter[]{new QFilter("id", "in", calTaskIds)});
    }

    public static Date queryCostAllocationModifyDate(Long calTaskId) {
        SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper("pcs_costallocation");
        DynamicObject costAllocation = serviceHelper.queryOriginalOne("modifytime", new QFilter[]{new QFilter("caltask.id", "=", (Object)calTaskId)});
        return costAllocation.getDate("modifytime");
    }

    public static boolean costCfgModifyTimeIsLaterThanCostAllocationModifyDate(Long costAdapterId, Date costAllocationModifyDate) {
        SWCDataServiceHelper costSetupRstHelper = new SWCDataServiceHelper("pcs_costcfg");
        QFilter commonFilter = new QFilter("costadapter.id", "=", (Object)costAdapterId);
        commonFilter.and(new QFilter("sourcetype.id", "in", (Object)new long[]{SWCCostConstants.COST_TYPE_DEPT, SWCCostConstants.COST_TYPE_ITEM, SWCCostConstants.COST_TYPE_POST, SWCCostConstants.COST_TYPE_EMP, SWCCostConstants.COST_TYPE_SALARYFILE, SWCCostConstants.COST_TYPE_SALARYFILEITEM}));
        commonFilter.and(new QFilter("datastatus", "=", (Object)"1"));
        commonFilter.and(new QFilter("modifytime", ">", (Object)costAllocationModifyDate));
        commonFilter.and(new QFilter("iscurrentversion", "=", (Object)"0"));
        return costSetupRstHelper.isExists(new QFilter[]{commonFilter});
    }

    public static DynamicObject[] queryCostSetUpArr(Long calTaskId, List<Long> salaryfileList) {
        SWCDataServiceHelper costSetupRstHelper = new SWCDataServiceHelper("pcs_costsetuprst");
        QFilter calTaskFilter = new QFilter("caltask.id", "=", (Object)calTaskId);
        calTaskFilter.and(new QFilter("salaryfile.id", "in", salaryfileList));
        String properties = "caltask,salaryfile,salaryitem,costadapter,percentage,defcostsetupconst,defcostsetupconstval,maxmount,isrevealdetail,costitem";
        return costSetupRstHelper.query(properties, new QFilter[]{calTaskFilter});
    }

    public static DynamicObject queryCostAdapterIdByCalTaskId(Long calTaskId) {
        SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper("hsas_calpayrolltask");
        DynamicObject calTaskObj = serviceHelper.queryOne("payrollgroupv", (Object)calTaskId);
        Long payrollGroupVid = calTaskObj.getLong("payrollgroupv.id");
        serviceHelper.setEntityName("pcs_costadaptionmap");
        DynamicObject dynamicObject = serviceHelper.queryOne("costadaption", new QFilter[]{new QFilter("mapobj", "=", (Object)SWCCostConstants.MAPOBJ_PAYROLLGROUP), new QFilter("source", "=", (Object)payrollGroupVid), new QFilter("status", "=", (Object)"C")}, "modifytime desc");
        return dynamicObject == null ? null : dynamicObject.getDynamicObject("costadaption");
    }

    public static Map<Long, DynamicObject> queryCostAdapterIdByCalTaskIds(Map<Long, DynamicObject> calTasks) {
        Map<Long, List<DynamicObject>> taskByGroup = calTasks.values().stream().collect(Collectors.groupingBy(ele -> ele.getLong("payrollgroupv.id")));
        SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper("pcs_costadaptionmap");
        DynamicObject[] costAdaptionMaps = serviceHelper.query("costadaption,source", new QFilter[]{new QFilter("mapobj", "=", (Object)SWCCostConstants.MAPOBJ_PAYROLLGROUP), new QFilter("source", "in", taskByGroup.keySet()), new QFilter("status", "=", (Object)"C")}, "modifytime desc");
        HashMap result = Maps.newHashMapWithExpectedSize((int)calTasks.size());
        for (DynamicObject costAdaptionMap : costAdaptionMaps) {
            long payrollGroup = costAdaptionMap.getLong("source");
            List<DynamicObject> tasks = taskByGroup.remove(payrollGroup);
            if (tasks == null) continue;
            for (DynamicObject task : tasks) {
                result.put(task.getLong("id"), costAdaptionMap.getDynamicObject("costadaption"));
            }
        }
        return result;
    }

    public static DynamicObject[] queryCostAllotByCalTask(String selectProperties, Long calTaskId) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("pcs_allotdetail");
        return helper.query(selectProperties, new QFilter[]{new QFilter("caltask", "=", (Object)calTaskId)});
    }

    public static boolean existCreatedAllotDetailByTaskId(Long calTaskId) {
        QFilter calPersonFilter = new QFilter("caltask", "=", (Object)calTaskId);
        calPersonFilter.and(new QFilter("allotstatus", "=", (Object)"B"));
        SWCDataServiceHelper calPersonHelper = new SWCDataServiceHelper("hsas_calperson");
        return calPersonHelper.isExists(new QFilter[]{calPersonFilter});
    }

    public static DynamicObject getCostAllotCalTaskId(Long costAllocationId) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("pcs_allottask");
        QFilter filter = new QFilter("id", "=", (Object)costAllocationId);
        return helper.queryOne("id,caltask", new QFilter[]{filter});
    }

    public static DynamicObject[] getCostAllotCalTaskIds(Collection<Long> costAllocationIds) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("pcs_allottask");
        QFilter filter = new QFilter("id", "in", costAllocationIds);
        return helper.query("id,caltask", new QFilter[]{filter});
    }

    public static boolean checkGenerateAllotPerm(long calTaskId) {
        Set payrollGroupIdSet;
        Set payRollCalSet;
        long payrollGroupId;
        DynamicObject calTaskDy = CostAllotHelper.queryCalPalRollTaskObj(calTaskId);
        long orgId = calTaskDy.getLong("org.id");
        boolean flag = CostAllotHelper.isHavePerm(orgId, payrollGroupId = calTaskDy.getLong("payrollgroup.id"), payRollCalSet = SWCPermissionServiceHelper.getPayrollCalSetByPermItem((String)"1ANC8T4UC434", (String)"pcs_allotdetail", (String)"47150e89000000ac"), payrollGroupIdSet = SWCPermissionServiceHelper.getPayrollGrpSetByPermItem((String)"1ANC8T4UC434", (String)"pcs_allotdetail", (String)"47150e89000000ac"));
        if (flag) {
            LOGGER.info("dimvalueresult no perm");
            return false;
        }
        return true;
    }

    public static Map<Long, DynamicObject> checkGenerateAllotPerm(Collection<Long> calTaskIds) {
        Object[] calTaskDys = CostAllotHelper.queryCalPalRollTaskObj(calTaskIds);
        if (ArrayUtils.isEmpty((Object[])calTaskDys)) {
            return Maps.newHashMap();
        }
        Set payRollCalSet = SWCPermissionServiceHelper.getPayrollCalSetByPermItem((String)"1ANC8T4UC434", (String)"pcs_allotdetail", (String)"47150e89000000ac");
        Set payrollGroupIdSet = SWCPermissionServiceHelper.getPayrollGrpSetByPermItem((String)"1ANC8T4UC434", (String)"pcs_allotdetail", (String)"47150e89000000ac");
        HashMap result = Maps.newHashMapWithExpectedSize((int)calTaskDys.length);
        for (Object calTaskDy : calTaskDys) {
            long payrollGroupId;
            long orgId = calTaskDy.getLong("org.id");
            if (CostAllotHelper.isHavePerm(orgId, payrollGroupId = calTaskDy.getLong("payrollgroup.id"), payRollCalSet, payrollGroupIdSet)) continue;
            result.put(calTaskDy.getLong("id"), calTaskDy);
        }
        return result;
    }

    public static DynamicObject queryCostAllotByCalTaskId(Long calTaskId) {
        SWCDataServiceHelper costAllocationHelper = new SWCDataServiceHelper("pcs_allottask");
        return costAllocationHelper.queryOne("id,caltask,costtaskstatus", new QFilter[]{new QFilter("caltask.id", "=", (Object)calTaskId)});
    }

    public static Map<Long, DynamicObject> queryCostAllotByCalTaskIds(Collection<Long> calTaskIds) {
        SWCDataServiceHelper costAllocationHelper = new SWCDataServiceHelper("pcs_allottask");
        DynamicObject[] query = costAllocationHelper.query("id,caltask,costtaskstatus", new QFilter[]{new QFilter("caltask.id", "in", calTaskIds)});
        return Arrays.stream(query).collect(Collectors.toMap(ele -> ele.getLong("caltask.id"), ele -> ele, (k1, k2) -> k1));
    }

    private static boolean isHavePerm(long orgId, long payrollGroupId, Set<Long> payRollCalSet, Set<Long> payrollGroupIdSet) {
        return payRollCalSet != null && !payRollCalSet.contains(orgId) || payrollGroupIdSet != null && !payrollGroupIdSet.contains(payrollGroupId);
    }
}

