/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.pcs.business.costallotbill.helper;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.cache.SWCPageCache;
import kd.swc.hsbp.common.util.SWCStringUtils;

public class CostAllotBillHelper {
    private static final String VOUCHERID_REF_ALLOTID = "voucherRefAllotIdRefIdMap";
    private static final Log LOGGER = LogFactory.getLog(CostAllotBillHelper.class);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Map<String, Long> getVoucherIdMap(List<Long> allotBillPkIds) {
        if (CollectionUtils.isEmpty(allotBillPkIds)) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(" SELECT FSOURCEBILLID FSID,FID AS ID FROM T_GL_VOUCHER ");
        sb.append(" WHERE FSOURCEBILLID IN (");
        for (Long fid : allotBillPkIds) {
            sb.append(fid);
            sb.append(',');
        }
        sb.deleteCharAt(sb.length() - 1);
        sb.append(')');
        HashMap<String, Long> returnMap = new HashMap<String, Long>(16);
        try (DataSet dataSet = DB.queryDataSet((String)"kd.swc.pcs.business.costallotbill.helper.CostAllotBillHelper", (DBRoute)DBRoute.of((String)"fa"), (String)sb.toString(), null);){
            for (Row row : dataSet) {
                returnMap.put(row.getString("id"), row.getLong("FSID"));
            }
            HashMap<String, Long> hashMap = returnMap;
            return hashMap;
        }
        catch (Exception e) {
            LOGGER.error("CostAllotBillHelper getVoucherIdMap error", (Object)e.getMessage());
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Map<String, String> getVoucherStatus(List<Long> fidList) {
        if (CollectionUtils.isEmpty(fidList)) {
            return null;
        }
        HashMap<String, String> returnMap = new HashMap<String, String>(16);
        StringBuilder sb = new StringBuilder();
        sb.append(" SELECT AI.FSOURCEBILLID AS ID,GL.FBILLSTATUS AS VOUNCHERSTATUS,GL.FISPOST ISPOST");
        sb.append(" FROM T_ai_daptracker AI LEFT JOIN T_GL_VOUCHER GL");
        sb.append(" ON AI.FVOUCHERID = GL.FID");
        sb.append(" WHERE AI.FSOURCEBILLID IN (");
        for (Long fid : fidList) {
            sb.append(fid);
            sb.append(',');
        }
        sb.deleteCharAt(sb.length() - 1);
        sb.append(')');
        try (DataSet dataSet = DB.queryDataSet((String)"kd.swc.pcs.business.costallotbill.helper.CostAllotBillHelper", (DBRoute)DBRoute.of((String)"fa"), (String)sb.toString(), null);){
            for (Row row : dataSet) {
                String isPost = row.getString("ISPOST");
                if ("1".equals(isPost)) {
                    returnMap.put(row.getString("id"), "E");
                    continue;
                }
                returnMap.put(row.getString("id"), row.getString("VOUNCHERSTATUS"));
            }
            HashMap<String, String> hashMap = returnMap;
            return hashMap;
        }
        catch (Exception e) {
            LOGGER.error("CostAllotBillHelper getVoucherStatus error", (Object)e.getMessage());
            return null;
        }
    }

    public static List<Long> getUnSubmitFinancePkIds(List<Long> selectedPkList) {
        SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper("pcs_allotbill");
        QFilter qFilter = new QFilter("id", "in", selectedPkList);
        DynamicObject[] allotBillObjArr = serviceHelper.query("financingStatus", new QFilter[]{qFilter});
        ArrayList<Long> unSubmitFinancePkIdList = new ArrayList<Long>(allotBillObjArr.length);
        for (DynamicObject allotBillDy : allotBillObjArr) {
            if (!"A".equals(allotBillDy.getString("financingStatus"))) continue;
            unSubmitFinancePkIdList.add(allotBillDy.getLong("id"));
        }
        return unSubmitFinancePkIdList;
    }

    public static void updateFinancingStatus(List<Long> pkIds) {
        DynamicObject[] allotBillObjArr;
        SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper("pcs_allotbill");
        QFilter qFilter = new QFilter("id", "in", pkIds);
        for (DynamicObject obj : allotBillObjArr = serviceHelper.query("financingStatus", new QFilter[]{qFilter})) {
            obj.set("financingStatus", (Object)"A");
        }
        serviceHelper.update(allotBillObjArr);
    }

    public static void updateFinancingStatus(Long pkId) {
        SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper("pcs_allotbill");
        QFilter qFilter = new QFilter("id", "=", (Object)pkId);
        DynamicObject allotBillObj = serviceHelper.queryOne("financingstatus", new QFilter[]{qFilter});
        allotBillObj.set("financingstatus", (Object)"A");
        serviceHelper.updateOne(allotBillObj);
    }

    public static void showAllotDetailList(List<String> billNoList, IFormView view) {
        if (!billNoList.isEmpty()) {
            ListShowParameter showParameter = new ListShowParameter();
            showParameter.setFormId("bos_list");
            showParameter.setBillFormId("pcs_allotdetail");
            showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            showParameter.setCustomParam("allotbillStatus", (Object)"allotbill");
            showParameter.setCustomParam("allotBillNo", billNoList);
            view.showForm((FormShowParameter)showParameter);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int queryVoucherCount(Long fid) {
        StringBuilder sb = new StringBuilder();
        sb.append("SELECT COUNT(1) COUNT");
        sb.append(" FROM T_AI_DAPTRACKER AI LEFT JOIN T_GL_VOUCHER GL ");
        sb.append(" ON AI.FVOUCHERID = GL.FID ");
        sb.append(" WHERE AI.FSOURCEBILLID=");
        sb.append(fid);
        int count = 0;
        try (DataSet dataSet = DB.queryDataSet((String)"kd.swc.pcs.business.costallotbill.helper.CostAllotBillHelper", (DBRoute)DBRoute.of((String)"fa"), (String)sb.toString(), (Object[])null);){
            Iterator dataSetIterator = dataSet.iterator();
            if (dataSetIterator.hasNext()) {
                Row row = (Row)dataSetIterator.next();
                count = row.getInteger("count");
            }
            int n = count;
            return n;
        }
        catch (Exception e) {
            LOGGER.error("CostAllotBillHelper queryVoucherCount error", (Object)e.getMessage());
            return count;
        }
    }

    public static List<Long> getPkIdList(DynamicObject[] dataEntities) {
        ArrayList<Long> pkIds = new ArrayList<Long>(dataEntities.length);
        for (DynamicObject dataEntity : dataEntities) {
            pkIds.add(dataEntity.getLong("id"));
        }
        return pkIds;
    }

    public static DynamicObject[] getCostAllotBillByAllotDetaiIdList(List<Long> allotDetailIdList) {
        SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper("pcs_allotdetail");
        QFilter qFilter = new QFilter("id", "in", allotDetailIdList);
        QFilter billStatusQFilter = new QFilter("allotbillstatus", "=", (Object)"B");
        return serviceHelper.query("allotbill,personorg", new QFilter[]{qFilter, billStatusQFilter});
    }

    public static DynamicObject queryAdapterObj(Long costAdapterId) {
        SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper("lcs_costadaption");
        DynamicObject costAdaption = serviceHelper.queryOriginalOne("coststru.id,createorg.id,currency.id", (Object)costAdapterId);
        return costAdaption;
    }

    public static void clearVoucherIdMap(IFormView view) {
        SWCPageCache pageCache = new SWCPageCache(view);
        pageCache.remove(VOUCHERID_REF_ALLOTID);
    }

    public static Map<String, Long> getVoucherIdRefAllotIdMap(List<Long> entryPkList, IFormView view) {
        SWCPageCache pageCache = new SWCPageCache(view);
        Map<String, Long> voucherIdRefAllotIdMap = (Map<String, Long>)pageCache.get(VOUCHERID_REF_ALLOTID, Map.class);
        if (voucherIdRefAllotIdMap == null) {
            voucherIdRefAllotIdMap = CostAllotBillHelper.getVoucherIdMap(entryPkList);
            pageCache.put(VOUCHERID_REF_ALLOTID, voucherIdRefAllotIdMap);
        }
        return voucherIdRefAllotIdMap;
    }

    public static String getStatusVal(String status) {
        if (SWCStringUtils.isEmpty((String)status)) {
            status = "";
        }
        String statusVal = "";
        switch (status) {
            case "A": {
                statusVal = ResManager.loadKDString((String)"\u6682\u5b58", (String)"CostAllotBillHelper_0", (String)"swc-pcs-business", (Object[])new Object[0]);
                break;
            }
            case "B": {
                statusVal = ResManager.loadKDString((String)"\u5df2\u63d0\u4ea4", (String)"CostAllotBillHelper_1", (String)"swc-pcs-business", (Object[])new Object[0]);
                break;
            }
            case "C": {
                statusVal = ResManager.loadKDString((String)"\u5df2\u5ba1\u6838", (String)"CostAllotBillHelper_2", (String)"swc-pcs-business", (Object[])new Object[0]);
                break;
            }
            case "D": {
                statusVal = ResManager.loadKDString((String)"\u5df2\u5e9f\u5f03", (String)"CostAllotBillHelper_3", (String)"swc-pcs-business", (Object[])new Object[0]);
                break;
            }
            case "E": {
                statusVal = ResManager.loadKDString((String)"\u5df2\u8fc7\u8d26", (String)"CostAllotBillHelper_4", (String)"swc-pcs-business", (Object[])new Object[0]);
                break;
            }
            default: {
                statusVal = ResManager.loadKDString((String)"\u672a\u751f\u6210", (String)"CostAllotBillHelper_5", (String)"swc-pcs-business", (Object[])new Object[0]);
            }
        }
        return statusVal;
    }
}

