/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.pcs.business.costallotbill.service;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.list.BillList;
import kd.bos.list.IListView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.threads.ThreadPools;
import kd.bos.util.CollectionUtils;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.common.cache.SWCPageCache;
import kd.swc.pcs.business.costallotbill.helper.CostAllotBillExportHelper;
import kd.swc.pcs.business.costcommon.CostExportCommonHelper;
import kd.swc.pcs.business.costthread.CostAllotBillExportThread;
import kd.swc.pcs.common.constants.CostAllotBillConstants;
import kd.swc.pcs.common.constants.CostExportConstants;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;

public class CostAllotBillExportService {
    protected static final Log logger = LogFactory.getLog(CostAllotBillExportService.class);
    private Map<Long, String> allotBillNumberMap = new HashMap<Long, String>();
    public static final String SWC_PCS_BUSINESS = "swc-pcs-business";

    public void doExport(IFormView view) {
        IListView listView = (IListView)view;
        ListSelectedRowCollection selectedRows = listView.getSelectedRows();
        if (selectedRows.isEmpty()) {
            this.doExportAll(view);
        } else {
            ArrayList<Long> selectIdList = new ArrayList<Long>(10);
            for (ListSelectedRow row : selectedRows) {
                Long primaryKeyValue = (Long)row.getPrimaryKeyValue();
                if (selectIdList.contains(primaryKeyValue)) continue;
                selectIdList.add(primaryKeyValue);
            }
            int totalPages = (int)Math.ceil((double)selectIdList.size() * 1.0 / (double)CostExportConstants.PAGE_SIZE.intValue());
            this.openExportProgressBar(totalPages, view);
            this.execute(selectIdList, view);
        }
    }

    private void execute(List<Long> selectIdList, IFormView view) {
        logger.info("CostAllotBillExportService execute export data 1");
        RequestContext ctx = RequestContext.get();
        ThreadPools.executeOnce((String)"EXPORT_EXCEL_POOL_FLUSH_DATA_ASYNC", () -> {
            RequestContext.copyAndSet((RequestContext)ctx);
            Map<Long, SXSSFWorkbook> workBookMap = this.doExportSelected(selectIdList, view);
            CostExportCommonHelper.writeWorkBookToFile(workBookMap, view, this.allotBillNumberMap, "2");
        });
    }

    public void exportOneBill(IFormView view) {
        ArrayList<Long> selectIdList = new ArrayList<Long>(10);
        selectIdList.add(view.getModel().getDataEntity().getLong("id"));
        int totalPages = (int)Math.ceil((double)selectIdList.size() * 1.0 / (double)CostExportConstants.PAGE_SIZE.intValue());
        this.openExportProgressBar(totalPages, view);
        Map<Long, SXSSFWorkbook> workBookMap = this.doExportSelected(selectIdList, view);
        CostExportCommonHelper.writeWorkBookToFile(workBookMap, view, this.allotBillNumberMap, "2");
    }

    private void openExportProgressBar(int totalPages, IFormView view) {
        String pageId = view.getPageId();
        FormShowParameter para = new FormShowParameter();
        para.setFormId("pcs_costcommonprogress");
        para.getOpenStyle().setShowType(ShowType.Modal);
        para.setCustomParam("pageId", (Object)pageId);
        para.setCustomParam("title", (Object)ResManager.loadKDString((String)"\u6210\u672c\u5206\u914d\u5355\u5bfc\u51fa\u8fdb\u5ea6", (String)"CostAllotBillExportService_13", (String)SWC_PCS_BUSINESS, (Object[])new Object[0]));
        SWCPageCache pageCache = new SWCPageCache(view);
        if (totalPages <= 0) {
            pageCache.put("progress", (Object)CostAllotBillConstants.PROGRESS_ZERO);
        } else {
            int i = totalPages / 4;
            pageCache.put("progress", (Object)(i / totalPages));
        }
        pageCache.saveChanges();
        CloseCallBack closeCallBack = new CloseCallBack("kd.swc.pcs.formplugin.web.costallot.CostAllotBillList", "openExportProgressBar");
        para.setCloseCallBack(closeCallBack);
        view.showForm(para);
    }

    private Map<Long, Map<String, String>> getAllotBillExportHeaders(List<Long> selectIdList) {
        logger.info("CostAllotBillExportService getAllotBillExportHeaders 7");
        LinkedHashMap<Long, Map<String, String>> result = new LinkedHashMap<Long, Map<String, String>>(selectIdList.size());
        for (Long allotBillId : selectIdList) {
            LinkedHashMap<String, String> map = new LinkedHashMap<String, String>(1);
            map.put("allotbillkey", "");
            map.put("allotbillvalue", "");
            result.put(allotBillId, map);
        }
        return result;
    }

    private Map<Long, Map<String, String>> getAllotBillDetailExportHeaders(List<Long> selectIdList, Map<Long, Long> allotBillAndAdapterMap, Map<Long, Long> adapterAndStruMap, Map<Long, Map<String, String>> dynamicColumnMaps) {
        logger.info("CostAllotBillExportService getAllotBillDetailExportHeaders 8");
        LinkedHashMap<Long, Map<String, String>> allotBillColumnMaps = new LinkedHashMap<Long, Map<String, String>>(16);
        for (Long allotBillId : selectIdList) {
            LinkedHashMap<String, String> columnMap = new LinkedHashMap<String, String>(16);
            columnMap.put("rowSeq", ResManager.loadKDString((String)"\u5e8f\u53f7", (String)"CostAllotBillExportService_2", (String)SWC_PCS_BUSINESS, (Object[])new Object[0]));
            columnMap.put("costitem", ResManager.loadKDString((String)"\u6210\u672c\u9879\u76ee", (String)"CostAllotBillExportService_3", (String)SWC_PCS_BUSINESS, (Object[])new Object[0]));
            Long costAdapterId = allotBillAndAdapterMap.get(allotBillId);
            Long costStruId = adapterAndStruMap.get(costAdapterId);
            Map<String, String> dynamicColumnMap = dynamicColumnMaps.get(costStruId);
            if (!dynamicColumnMap.isEmpty()) {
                columnMap.putAll(dynamicColumnMap);
            }
            columnMap.put("assuamount", ResManager.loadKDString((String)"\u627f\u62c5\u91d1\u989d", (String)"CostAllotBillExportService_4", (String)SWC_PCS_BUSINESS, (Object[])new Object[0]));
            columnMap.put("startdate", ResManager.loadKDString((String)"\u85aa\u8d44\u8d77\u59cb\u65e5\u671f", (String)"CostAllotBillExportService_7", (String)SWC_PCS_BUSINESS, (Object[])new Object[0]));
            columnMap.put("enddate", ResManager.loadKDString((String)"\u85aa\u8d44\u7ed3\u675f\u65e5\u671f", (String)"CostAllotBillExportService_8", (String)SWC_PCS_BUSINESS, (Object[])new Object[0]));
            columnMap.put("paydate", ResManager.loadKDString((String)"\u9884\u8ba1\u652f\u4ed8\u65e5\u671f", (String)"CostAllotBillExportService_15", (String)SWC_PCS_BUSINESS, (Object[])new Object[0]));
            allotBillColumnMaps.put(allotBillId, columnMap);
        }
        return allotBillColumnMaps;
    }

    private void doExportAll(IFormView view) {
        logger.info("CostAllotBillExportService doExportAll 1");
        List<QFilter> allFilterList = this.getAllFilterList(view, "pcs_allotdetail");
        List<Long> selectIdList = CostAllotBillExportHelper.getAllotBillList(allFilterList);
        if (selectIdList.isEmpty()) {
            view.showTipNotification(ResManager.loadKDString((String)"\u6682\u65e0\u5bfc\u51fa\u6570\u636e\u3002", (String)"CostAllotBillExportService_12", (String)SWC_PCS_BUSINESS, (Object[])new Object[0]));
            return;
        }
        int totalPages = (int)Math.ceil((double)selectIdList.size() * 1.0 / (double)CostExportConstants.EXPORT_PAGE_SIZE_ALL.intValue());
        this.openExportProgressBar(totalPages, view);
        this.execute(selectIdList, totalPages, view);
    }

    private List<QFilter> getAllFilterList(IFormView view, String billFormId) {
        BillList billList;
        List filters;
        ArrayList<QFilter> filterList = new ArrayList<QFilter>(10);
        List authorizedDataRuleQFilter = SWCPermissionServiceHelper.getAuthorizedDataRuleQFilter((String)"1ANC8T4UC434", (String)billFormId, (String)"47150e89000000ac");
        if (CollectionUtils.isNotEmpty((Collection)authorizedDataRuleQFilter)) {
            filterList.addAll(authorizedDataRuleQFilter);
        }
        if (CollectionUtils.isNotEmpty((Collection)(filters = (billList = (BillList)((IListView)view).getControl("billlistap")).generalFilterParameter().getQFilters()))) {
            filterList.addAll(filters);
        }
        return filterList;
    }

    private void execute(List<Long> selectIdList, int totalPages, IFormView view) {
        logger.info("CostAllotBillExportService doExportAll execute 2");
        HashMap map = new HashMap(16);
        CountDownLatch countDownLatch = new CountDownLatch(totalPages);
        SWCPageCache pageCache = new SWCPageCache(view);
        RequestContext ctx = RequestContext.get();
        ThreadPools.executeOnce((String)"EXPORT_BILL_EXCEL_POOL_FLUSH_DATA_ASYNC", () -> {
            RequestContext.copyAndSet((RequestContext)ctx);
            logger.info("export data 7");
            logger.info("CostAllotBillExportService doExportAll execute 3");
            for (int pageIndex = 0; pageIndex < totalPages; ++pageIndex) {
                int fromIndex = Math.min(pageIndex * CostExportConstants.EXPORT_PAGE_SIZE_ALL, selectIdList.size());
                int toIndex = Math.min(fromIndex + CostExportConstants.EXPORT_PAGE_SIZE_ALL, selectIdList.size());
                ImmutableList batchList = ImmutableList.copyOf(selectIdList.subList(fromIndex, toIndex));
                Map<Long, SXSSFWorkbook> workBookMap = this.doExportSelected((List<Long>)batchList, view);
                map.putAll(workBookMap);
                countDownLatch.countDown();
                this.updateProgressCache(totalPages, countDownLatch, pageCache);
            }
            logger.info("CostAllotBillExportService doExportAll execute 4");
            try {
                if (countDownLatch.await(10L, TimeUnit.MINUTES)) {
                    logger.info("CostAllotBillExportService doExportAll execute 5");
                    CostExportCommonHelper.writeWorkBookToFile(map, view, this.allotBillNumberMap, "2");
                    logger.info("CostAllotBillExportService doExportAll execute 6");
                }
            }
            catch (InterruptedException e) {
                logger.error("CostAllotBillExportService execute error", (Throwable)e);
            }
            logger.info("CostAllotBillExportService doExportAll execute 10");
        });
    }

    private void updateProgressCache(int totalPages, CountDownLatch countDownLatch, SWCPageCache pageCache) {
        Double percent = totalPages <= 0 ? Double.valueOf(100.0) : Double.valueOf((double)((long)totalPages - countDownLatch.getCount()) * 100.0 / (double)totalPages);
        pageCache.put("progress", (Object)percent);
        pageCache.saveChanges();
    }

    private Map<Long, SXSSFWorkbook> doExportSelected(List<Long> selectIdList, IFormView view) {
        logger.info("CostAllotBillExportService doExportSelected 2");
        Map<Long, Long> allotBillAndAdapterMap = CostAllotBillExportHelper.queryAdapterIdByAllotBills(selectIdList, this.allotBillNumberMap);
        ArrayList<Long> costAdapterIds = new ArrayList<Long>(allotBillAndAdapterMap.values());
        logger.info("CostAllotBillExportService doExportSelected 3");
        Map<Long, Long> adapterAndStruMap = CostAllotBillExportHelper.queryCostStruByAdapter(costAdapterIds);
        ArrayList<Long> costStruIds = new ArrayList<Long>(adapterAndStruMap.values());
        Map<Long, Map<String, String>> dynamicColumnMaps = CostAllotBillExportHelper.getDynamicColumnMap(costStruIds);
        logger.info("CostAllotBillExportService doExportSelected 4");
        int totalPages = (int)Math.ceil((double)selectIdList.size() * 1.0 / (double)CostExportConstants.PAGE_SIZE.intValue());
        logger.info("CostAllotBillExportService doExportSelected 5");
        List<FutureTask<List<List<Map<String, Object>>>>> taskList = this.batchQuerySelectBillExportData(selectIdList, totalPages, adapterAndStruMap);
        return this.batchWriteExportBillContent(selectIdList, allotBillAndAdapterMap, adapterAndStruMap, dynamicColumnMaps, taskList);
    }

    private Map<Long, SXSSFWorkbook> batchWriteExportBillContent(List<Long> selectIdList, Map<Long, Long> allotBillAndAdapterMap, Map<Long, Long> adapterAndStruMap, Map<Long, Map<String, String>> dynamicColumnMaps, List<FutureTask<List<List<Map<String, Object>>>>> taskList) {
        logger.info("CostAllotBillExportService batchWriteExportBillContent 6");
        LinkedHashMap<Long, SXSSFWorkbook> workBookMap = new LinkedHashMap<Long, SXSSFWorkbook>(selectIdList.size());
        for (FutureTask<List<List<Map<String, Object>>>> task : taskList) {
            try {
                List<List<Map<String, Object>>> resultList = task.get();
                Map<Long, Map<String, String>> allotBillHeaders = this.getAllotBillExportHeaders(selectIdList);
                Map<Long, Map<String, String>> allotBillDetailHeaders = this.getAllotBillDetailExportHeaders(selectIdList, allotBillAndAdapterMap, adapterAndStruMap, dynamicColumnMaps);
                this.batchCreateWorkbook(workBookMap, resultList, allotBillHeaders, allotBillDetailHeaders);
            }
            catch (InterruptedException | ExecutionException e) {
                logger.error("doExportSelected ExecutionException", (Throwable)e);
            }
        }
        logger.info("CostAllotBillExportService batchWriteExportBillContent 10");
        return workBookMap;
    }

    private void batchCreateWorkbook(Map<Long, SXSSFWorkbook> workBookMap, List<List<Map<String, Object>>> resultList, Map<Long, Map<String, String>> allotBillHeaders, Map<Long, Map<String, String>> allotBillDetailHeaders) {
        logger.info("CostAllotBillExportService batchCreateWorkbook 9");
        for (List<Map<String, Object>> batchList : resultList) {
            Map<String, Object> resultMap = batchList.get(0);
            Long allotBillId = (Long)resultMap.get("allotbillvalue");
            if (allotBillId == null) continue;
            SXSSFWorkbook workbook = this.createWorkbook(batchList, allotBillHeaders, allotBillDetailHeaders, allotBillId);
            workBookMap.put(allotBillId, workbook);
        }
        logger.error("CostAllotBillExportService batchCreateWorkbook error 10");
    }

    private List<FutureTask<List<List<Map<String, Object>>>>> batchQuerySelectBillExportData(List<Long> selectIdList, int totalPages, Map<Long, Long> adapterAndStruMap) {
        ArrayList<FutureTask<List<List<Map<String, Object>>>>> taskList = new ArrayList<FutureTask<List<List<Map<String, Object>>>>>(10);
        RequestContext cxt = RequestContext.get();
        for (int pageIndex = 0; pageIndex < totalPages; ++pageIndex) {
            int fromIndex = Math.min(pageIndex * CostExportConstants.PAGE_SIZE, selectIdList.size());
            int toIndex = Math.min(fromIndex + CostExportConstants.PAGE_SIZE, selectIdList.size());
            ImmutableList batchList = ImmutableList.copyOf(selectIdList.subList(fromIndex, toIndex));
            CostAllotBillExportThread task = new CostAllotBillExportThread(pageIndex, cxt, (List<Long>)batchList, CostExportConstants.PAGE_SIZE, adapterAndStruMap);
            FutureTask<List<List<Map<String, Object>>>> futureTask = new FutureTask<List<List<Map<String, Object>>>>(task);
            CostExportConstants.QUERY_COST_ALLOT_BILL_POOL.submit(futureTask);
            taskList.add(futureTask);
        }
        return taskList;
    }

    private SXSSFWorkbook createWorkbook(List<Map<String, Object>> batchList, Map<Long, Map<String, String>> allotBillHeaders, Map<Long, Map<String, String>> allotBillDetailHeaders, Long allotBillId) {
        SXSSFWorkbook wb = new SXSSFWorkbook(CostExportConstants.ROW_ACCESS_WINDOWS_SIZE);
        SXSSFSheet allotBillSheet = wb.createSheet(ResManager.loadKDString((String)"\u5206\u914d\u5355\u4fe1\u606f", (String)"CostAllotBillExportService_10", (String)SWC_PCS_BUSINESS, (Object[])new Object[0]));
        SXSSFSheet allotBillDetailSheet = wb.createSheet(ResManager.loadKDString((String)"\u5206\u914d\u5355\u660e\u7ec6", (String)"CostAllotBillExportService_11", (String)SWC_PCS_BUSINESS, (Object[])new Object[0]));
        int RANDOM_SEEK = -1;
        allotBillSheet.setRandomAccessWindowSize(-1);
        allotBillDetailSheet.setRandomAccessWindowSize(-1);
        CostExportCommonHelper.write2ExportHead(allotBillSheet, allotBillHeaders.get(allotBillId));
        CostExportCommonHelper.write2ExportHead(allotBillDetailSheet, allotBillDetailHeaders.get(allotBillId));
        List<Map<String, Object>> allotBills = batchList.subList(1, 9);
        CostExportCommonHelper.write2ExportContent(allotBillSheet, 0, allotBills, allotBillHeaders.get(allotBillId));
        List<Map<String, Object>> allotBillDetails = batchList.subList(9, batchList.size());
        CostExportCommonHelper.write2ExportContent(allotBillDetailSheet, 1, allotBillDetails, allotBillDetailHeaders.get(allotBillId));
        return wb;
    }
}

