/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.pcs.business.costcfg;

import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ArrayUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.service.operation.OperationServiceImpl;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.hr.hbp.business.domain.model.newhismodel.HisResponse;
import kd.hr.hbp.business.domain.model.newhismodel.VersionChangeRespData;
import kd.swc.hsbp.business.historynew.BaseDataHisHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCHisBaseDataHelper;
import kd.swc.hsbp.common.constants.SWCCostConstants;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCObjectUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.pcs.business.costcfg.CostCfgExportHelper;
import kd.swc.pcs.business.costcfg.CostCfgHelper;
import kd.swc.pcs.business.costcfg.service.CostCfgInterfaceValidatorService;
import kd.swc.pcs.business.costcommon.CostCommonHelper;
import kd.swc.pcs.business.vo.CostCfgInterfaceQueryInfo;
import org.apache.commons.collections.MapUtils;

public class CostCfgInterfaceHelper {
    private static final Log LOG = LogFactory.getLog(CostCfgInterfaceHelper.class);
    private Map<Long, String> errorMessageMap = new HashMap<Long, String>();

    public Map<String, Object> saveCostCfg(Map<String, Object> param) {
        if (null == param) {
            return null;
        }
        param.put("success", Boolean.TRUE);
        List data = (List)param.get("data");
        if (CollectionUtils.isEmpty((Collection)data)) {
            this.addErrorMessage(param, "data is empty!");
            return param;
        }
        if (data.size() > 10000) {
            this.addErrorMessage(param, "data size over 10000");
            return param;
        }
        List<Map<String, Object>> successList = null;
        try {
            LOG.info("CostCfgInterfaceHelper saveCostCfg getQueryMap begin");
            CostCfgInterfaceQueryInfo queryInfo = this.getQueryInfo(data);
            if (queryInfo == null) {
                String message = ResManager.loadKDString((String)"\u6bcf\u6b21\u4ec5\u652f\u6301\u5904\u7406\u4e00\u4e2a\u4eba\u529b\u6210\u672c\u7ef4\u5ea6\u65b9\u6848\u7684\u6570\u636e\uff0c\u8bf7\u68c0\u67e5\u786e\u8ba4\u3002", (String)"CostCfgInterfaceHelper_1", (String)"swc-pcs-business", (Object[])new Object[0]);
                this.addErrorMessage(param, message);
                return param;
            }
            LOG.info("CostCfgInterfaceHelper saveCostCfg getCheckPassData begin");
            CostCfgInterfaceValidatorService service = new CostCfgInterfaceValidatorService();
            successList = service.getCheckPassData(data, queryInfo);
            LOG.info("CostCfgInterfaceHelper saveCostCfg doSave begin");
            this.doSave(successList, queryInfo);
        }
        catch (Exception exp) {
            LOG.error("CostCfgInterfaceHelper error", (Throwable)exp);
            if (!CollectionUtils.isEmpty(successList)) {
                for (Map map : successList) {
                    this.addErrorMessage(map, "Execution failure!");
                }
            }
            this.addErrorMessage(param, "Execution failure!" + exp.getMessage());
            return param;
        }
        LOG.info("CostCfgInterfaceHelper saveCostCfg doSave end");
        return param;
    }

    private void doSave(List<Map<String, Object>> successList, CostCfgInterfaceQueryInfo queryInfo) {
        if (CollectionUtils.isEmpty(successList)) {
            return;
        }
        HashMap<Long, List<Map<String, Object>>> waitSaveDateMap = new HashMap<Long, List<Map<String, Object>>>(16);
        HashMap<Long, List<Map<String, Object>>> waitUpdateDateMap = new HashMap<Long, List<Map<String, Object>>>(16);
        LOG.info("CostCfgInterfaceHelper doSave sortDataBySourceType begin");
        this.sortDataBySourceType(successList, waitSaveDateMap, waitUpdateDateMap);
        LOG.info("CostCfgInterfaceHelper doSave saveOrUpdateCostCfgByType begin");
        this.saveOrUpdateCostCfgByType(queryInfo, waitSaveDateMap);
        this.saveOrUpdateCostCfgByType(queryInfo, waitUpdateDateMap);
        LOG.info("CostCfgInterfaceHelper doSave saveOrUpdateCostCfgByType end");
        this.setDealMessage(successList);
    }

    private void setDealMessage(List<Map<String, Object>> successList) {
        for (Map<String, Object> record : successList) {
            Long id = MapUtils.getLong(record, (Object)"id");
            String errorMessage = this.errorMessageMap.get(id);
            if (SWCStringUtils.isEmpty((String)errorMessage)) {
                record.put("success", Boolean.TRUE);
                continue;
            }
            this.addErrorMessage(record, errorMessage);
        }
    }

    private void saveOrUpdateCostCfgByType(CostCfgInterfaceQueryInfo queryInfo, Map<Long, List<Map<String, Object>>> waitDateMap) {
        if (CollectionUtils.isEmpty(waitDateMap)) {
            return;
        }
        Long costStruId = queryInfo.getCostStruId();
        Map<Long, Map<Long, DynamicObject>> sourceTypeAndCostIdDyMap = queryInfo.getSourceTypeAndCostIdDyMap();
        for (Map.Entry<Long, List<Map<String, Object>>> next : waitDateMap.entrySet()) {
            Long sourceTypeId = next.getKey();
            List<Map<String, Object>> valueList = next.getValue();
            List<DynamicObject> dynamicObjects = this.dataConvertToCostCfgDy(sourceTypeId, valueList, queryInfo);
            this.executeOp("save_validate", dynamicObjects);
            String billFormId = this.getCostCfgFormIdByType(sourceTypeId);
            Map<Long, DynamicObject> keyAndCostCfgDyMap = sourceTypeAndCostIdDyMap.get(sourceTypeId);
            this.batchDealData(dynamicObjects, keyAndCostCfgDyMap, billFormId, costStruId);
        }
    }

    private void sortDataBySourceType(List<Map<String, Object>> successList, Map<Long, List<Map<String, Object>>> waitSaveDateMap, Map<Long, List<Map<String, Object>>> waitUpdateDateMap) {
        for (Map<String, Object> record : successList) {
            String operateType = MapUtils.getString(record, (Object)"operate");
            Long sourceTypeId = MapUtils.getLong(record, (Object)"sourcetype");
            if ("1".equals(operateType)) {
                this.mergeDate(sourceTypeId, record, waitSaveDateMap);
                continue;
            }
            if (!"2".equals(operateType)) continue;
            this.mergeDate(sourceTypeId, record, waitUpdateDateMap);
        }
    }

    private void mergeDate(Long sourceTypeId, Map<String, Object> record, Map<Long, List<Map<String, Object>>> waitDateMap) {
        List<Map<String, Object>> dateList = waitDateMap.get(sourceTypeId);
        if (CollectionUtils.isEmpty(dateList)) {
            dateList = new ArrayList<Map<String, Object>>();
        }
        dateList.add(record);
        waitDateMap.put(sourceTypeId, dateList);
    }

    private Map<Long, Long> getEmpAndPosOrgRelMap(Map<Long, Map<Long, DynamicObject>> sourceTypeAndActualIdDyMap) {
        Map<Long, Long> empIdAndRelMap = new HashMap<Long, Long>(16);
        if (CollectionUtils.isEmpty(sourceTypeAndActualIdDyMap)) {
            return empIdAndRelMap;
        }
        Map<Long, DynamicObject> costTypeEmpSourceIdMap = sourceTypeAndActualIdDyMap.get(SWCCostConstants.COST_TYPE_EMP);
        if (CollectionUtils.isEmpty(costTypeEmpSourceIdMap)) {
            return empIdAndRelMap;
        }
        Set<Long> sourceIdList = costTypeEmpSourceIdMap.keySet();
        empIdAndRelMap = CostCfgExportHelper.getEmpAndPosOrgRelMap(new ArrayList<Long>(sourceIdList), SWCCostConstants.COST_TYPE_EMP);
        return empIdAndRelMap;
    }

    private List<DynamicObject> dataConvertToCostCfgDy(Long sourceTypeId, List<Map<String, Object>> valueList, CostCfgInterfaceQueryInfo queryInfo) {
        Map<Long, Map<Long, DynamicObject>> sourceTypeAndActualIdDyMap = queryInfo.getSourceTypeAndActualIdDyMap();
        Map<Long, Long> empIdAndRelMap = this.getEmpAndPosOrgRelMap(sourceTypeAndActualIdDyMap);
        Map<Long, DynamicObject> orgMap = queryInfo.getOrgMap();
        Map<Long, Map<Long, DynamicObject>> sourceTypeAndCostIdDyMap = queryInfo.getSourceTypeAndCostIdDyMap();
        Map<Long, Map<Long, DynamicObject>> entryDimDyColumnAndIdDyMap = queryInfo.getEntryDimDyColumnAndIdDyMap();
        Long costStruId = queryInfo.getCostStruId();
        DynamicObjectCollection dimensionDyColl = CostCommonHelper.getCostStruDimById(costStruId);
        Map<Long, DynamicObject> sourceIdAndDyMap = sourceTypeAndActualIdDyMap.get(sourceTypeId);
        Map<Long, DynamicObject> keyAndCostCfgDyMap = sourceTypeAndCostIdDyMap.get(sourceTypeId);
        DynamicObject costAdapterDy = queryInfo.getCostAdapterDy();
        DynamicObject costStruDy = queryInfo.getCostStruDy();
        String billFormId = this.getCostCfgFormIdByType(sourceTypeId);
        long[] genLongIds = ORM.create().genLongIds(billFormId, valueList.size());
        SWCDataServiceHelper helper = new SWCDataServiceHelper(billFormId);
        ArrayList<DynamicObject> costCfgDyList = new ArrayList<DynamicObject>(10);
        for (int i = 0; i < valueList.size(); ++i) {
            Map<String, Object> record = valueList.get(i);
            Long orgId = MapUtils.getLong(record, (Object)"org");
            DynamicObject orgDy = orgMap.get(orgId);
            Long id = MapUtils.getLong(record, (Object)"id");
            DynamicObject dynamicObject = this.fillCostCfgDyId(billFormId, helper, i, genLongIds, keyAndCostCfgDyMap, orgDy, id, record);
            Date bsed = this.getDate(record);
            Long sourceId = MapUtils.getLong(record, (Object)"source");
            DynamicObject sourceDy = sourceIdAndDyMap.get(sourceId);
            this.fillCostCfgMainInfo(sourceTypeId, dynamicObject, costAdapterDy, costStruDy, empIdAndRelMap, bsed, sourceDy);
            this.fillCostCfgEntryInfo(sourceTypeId, helper, dynamicObject, dimensionDyColl, record, entryDimDyColumnAndIdDyMap);
            costCfgDyList.add(dynamicObject);
        }
        return costCfgDyList;
    }

    private Date getDate(Map<String, Object> record) {
        Object bsedObj = MapUtils.getObject(record, (Object)"bsed");
        Date bsedDate = null;
        if (bsedObj instanceof Date) {
            bsedDate = (Date)bsedObj;
        } else if (bsedObj instanceof Long) {
            Long bsedDateL = (Long)bsedObj;
            bsedDate = new Date(bsedDateL);
        } else if (bsedObj instanceof String) {
            String bsedStr = String.valueOf(bsedObj);
            try {
                bsedDate = SWCDateTimeUtils.parseDate((String)bsedStr, (String)"yyyy-MM-dd");
            }
            catch (ParseException e) {
                LOG.error("CostCfgInterfaceHelper getDate parseDate error", (Object)e.getMessage());
            }
        }
        try {
            String dateFormat = SWCDateTimeUtils.format((Date)bsedDate, (String)"yyyy-MM-dd");
            bsedDate = SWCDateTimeUtils.parseDate((String)dateFormat);
        }
        catch (ParseException e) {
            LOG.error("CostCfgInterfaceHelper format parseDate error", (Object)e.getMessage());
        }
        return bsedDate;
    }

    private void fillCostCfgEntryInfo(Long sourceTypeId, SWCDataServiceHelper helper, DynamicObject dynamicObject, DynamicObjectCollection dimensionDyColl, Map<String, Object> record, Map<Long, Map<Long, DynamicObject>> entryDimDyColumnAndIdDyMap) {
        DynamicObjectCollection entryEntityColl = dynamicObject.getDynamicObjectCollection("costcfgentryentity");
        DynamicObjectCollection needShowDimensionColl = CostCfgHelper.getNeedShowDimensionColl(sourceTypeId, "COST", dimensionDyColl);
        List<Map<String, Object>> costCfgEntryList = CostCfgInterfaceHelper.getCostCfgEntryList(record);
        for (int i = 0; i < costCfgEntryList.size(); ++i) {
            Map<String, Object> entryRecord = costCfgEntryList.get(i);
            StringBuilder sb = new StringBuilder();
            HashMap<String, Object> hideKeyAndValueMap = new HashMap<String, Object>(16);
            this.initHideKeyAndValueMap(sb, entryRecord, hideKeyAndValueMap, entryDimDyColumnAndIdDyMap, needShowDimensionColl, "1");
            this.setEntryValue(i + 1, "costcfgentryentity", sb, helper, hideKeyAndValueMap, entryRecord, entryEntityColl);
        }
        if (SWCCostConstants.COST_TYPE_DEPT.equals(sourceTypeId)) {
            DynamicObjectCollection entryTypeEntityColl = dynamicObject.getDynamicObjectCollection("costcfgtypeentryentity");
            DynamicObjectCollection typeNeedShowDimensionColl = CostCfgHelper.getNeedShowDimensionColl(sourceTypeId, "DEFAULT", dimensionDyColl);
            List<Map<String, Object>> costCfgTypeEntryList = CostCfgInterfaceHelper.getCostCfgTypeEntryList(record);
            for (int i = 0; i < costCfgTypeEntryList.size(); ++i) {
                Map<String, Object> entryRecord = costCfgTypeEntryList.get(i);
                StringBuilder sb = new StringBuilder();
                HashMap<String, Object> hideKeyAndValueMap = new HashMap<String, Object>(16);
                this.initHideKeyAndValueMap(sb, entryRecord, hideKeyAndValueMap, entryDimDyColumnAndIdDyMap, typeNeedShowDimensionColl, "3");
                this.setEntryValue(i + 1, "costcfgtypeentryentity", sb, helper, hideKeyAndValueMap, entryRecord, entryTypeEntityColl);
            }
        }
    }

    private void setEntryValue(int seq, String entryEntityKey, StringBuilder sb, SWCDataServiceHelper helper, Map<String, Object> hideKeyAndValueMap, Map<String, Object> record, DynamicObjectCollection entryEntityColl) {
        String costStruCfgValue;
        if (entryEntityColl == null) {
            return;
        }
        boolean isCostCfg = "costcfgentryentity".equals(entryEntityKey);
        String proportionKey = isCostCfg ? "calcostproportion" : "costcfgtypeproportion";
        String costStruCfgValueKey = isCostCfg ? "coststrucfgvalue" : "coststrutypecfgvalue";
        String hideKey = isCostCfg ? "hidekeyandvalue" : "hidetypekeyandvalue";
        DynamicObject costCfgEntryEntity = helper.generateEmptyEntryDynamicObject(entryEntityKey);
        String proportionStr = MapUtils.getString(record, (Object)"calcostproportion");
        String entityName = helper.getEntityName();
        if (!isCostCfg && "pcs_costdeptcfg".equals(entityName)) {
            proportionStr = "100";
        }
        if (SWCStringUtils.isNotEmpty((String)proportionStr)) {
            BigDecimal proportion = new BigDecimal(proportionStr);
            costCfgEntryEntity.set(proportionKey, (Object)proportion);
        }
        if (SWCStringUtils.isNotEmpty((String)(costStruCfgValue = sb.toString()))) {
            costCfgEntryEntity.set(costStruCfgValueKey, (Object)costStruCfgValue.substring(0, sb.toString().length() - 1));
        }
        if (!CollectionUtils.isEmpty(hideKeyAndValueMap)) {
            costCfgEntryEntity.set(hideKey, (Object)new JSONObject(hideKeyAndValueMap));
        }
        costCfgEntryEntity.set("seq", (Object)seq);
        entryEntityColl.add((Object)costCfgEntryEntity);
    }

    private void initHideKeyAndValueMap(StringBuilder sb, Map<String, Object> entryRecord, Map<String, Object> hideKeyAndValueMap, Map<Long, Map<Long, DynamicObject>> entryDimDyColumnAndIdDyMap, DynamicObjectCollection dimensionDyColl, String costType) {
        for (DynamicObject dimensionDy : dimensionDyColl) {
            long dimId = dimensionDy.getLong("costdimension.id");
            Map<String, Object> costStruCfgValueMap = "1".equals(costType) ? CostCfgInterfaceHelper.getCostStruCfgValue(entryRecord) : CostCfgInterfaceHelper.getCostStruTypeCfgValue(entryRecord);
            Object dimValueObj = costStruCfgValueMap.get(String.valueOf(dimId));
            if (dimValueObj == null) continue;
            String dimValue = String.valueOf(dimValueObj);
            Map<Long, DynamicObject> dimIdValueAndDyMap = entryDimDyColumnAndIdDyMap.get(dimId);
            if (CollectionUtils.isEmpty(dimIdValueAndDyMap)) continue;
            DynamicObject dynamicObject = dimIdValueAndDyMap.get(Long.valueOf(dimValue));
            String valueType = dimensionDy.getString("costdimension.valuetype");
            long costDimensionId = dimensionDy.getLong("costdimension.id");
            String costDimensionStr = String.valueOf(costDimensionId);
            if (!"1".equals(valueType) && !"2".equals(valueType)) continue;
            if (dynamicObject == null) {
                sb.append(' ').append('.');
                continue;
            }
            String displayProperty = dimensionDy.getString("costdimension.displayproperty");
            String value = "1".equals(displayProperty) ? dynamicObject.getString("number") : dynamicObject.getString("name");
            sb.append(value).append('.');
            String id = dynamicObject.getString("id");
            if (!SWCStringUtils.isNotEmpty((String)value)) continue;
            hideKeyAndValueMap.put(costDimensionStr, id + "||" + value);
        }
    }

    public static Map<String, Object> getCostStruCfgValue(Map<String, Object> entryRecord) {
        return CostCfgInterfaceHelper.getCostStruCfgByType(entryRecord, "coststrucfgvalue");
    }

    public static Map<String, Object> getCostStruTypeCfgValue(Map<String, Object> entryRecord) {
        return CostCfgInterfaceHelper.getCostStruCfgByType(entryRecord, "coststrutypecfgvalue");
    }

    private static Map<String, Object> getCostStruCfgByType(Map<String, Object> entryRecord, String costStruCfgValue) {
        Object costStruCfgValueObj = entryRecord.get(costStruCfgValue);
        HashMap costStruCfgValueMap = new HashMap(16);
        if (costStruCfgValueObj instanceof HashMap) {
            costStruCfgValueMap = (HashMap)costStruCfgValueObj;
        }
        return costStruCfgValueMap;
    }

    private void fillCostCfgMainInfo(Long costCfgTypeId, DynamicObject dynamicObject, DynamicObject costAdapterDy, DynamicObject costStruDy, Map<Long, Long> empIdAndRelMap, Date bsed, DynamicObject sourceDy) {
        long userId = RequestContext.get().getCurrUserId();
        dynamicObject.set("creator", (Object)userId);
        dynamicObject.set("sourcetype", (Object)costCfgTypeId);
        dynamicObject.set("source", (Object)sourceDy);
        dynamicObject.set("costadapter", (Object)costAdapterDy);
        dynamicObject.set("bsed", (Object)bsed);
        dynamicObject.set("coststru", (Object)costStruDy);
        if (SWCCostConstants.COST_TYPE_EMP.equals(costCfgTypeId)) {
            Long empPosOrgRelId = empIdAndRelMap.get(sourceDy.getLong("id"));
            dynamicObject.set("empposorgrel", (Object)empPosOrgRelId);
        }
    }

    private DynamicObject fillCostCfgDyId(String billFormId, SWCDataServiceHelper helper, int i, long[] genLongIds, Map<Long, DynamicObject> keyAndCostCfgDyMap, DynamicObject orgDyObj, Long id, Map<String, Object> record) {
        DynamicObject dynamicObject;
        if (SWCObjectUtils.isEmpty((Object)id)) {
            id = genLongIds[i];
            record.put("id", id);
        }
        if ((dynamicObject = keyAndCostCfgDyMap.get(id)) == null) {
            dynamicObject = helper.generateEmptyDynamicObject();
            dynamicObject.set("id", (Object)id);
            dynamicObject.set("createorg", (Object)orgDyObj);
        } else {
            DynamicObjectCollection costCfgEntryList = dynamicObject.getDynamicObjectCollection("costcfgentryentity");
            costCfgEntryList.clear();
            if ("pcs_costdeptcfg".equals(billFormId)) {
                DynamicObjectCollection costCfgTypeEntryList = dynamicObject.getDynamicObjectCollection("costcfgtypeentryentity");
                costCfgTypeEntryList.clear();
            }
        }
        return dynamicObject;
    }

    private void executeOp(String opName, List<DynamicObject> costCfgDealResultList) {
        if (CollectionUtils.isEmpty(costCfgDealResultList)) {
            return;
        }
        OperateOption operateOption = OperateOption.create();
        operateOption.setVariableValue("isimport", "2");
        operateOption.setVariableValue("hasRight", "true");
        OperationServiceImpl opImpl = new OperationServiceImpl();
        OperationResult operationResult = opImpl.localInvokeOperation(opName, costCfgDealResultList.toArray(new DynamicObject[0]), operateOption);
        this.dealOperationResult(costCfgDealResultList, operationResult);
    }

    private void dealOperationResult(List<DynamicObject> costCfgDealResultList, OperationResult operationResult) {
        if (!operationResult.isSuccess()) {
            List operateInfos = operationResult.getAllErrorOrValidateInfo();
            for (IOperateInfo operateInfo : operateInfos) {
                long id = Long.parseLong(String.valueOf(operateInfo.getPkValue()));
                this.errorMessageMap.put(id, operateInfo.getMessage());
            }
            String msg = operationResult.getMessage();
            if (CollectionUtils.isEmpty((Collection)operateInfos) && SWCStringUtils.isNotEmpty((String)msg)) {
                for (DynamicObject importRowEntity : costCfgDealResultList) {
                    long id = importRowEntity.getLong("id");
                    this.errorMessageMap.put(id, msg);
                }
            }
        }
    }

    private void batchDealData(List<DynamicObject> costCfgDealResultList, Map<Long, DynamicObject> keyAndCostCfgDyMap, String billFormId, Long costStruId) {
        if (CollectionUtils.isEmpty(costCfgDealResultList)) {
            return;
        }
        Set<String> ignoreKeysSet = this.getIgnoreKeysSet();
        ArrayList<DynamicObject> needSaveAddList = new ArrayList<DynamicObject>(10);
        ArrayList<DynamicObject> needSaveUpdateList = new ArrayList<DynamicObject>(10);
        ArrayList<DynamicObject> newHisDys = new ArrayList<DynamicObject>(10);
        ArrayList<DynamicObject> newHisImportRowEntity = new ArrayList<DynamicObject>(10);
        DynamicObjectCollection costSegTypeStoreDyList = new DynamicObjectCollection();
        SWCDataServiceHelper costSegStoreHelper = new SWCDataServiceHelper("pcs_costsegstore");
        Map<Long, String> costStruDimensionIdMap = CostCfgHelper.getCostStruDimensionIdStorageNumberMap(costStruId);
        String costSourceType = CostCfgHelper.getCostType(billFormId);
        for (DynamicObject currEntityDyObj : costCfgDealResultList) {
            long id = currEntityDyObj.getLong("id");
            DynamicObject dbDynamicObj = keyAndCostCfgDyMap.get(id);
            if (dbDynamicObj == null) {
                needSaveAddList.add(currEntityDyObj);
                continue;
            }
            String status = dbDynamicObj.getString("status");
            if ("A".equals(status) || "B".equals(status)) {
                needSaveUpdateList.add(currEntityDyObj);
                continue;
            }
            if (!"C".equals(status)) continue;
            SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper(dbDynamicObj.getDataEntityType().getName());
            DynamicObject hisDyn = serviceHelper.generateEmptyDynamicObject();
            SWCHisBaseDataHelper.transferDynamicObject((DynamicObject)dbDynamicObj, (DynamicObject)hisDyn, null, null);
            SWCHisBaseDataHelper.transferDynamicObject((DynamicObject)currEntityDyObj, (DynamicObject)hisDyn, ignoreKeysSet, null);
            hisDyn.set("status", (Object)"C");
            hisDyn.set("boid", dbDynamicObj.get("id"));
            Date firstBsed = currEntityDyObj.getDate("firstbsed");
            Date bsed = currEntityDyObj.getDate("bsed");
            if (firstBsed != null && bsed != null && SWCDateTimeUtils.dayBefore((Date)bsed, (Date)firstBsed)) {
                hisDyn.set("firstbsed", (Object)bsed);
            }
            CostCfgHelper.fillCostSegmentInfo("costCfg", "1", costSegStoreHelper, hisDyn, costStruDimensionIdMap, costSegTypeStoreDyList);
            if ("pcs_costdeptcfg".equals(billFormId)) {
                CostCfgHelper.fillCostSegmentInfo("costCfgType", costSourceType, costSegStoreHelper, hisDyn, costStruDimensionIdMap, costSegTypeStoreDyList);
            }
            newHisDys.add(hisDyn);
            newHisImportRowEntity.add(currEntityDyObj);
        }
        this.executeOp("save", needSaveAddList);
        this.executeOp("save", needSaveUpdateList);
        HisResponse response = BaseDataHisHelper.saveNoTimeVersion((DynamicObject[])newHisDys.toArray(new DynamicObject[newHisDys.size()]), (boolean)true);
        costSegStoreHelper.save(costSegTypeStoreDyList);
        this.setMessageByResponse((HisResponse<VersionChangeRespData>)response, newHisImportRowEntity);
    }

    private void setMessageByResponse(HisResponse<VersionChangeRespData> response, List<DynamicObject> newHisImportRowEntity) {
        if (response != null && SWCStringUtils.isNotEmpty((String)response.getErrorMessage())) {
            String errorMessage = response.getErrorMessage();
            for (DynamicObject importRowEntity : newHisImportRowEntity) {
                long id = importRowEntity.getLong("id");
                this.errorMessageMap.put(id, errorMessage);
            }
        }
    }

    private Set<String> getIgnoreKeysSet() {
        return Sets.newHashSetWithExpectedSize((int)6);
    }

    private CostCfgInterfaceQueryInfo getQueryInfo(List<Map<String, Object>> data) {
        HashSet<Long> orgIdSet = new HashSet<Long>(16);
        ArrayList<Long> costCfgIds = new ArrayList<Long>(data.size());
        HashSet<Long> costAdapterIdSet = new HashSet<Long>(data.size());
        HashMap<Long, List<Long>> sourceTypeAndSourceIdMap = new HashMap<Long, List<Long>>(16);
        HashMap<Long, Set<Long>> entryDimAndDimValueIdMap = new HashMap<Long, Set<Long>>(16);
        for (Map<String, Object> record : data) {
            Long sourceType;
            Long costAdapterId;
            Long costCfgId;
            Long orgId = MapUtils.getLong(record, (Object)"org");
            if (!SWCObjectUtils.isEmpty((Object)orgId)) {
                orgIdSet.add(orgId);
            }
            if (!SWCObjectUtils.isEmpty((Object)(costCfgId = MapUtils.getLong(record, (Object)"id")))) {
                costCfgIds.add(costCfgId);
            }
            if (!SWCObjectUtils.isEmpty((Object)(costAdapterId = MapUtils.getLong(record, (Object)"costadapter")))) {
                costAdapterIdSet.add(costAdapterId);
            }
            if (!SWCObjectUtils.isEmpty((Object)(sourceType = MapUtils.getLong(record, (Object)"sourcetype")))) {
                Long sourceId;
                ArrayList<Long> sourceIds = (ArrayList<Long>)sourceTypeAndSourceIdMap.get(sourceType);
                if (CollectionUtils.isEmpty((Collection)sourceIds)) {
                    sourceIds = new ArrayList<Long>();
                }
                if (!SWCObjectUtils.isEmpty((Object)(sourceId = MapUtils.getLong(record, (Object)"source")))) {
                    sourceIds.add(sourceId);
                }
                sourceTypeAndSourceIdMap.put(sourceType, sourceIds);
            }
            List<Map<String, Object>> costCfgEntryList = CostCfgInterfaceHelper.getCostCfgEntryList(record);
            this.initEntryDimAndDimValueIdMap(entryDimAndDimValueIdMap, costCfgEntryList, "1");
            List<Map<String, Object>> costCfgTypeEntryList = CostCfgInterfaceHelper.getCostCfgTypeEntryList(record);
            this.initEntryDimAndDimValueIdMap(entryDimAndDimValueIdMap, costCfgTypeEntryList, "3");
        }
        LOG.info("CostCfgInterfaceHelper getQueryInfo init query date end");
        if (costAdapterIdSet.size() > 1) {
            return null;
        }
        if (costAdapterIdSet.isEmpty()) {
            return new CostCfgInterfaceQueryInfo();
        }
        ArrayList costAdapterIdList = new ArrayList(costAdapterIdSet);
        Long costAdapterId = (Long)costAdapterIdList.get(0);
        Long costStruId = this.queryCostStruByAdapter(costAdapterId);
        DynamicObject costStruDy = BusinessDataServiceHelper.loadSingleFromCache((Object)costStruId, (String)"lcs_coststru");
        DynamicObject costAdapterDy = BusinessDataServiceHelper.loadSingleFromCache((Object)costAdapterId, (String)"lcs_costadaption");
        DynamicObjectCollection dimensionDyColl = CostCommonHelper.getCostStruDimById(costStruId);
        Map<Long, String> dimIdAndBillNumberMap = this.getDimIdAndBillNumberMap(dimensionDyColl);
        Map<Long, DynamicObject> orgMap = this.getOrgMap(orgIdSet);
        Map<Long, DynamicObject> costAdapterMap = this.getCostAdapterMap(costAdapterIdSet);
        Set<Long> allCostCfgIdSet = this.getAllCostCfgIdSet(costCfgIds);
        HashMap<Long, Map<Long, DynamicObject>> sourceTypeAndCostIdDyMap = new HashMap<Long, Map<Long, DynamicObject>>(16);
        Map<Long, Map<Long, DynamicObject>> sourceTypeAndActualIdDyMap = this.getSourceTypeAndActualIdDyMap(costAdapterId, costCfgIds, sourceTypeAndSourceIdMap, sourceTypeAndCostIdDyMap);
        HashMap<String, Long> costCfgExistKeyAndIdMap = new HashMap<String, Long>(16);
        Map<Long, Set<String>> sourceTypeAndCostCfgAddKeyMap = this.getSourceTypeAndCostCfgAddKeyMap(sourceTypeAndCostIdDyMap, costCfgExistKeyAndIdMap);
        Map<Long, Map<Long, DynamicObject>> entryDimDyColumnAndIdDyMap = this.getEntryDimDyColumnAndIdDyMap(entryDimAndDimValueIdMap, dimIdAndBillNumberMap);
        CostCfgInterfaceQueryInfo costCfgInterfaceQueryInfo = new CostCfgInterfaceQueryInfo(costStruId, costAdapterId, costStruDy, costAdapterDy, orgMap, costAdapterMap, sourceTypeAndCostIdDyMap, sourceTypeAndActualIdDyMap, entryDimDyColumnAndIdDyMap, sourceTypeAndCostCfgAddKeyMap, costCfgExistKeyAndIdMap, allCostCfgIdSet);
        return costCfgInterfaceQueryInfo;
    }

    private Set<Long> getAllCostCfgIdSet(List<Long> costCfgIds) {
        HashSet<Long> allCostCfgIdSet = new HashSet<Long>(16);
        if (!CollectionUtils.isEmpty(costCfgIds)) {
            DynamicObject[] queryResultByIdArray;
            QFilter filter = new QFilter("id", "in", costCfgIds);
            SWCDataServiceHelper helper = new SWCDataServiceHelper("pcs_costcfg");
            for (DynamicObject costCfgDy : queryResultByIdArray = helper.query("id", new QFilter[]{filter})) {
                long id = costCfgDy.getLong("id");
                allCostCfgIdSet.add(id);
            }
        }
        return allCostCfgIdSet;
    }

    private Map<Long, Set<String>> getSourceTypeAndCostCfgAddKeyMap(Map<Long, Map<Long, DynamicObject>> sourceTypeAndCostIdDyMap, Map<String, Long> costCfgExistKeyAndIdMap) {
        Iterator<Map.Entry<Long, Map<Long, DynamicObject>>> iterator = sourceTypeAndCostIdDyMap.entrySet().iterator();
        HashMap<Long, Set<String>> sourceTypeAndCostCfgAddKeyMap = new HashMap<Long, Set<String>>(16);
        while (iterator.hasNext()) {
            Map.Entry<Long, Map<Long, DynamicObject>> next = iterator.next();
            Long sourceTypeId = next.getKey();
            Map<Long, DynamicObject> valueMap = next.getValue();
            Iterator<Map.Entry<Long, DynamicObject>> valueIterator = valueMap.entrySet().iterator();
            HashSet<String> costCfgAddKeySet = new HashSet<String>(16);
            while (valueIterator.hasNext()) {
                Map.Entry<Long, DynamicObject> valueNext = valueIterator.next();
                DynamicObject costCfgDy = valueNext.getValue();
                long costCfgId = costCfgDy.getLong("id");
                long costAdapterId = costCfgDy.getLong("costadapter.id");
                long sourceId = costCfgDy.getLong("source.id");
                String existKey = sourceTypeId + "_" + costAdapterId + "_" + sourceId;
                costCfgAddKeySet.add(existKey);
                costCfgExistKeyAndIdMap.put(existKey, costCfgId);
            }
            sourceTypeAndCostCfgAddKeyMap.put(sourceTypeId, costCfgAddKeySet);
        }
        return sourceTypeAndCostCfgAddKeyMap;
    }

    private Map<Long, Map<Long, DynamicObject>> getSourceTypeAndActualIdDyMap(Long costAdapterId, List<Long> costCfgIds, Map<Long, List<Long>> sourceTypeAndSourceIdMap, Map<Long, Map<Long, DynamicObject>> sourceTypeAndCostIdDyMap) {
        HashMap<Long, Map<Long, DynamicObject>> sourceTypeAndActualIdDyMap = new HashMap<Long, Map<Long, DynamicObject>>(16);
        for (Map.Entry<Long, List<Long>> next : sourceTypeAndSourceIdMap.entrySet()) {
            Long sourceTypeId = next.getKey();
            String billFormId = this.getCostCfgFormIdByType(sourceTypeId);
            if (SWCStringUtils.isEmpty((String)billFormId)) continue;
            List<Long> sourceIds = next.getValue();
            Map<Long, DynamicObject> costCfgMap = this.getCostCfgMap(billFormId, sourceTypeId, costAdapterId, sourceIds, costCfgIds);
            sourceTypeAndCostIdDyMap.put(sourceTypeId, costCfgMap);
            String actualNumber = this.getActualNumberByType(billFormId);
            if (SWCStringUtils.isEmpty((String)actualNumber)) continue;
            Map<Long, DynamicObject> actualMap = this.getActualMap(actualNumber, sourceIds);
            sourceTypeAndActualIdDyMap.put(sourceTypeId, actualMap);
        }
        return sourceTypeAndActualIdDyMap;
    }

    private Map<Long, Map<Long, DynamicObject>> getEntryDimDyColumnAndIdDyMap(Map<Long, Set<Long>> entryDimAndDimValueIdMap, Map<Long, String> dimIdAndBillNumberMap) {
        HashMap<Long, Map<Long, DynamicObject>> entryDyColumnAndIdDyMap = new HashMap<Long, Map<Long, DynamicObject>>(16);
        for (Map.Entry<Long, String> next : dimIdAndBillNumberMap.entrySet()) {
            Set<Long> dimValueSet;
            Long dimId = next.getKey();
            String billNumber = next.getValue();
            if (SWCStringUtils.isEmpty((String)billNumber) || CollectionUtils.isEmpty(dimValueSet = entryDimAndDimValueIdMap.get(dimId))) continue;
            Map<Long, DynamicObject> entryDyColumnMap = this.getActualMap(billNumber, new ArrayList<Long>(dimValueSet));
            entryDyColumnAndIdDyMap.put(dimId, entryDyColumnMap);
        }
        return entryDyColumnAndIdDyMap;
    }

    private Map<Long, String> getDimIdAndBillNumberMap(DynamicObjectCollection dimensionDyColl) {
        HashMap<Long, String> dimIdAndBillNumberMap = new HashMap<Long, String>(16);
        for (DynamicObject dimensionDy : dimensionDyColl) {
            long dimId = dimensionDy.getLong("costdimension.id");
            String valueType = dimensionDy.getString("costdimension.valuetype");
            String number = "";
            if ("1".equals(valueType)) {
                number = dimensionDy.getString("costdimension.valuesource.id");
            } else if ("2".equals(valueType)) {
                number = "bos_assistantdata_detail";
            }
            if (!SWCStringUtils.isNotEmpty((String)number)) continue;
            dimIdAndBillNumberMap.put(dimId, number);
        }
        return dimIdAndBillNumberMap;
    }

    private void initEntryDimAndDimValueIdMap(Map<Long, Set<Long>> entryDimAndDimValueIdMap, List<Map<String, Object>> entryList, String costType) {
        if (CollectionUtils.isEmpty(entryList)) {
            return;
        }
        for (Map<String, Object> entryMap : entryList) {
            Map<String, Object> costStruCfgValueMap = "1".equals(costType) ? CostCfgInterfaceHelper.getCostStruCfgValue(entryMap) : CostCfgInterfaceHelper.getCostStruTypeCfgValue(entryMap);
            for (Map.Entry<String, Object> next : costStruCfgValueMap.entrySet()) {
                String dimIdStr = next.getKey();
                Object dimValueObj = costStruCfgValueMap.get(dimIdStr);
                if (dimValueObj == null) continue;
                String dimValueStr = String.valueOf(dimValueObj);
                Long dimId = Long.valueOf(dimIdStr);
                Set<Long> dimValueSet = entryDimAndDimValueIdMap.get(dimId);
                if (CollectionUtils.isEmpty(dimValueSet)) {
                    dimValueSet = new HashSet<Long>();
                }
                if (!StringUtils.isNotEmpty((CharSequence)dimValueStr)) continue;
                dimValueSet.add(Long.valueOf(dimValueStr));
                entryDimAndDimValueIdMap.put(dimId, dimValueSet);
            }
        }
    }

    public static List<Map<String, Object>> getCostCfgEntryList(Map<String, Object> record) {
        return CostCfgInterfaceHelper.getEntryListByType(record, "costcfgentryentity");
    }

    public static List<Map<String, Object>> getCostCfgTypeEntryList(Map<String, Object> record) {
        return CostCfgInterfaceHelper.getEntryListByType(record, "costcfgtypeentryentity");
    }

    public static List<Map<String, Object>> getEntryListByType(Map<String, Object> record, String entityKey) {
        Object entityKeyObj = MapUtils.getObject(record, (Object)entityKey);
        List<Map<String, Object>> entryList = new ArrayList<Map<String, Object>>(10);
        if (entityKeyObj instanceof List) {
            entryList = (List)entityKeyObj;
        }
        return entryList;
    }

    private String getCostCfgFormIdByType(Long sourceTypeId) {
        String billNumber = "";
        if (SWCCostConstants.COST_TYPE_DEPT.equals(sourceTypeId)) {
            billNumber = "pcs_costdeptcfg";
        } else if (SWCCostConstants.COST_TYPE_EMP.equals(sourceTypeId)) {
            billNumber = "pcs_costempcfg";
        }
        return billNumber;
    }

    private Long queryCostStruByAdapter(Long costAdapterId) {
        SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper("lcs_costadaption");
        QFilter idFilter = new QFilter("id", "=", (Object)costAdapterId);
        DynamicObject costAdaptionDy = serviceHelper.queryOne("id,coststru", new QFilter[]{idFilter});
        return costAdaptionDy == null ? 0L : costAdaptionDy.getLong("coststru.id");
    }

    private String getActualNumberByType(String billFormId) {
        String actualBillNumber = "";
        if ("pcs_costdeptcfg".equals(billFormId)) {
            actualBillNumber = "haos_adminorghr";
        } else if ("pcs_costempcfg".equals(billFormId)) {
            actualBillNumber = "hrpi_employee";
        }
        return actualBillNumber;
    }

    private void addErrorMessage(Map<String, Object> record, String message) {
        record.put("success", Boolean.FALSE);
        record.put("message", message);
    }

    private Map<Long, DynamicObject> getOrgMap(Set<Long> orgIds) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("bos_org");
        QFilter filter = new QFilter("id", "in", orgIds);
        filter.and(new QFilter("enable", "=", (Object)"1"));
        filter.and(new QFilter("status", "=", (Object)"C"));
        DynamicObject[] orgArr = helper.query("id,number,name", new QFilter[]{filter});
        Map<Long, DynamicObject> orgMap = Arrays.stream(orgArr).collect(Collectors.toMap(org -> org.getLong("id"), org -> org, (k1, k2) -> k1));
        return orgMap;
    }

    private Map<Long, DynamicObject> getCostAdapterMap(Set<Long> costAdapterIdSet) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("lcs_costadaption");
        QFilter filter = new QFilter("id", "in", costAdapterIdSet);
        filter.and(new QFilter("enable", "=", (Object)"1"));
        filter.and(new QFilter("status", "=", (Object)"C"));
        DynamicObject[] costAdaptionArr = helper.query("id,number,name", new QFilter[]{filter});
        Map<Long, DynamicObject> costAdaptionMap = Arrays.stream(costAdaptionArr).collect(Collectors.toMap(org -> org.getLong("id"), org -> org, (k1, k2) -> k1));
        return costAdaptionMap;
    }

    private Map<Long, DynamicObject> getCostCfgMap(String billNumber, Long sourceTypeId, Long costAdapterId, List<Long> sourceIds, List<Long> costCfgIds) {
        QFilter filter = new QFilter("source", "in", sourceIds);
        filter.and(new QFilter("costadapter.id", "=", (Object)costAdapterId));
        filter.and(new QFilter("sourcetype", "=", (Object)sourceTypeId));
        if (!CollectionUtils.isEmpty(costCfgIds)) {
            filter.or("id", "in", costCfgIds);
        }
        BaseDataHisHelper.addHisCurrFilter((QFilter)filter);
        QFilter[] filters = new QFilter[]{filter};
        SWCDataServiceHelper helper = new SWCDataServiceHelper(billNumber);
        String props = SWCHisBaseDataHelper.getSelectProperties((String)billNumber);
        DynamicObject[] costCfgQueryDys = helper.query(props, filters);
        Map<Long, DynamicObject> costCfgMap = Arrays.stream(costCfgQueryDys).collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy, (k1, k2) -> k1));
        return costCfgMap;
    }

    private Map<Long, DynamicObject> getActualMap(String billNumber, List<Long> sourceIds) {
        String props = SWCHisBaseDataHelper.getSelectProperties((String)billNumber);
        Object[] allFilter = new QFilter[]{new QFilter("id", "in", sourceIds)};
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)billNumber);
        if (dataEntityType.getProperty("iscurrentversion") != null) {
            allFilter = (QFilter[])ArrayUtils.addAll((Object[])allFilter, (Object[])new QFilter[]{new QFilter("iscurrentversion", "=", (Object)Boolean.TRUE)});
        }
        if (props.contains(",enable,") || props.startsWith("enable,") || props.startsWith(",enable")) {
            allFilter = (QFilter[])ArrayUtils.addAll((Object[])allFilter, (Object[])new QFilter[]{new QFilter("enable", "=", (Object)"1")});
        }
        if (props.contains(",status,") || props.startsWith("status,") || props.startsWith(",status")) {
            allFilter = (QFilter[])ArrayUtils.addAll((Object[])allFilter, (Object[])new QFilter[]{new QFilter("status", "=", (Object)"C")});
        }
        SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper(billNumber);
        DynamicObject[] queryResults = serviceHelper.query(props, (QFilter[])allFilter);
        Map<Long, DynamicObject> actualMap = Arrays.stream(queryResults).collect(Collectors.toMap(dy -> dy.getLong("id"), dy -> dy, (k1, k2) -> k1));
        return actualMap;
    }
}

