/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.pcs.business.costcfg;

import java.io.IOException;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.tree.TreeNode;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.swc.hsbp.business.historynew.BaseDataHisHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.cache.SWCPageCache;
import kd.swc.hsbp.common.constants.SWCCostConstants;
import kd.swc.hsbp.common.util.SWCJSONUtils;
import kd.swc.hsbp.common.util.SWCListUtils;

public class CostItemCfgQualityHelper {
    private static final Log logger = LogFactory.getLog(CostItemCfgQualityHelper.class);

    public static DynamicObject[] selectCostItemCfgList(long parentId) {
        SWCDataServiceHelper costCfgHelper = new SWCDataServiceHelper("pcs_costitemcfg");
        QFilter qFilter = new QFilter("parentid", "=", (Object)parentId);
        qFilter.and(new QFilter("sourcetype", "=", (Object)SWCCostConstants.COST_TYPE_ITEM));
        BaseDataHisHelper.addHisCurrFilter((QFilter)qFilter);
        return costCfgHelper.query("id,source.id,qualityname,qualitydim,groupvalue", new QFilter[]{qFilter}, "qualityname asc");
    }

    public static int getQualityGroupIndex(long qualityId) {
        QFilter filter = new QFilter("id", "=", (Object)qualityId);
        SWCDataServiceHelper helper = new SWCDataServiceHelper("pcs_costqualitydim");
        DynamicObject dynamicObject = helper.queryOne("id,index", new QFilter[]{filter});
        return dynamicObject == null ? 1 : dynamicObject.getInt("index");
    }

    public static long getParentId(long pkId) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("pcs_costitemcfg");
        DynamicObject dynamicObject = helper.queryOne((Object)pkId);
        return dynamicObject.getLong("parentId");
    }

    public static void updateCache(List<TreeNode> treeNodeList, IFormView view) {
        try {
            if (!SWCListUtils.isEmpty(treeNodeList)) {
                String treeNodeStr = SWCJSONUtils.toString(treeNodeList);
                SWCPageCache swcPageCache = new SWCPageCache(view);
                swcPageCache.put("treeNode", (Object)treeNodeStr);
            }
        }
        catch (IOException exception) {
            logger.error(exception.getMessage());
            view.showErrorNotification(ResManager.loadKDString((String)"\u7cfb\u7edf\u5f02\u5e38\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"CostItemCfgQualityHelper_1", (String)"swc-pcs-business", (Object[])new Object[0]));
        }
    }

    public static String getTootNodeName(long parentId) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("pcs_costitemcfg");
        DynamicObject dynamicObject = helper.queryOne("id,name", (Object)parentId);
        if (dynamicObject != null) {
            return dynamicObject.getString("name");
        }
        return "";
    }
}

