/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.pcs.business.costcfg;

import java.math.BigDecimal;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.pcs.business.costcommon.CostCommonHelper;

public class CostSetUpExportHelper {
    private CostSetUpExportHelper() {
    }

    public static DynamicObject getTaskInfo(Long calTaskId) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_calpayrolltask");
        String field = "id,name";
        QFilter taskFilter = new QFilter("id", "=", (Object)calTaskId);
        QFilter[] filters = new QFilter[]{taskFilter};
        return helper.queryOne(field, filters);
    }

    public static Map<String, String> getDynamicColumnMap(Long costStruId) {
        LinkedHashMap<String, String> dynamicColumnMap = new LinkedHashMap<String, String>(16);
        SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper("lcs_coststru");
        QFilter idFilter = new QFilter("id", "=", (Object)costStruId);
        DynamicObject costStruDy = serviceHelper.queryOne("dimensionentry,costdimension,storageset,costdimension.valuetype", new QFilter[]{idFilter});
        if (costStruDy == null) {
            return dynamicColumnMap;
        }
        DynamicObjectCollection entryEntity = costStruDy.getDynamicObjectCollection("dimensionentry");
        CostCommonHelper.getDynamicColumnMap(dynamicColumnMap, entryEntity);
        return dynamicColumnMap;
    }

    public static int queryAllCostSetUpListByCalTaskId(Long calTaskId, List<QFilter> costSetUpFilterFromCache) {
        QFilter qFilter = new QFilter("caltask.id", "=", (Object)calTaskId);
        if (costSetUpFilterFromCache != null) {
            for (QFilter filterFromCache : costSetUpFilterFromCache) {
                qFilter.and(filterFromCache);
            }
        }
        SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper("pcs_costsetuprst");
        return serviceHelper.count(new QFilter[]{qFilter});
    }

    public static Map<String, Object> setFixColumnValue(int rowSeq, DynamicObject salaryItemEntryDy, DynamicObject costSetUpData) {
        LinkedHashMap<String, Object> valueMap = new LinkedHashMap<String, Object>(16);
        valueMap.put("id", costSetUpData.getLong("id"));
        valueMap.put("rowSeq", rowSeq + 1);
        valueMap.put("personName", costSetUpData.getString("salaryfile.person.name"));
        valueMap.put("personNum", costSetUpData.getString("salaryfile.employee.empnumber"));
        valueMap.put("salaryFileNum", costSetUpData.getString("salaryfile.number"));
        valueMap.put("adapterCountryName", costSetUpData.getString("salaryfile.payrollregion.name"));
        String enable = costSetUpData.getString("enable");
        String desc = CostSetUpExportHelper.getEnableDesc(enable);
        valueMap.put("enable", desc);
        valueMap.put("salaryItemName", costSetUpData.getString("salaryitem.name"));
        valueMap.put("costitemName", costSetUpData.getString("costitem.name"));
        if (salaryItemEntryDy == null) {
            valueMap.put("percentage", "");
            valueMap.put("defcostsetupconstval", "");
            valueMap.put("isRevealDetail", "");
        } else {
            BigDecimal percentage = salaryItemEntryDy.getBigDecimal("percentage");
            valueMap.put("percentage", BigDecimal.ZERO.compareTo(percentage) == 0 ? "" : percentage.setScale(6));
            valueMap.put("defcostsetupconstval", salaryItemEntryDy.getString("defcostsetupconstval"));
            valueMap.put("isRevealDetail", salaryItemEntryDy.getBoolean("isrevealdetail") ? ResManager.loadKDString((String)"\u662f", (String)"CostSetUpExportHelper_1", (String)"swc-pcs-business", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5426", (String)"CostSetUpExportHelper_2", (String)"swc-pcs-business", (Object[])new Object[0]));
        }
        return valueMap;
    }

    private static String getEnableDesc(String enable) {
        String desc = "";
        if ("0".equals(enable)) {
            desc = ResManager.loadKDString((String)"\u65e0\u6548", (String)"CostSetUpExportHelper_3", (String)"swc-pcs-business", (Object[])new Object[0]);
        } else if ("1".equals(enable)) {
            desc = ResManager.loadKDString((String)"\u6709\u6548", (String)"CostSetUpExportHelper_4", (String)"swc-pcs-business", (Object[])new Object[0]);
        } else if ("2".equals(enable)) {
            desc = ResManager.loadKDString((String)"\u8b66\u544a", (String)"CostSetUpExportHelper_5", (String)"swc-pcs-business", (Object[])new Object[0]);
        }
        return desc;
    }
}

