/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.pcs.business.costcfg;

import java.math.BigDecimal;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.Tips;
import kd.bos.entity.property.TextProp;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.list.ListShowParameter;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.entity.commonfield.TextField;
import kd.bos.metadata.form.control.EntryAp;
import kd.bos.metadata.form.control.EntryFieldAp;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.common.constants.SWCCostConstants;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCListUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.pcs.business.costcfg.CostCfgHelper;
import kd.swc.pcs.business.costcfg.CostCustomCreateEntryHelper;
import kd.swc.pcs.business.costcommon.CostCommonHelper;

public class CostSetUpHelper {
    private static final String SWC_PCS_BUSINESS = "swc-pcs-business";
    private static final Log logger = LogFactory.getLog(CostSetUpHelper.class);
    private static final String SEPARATOR = "||";

    private static Map<String, Long> queryCostSetupConstMap(Long costStruId) {
        SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper("pcs_costsetupconst");
        QFilter costStruFilter = new QFilter("coststru", "=", (Object)costStruId);
        DynamicObject[] costSetUpConstArr = serviceHelper.queryOriginalArray("id,coststru,segmentvalmd5", new QFilter[]{costStruFilter});
        HashMap<String, Long> setUpConstInfoMap = new HashMap<String, Long>(costSetUpConstArr.length);
        for (DynamicObject setUpConstObj : costSetUpConstArr) {
            String segmentValMd5 = setUpConstObj.getString("segmentvalmd5");
            Long setUpConstObjId = (Long)setUpConstInfoMap.get(segmentValMd5);
            if (setUpConstObjId != null) continue;
            setUpConstInfoMap.put(segmentValMd5, setUpConstObj.getLong("id"));
        }
        return setUpConstInfoMap;
    }

    public static List<Long> getExistSalaryFileNumber(long calTaskId, boolean isDefined) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("pcs_costsetuprst");
        QFilter taskQFilter = new QFilter("caltask.id", "=", (Object)calTaskId);
        if (isDefined) {
            taskQFilter.and(new QFilter("isdefined", "=", (Object)"1"));
        }
        DynamicObject[] queryResult = helper.query("salaryfile.id", new QFilter[]{taskQFilter});
        ArrayList<Long> salaryFileList = new ArrayList<Long>(queryResult.length);
        for (DynamicObject dynamicObject : queryResult) {
            long salaryFileId = dynamicObject.getLong("salaryfile.id");
            salaryFileList.add(salaryFileId);
        }
        return salaryFileList;
    }

    public static Long getEntryInfoByEntryPkId(Long entryPkId, Long costSetUpId) {
        String sql = "SELECT FDEFCOSTSETUPCONSTID CONSTID FROM T_PCS_COSTSETUPRSTENT WHERE FENTRYID=? and FID=?";
        try (DataSet dataSet = DB.queryDataSet((String)"kd.swc.pcs.business.costcfg.CostSetUpHelper", (DBRoute)DBRoute.of((String)"swc"), (String)sql, (Object[])new Object[]{entryPkId, costSetUpId});){
            Iterator dataSetIterator = dataSet.iterator();
            if (dataSetIterator.hasNext()) {
                Row row = (Row)dataSetIterator.next();
                Long l = row.getLong("CONSTID");
                return l;
            }
        }
        return null;
    }

    public static DynamicObject querySetUpConstObjById(Long constId) {
        SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper("pcs_costsetupconst");
        return serviceHelper.queryOne("coststru,segment1,segment2,segment3,segment4,segment5,segment6,segment7,segment8,segment9,segment10,segment11,segment12,segment13,segment14,segment15,segment16,segment17,segment18,segment19,segment20,segment21,segment22,segment23,segment24,segment25,segment26,segment27,segment28,segment29,segment30", (Object)constId);
    }

    public static Map<String, DynamicObject> querySetUpConstObjByIdList(List<Long> constIdList) {
        SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper("pcs_costsetupconst");
        DynamicObject[] costConstObjArr = serviceHelper.queryOriginalArray("id,segment1,segment2,segment3,segment4,segment5,segment6,segment7,segment8,segment9,segment10,segment11,segment12,segment13,segment14,segment15,segment16,segment17,segment18,segment19,segment20,segment21,segment22,segment23,segment24,segment25,segment26,segment27,segment28,segment29,segment30", new QFilter[]{new QFilter("id", "in", constIdList)});
        HashMap<String, DynamicObject> constObjMap = new HashMap<String, DynamicObject>(costConstObjArr.length);
        for (DynamicObject costConstObj : costConstObjArr) {
            constObjMap.put(costConstObj.getString("id"), costConstObj);
        }
        return constObjMap;
    }

    public static Map<String, DynamicObject> querySegmentObjByIdList(List<Long> constIdList) {
        SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper("pcs_costsegstore");
        String properties = "coststru,segment1,segment2,segment3,segment4,segment5,segment6,segment7,segment8,segment9,segment10,segment11,segment12,segment13,segment14,segment15,segment16,segment17,segment18,segment19,segment20,segment21,segment22,segment23,segment24,segment25,segment26,segment27,segment28,segment29,segment30";
        DynamicObject[] costSegStoreArr = serviceHelper.query(properties, new QFilter[]{new QFilter("id", "in", constIdList)});
        HashMap<String, DynamicObject> constObjMap = new HashMap<String, DynamicObject>(costSegStoreArr.length);
        for (DynamicObject costSegStore : costSegStoreArr) {
            constObjMap.put(costSegStore.getString("id"), costSegStore);
        }
        return constObjMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveCostUpCustomizeInfo(ClosedCallBackEvent event, IFormView view) {
        Map returnDataMap = (Map)event.getReturnData();
        List resultList = (List)returnDataMap.get("costsetupcustomizevalue");
        Object costSetUpIdObjId = returnDataMap.get("costsetupid");
        Object costItemIdObj = returnDataMap.get("costitemid");
        SWCDataServiceHelper setUpRstHelper = new SWCDataServiceHelper("pcs_costsetuprst");
        QFilter filter = new QFilter("id", "=", (Object)Long.parseLong(String.valueOf(costSetUpIdObjId)));
        DynamicObject setUpRstQueryResult = setUpRstHelper.queryOne("id,vid,name,number,enable,simplename,description,createtime,caltask,salaryfile,costadapter,country,isdefined,salaryitem,costitem,costadapter,entryentity.seq,entryentity,percentage,aotucostsetupconst,aotucostsetupconstval,defcostsetupconst,defcostsetupconstval,isrevealdetail,maxmount,calcurrency", new QFilter[]{filter});
        DynamicObjectCollection setUpRstEntryDys = setUpRstQueryResult.getDynamicObjectCollection("entryentity");
        SWCDataServiceHelper setUpRstHisHelper = new SWCDataServiceHelper("pcs_costsetuprsthis");
        DynamicObject setUpRstHisDy = setUpRstHisHelper.generateEmptyDynamicObject();
        DynamicObjectCollection setUpRstHisEntryDys = setUpRstHisDy.getDynamicObjectCollection("entryentity");
        DynamicObjectCollection setUpRstHisDys = new DynamicObjectCollection();
        SWCDataServiceHelper setUpConstHelper = new SWCDataServiceHelper("pcs_costsetupconst");
        long id = setUpRstQueryResult.getLong("id");
        QFilter vidFilter = new QFilter("costsetuprst", "=", (Object)id);
        DynamicObject[] queryResult = setUpRstHisHelper.query(new QFilter[]{vidFilter});
        if (queryResult.length == 0) {
            CostSetUpHelper.setUpResultHisMasterInfo(setUpRstQueryResult, setUpRstHisDy, true);
            CostSetUpHelper.setUpResultHisEntryInfo(setUpRstEntryDys, setUpRstHisEntryDys);
            setUpRstHisDys.add((Object)setUpRstHisDy);
        }
        setUpRstEntryDys.clear();
        DynamicObjectCollection saveSetUpConstDys = CostSetUpHelper.packageResultData(resultList, setUpRstQueryResult, setUpRstEntryDys, setUpRstHisDys, costItemIdObj);
        try (TXHandle txHandle = TX.required();){
            setUpRstHelper.saveOne(setUpRstQueryResult);
            setUpRstHisHelper.save(setUpRstHisDys);
            if (!saveSetUpConstDys.isEmpty()) {
                setUpConstHelper.save(saveSetUpConstDys);
            }
            view.invokeOperation("refresh");
        }
    }

    private static void setUpResultHisEntryInfo(DynamicObjectCollection setUpRstEntryDys, DynamicObjectCollection setUpRstHisEntryDys) {
        SWCDataServiceHelper setUpRstHisHelper = new SWCDataServiceHelper("pcs_costsetuprsthis");
        int i = 1;
        for (DynamicObject setUpRstEntryDy : setUpRstEntryDys) {
            DynamicObject setUpRstHisEntryDy = setUpRstHisHelper.generateEmptyEntryDynamicObject("entryentity");
            setUpRstHisEntryDy.set("seq", (Object)i++);
            setUpRstHisEntryDy.set("isrevealdetail", setUpRstEntryDy.get("isrevealdetail"));
            setUpRstHisEntryDy.set("percentage", setUpRstEntryDy.get("percentage"));
            setUpRstHisEntryDy.set("maxmount", setUpRstEntryDy.get("maxmount"));
            setUpRstHisEntryDy.set("aotucostsetupconst", setUpRstEntryDy.get("aotucostsetupconst"));
            setUpRstHisEntryDy.set("aotucostsetupconstval", setUpRstEntryDy.get("aotucostsetupconstval"));
            setUpRstHisEntryDy.set("defcostsetupconst", setUpRstEntryDy.get("defcostsetupconst"));
            setUpRstHisEntryDy.set("defcostsetupconstval", setUpRstEntryDy.get("defcostsetupconstval"));
            setUpRstHisEntryDys.add((Object)setUpRstHisEntryDy);
        }
    }

    private static void setUpResultHisMasterInfo(DynamicObject setUpRstQueryResult, DynamicObject setUpRstHisDy, boolean isFirstSave) {
        long id = setUpRstQueryResult.getLong("id");
        long salaryItemId = setUpRstQueryResult.getLong("salaryitem.id");
        long costItemId = setUpRstQueryResult.getLong("costitem.id");
        setUpRstHisDy.set("costsetuprst", (Object)id);
        setUpRstHisDy.set("salaryitem", (Object)salaryItemId);
        setUpRstHisDy.set("costitem", (Object)costItemId);
        setUpRstHisDy.set("caltask", setUpRstQueryResult.get("caltask"));
        setUpRstHisDy.set("salaryfile", setUpRstQueryResult.get("salaryfile"));
        setUpRstHisDy.set("costadapter", setUpRstQueryResult.get("costadapter"));
        setUpRstHisDy.set("country", setUpRstQueryResult.get("country"));
        long userId = RequestContext.get().getCurrUserId();
        setUpRstHisDy.set("creator", (Object)userId);
        setUpRstHisDy.set("modifier", (Object)userId);
        if (isFirstSave) {
            setUpRstHisDy.set("createtime", (Object)setUpRstQueryResult.getDate("createtime"));
            setUpRstHisDy.set("modifytime", (Object)setUpRstQueryResult.getDate("createtime"));
        } else {
            setUpRstHisDy.set("createtime", (Object)new Date());
            setUpRstHisDy.set("modifytime", (Object)new Date());
        }
    }

    private static DynamicObjectCollection packageResultData(List<Map<String, Object>> resultList, DynamicObject setUpRstQueryResult, DynamicObjectCollection setUpRstEntryDys, DynamicObjectCollection setUpRstHisDys, Object costItemIdObj) {
        long costStruId = setUpRstQueryResult.getLong("costadapter.coststru.id");
        long calCurrencyId = setUpRstQueryResult.getLong("costadapter.currency.id");
        Map<String, String> queryCostStruMap = CostCommonHelper.queryCostStruMap(costStruId);
        Map<String, Long> queryCostSetupConstMap = CostSetUpHelper.queryCostSetupConstMap(costStruId);
        SWCDataServiceHelper setUpRstHisHelper = new SWCDataServiceHelper("pcs_costsetuprsthis");
        DynamicObject setUpRstHisDy = setUpRstHisHelper.generateEmptyDynamicObject();
        DynamicObjectCollection setUpRstHisEntryDys = setUpRstHisDy.getDynamicObjectCollection("entryentity");
        DynamicObjectType dynamicObjectType = setUpRstEntryDys.getDynamicObjectType();
        DynamicObjectCollection saveSetUpConstDys = new DynamicObjectCollection();
        setUpRstQueryResult.set("isdefined", (Object)Boolean.TRUE);
        setUpRstQueryResult.set("costitem", costItemIdObj);
        if (SWCListUtils.isEmpty(resultList)) {
            CostSetUpHelper.setUpResultHisMasterInfo(setUpRstQueryResult, setUpRstHisDy, false);
            setUpRstQueryResult.set("enable", (Object)"0");
        } else {
            int i = 1;
            BigDecimal costCfgTotal = BigDecimal.ZERO;
            for (Map<String, Object> customizeMap : resultList) {
                String costStruCfgValue;
                String costStruCfgValueMd5;
                Long costSetupConstId;
                Object calCostProportion = customizeMap.get("decimal10007");
                String calCostProportionStr = String.valueOf(calCostProportion);
                if (SWCStringUtils.isNotEmpty((String)calCostProportionStr)) {
                    costCfgTotal = costCfgTotal.add(new BigDecimal(calCostProportionStr));
                }
                if ((costSetupConstId = queryCostSetupConstMap.get(costStruCfgValueMd5 = SWCStringUtils.getMD5str((String)(costStruCfgValue = String.valueOf(customizeMap.get("defcostsetupconstvalueresult")))))) == null) {
                    costSetupConstId = CostSetUpHelper.setUpConstDyInfo(costStruId, queryCostStruMap, saveSetUpConstDys, customizeMap, costStruCfgValue, costStruCfgValueMd5);
                }
                DynamicObject setUpRstHisEntryDy = setUpRstHisHelper.generateEmptyEntryDynamicObject("entryentity");
                CostSetUpHelper.setUpResultHisMasterInfo(setUpRstQueryResult, setUpRstHisDy, false);
                setUpRstHisDy.set("costitem", costItemIdObj);
                int seq = i++;
                CostSetUpHelper.setUpResultEntryCommonInfo(customizeMap, costStruCfgValue, costSetupConstId, setUpRstHisEntryDy, seq);
                setUpRstHisEntryDys.add((Object)setUpRstHisEntryDy);
                DynamicObject newSetUpRstEntryDy = new DynamicObject(dynamicObjectType);
                CostSetUpHelper.setUpResultEntryCommonInfo(customizeMap, costStruCfgValue, costSetupConstId, newSetUpRstEntryDy, seq);
                newSetUpRstEntryDy.set("calcurrency", (Object)calCurrencyId);
                setUpRstEntryDys.add((Object)newSetUpRstEntryDy);
            }
            CostSetUpHelper.setCostSetUpEnable(setUpRstQueryResult, costCfgTotal);
        }
        setUpRstHisDys.add((Object)setUpRstHisDy);
        return saveSetUpConstDys;
    }

    private static void setCostSetUpEnable(DynamicObject setUpRstQueryResult, BigDecimal costCfgTotal) {
        if (costCfgTotal.compareTo(new BigDecimal(100)) < 0) {
            setUpRstQueryResult.set("enable", (Object)"2");
        } else if (costCfgTotal.compareTo(new BigDecimal(100)) == 0) {
            setUpRstQueryResult.set("enable", (Object)"1");
        } else {
            setUpRstQueryResult.set("enable", (Object)"0");
        }
    }

    private static Long setUpConstDyInfo(long costStruId, Map<String, String> queryCostStruMap, DynamicObjectCollection saveSetUpConstDys, Map<String, Object> customizeMap, String costStruCfgValue, String costStruCfgValueMd5) {
        Iterator<Map.Entry<String, String>> iterator = queryCostStruMap.entrySet().iterator();
        SWCDataServiceHelper consHelper = new SWCDataServiceHelper("pcs_costsetupconst");
        DynamicObject setUpConstDy = consHelper.generateEmptyDynamicObject();
        Long costSetupConstObjId = ORM.create().genLongId(setUpConstDy.getDataEntityType());
        setUpConstDy.set("id", (Object)costSetupConstObjId);
        setUpConstDy.set("coststru", (Object)costStruId);
        setUpConstDy.set("segmentval", (Object)costStruCfgValue);
        setUpConstDy.set("segmentvalmd5", (Object)costStruCfgValueMd5);
        setUpConstDy.set("createtime", (Object)new Date());
        setUpConstDy.set("modifytime", (Object)new Date());
        long userId = RequestContext.get().getCurrUserId();
        setUpConstDy.set("creator", (Object)userId);
        setUpConstDy.set("modifier", (Object)userId);
        while (iterator.hasNext()) {
            Map.Entry<String, String> next = iterator.next();
            String fieldKey = next.getKey();
            String numberValue = next.getValue();
            Object object = customizeMap.get(fieldKey);
            setUpConstDy.set("segment" + numberValue, object);
        }
        saveSetUpConstDys.add((Object)setUpConstDy);
        return costSetupConstObjId;
    }

    private static void setUpResultEntryCommonInfo(Map<String, Object> customizemap, String costStruCfgValue, Long costSetupConstId, DynamicObject setUpRstHisEntryDy, int seq) {
        setUpRstHisEntryDy.set("seq", (Object)seq);
        setUpRstHisEntryDy.set("isrevealdetail", (Object)Boolean.valueOf(String.valueOf(customizemap.get("checkbox10006"))));
        setUpRstHisEntryDy.set("percentage", (Object)new BigDecimal(String.valueOf(customizemap.get("decimal10007"))));
        setUpRstHisEntryDy.set("aotucostsetupconst", (Object)costSetupConstId);
        setUpRstHisEntryDy.set("aotucostsetupconstval", (Object)costStruCfgValue);
        setUpRstHisEntryDy.set("defcostsetupconst", (Object)costSetupConstId);
        setUpRstHisEntryDy.set("defcostsetupconstval", (Object)costStruCfgValue);
    }

    public static List<DynamicObject> addNewFixColumn(List<DynamicObject> dimensionObjList, String type) {
        DynamicObjectType dynamicObjectType = CostCommonHelper.getDynamicObjectType(dimensionObjList);
        ArrayList<DynamicObject> newColumnList = new ArrayList<DynamicObject>();
        if ("0".equals(type)) {
            DynamicObject costObjColumn = new DynamicObject(dynamicObjectType);
            costObjColumn.set("id", (Object)"10001");
            costObjColumn.set("name", (Object)ResManager.loadKDString((String)"\u6210\u672c\u5bf9\u8c61", (String)"CostSetUpHelper_0", (String)SWC_PCS_BUSINESS, (Object[])new Object[0]));
            newColumnList.add(costObjColumn);
            DynamicObject typeColumn = new DynamicObject(dynamicObjectType);
            typeColumn.set("id", (Object)"10004");
            typeColumn.set("name", (Object)ResManager.loadKDString((String)"\u7c7b\u578b", (String)"CostSetUpHelper_3", (String)SWC_PCS_BUSINESS, (Object[])new Object[0]));
            newColumnList.add(typeColumn);
        }
        DynamicObject percentColumn = new DynamicObject(dynamicObjectType);
        percentColumn.set("id", (Object)"10002");
        percentColumn.set("name", (Object)ResManager.loadKDString((String)"\u767e\u5206\u6bd4(%)", (String)"CostSetUpHelper_1", (String)SWC_PCS_BUSINESS, (Object[])new Object[0]));
        newColumnList.add(percentColumn);
        if (!dimensionObjList.isEmpty()) {
            newColumnList.addAll(dimensionObjList);
        }
        return newColumnList;
    }

    public static void dynamicCreateEntryApItem(EntryAp dynamicEntryAp, EntityMetadata entityMetadata, Long costStruId, String type) {
        List<DynamicObject> dimensionObjList = CostCfgHelper.getSortedDimensionList(costStruId, null, "");
        List<DynamicObject> newColumnList = CostSetUpHelper.addNewFixColumn(dimensionObjList, type);
        for (DynamicObject dynamicObject : newColumnList) {
            EntryFieldAp groupAp = CostSetUpHelper.createEntryFieldByType(entityMetadata, dynamicObject);
            if (groupAp == null) continue;
            dynamicEntryAp.getItems().add(groupAp);
        }
    }

    public static EntryAp createDynamicEntryAp(String key) {
        EntryAp entryAp = new EntryAp();
        entryAp.setKey(key);
        entryAp.setOrderAndFilter(1);
        entryAp.setWidth(new LocaleString("50%"));
        entryAp.setGrow(0);
        entryAp.setShrink(0);
        entryAp.setRowHeight("40px");
        return entryAp;
    }

    public static EntryFieldAp createEntryFieldByType(EntityMetadata entityMetadata, DynamicObject dimensionObj) {
        String name;
        String dimensionName = dimensionObj.getString("name");
        String dimensionId = dimensionObj.getString("id");
        EntryFieldAp entryFieldAp = CostCustomCreateEntryHelper.createEntryFieldAp(dimensionName, dimensionId);
        TextField field = new TextField();
        field.setId(dimensionId);
        field.setKey(dimensionId);
        field.setEmptyText(new LocaleString(dimensionName));
        field.setEnableNull(false);
        field.setLockedEmptyTip(new LocaleString(""));
        field.setDefValue("");
        field.setEntityMetadata(entityMetadata);
        entryFieldAp.setField((Field)field);
        String porName = ResManager.loadKDString((String)"\u767e\u5206\u6bd4(%)", (String)"CostSetUpHelper_1", (String)SWC_PCS_BUSINESS, (Object[])new Object[0]);
        if (porName.equals(dimensionName)) {
            entryFieldAp.setTextAlign("right");
        }
        if ((name = ResManager.loadKDString((String)"\u7c7b\u578b", (String)"CostSetUpHelper_3", (String)SWC_PCS_BUSINESS, (Object[])new Object[0])).equals(dimensionName)) {
            Tips tips = new Tips();
            tips.setContent(new LocaleString(ResManager.loadKDString((String)"\u5206\u4e3a\u884c\u653f\u7ec4\u7ec7\u5c42\u7ea7\u4e0a\u7684\u515c\u5e95\u6210\u672c\u8bbe\u7f6e\u3001\u85aa\u916c\u9879\u76ee\u5c42\u7ea7\u4e0a\u7684\u4f18\u5148\u6210\u672c\u8bbe\u7f6e\u53ca\u5404\u5c42\u7ea7\u4e0a\u7684\u6210\u672c\u8bbe\u7f6e\u3002", (String)"CostSetUpHelper_5", (String)SWC_PCS_BUSINESS, (Object[])new Object[0])));
            tips.setType("text");
            tips.setTriggerType("hover");
            entryFieldAp.setCtlTips(tips);
        }
        return entryFieldAp;
    }

    public static void createPropByType(MainEntityType newMainType, DynamicObject dimensionObj, String identifying) {
        String dimensionId = dimensionObj.getString("id");
        String dimensionName = dimensionObj.getString("name");
        TextProp textProp = new TextProp();
        textProp.setName(dimensionId);
        textProp.setDisplayName(new LocaleString(dimensionName));
        textProp.setDefaultValue((Object)"");
        textProp.setDbIgnore(true);
        textProp.setDefValue((Object)"");
        textProp.setAlias(null);
        EntityType entityType = (EntityType)newMainType.getAllEntities().get(identifying);
        entityType.registerSimpleProperty((DynamicSimpleProperty)textProp);
    }

    public static DynamicObject querySalaryFile(long salaryFileId) {
        SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper("hsas_salaryfile");
        String selectProperties = "number,name,adminorg.name,empgroup,empposinfo.adminorg,empposinfo.position,employee";
        return serviceHelper.queryOne(selectProperties, (Object)salaryFileId);
    }

    public static DynamicObject getCalPersonDyByTaskFileId(Long calTaskId, Long salaryFileId) {
        SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper("hsas_calperson");
        QFilter salaryFileFilter = new QFilter("salaryfile.id", "=", (Object)salaryFileId);
        salaryFileFilter.and(new QFilter("caltask.id", "=", (Object)calTaskId));
        String selectProperties = "id,salaryfile,empposorgrelhrv.position,empposorgrelhrv.adminorg";
        DynamicObject calPerson = serviceHelper.queryOne(selectProperties, new QFilter[]{salaryFileFilter});
        return calPerson;
    }

    public static Map<String, String> queryCostBizObjMap(List<Long> costBizObjIdList) {
        SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper("lcs_costbizobj");
        QFilter idFilter = new QFilter("id", "in", costBizObjIdList);
        DynamicObject[] costBizObjArr = serviceHelper.query("id,name", new QFilter[]{idFilter}, "index");
        LinkedHashMap<String, String> costBizObjIdRefNameMap = new LinkedHashMap<String, String>(costBizObjArr.length);
        for (DynamicObject costBizObj : costBizObjArr) {
            costBizObjIdRefNameMap.put(costBizObj.getString("id"), costBizObj.getString("name"));
        }
        return costBizObjIdRefNameMap;
    }

    public static DynamicObject[] queryCostCfgHis(Long costAdapterId, Long[] sourceIds, Date calTaskEndDate, List<Long> boidList) {
        SWCDataServiceHelper costSetupRstHelper = new SWCDataServiceHelper("pcs_costcfg");
        QFilter costAdapterQFilter = new QFilter("costadapter.id", "=", (Object)costAdapterId);
        costAdapterQFilter.and(new QFilter("source", "in", (Object)sourceIds));
        costAdapterQFilter.and(new QFilter("datastatus", "in", (Object)new String[]{"2", "1", "0"}));
        costAdapterQFilter.and(new QFilter("bsed", "<=", (Object)calTaskEndDate));
        costAdapterQFilter.and(new QFilter("bsled", ">=", (Object)calTaskEndDate));
        costAdapterQFilter.and(new QFilter("iscurrentversion", "=", (Object)"0"));
        costAdapterQFilter.and(new QFilter("enable", "=", (Object)"1"));
        costAdapterQFilter.and(new QFilter("boid", "in", boidList));
        String fieldKey = "id,boid,sourcetype,source,creatorobj,calcostproportion,coststrucfgvalue,costsegstore,costcfgtypeproportion,costtypesegstore,coststrutypecfgvalue";
        return costSetupRstHelper.query(fieldKey, new QFilter[]{costAdapterQFilter});
    }

    public static DynamicObject[] queryCostCfgCurrent(Long costAdapterId, Long[] sourceIds) {
        SWCDataServiceHelper costSetupRstHelper = new SWCDataServiceHelper("pcs_costcfg");
        QFilter costAdapterQFilter = new QFilter("costadapter.id", "=", (Object)costAdapterId);
        costAdapterQFilter.and(new QFilter("source", "in", (Object)sourceIds));
        costAdapterQFilter.and(new QFilter("iscurrentversion", "=", (Object)"1"));
        costAdapterQFilter.and(new QFilter("enable", "=", (Object)"1"));
        return costSetupRstHelper.query("id,boid", new QFilter[]{costAdapterQFilter});
    }

    public static DynamicObject[] queryAdminOrgCostCfgHis(long costAdapterId, Date calTaskEndDate) {
        SWCDataServiceHelper costSetupRstHelper = new SWCDataServiceHelper("pcs_costdeptcfg");
        QFilter costAdapterQFilter = new QFilter("costadapter.id", "=", (Object)costAdapterId);
        costAdapterQFilter.and(new QFilter("datastatus", "in", (Object)new String[]{"2", "1", "0"}));
        costAdapterQFilter.and(new QFilter("bsed", "<=", (Object)calTaskEndDate));
        costAdapterQFilter.and(new QFilter("bsled", ">=", (Object)calTaskEndDate));
        costAdapterQFilter.and(new QFilter("iscurrentversion", "=", (Object)"0"));
        costAdapterQFilter.and(new QFilter("enable", "=", (Object)"1"));
        costAdapterQFilter.and(new QFilter("sourcetype.id", "=", (Object)SWCCostConstants.COST_TYPE_DEPT));
        return costSetupRstHelper.query("source", new QFilter[]{costAdapterQFilter});
    }

    public static DynamicObject queryCostSetUpObjBykId(Long costSetUpId) {
        SWCDataServiceHelper costSetupRstHelper = new SWCDataServiceHelper("pcs_costsetuprst");
        return costSetupRstHelper.queryOne("id,salaryitem,salaryfile,costadapter,caltask,percentage,aotucostsetupconst", (Object)costSetUpId);
    }

    public static boolean isExistSetUp(Long costSetUpId) {
        SWCDataServiceHelper costSetupRstHelper = new SWCDataServiceHelper("pcs_costsetuprst");
        return costSetupRstHelper.isExists((Object)costSetUpId);
    }

    public static DynamicObject queryCostSetUpByPkId(Long costSetUpId) {
        SWCDataServiceHelper setUpRstHelper = new SWCDataServiceHelper("pcs_costsetuprst");
        QFilter filter = new QFilter("id", "=", (Object)costSetUpId);
        return setUpRstHelper.queryOne("id,costadapter.coststru", new QFilter[]{filter});
    }

    public static String getNameVal(String segmentVal) {
        if (SWCStringUtils.isEmpty((String)segmentVal)) {
            return "";
        }
        if (segmentVal.contains(SEPARATOR)) {
            String segmentValue = segmentVal.substring(segmentVal.indexOf(SEPARATOR) + 2);
            if ("null".equals(segmentValue)) {
                return "";
            }
            return segmentValue;
        }
        return segmentVal;
    }

    public static String getIdVal(String segStoreValue) {
        if (SWCStringUtils.isEmpty((String)segStoreValue)) {
            return "";
        }
        return segStoreValue;
    }

    public static ListShowParameter getCalTableListForm(String parentPageId, long calTaskId) {
        Map<String, String> taskInfo = CostSetUpHelper.getTaskInfo(calTaskId);
        if (taskInfo == null) {
            return null;
        }
        ListShowParameter showParameter = new ListShowParameter();
        showParameter.setFormId("hsas_calpersonlist");
        showParameter.setBillFormId("hsas_calperson");
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setCustomParam("payrolltaskdatanumber", (Object)taskInfo.get("payrolltaskdatanumber"));
        showParameter.setCustomParam("payrolltaskdataid", (Object)calTaskId);
        showParameter.setCustomParam("org", (Object)taskInfo.get("orgId"));
        showParameter.setCustomParam("name", (Object)taskInfo.get("name"));
        showParameter.setCustomParam("startdate", (Object)taskInfo.get("startdate"));
        showParameter.setCustomParam("enddate", (Object)taskInfo.get("enddate"));
        showParameter.setCustomParam("calListViewVid", (Object)taskInfo.get("calListViewVid"));
        showParameter.setCustomParam("payrollgroup", (Object)taskInfo.get("payrollgroup"));
        showParameter.setCustomParam("payrollgroupv", (Object)taskInfo.get("payrollgroupv"));
        showParameter.setCustomParam("payrolldate", (Object)taskInfo.get("payrolldate"));
        showParameter.setCustomParam("calTaskType", (Object)taskInfo.get("calTaskType"));
        showParameter.setCustomParam("payRollSceneVId", (Object)taskInfo.get("payRollSceneVId"));
        showParameter.setCustomParam("calPeriodId", (Object)taskInfo.get("calPeriodVId"));
        showParameter.setCustomParam("calRuleId", (Object)taskInfo.get("calRuleId"));
        showParameter.setCustomParam("calRuleVId", (Object)taskInfo.get("calRuleVId"));
        showParameter.setCustomParam("calTimes", (Object)taskInfo.get("calCount"));
        showParameter.setCustomParam("orgName", (Object)taskInfo.get("orgName"));
        showParameter.setCustomParam("taskstatus", (Object)taskInfo.get("taskstatus"));
        showParameter.setCustomParam("countryId", (Object)taskInfo.get("countryId"));
        showParameter.setCustomParam("isEdit", (Object)Boolean.FALSE);
        showParameter.setCustomParam("isSplitPage", (Object)Boolean.TRUE);
        showParameter.setCustomParam("isShowNotCover", (Object)Boolean.TRUE);
        showParameter.setCustomParam("notShowColumns", null);
        showParameter.setCustomParam("editColumns", null);
        showParameter.setCustomParam("isShowSalaryItem", (Object)Boolean.FALSE);
        showParameter.setPageId(parentPageId + "bill" + calTaskId);
        return showParameter;
    }

    private static Map<String, String> getTaskInfo(Long taskId) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hsas_calpayrolltask");
        HashMap<String, String> map = new HashMap<String, String>(16);
        DynamicObject dy = helper.queryOne("org.id,name,startdate,enddate,calcount,calrule.id,calrulev.id,org.name,taskstatus,country.id,payrollgroup.id,payrolldate,payrollgroupv.id,tasktype,payrollscenev.id,period.id,callistviewv.id", (Object)taskId);
        if (null == dy) {
            return null;
        }
        String orgStr = dy.getString("org.id");
        String name = dy.getString("name");
        String startDate = dy.getString("startdate");
        String endDate = dy.getString("enddate");
        String calCount = dy.getString("calcount");
        String calRuleId = dy.getString("calrule.id");
        String calRuleVId = dy.getString("calrulev.id");
        String orgName = dy.getString("org.name");
        String taskstatus = dy.getString("taskstatus");
        String calListViewVid = dy.getString("callistviewv.id");
        long countryId = dy.getLong("country.id");
        String calTaskType = dy.getString("tasktype");
        String payRollSceneId = dy.getString("payrollscenev.id");
        String calPeriodId = dy.getString("period.id");
        map.put("payrolltaskdatanumber", dy.getString("number"));
        map.put("orgId", orgStr);
        map.put("name", name);
        map.put("startdate", startDate);
        map.put("enddate", endDate);
        map.put("calCount", calCount);
        map.put("calRuleId", calRuleId);
        map.put("calRuleVId", calRuleVId);
        map.put("orgName", orgName);
        map.put("taskstatus", taskstatus);
        map.put("countryId", String.valueOf(countryId));
        map.put("payrollgroup", dy.getString("payrollgroup.id"));
        map.put("payrollgroupv", dy.getString("payrollgroupv.id"));
        map.put("payrolldate", dy.getString("payrolldate"));
        map.put("calTaskType", calTaskType);
        map.put("payRollSceneVId", payRollSceneId);
        map.put("calPeriodVId", calPeriodId);
        map.put("calListViewVid", calListViewVid);
        return map;
    }

    public static String getUserNameById(String userId) {
        SWCDataServiceHelper helper = new SWCDataServiceHelper("bos_user");
        QFilter[] filters = new QFilter[]{new QFilter("id", "=", (Object)Long.valueOf(userId))};
        DynamicObject lockUser = helper.queryOne("name", filters);
        if (null != lockUser) {
            return lockUser.getString("name");
        }
        return null;
    }

    public static Date convertDate(Date calTaskEndDate) {
        String format = SWCDateTimeUtils.format((Date)calTaskEndDate, (String)"yyyy-MM-dd");
        Date date = null;
        try {
            date = SWCDateTimeUtils.parseDate((String)format);
        }
        catch (ParseException e) {
            logger.error("CostSetUpHelper convertDate error:", (Object)e.getMessage());
        }
        return date;
    }
}

