/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.pcs.business.costcfg.dataimport.helper;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.swc.hsbp.business.historynew.BaseDataHisHelper;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCHisBaseDataHelper;
import kd.swc.hsbp.common.constants.SWCCostConstants;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.pcs.business.costcfg.CostCfgExportHelper;
import kd.swc.pcs.business.costcommon.CostCommonHelper;

public class CostCfgImportHelper {
    private static final Log LOGGER = LogFactory.getLog(CostCfgImportHelper.class);

    public static Map<String, DynamicObject> queryCostCfgDy(String billFormId, long costAdapterId, List<Long> sourceIdList, List<Long> salaryFileIdList) {
        Long sourceTypeId = CostCommonHelper.getCostCfgTypeIdByFormId(billFormId);
        QFilter filter = new QFilter("costadapter.id", "=", (Object)costAdapterId);
        filter.and(new QFilter("sourcetype", "=", (Object)sourceTypeId));
        filter.and(new QFilter("source", "in", sourceIdList));
        String props = SWCHisBaseDataHelper.getSelectProperties((String)billFormId);
        if (SWCCostConstants.COST_TYPE_SALARYFILEITEM.equals(sourceTypeId)) {
            filter.and(new QFilter("creatorobj.id", "in", salaryFileIdList));
        }
        BaseDataHisHelper.addHisCurrFilter((QFilter)filter);
        QFilter[] filters = new QFilter[]{filter};
        SWCDataServiceHelper helper = new SWCDataServiceHelper(billFormId);
        DynamicObject[] costCfgQueryDys = helper.query(props, filters);
        HashMap<String, DynamicObject> keyAndCostCfgDyMap = new HashMap<String, DynamicObject>(costCfgQueryDys.length);
        for (DynamicObject costCfgQueryDy : costCfgQueryDys) {
            StringBuilder sb = new StringBuilder();
            long sourceId = costCfgQueryDy.getLong("source.id");
            if (SWCCostConstants.COST_TYPE_SALARYFILEITEM.equals(sourceTypeId)) {
                long creatorObjId = costCfgQueryDy.getLong("creatorobj.id");
                sb.append(sourceTypeId).append('_').append(costAdapterId).append('_').append(creatorObjId).append('_').append(sourceId);
            } else {
                String qualityNumber;
                if (SWCCostConstants.COST_TYPE_ITEM.equals(sourceTypeId) && SWCStringUtils.isNotEmpty((String)(qualityNumber = costCfgQueryDy.getString("qualitynumber")))) continue;
                sb.append(sourceTypeId).append('_').append(costAdapterId).append('_').append(sourceId);
            }
            keyAndCostCfgDyMap.put(sb.toString(), costCfgQueryDy);
        }
        return keyAndCostCfgDyMap;
    }

    public static boolean queryIsAllowedSplitById(Long id) {
        SWCDataServiceHelper serviceHelper = new SWCDataServiceHelper("lcs_costbizobj");
        QFilter idFilter = new QFilter("id", "=", (Object)id);
        DynamicObject queryResult = serviceHelper.queryOne("isallowedsplit", new QFilter[]{idFilter});
        return queryResult.getBoolean("isallowedsplit");
    }

    public static Map<String, Map<String, String>> initQueryDbNameAndTypeMap(String billFormId, Long costAdapterId) {
        HashMap<String, Map<String, String>> columnKeyAndQueryMap = new HashMap<String, Map<String, String>>(2);
        switch (billFormId) {
            case "pcs_costdeptcfg": {
                CostCfgImportHelper.setColKeyAndQueryMap(columnKeyAndQueryMap, "haos_adminorghr");
                break;
            }
            case "pcs_costitemcfg": {
                CostCfgImportHelper.setColKeyAndQueryMap(columnKeyAndQueryMap, "hsbs_salaryitem");
                break;
            }
            case "pcs_costempcfg": {
                CostCfgImportHelper.setColKeyAndQueryMap(columnKeyAndQueryMap, "hrpi_employee");
                break;
            }
            case "pcs_costpostcfg": {
                CostCfgImportHelper.setColKeyAndQueryMap(columnKeyAndQueryMap, "hbpm_positionhr");
                break;
            }
            case "pcs_costsalaryfilecfg": {
                CostCfgImportHelper.setColKeyAndQueryMap(columnKeyAndQueryMap, "hsas_salaryfile");
                break;
            }
            case "pcs_costsalaryitemcfg": {
                CostCfgImportHelper.setColKeyAndQueryMap(columnKeyAndQueryMap, "hsbs_salaryitem");
                CostCfgImportHelper.addSalaryFileItemQueryMap(columnKeyAndQueryMap);
                break;
            }
            case "pcs_costgroupcfg": {
                CostCfgImportHelper.setColKeyAndQueryMap(columnKeyAndQueryMap, "hsas_payrollgrp");
                break;
            }
            case "pcs_costjobcfg": {
                CostCfgImportHelper.setColKeyAndQueryMap(columnKeyAndQueryMap, "hbjm_jobhr");
                break;
            }
        }
        CostCfgImportHelper.initDyColumnQueryMap(costAdapterId, columnKeyAndQueryMap);
        return columnKeyAndQueryMap;
    }

    private static void addSalaryFileItemQueryMap(Map<String, Map<String, String>> columnKeyAndQueryMap) {
        HashMap<String, String> billNameAndQueryType = new HashMap<String, String>(1);
        billNameAndQueryType.put("hsas_salaryfile", "1");
        columnKeyAndQueryMap.put("salaryFileNumber", billNameAndQueryType);
    }

    private static void initDyColumnQueryMap(Long costAdapterId, Map<String, Map<String, String>> columnKeyAndQueryMap) {
        Long costStruId = CostCfgExportHelper.queryCostStruByAdapter(costAdapterId);
        DynamicObjectCollection costStruDimColl = CostCommonHelper.getCostStruDimById(costStruId);
        for (DynamicObject dimensionDy : costStruDimColl) {
            String importProperty = dimensionDy.getString("costdimension.importproperty");
            String queryDbType = "1".equals(importProperty) ? "1" : "0";
            HashMap<String, String> billNameAndQueryType = new HashMap<String, String>(1);
            String valueType = dimensionDy.getString("costdimension.valuetype");
            String storageSetNumber = dimensionDy.getString("storageset.number");
            if ("1".equals(valueType)) {
                String baseDataNumber = dimensionDy.getString("costdimension.valuesource.id");
                billNameAndQueryType.put(baseDataNumber, queryDbType);
                columnKeyAndQueryMap.put("segment" + storageSetNumber, billNameAndQueryType);
                continue;
            }
            if (!"2".equals(valueType)) continue;
            billNameAndQueryType.put("bos_assistantdata_detail", queryDbType);
            columnKeyAndQueryMap.put("segment" + storageSetNumber, billNameAndQueryType);
        }
    }

    private static void setColKeyAndQueryMap(Map<String, Map<String, String>> columnKeyAndQueryMap, String billFormId) {
        HashMap<String, String> billNameAndQueryType = new HashMap<String, String>(1);
        billNameAndQueryType.put("bos_org", "1");
        columnKeyAndQueryMap.put("orgNumber", billNameAndQueryType);
        HashMap<String, String> billNameAndQueryType2 = new HashMap<String, String>(1);
        billNameAndQueryType2.put(billFormId, "1");
        columnKeyAndQueryMap.put("costCfgNumber", billNameAndQueryType2);
    }

    public static String getShowDimNameByShowDim(DynamicObjectCollection needShowDimensionEntryColl) {
        ArrayList<String> dimNameList = new ArrayList<String>();
        for (DynamicObject dimensionDy : needShowDimensionEntryColl) {
            String costDimensionName = dimensionDy.getString("costdimension.name");
            dimNameList.add(costDimensionName);
        }
        return String.join((CharSequence)"\u3001", dimNameList);
    }
}

