/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.pcs.business.costcfg.dataimport.helper;

import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import org.apache.poi.ss.usermodel.BuiltinFormats;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;

public class CostCfgImportSheetHandler {
    protected static final Log logger = LogFactory.getLog(CostCfgImportSheetHandler.class);

    public static List<String> getExcelHeader(Sheet sheet) {
        ArrayList<String> headerList = new ArrayList<String>(10);
        if (sheet == null) {
            return headerList;
        }
        int num = 1;
        Row firstRow = sheet.getRow(num);
        if (null == firstRow) {
            return headerList;
        }
        int maxColumnNum = sheet.getRow(num).getPhysicalNumberOfCells();
        for (int j = 0; j < maxColumnNum; ++j) {
            Object cellData = CostCfgImportSheetHandler.getCellFormatValue(firstRow.getCell(j));
            headerList.add(String.valueOf(cellData));
        }
        return headerList;
    }

    public static Object getCellFormatValue(Cell cell) {
        Object cellValue;
        if (cell == null) {
            return "";
        }
        switch (cell.getCellType()) {
            case NUMERIC: {
                cellValue = CostCfgImportSheetHandler.stringDateProcess(cell);
                break;
            }
            case STRING: {
                cellValue = cell.getRichStringCellValue();
                break;
            }
            case FORMULA: {
                if (DateUtil.isCellDateFormatted((Cell)cell)) {
                    Date cellValueDate = cell.getDateCellValue();
                    cellValue = cellValueDate == null ? null : SWCDateTimeUtils.format((Date)cellValueDate, (String)"yyyy-MM-dd HH:mm:ss");
                    break;
                }
                cellValue = cell.getNumericCellValue();
                break;
            }
            case BLANK: {
                cellValue = null;
                break;
            }
            case BOOLEAN: {
                cellValue = cell.getBooleanCellValue();
                break;
            }
            default: {
                cellValue = "";
            }
        }
        return cellValue;
    }

    public static String stringDateProcess(Cell cell) {
        String result;
        if (DateUtil.isCellDateFormatted((Cell)cell)) {
            SimpleDateFormat sdf = cell.getCellStyle().getDataFormat() == (short)BuiltinFormats.getBuiltinFormat((String)"h:mm") ? new SimpleDateFormat("HH:mm") : new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            Date date = cell.getDateCellValue();
            Calendar cal = Calendar.getInstance();
            cal.setTime(date);
            sdf = CostCfgImportSheetHandler.getDateFormat(sdf, cal);
            result = sdf.format(date);
        } else if (cell.getCellStyle().getDataFormat() == 58) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            double value = cell.getNumericCellValue();
            Date date = DateUtil.getJavaDate((double)value);
            result = sdf.format(date);
        } else {
            double value = cell.getNumericCellValue();
            CellStyle style = cell.getCellStyle();
            DecimalFormat format = new DecimalFormat();
            String temp = style.getDataFormatString();
            if ("General".equals(temp)) {
                format.applyPattern("#");
            }
            result = format.format(value);
        }
        return result;
    }

    private static SimpleDateFormat getDateFormat(SimpleDateFormat sdf, Calendar cal) {
        int hour = cal.get(11);
        int minute = cal.get(12);
        int second = cal.get(13);
        if (hour == 0 && minute == 0 && second == 0) {
            sdf = new SimpleDateFormat("yyyy-MM-dd");
        }
        return sdf;
    }
}

