/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.pcs.business.costcfg.service;

import java.math.BigDecimal;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.util.CollectionUtils;
import kd.swc.hsbp.common.constants.SWCCostConstants;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCObjectUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.pcs.business.costcfg.CostCfgHelper;
import kd.swc.pcs.business.costcfg.CostCfgInterfaceHelper;
import kd.swc.pcs.business.costcommon.CostCommonHelper;
import kd.swc.pcs.business.vo.CostCfgInterfaceQueryInfo;
import org.apache.commons.collections.MapUtils;

public class CostCfgInterfaceValidatorService {
    private static List<String> MUST_INPUT_FIELDS = new ArrayList<String>(10);

    public List<Map<String, Object>> getCheckPassData(List<Map<String, Object>> data, CostCfgInterfaceQueryInfo queryInfo) {
        Long costStruId = queryInfo.getCostStruId();
        DynamicObjectCollection dimensionDyColl = new DynamicObjectCollection();
        if (!SWCObjectUtils.isEmpty((Object)costStruId)) {
            dimensionDyColl = CostCommonHelper.getCostStruDimById(costStruId);
        }
        Map<Long, Map<Long, DynamicObject>> sourceTypeAndCostIdDyMap = queryInfo.getSourceTypeAndCostIdDyMap();
        Map<Long, Set<String>> sourceTypeAndCostCfgAddKeyMap = queryInfo.getSourceTypeAndCostCfgAddKeyMap();
        Set<Long> costCfgExistsIds = queryInfo.getAllCostCfgExistIdSet();
        Map<Long, DynamicObject> orgMap = queryInfo.getOrgMap();
        Map<Long, DynamicObject> costAdapterMap = queryInfo.getCostAdapterMap();
        Map<Long, Map<Long, DynamicObject>> sourceTypeAndActualIdDyMap = queryInfo.getSourceTypeAndActualIdDyMap();
        Map<String, Long> costCfgExistKeyAndIdMap = queryInfo.getCostCfgExistKeyAndIdMap();
        HashSet<String> addCostCfgKeySet = new HashSet<String>(16);
        HashSet<Long> updateExistId = new HashSet<Long>(16);
        ArrayList<Map<String, Object>> successList = new ArrayList<Map<String, Object>>(data.size());
        Map<Long, Map<Long, DynamicObject>> entryDimDyColumnAndIdDyMap = queryInfo.getEntryDimDyColumnAndIdDyMap();
        for (Map<String, Object> record : data) {
            if (!this.validator(dimensionDyColl, addCostCfgKeySet, updateExistId, record, sourceTypeAndCostIdDyMap, sourceTypeAndCostCfgAddKeyMap, costCfgExistsIds, orgMap, costAdapterMap, sourceTypeAndActualIdDyMap, costCfgExistKeyAndIdMap, entryDimDyColumnAndIdDyMap)) continue;
            successList.add(record);
        }
        return successList;
    }

    private boolean validator(DynamicObjectCollection dimensionDyColl, Set<String> addCostCfgKeySet, Set<Long> updateExistId, Map<String, Object> record, Map<Long, Map<Long, DynamicObject>> sourceTypeAndCostIdDyMap, Map<Long, Set<String>> sourceTypeAndCostCfgAddKeyMap, Set<Long> costCfgExistsIds, Map<Long, DynamicObject> orgMap, Map<Long, DynamicObject> costAdapterMap, Map<Long, Map<Long, DynamicObject>> sourceTypeAndActualIdDyMap, Map<String, Long> costCfgExistKeyAndIdMap, Map<Long, Map<Long, DynamicObject>> entryDimDyColumnAndIdDyMap) {
        return this.checkMustInput(record) && this.checkValueLegal(record, orgMap, costAdapterMap, sourceTypeAndActualIdDyMap, entryDimDyColumnAndIdDyMap) && this.checkIsExist(addCostCfgKeySet, updateExistId, costCfgExistsIds, record, sourceTypeAndCostCfgAddKeyMap, sourceTypeAndCostIdDyMap, costCfgExistKeyAndIdMap) && this.validatorDyMustInputColumn(record, dimensionDyColl) && this.validatorCostCfgEntryType(record) && this.validatorDate(record) && this.validatorProportion(record);
    }

    private boolean checkIsExist(Set<String> addCostCfgKeySet, Set<Long> updateExistId, Set<Long> costCfgExistsIds, Map<String, Object> record, Map<Long, Set<String>> sourceTypeAndCostCfgAddKeyMap, Map<Long, Map<Long, DynamicObject>> sourceTypeAndCostIdDyMap, Map<String, Long> costCfgExistKeyAndIdMap) {
        Long costAdapterId = MapUtils.getLong(record, (Object)"costadapter");
        Long sourceTypeId = MapUtils.getLong(record, (Object)"sourcetype");
        String operateType = MapUtils.getString(record, (Object)"operate");
        Long sourceId = MapUtils.getLong(record, (Object)"source");
        Long orgId = MapUtils.getLong(record, (Object)"org");
        Long id = MapUtils.getLong(record, (Object)"id");
        boolean pkIdNonNull = id != null && id != 0L;
        String addCostCfgKey = "";
        String errorMessage = "";
        if ("1".equals(operateType)) {
            Set<String> costCfgAddKeySet = sourceTypeAndCostCfgAddKeyMap.get(sourceTypeId);
            boolean isExistDbFlag = false;
            addCostCfgKey = sourceTypeId + "_" + costAdapterId + "_" + sourceId;
            if (!CollectionUtils.isEmpty(costCfgAddKeySet) && costCfgAddKeySet.contains(addCostCfgKey)) {
                isExistDbFlag = true;
            }
            if (isExistDbFlag || addCostCfgKeySet.contains(addCostCfgKey)) {
                if (SWCCostConstants.COST_TYPE_DEPT.equals(sourceTypeId)) {
                    errorMessage = ResManager.loadKDString((String)"\u4eba\u529b\u6210\u672c\u7ef4\u5ea6\u65b9\u6848\u4e0b\u8be5\u7ec4\u7ec7\u5df2\u5b58\u5728\u91cd\u590d\u6570\u636e\uff0c\u65e0\u6cd5\u65b0\u589e\u3002", (String)"CostCfgInterfaceValidatorService_8", (String)"swc-pcs-business", (Object[])new Object[0]);
                } else if (SWCCostConstants.COST_TYPE_EMP.equals(sourceTypeId)) {
                    errorMessage = ResManager.loadKDString((String)"\u4eba\u529b\u6210\u672c\u7ef4\u5ea6\u65b9\u6848\u4e0b\u8be5\u4eba\u5458\u5df2\u5b58\u5728\u91cd\u590d\u6570\u636e\uff0c\u65e0\u6cd5\u65b0\u589e\u3002", (String)"CostCfgInterfaceValidatorService_18", (String)"swc-pcs-business", (Object[])new Object[0]);
                }
                this.addErrorMessage(record, errorMessage);
                return false;
            }
            if (pkIdNonNull && costCfgExistsIds.contains(id)) {
                errorMessage = ResManager.loadKDString((String)"\u4e3b\u952e\u5df2\u5b58\u5728\u3002", (String)"CostCfgInterfaceValidatorService_9", (String)"swc-pcs-business", (Object[])new Object[0]);
                this.addErrorMessage(record, errorMessage);
                return false;
            }
        } else if ("2".equals(operateType)) {
            if (!this.validatorUpdate(costAdapterId, sourceTypeId, sourceId, orgId, id, updateExistId, costCfgExistsIds, record, sourceTypeAndCostIdDyMap, costCfgExistKeyAndIdMap)) {
                return false;
            }
        } else {
            errorMessage = ResManager.loadKDString((String)"\u201c\u64cd\u4f5c\u7c7b\u578b\u201d\u4e0d\u6b63\u786e\u3002", (String)"CostCfgInterfaceValidatorService_11", (String)"swc-pcs-business", (Object[])new Object[0]);
            this.addErrorMessage(record, errorMessage);
            return false;
        }
        if ("1".equals(operateType)) {
            addCostCfgKeySet.add(addCostCfgKey);
            if (pkIdNonNull) {
                costCfgExistsIds.add(id);
            }
        }
        return true;
    }

    private boolean validatorUpdate(Long costAdapterId, Long sourceTypeId, Long sourceId, Long orgId, Long id, Set<Long> updateExistId, Set<Long> costCfgExistsIds, Map<String, Object> record, Map<Long, Map<Long, DynamicObject>> sourceTypeAndCostIdDyMap, Map<String, Long> costCfgExistKeyAndIdMap) {
        Map<Long, DynamicObject> costCfgIdDyMap;
        String errorMessage = "";
        if (SWCCostConstants.COST_TYPE_DEPT.equals(sourceTypeId)) {
            errorMessage = ResManager.loadKDString((String)"\u6839\u636e\u4eba\u529b\u6210\u672c\u7ef4\u5ea6\u65b9\u6848\u4e0e\u7ec4\u7ec7\u672a\u5339\u914d\u5230\u552f\u4e00\u4e00\u6761\u6570\u636e\u3002", (String)"CostCfgInterfaceValidatorService_24", (String)"swc-pcs-business", (Object[])new Object[0]);
        } else if (SWCCostConstants.COST_TYPE_EMP.equals(sourceTypeId)) {
            errorMessage = ResManager.loadKDString((String)"\u6839\u636e\u4eba\u529b\u6210\u672c\u7ef4\u5ea6\u65b9\u6848\u4e0e\u4eba\u5458\u672a\u5339\u914d\u5230\u552f\u4e00\u4e00\u6761\u6570\u636e\u3002", (String)"CostCfgInterfaceValidatorService_25", (String)"swc-pcs-business", (Object[])new Object[0]);
        }
        boolean pkIdNonNull = id != null && id != 0L;
        String existCostCfgKey = sourceTypeId + "_" + costAdapterId + "_" + sourceId;
        if (pkIdNonNull) {
            costCfgIdDyMap = sourceTypeAndCostIdDyMap.get(sourceTypeId);
            DynamicObject dynamicObject = costCfgIdDyMap.get(id);
            if (dynamicObject == null) {
                errorMessage = costCfgExistsIds.contains(id) ? ResManager.loadKDString((String)"\u201c\u6210\u672c\u5bf9\u8c61\u7c7b\u578b\u201d\u3001\u201c\u4eba\u529b\u6210\u672c\u7ef4\u5ea6\u65b9\u6848\u201d\u3001\u201c\u5bf9\u8c61\u201d\u5b57\u6bb5\u503c\u4e0e\u6839\u636e\u201c\u4e3b\u952eid\u201d\u83b7\u53d6\u6570\u636e\u4e0d\u4e00\u81f4\uff0c\u65e0\u6cd5\u4fee\u6539\u3002", (String)"CostCfgInterfaceValidatorService_38", (String)"swc-pcs-business", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u4e3b\u952eid\u4e0d\u5b58\u5728\u3002", (String)"CostCfgInterfaceValidatorService_39", (String)"swc-pcs-business", (Object[])new Object[0]);
                this.addErrorMessage(record, errorMessage);
                return false;
            }
        } else {
            id = costCfgExistKeyAndIdMap.get(existCostCfgKey);
            if (SWCObjectUtils.isEmpty((Object)id)) {
                this.addErrorMessage(record, errorMessage);
                return false;
            }
            record.put("id", id);
        }
        costCfgIdDyMap = sourceTypeAndCostIdDyMap.get(sourceTypeId);
        DynamicObject costCfgDy = costCfgIdDyMap.get(id);
        if (costCfgDy == null) {
            this.addErrorMessage(record, errorMessage);
            return false;
        }
        long dbCostAdapterId = costCfgDy.getLong("costadapter.id");
        long dbSourceId = costCfgDy.getLong("source.id");
        long dbSourceTypeId = costCfgDy.getLong("sourcetype.id");
        String dbExistCostCfgKey = dbSourceTypeId + "_" + dbCostAdapterId + "_" + dbSourceId;
        if (!SWCStringUtils.equals((String)dbExistCostCfgKey, (String)existCostCfgKey)) {
            errorMessage = ResManager.loadKDString((String)"\u201c\u6210\u672c\u5bf9\u8c61\u7c7b\u578b\u201d\u3001\u201c\u4eba\u529b\u6210\u672c\u7ef4\u5ea6\u65b9\u6848\u201d\u3001\u201c\u5bf9\u8c61\u201d\u5b57\u6bb5\u503c\u4e0e\u6839\u636e\u201c\u4e3b\u952eid\u201d\u83b7\u53d6\u6570\u636e\u4e0d\u4e00\u81f4\uff0c\u65e0\u6cd5\u4fee\u6539\u3002", (String)"CostCfgInterfaceValidatorService_38", (String)"swc-pcs-business", (Object[])new Object[0]);
            this.addErrorMessage(record, errorMessage);
            return false;
        }
        Long dbOrgId = costCfgDy.getLong("createorg.id");
        if (!dbOrgId.equals(orgId)) {
            errorMessage = ResManager.loadKDString((String)"\u4eba\u529b\u6210\u672c\u7ba1\u7406\u7ec4\u7ec7\u4e0d\u5141\u8bb8\u4fee\u6539\u3002", (String)"CostCfgInterfaceValidatorService_19", (String)"swc-pcs-business", (Object[])new Object[0]);
            this.addErrorMessage(record, errorMessage);
            return false;
        }
        if (updateExistId.contains(id)) {
            errorMessage = ResManager.loadKDString((String)"\u4eba\u529b\u6210\u672c\u7ef4\u5ea6\u65b9\u6848\u4e0b\u8be5\u7ec4\u7ec7\u5b58\u5728\u91cd\u590d\u6570\u636e\uff0c\u65e0\u6cd5\u66f4\u65b0\u3002", (String)"CostCfgInterfaceValidatorService_26", (String)"swc-pcs-business", (Object[])new Object[0]);
            this.addErrorMessage(record, errorMessage);
            return false;
        }
        updateExistId.add(id);
        return true;
    }

    private boolean checkMustInput(Map<String, Object> record) {
        Map<String, String> keyAndNameMap = this.getKeyAndNameMap();
        ArrayList<String> notPassFields = new ArrayList<String>(10);
        boolean isPass = true;
        for (String field : MUST_INPUT_FIELDS) {
            if (!SWCObjectUtils.isEmpty((Object)record.get(field))) continue;
            isPass = false;
            String fieldName = keyAndNameMap.get(field);
            notPassFields.add(fieldName);
        }
        if (!isPass) {
            String message = MessageFormat.format(ResManager.loadKDString((String)"\u201c{0}\u201d\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"CostCfgInterfaceValidatorService_2", (String)"swc-pcs-business", (Object[])new Object[0]), notPassFields.stream().collect(Collectors.joining("\u201d\u3001\u201c")));
            this.addErrorMessage(record, message);
        }
        return isPass;
    }

    private Map<String, String> getKeyAndNameMap() {
        HashMap<String, String> keyAndNameMap = new HashMap<String, String>(16);
        String operateName = ResManager.loadKDString((String)"\u64cd\u4f5c\u7c7b\u578b", (String)"CostCfgInterfaceValidatorService_32", (String)"swc-pcs-business", (Object[])new Object[0]);
        keyAndNameMap.put("operate", operateName);
        String sourceName = ResManager.loadKDString((String)"\u6210\u672c\u5bf9\u8c61\u6570\u636e\u6e90", (String)"CostCfgInterfaceValidatorService_33", (String)"swc-pcs-business", (Object[])new Object[0]);
        keyAndNameMap.put("source", sourceName);
        String sourceTypeName = ResManager.loadKDString((String)"\u6210\u672c\u5bf9\u8c61", (String)"CostCfgInterfaceValidatorService_34", (String)"swc-pcs-business", (Object[])new Object[0]);
        keyAndNameMap.put("sourcetype", sourceTypeName);
        String orgName = ResManager.loadKDString((String)"\u4eba\u529b\u6210\u672c\u7ba1\u7406\u7ec4\u7ec7", (String)"CostCfgInterfaceValidatorService_35", (String)"swc-pcs-business", (Object[])new Object[0]);
        keyAndNameMap.put("org", orgName);
        String costAdapterName = ResManager.loadKDString((String)"\u6210\u672c\u7ef4\u5ea6\u65b9\u6848", (String)"CostCfgInterfaceValidatorService_36", (String)"swc-pcs-business", (Object[])new Object[0]);
        keyAndNameMap.put("costadapter", costAdapterName);
        String bsedName = ResManager.loadKDString((String)"\u751f\u6548\u65e5\u671f", (String)"CostCfgInterfaceValidatorService_37", (String)"swc-pcs-business", (Object[])new Object[0]);
        keyAndNameMap.put("bsed", bsedName);
        return keyAndNameMap;
    }

    private boolean checkValueLegal(Map<String, Object> record, Map<Long, DynamicObject> orgMap, Map<Long, DynamicObject> costAdapterMap, Map<Long, Map<Long, DynamicObject>> sourceTypeAndActualIdDyMap, Map<Long, Map<Long, DynamicObject>> entryDimDyColumnAndIdDyMap) {
        Long orgId = MapUtils.getLong(record, (Object)"org");
        Long costAdapterId = MapUtils.getLong(record, (Object)"costadapter");
        Long sourceTypeId = MapUtils.getLong(record, (Object)"sourcetype");
        Long sourceId = MapUtils.getLong(record, (Object)"source");
        String idStr = MapUtils.getString(record, (Object)"id");
        String errorMessage = "";
        if (!SWCCostConstants.COST_TYPE_DEPT.equals(sourceTypeId) && !SWCCostConstants.COST_TYPE_EMP.equals(sourceTypeId)) {
            errorMessage = ResManager.loadKDString((String)"\u201c\u6210\u672c\u5bf9\u8c61\u201d\u5b57\u6bb5\u503c\u4e0d\u53ef\u7528\u3002", (String)"CostCfgInterfaceValidatorService_4", (String)"swc-pcs-business", (Object[])new Object[0]);
            this.addErrorMessage(record, errorMessage);
            return false;
        }
        if (!orgMap.containsKey(orgId)) {
            errorMessage = ResManager.loadKDString((String)"\u201c\u4eba\u529b\u6210\u672c\u7ba1\u7406\u7ec4\u7ec7\u201d\u5b57\u6bb5\u503c\u4e0d\u5b58\u5728\u3002", (String)"CostCfgInterfaceValidatorService_6", (String)"swc-pcs-business", (Object[])new Object[0]);
            this.addErrorMessage(record, errorMessage);
            return false;
        }
        if (!costAdapterMap.containsKey(costAdapterId)) {
            errorMessage = ResManager.loadKDString((String)"\u201c\u4eba\u529b\u6210\u672c\u7ef4\u5ea6\u65b9\u6848\u201d\u5b57\u6bb5\u503c\u4e0d\u5b58\u5728\u3002", (String)"CostCfgInterfaceValidatorService_7", (String)"swc-pcs-business", (Object[])new Object[0]);
            this.addErrorMessage(record, errorMessage);
            return false;
        }
        Map<Long, DynamicObject> sourceTypeDbMap = sourceTypeAndActualIdDyMap.get(sourceTypeId);
        if (this.sourceIsExist(sourceId, sourceTypeDbMap)) {
            errorMessage = ResManager.loadKDString((String)"\u201c\u6210\u672c\u5bf9\u8c61\u6570\u636e\u6e90\u201d\u5b57\u6bb5\u503c\u4e0d\u5b58\u5728\u3002", (String)"CostCfgInterfaceValidatorService_5", (String)"swc-pcs-business", (Object[])new Object[0]);
            this.addErrorMessage(record, errorMessage);
            return false;
        }
        boolean numberFlag = CostCommonHelper.isNumber(idStr);
        if (!numberFlag) {
            errorMessage = ResManager.loadKDString((String)"\u5165\u53c2\u201c\u4e3b\u952eid\u201d\u683c\u5f0f\u9519\u8bef\uff0c\u8bf7\u8f93\u5165\u957f\u6574\u578b\u3002", (String)"CostCfgInterfaceValidatorService_27", (String)"swc-pcs-business", (Object[])new Object[0]);
            this.addErrorMessage(record, errorMessage);
            return false;
        }
        if (SWCStringUtils.isNotEmpty((String)idStr) && idStr.length() > 19) {
            errorMessage = ResManager.loadKDString((String)"\u201c\u4e3b\u952eid\u201d\u5b57\u6bb5\u957f\u5ea6\u8d85\u8fc7\u4e0a\u9650\uff0c\u8bf7\u8c03\u6574\u3002", (String)"CostCfgInterfaceValidatorService_30", (String)"swc-pcs-business", (Object[])new Object[0]);
            this.addErrorMessage(record, errorMessage);
            return false;
        }
        return this.checkEntryColumnDy(record, entryDimDyColumnAndIdDyMap) && this.checkEntryTypeColumnDy(record, entryDimDyColumnAndIdDyMap);
    }

    private boolean checkEntryColumnDy(Map<String, Object> record, Map<Long, Map<Long, DynamicObject>> entryDimDyColumnAndIdDyMap) {
        List<Map<String, Object>> costCfgEntryList = CostCfgInterfaceHelper.getCostCfgEntryList(record);
        if (CollectionUtils.isEmpty(costCfgEntryList)) {
            return true;
        }
        for (Map<String, Object> costCfgEntryMap : costCfgEntryList) {
            Map<String, Object> costStruCfgValue = CostCfgInterfaceHelper.getCostStruCfgValue(costCfgEntryMap);
            if (this.checkEntryDyIsExist("1", costStruCfgValue, record, entryDimDyColumnAndIdDyMap)) continue;
            return false;
        }
        return true;
    }

    private boolean checkEntryTypeColumnDy(Map<String, Object> record, Map<Long, Map<Long, DynamicObject>> entryDimDyColumnAndIdDyMap) {
        Long sourceTypeId = MapUtils.getLong(record, (Object)"sourcetype");
        if (SWCCostConstants.COST_TYPE_DEPT.equals(sourceTypeId)) {
            List<Map<String, Object>> costCfgEntryList = CostCfgInterfaceHelper.getCostCfgTypeEntryList(record);
            if (CollectionUtils.isEmpty(costCfgEntryList)) {
                return true;
            }
            for (Map<String, Object> costCfgEntryMap : costCfgEntryList) {
                Map<String, Object> costStruCfgValue = CostCfgInterfaceHelper.getCostStruTypeCfgValue(costCfgEntryMap);
                if (this.checkEntryDyIsExist("2", costStruCfgValue, record, entryDimDyColumnAndIdDyMap)) continue;
                return false;
            }
        }
        return true;
    }

    private boolean checkEntryDyIsExist(String type, Map<String, Object> costStruCfgValue, Map<String, Object> record, Map<Long, Map<Long, DynamicObject>> entryDimDyColumnAndIdDyMap) {
        if (costStruCfgValue != null && costStruCfgValue.size() > 0) {
            for (Map.Entry<String, Object> next : costStruCfgValue.entrySet()) {
                String dimId = next.getKey();
                Object valueObj = next.getValue();
                if (valueObj == null) continue;
                String errorMessage = "1".equals(type) ? ResManager.loadKDString((String)"\u201c\u6210\u672c\u7ef4\u5ea6\u7ec4\u5408\u503c\u201d\u5b57\u6bb5\u503c\u201c{0}\u201d\u4e0d\u5b58\u5728\u3002", (String)"CostCfgInterfaceValidatorService_28", (String)"swc-pcs-business", (Object[])new Object[]{valueObj}) : ResManager.loadKDString((String)"\u201c\u515c\u5e95\u6210\u672c\u7ef4\u5ea6\u7ec4\u5408\u503c\u201d\u5b57\u6bb5\u503c\u201c{0}\u201d\u4e0d\u5b58\u5728\u3002", (String)"CostCfgInterfaceValidatorService_29", (String)"swc-pcs-business", (Object[])new Object[]{valueObj});
                String valueStr = String.valueOf(valueObj);
                Map<Long, DynamicObject> entryDimIdAndDyMap = entryDimDyColumnAndIdDyMap.get(Long.valueOf(dimId));
                if (!CollectionUtils.isEmpty(entryDimIdAndDyMap)) {
                    DynamicObject dynamicObject = entryDimIdAndDyMap.get(Long.valueOf(valueStr));
                    if (dynamicObject != null) continue;
                    this.addErrorMessage(record, errorMessage);
                    return false;
                }
                if (!SWCStringUtils.isNotEmpty((String)valueStr)) continue;
                this.addErrorMessage(record, errorMessage);
                return false;
            }
        } else {
            Long sourceTypeId = MapUtils.getLong(record, (Object)"sourcetype");
            if (SWCCostConstants.COST_TYPE_EMP.equals(sourceTypeId)) {
                String errorMessage = ResManager.loadKDString((String)"\u201c\u6210\u672c\u7ef4\u5ea6\u7ec4\u5408\u503c\u201d\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"CostCfgInterfaceValidatorService_31", (String)"swc-pcs-business", (Object[])new Object[0]);
                this.addErrorMessage(record, errorMessage);
                return false;
            }
        }
        return true;
    }

    private boolean sourceIsExist(Long sourceId, Map<Long, DynamicObject> sourceTypeDbMap) {
        return CollectionUtils.isEmpty(sourceTypeDbMap) || !CollectionUtils.isEmpty(sourceTypeDbMap) && !sourceTypeDbMap.containsKey(sourceId);
    }

    private boolean validatorDyMustInputColumn(Map<String, Object> record, DynamicObjectCollection dimensionDyColl) {
        List<Map<String, Object>> entryList = CostCfgInterfaceHelper.getCostCfgEntryList(record);
        Long sourceTypeId = MapUtils.getLong(record, (Object)"sourcetype");
        DynamicObjectCollection needShowDimensionColl = CostCfgHelper.getNeedShowDimensionColl(sourceTypeId, "COST", dimensionDyColl);
        if (SWCCostConstants.COST_TYPE_EMP.equals(sourceTypeId)) {
            if (CollectionUtils.isEmpty((Collection)needShowDimensionColl)) {
                String errorMessage = ResManager.loadKDString((String)"\u6ca1\u6709\u53ef\u7ef4\u62a4\u7684\u7ef4\u5ea6\u3002", (String)"CostCfgInterfaceValidatorService_22", (String)"swc-pcs-business", (Object[])new Object[0]);
                this.addErrorMessage(record, errorMessage);
                return false;
            }
        } else if (SWCCostConstants.COST_TYPE_DEPT.equals(sourceTypeId) && CollectionUtils.isEmpty((Collection)needShowDimensionColl) && !CollectionUtils.isEmpty(entryList)) {
            String errorMessage = ResManager.loadKDString((String)"\u6ca1\u6709\u53ef\u7ef4\u62a4\u7684\u7ef4\u5ea6\u3002", (String)"CostCfgInterfaceValidatorService_22", (String)"swc-pcs-business", (Object[])new Object[0]);
            this.addErrorMessage(record, errorMessage);
            return false;
        }
        for (Map<String, Object> entryMap : entryList) {
            Map<String, Object> costStruCfgValue = CostCfgInterfaceHelper.getCostStruCfgValue(entryMap);
            boolean isFillValueFlag = false;
            for (DynamicObject needShowDimensionDy : needShowDimensionColl) {
                long dimId = needShowDimensionDy.getLong("costdimension.id");
                Object dimValueObj = costStruCfgValue.get(String.valueOf(dimId));
                if (SWCObjectUtils.isEmpty((Object)dimValueObj)) continue;
                isFillValueFlag = true;
                break;
            }
            if (isFillValueFlag) continue;
            String errorMessage = ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u586b\u5199\u4e00\u4e2a\u4eba\u529b\u6210\u672c\u7ef4\u5ea6\u503c\u3002", (String)"CostCfgInterfaceValidatorService_23", (String)"swc-pcs-business", (Object[])new Object[0]);
            this.addErrorMessage(record, errorMessage);
            return false;
        }
        if (SWCCostConstants.COST_TYPE_DEPT.equals(sourceTypeId)) {
            DynamicObjectCollection needShowDimensionTypeColl = CostCfgHelper.getNeedShowDimensionColl(sourceTypeId, "PRIORITY", dimensionDyColl);
            ArrayList<Long> requiredInputDimIdList = new ArrayList<Long>(10);
            for (DynamicObject dimensionDy : needShowDimensionTypeColl) {
                boolean isRequired = dimensionDy.getBoolean("isrequired");
                long dimId = dimensionDy.getLong("costdimension.id");
                if (!isRequired) continue;
                requiredInputDimIdList.add(dimId);
            }
            if (CollectionUtils.isEmpty(requiredInputDimIdList)) {
                return true;
            }
            List<Map<String, Object>> costCfgTypeEntryList = CostCfgInterfaceHelper.getCostCfgTypeEntryList(record);
            for (Map<String, Object> entryMap : costCfgTypeEntryList) {
                Map<String, Object> costStruCfgValue = CostCfgInterfaceHelper.getCostStruTypeCfgValue(entryMap);
                for (Long dimId : requiredInputDimIdList) {
                    String dimIdStr = String.valueOf(dimId);
                    Object dimValueObj = costStruCfgValue.get(dimIdStr);
                    if (!SWCObjectUtils.isEmpty((Object)dimValueObj)) continue;
                    String errorMessage = ResManager.loadKDString((String)"\u7ef4\u5ea6\u201c{0}\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"CostCfgInterfaceValidatorService_12", (String)"swc-pcs-business", (Object[])new Object[]{dimIdStr});
                    this.addErrorMessage(record, errorMessage);
                    return false;
                }
            }
        }
        return true;
    }

    private boolean validatorCostCfgEntryType(Map<String, Object> record) {
        List<Map<String, Object>> costCfgEntryList;
        Long sourceType = MapUtils.getLong(record, (Object)"sourcetype");
        if (SWCCostConstants.COST_TYPE_EMP.equals(sourceType) && CollectionUtils.isEmpty(costCfgEntryList = CostCfgInterfaceHelper.getCostCfgEntryList(record))) {
            String errorMessage = ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u6210\u672c\u8bbe\u7f6e\u3002", (String)"CostCfgInterfaceValidatorService_21", (String)"swc-pcs-business", (Object[])new Object[0]);
            this.addErrorMessage(record, errorMessage);
            return false;
        }
        return true;
    }

    private boolean validatorDate(Map<String, Object> record) {
        Object bsedObj = MapUtils.getObject(record, (Object)"bsed");
        if (!(bsedObj instanceof Date) && !(bsedObj instanceof Long)) {
            String errorMessage = ResManager.loadKDString((String)"\u751f\u6548\u65e5\u671f\u683c\u5f0f\u4e3ayyyy-mm-dd\uff0c\u8bf7\u786e\u8ba4\u8c03\u6574\u3002", (String)"CostCfgInterfaceValidatorService_14", (String)"swc-pcs-business", (Object[])new Object[0]);
            if (bsedObj instanceof String) {
                String bsedStr = String.valueOf(bsedObj);
                try {
                    SWCDateTimeUtils.parseDate((String)bsedStr, (String)"yyyy-MM-dd");
                }
                catch (ParseException e) {
                    this.addErrorMessage(record, errorMessage);
                    return false;
                }
            } else {
                this.addErrorMessage(record, errorMessage);
                return false;
            }
        }
        return true;
    }

    private boolean validatorProportion(Map<String, Object> record) {
        List<Map<String, Object>> entryList = CostCfgInterfaceHelper.getCostCfgEntryList(record);
        for (Map<String, Object> entryMap : entryList) {
            try {
                BigDecimal proportion;
                Object proportionObj = entryMap.get("calcostproportion");
                if (proportionObj == null) {
                    String message = ResManager.loadKDString((String)"\u201c\u6210\u672c\u8bbe\u7f6e\u767e\u5206\u6bd4\u201d\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"CostCfgInterfaceValidatorService_20", (String)"swc-pcs-business", (Object[])new Object[0]);
                    this.addErrorMessage(record, message);
                    return false;
                }
                String proportionStr = String.valueOf(proportionObj);
                String result = CostCommonHelper.numberRemoveZero(proportionStr);
                if (result.contains(".")) {
                    int length = result.length();
                    String substring = result.substring(result.indexOf(46) + 1, length);
                    if (substring.length() > 2) {
                        String errorMessage = ResManager.loadKDString((String)"\u767e\u5206\u6bd4\u4ec5\u652f\u6301\u8f93\u51652\u4f4d\u5c0f\u6570\u3002", (String)"CostCfgInterfaceValidatorService_42", (String)"swc-pcs-business", (Object[])new Object[0]);
                        this.addErrorMessage(record, errorMessage);
                        return false;
                    }
                }
                if ((proportion = new BigDecimal(String.valueOf(proportionObj))).compareTo(BigDecimal.ZERO) > 0 && proportion.compareTo(new BigDecimal(100)) <= 0) continue;
                String errorMessage = ResManager.loadKDString((String)"\u767e\u5206\u6bd4\u8d85\u51fa\u6570\u503c\u8303\u56f4(0,100]\u3002", (String)"CostCfgInterfaceValidatorService_41", (String)"swc-pcs-business", (Object[])new Object[0]);
                this.addErrorMessage(record, errorMessage);
                return false;
            }
            catch (Exception e) {
                String errorMessage = ResManager.loadKDString((String)"\u767e\u5206\u6bd4\u53ea\u80fd\u8f93\u51652\u4f4d\u5c0f\u6570\u7684\u6570\u503c\u3002", (String)"CostCfgInterfaceValidatorService_40", (String)"swc-pcs-business", (Object[])new Object[0]);
                this.addErrorMessage(record, errorMessage);
                return false;
            }
        }
        return true;
    }

    private void addErrorMessage(Map<String, Object> record, String message) {
        record.put("success", Boolean.FALSE);
        record.put("message", message);
    }

    static {
        MUST_INPUT_FIELDS.add("operate");
        MUST_INPUT_FIELDS.add("source");
        MUST_INPUT_FIELDS.add("sourcetype");
        MUST_INPUT_FIELDS.add("org");
        MUST_INPUT_FIELDS.add("costadapter");
        MUST_INPUT_FIELDS.add("bsed");
    }
}

