/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.pcs.business.costcfg.strategy.impl;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicComplexProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicSimpleProperty;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.LongProp;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.businessfield.BasedataField;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.form.control.FieldAp;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.pcs.business.costcfg.CostCfgHelper;
import kd.swc.pcs.business.costcfg.strategy.CreateFieldApStrategy;
import kd.swc.pcs.business.costcfg.strategy.constants.StrategyConstants;

public class BaseDataCreateFieldApStrategyImpl
implements CreateFieldApStrategy {
    private static final String PREFIX_ID = "_id";
    private static final String KEY_PREFIX = "basedata";

    @Override
    public FieldAp createField(EntityMetadata entityMetadata, DynamicObject dimensionObj) {
        String dimensionName = dimensionObj.getString("name");
        String dimensionId = dimensionObj.getString("id");
        String displayProp = dimensionObj.getString("displayproperty");
        FieldAp fieldAp = CostCfgHelper.createFieldAp(dimensionName, KEY_PREFIX + dimensionId);
        BasedataField basedataField = new BasedataField();
        String dentityId = CostCfgHelper.getDentityId(dimensionObj);
        if (SWCStringUtils.isEmpty((String)dentityId)) {
            return null;
        }
        basedataField.setBaseEntityId(dentityId);
        basedataField.setEntityMetadata(entityMetadata);
        if (!SWCStringUtils.isEmpty((String)displayProp)) {
            basedataField.setDisplayProp(StrategyConstants.getDisplayPropMap().get(displayProp));
        }
        basedataField.setKey(fieldAp.getKey());
        fieldAp.setField((Field)basedataField);
        return fieldAp;
    }

    @Override
    public void createPro(DynamicObject dimensionObj, MainEntityType newMainType) {
        String dimensionId = dimensionObj.getString("id");
        String dimensionName = dimensionObj.getString("name");
        String number = CostCfgHelper.getFormNumber(dimensionObj);
        if (SWCStringUtils.isEmpty((String)number)) {
            return;
        }
        String propName = KEY_PREFIX + dimensionId;
        LongProp refProp = new LongProp(true);
        refProp.setName(propName + PREFIX_ID);
        refProp.setDbIgnore(true);
        newMainType.registerSimpleProperty((DynamicSimpleProperty)refProp);
        BasedataProp basedataProp = new BasedataProp();
        basedataProp.setName(KEY_PREFIX + dimensionId);
        basedataProp.setDisplayName(new LocaleString(dimensionName));
        basedataProp.setBaseEntityId(number);
        basedataProp.setRefIdProp((IDataEntityProperty)refProp);
        basedataProp.setRefIdPropName(propName + PREFIX_ID);
        basedataProp.setDbIgnore(true);
        basedataProp.setAlias("");
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)number);
        basedataProp.setComplexType((IDataEntityType)dataEntityType);
        newMainType.registerComplexProperty((DynamicComplexProperty)basedataProp);
    }
}

