/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.pcs.business.costcommon;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.fileservice.FileItem;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.bill.BillView;
import kd.bos.mvc.list.ListView;
import kd.bos.url.UrlService;
import kd.bos.util.FileNameUtils;
import kd.swc.hsbp.business.url.SWCURLHelper;
import kd.swc.hsbp.common.cache.SWCPageCache;
import kd.swc.hsbp.common.util.SWCDateTimeUtils;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.pcs.business.costcfg.CostCfgExportHelper;
import kd.swc.pcs.business.costcfg.CostCfgHelper;
import kd.swc.pcs.business.costcfg.dataimport.helper.CostCfgImportHelper;
import kd.swc.pcs.business.costcfg.dataimport.strategy.CostCfgImportStrategy;
import kd.swc.pcs.business.costcommon.CostCommonHelper;
import kd.swc.pcs.common.constants.CostAllotBillConstants;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.DataFormat;
import org.apache.poi.ss.usermodel.DataValidation;
import org.apache.poi.ss.usermodel.DataValidationConstraint;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.CellRangeAddressList;
import org.apache.poi.xssf.streaming.SXSSFCell;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFDataValidation;

public class CostExportCommonHelper {
    private static Log logger = LogFactory.getLog(CostExportCommonHelper.class);
    private static final String TEXT = "text";
    private static final String NUM = "num";
    private static final String AMOUNT = "amount";
    private static final String DATE = "date";
    private static final String EXCEL_SUFFIX = ".xlsx";
    private static final String FILE_NAME_SUFFIX = ".zip";

    public static void write2ExportHead(SXSSFSheet sheet, Map<String, String> headData) {
        List<Map<String, String>> headList = CostExportCommonHelper.headMapToListMap(headData);
        CostExportCommonHelper.setColumnWidth(sheet, headList);
        CostExportCommonHelper.createHeadColumn(sheet.getWorkbook(), sheet, headList, 0);
    }

    public static void write2ExportCostCfgHead(SXSSFSheet sheet, Map<String, String> headData, String billFormId, long costAdaptionId) {
        List<Map<String, String>> headList = CostExportCommonHelper.headMapToListMap(headData);
        CostExportCommonHelper.setColumnWidth(sheet, headList);
        CostExportCommonHelper.createColumnTips(sheet.getWorkbook(), sheet, 0, billFormId, costAdaptionId);
        CostExportCommonHelper.createHeadColumn(sheet.getWorkbook(), sheet, headList, 1);
    }

    private static void setColumnWidth(SXSSFSheet sheet, List<Map<String, String>> headList) {
        for (int i = 0; i < headList.size(); ++i) {
            int columnWidth = sheet.getColumnWidth(i);
            sheet.setColumnWidth(i, columnWidth * 4);
        }
    }

    public static void createColumnTips(SXSSFWorkbook wb, SXSSFSheet sheet, int tipsRow, String billFormId, long costAdaptionId) {
        SXSSFRow headRow = sheet.createRow(tipsRow);
        int bsedTipsIndex = 3;
        String bsedTips = ResManager.loadKDString((String)"\u65e5\u671f\u683c\u5f0f\u4e3ayyyy-mm-dd", (String)"CostExportCommonHelper_20", (String)"swc-pcs-business", (Object[])new Object[0]);
        CostExportCommonHelper.setBsedTips(wb, headRow, bsedTipsIndex, bsedTips);
        Long costStruId = CostCfgExportHelper.queryCostStruByAdapter(costAdaptionId);
        DynamicObjectCollection dimensionEntryColl = CostCommonHelper.getCostStruDimById(costStruId);
        Long costTypeId = CostCommonHelper.getCostCfgTypeIdByFormId(billFormId);
        DynamicObjectCollection needShowDimensionEntryColl = CostCfgHelper.getNeedShowDimensionColl(costTypeId, "COST", dimensionEntryColl);
        String showDimName = CostCfgImportHelper.getShowDimNameByShowDim(needShowDimensionEntryColl);
        DynamicObjectCollection mustInputDimensionEntryColl = CostExportCommonHelper.getMustInputDim(dimensionEntryColl);
        String mustInputDimName = CostExportCommonHelper.getMustInputDimName(mustInputDimensionEntryColl);
        int costCfgTypeIndex = 4;
        if ("pcs_costitemcfg".equals(billFormId)) {
            String costCfgTypeTips = SWCStringUtils.isEmpty((String)showDimName) ? ResManager.loadKDString((String)"\u4ec5\u53ef\u8fdb\u884c\u4f18\u5148\u6210\u672c\u8bbe\u7f6e\uff0c\u53ef\u7ef4\u62a4\u6240\u6709\u6838\u7b97\u7ef4\u5ea6\u3002", (String)"CostExportCommonHelper_16", (String)"swc-pcs-business", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u5f53\u8fdb\u884c\u85aa\u916c\u9879\u76ee\u6210\u672c\u8bbe\u7f6e\u65f6\uff0c\u53ef\u7ef4\u62a4{0}\u3002\u5f53\u8fdb\u884c\u4f18\u5148\u6210\u672c\u8bbe\u7f6e\u65f6\uff0c\u53ef\u7ef4\u62a4\u6240\u6709\u6838\u7b97\u7ef4\u5ea6\u3002", (String)"CostExportCommonHelper_17", (String)"swc-pcs-business", (Object[])new Object[]{showDimName});
            costCfgTypeTips = CostExportCommonHelper.getCostCfgTips(mustInputDimName, costCfgTypeTips);
            CostExportCommonHelper.setCostCfgTypeTips(wb, headRow, costCfgTypeIndex, costCfgTypeTips);
        } else if ("pcs_costdeptcfg".equals(billFormId)) {
            String costCfgTypeTips = SWCStringUtils.isEmpty((String)showDimName) ? ResManager.loadKDString((String)"\u4ec5\u53ef\u8fdb\u884c\u515c\u5e95\u6210\u672c\u8bbe\u7f6e\uff0c\u53ef\u7ef4\u62a4\u6240\u6709\u6838\u7b97\u7ef4\u5ea6\u3002", (String)"CostExportCommonHelper_18", (String)"swc-pcs-business", (Object[])new Object[]{mustInputDimName}) : ResManager.loadKDString((String)"\u5f53\u8fdb\u884c\u7ec4\u7ec7\u85aa\u916c\u6210\u672c\u8bbe\u7f6e\u65f6\uff0c\u53ef\u7ef4\u62a4{0}\u3002\u5f53\u8fdb\u884c\u515c\u5e95\u6210\u672c\u8bbe\u7f6e\u65f6\uff0c\u53ef\u7ef4\u62a4\u6240\u6709\u6838\u7b97\u7ef4\u5ea6\u3002", (String)"CostExportCommonHelper_19", (String)"swc-pcs-business", (Object[])new Object[]{showDimName, mustInputDimName});
            costCfgTypeTips = CostExportCommonHelper.getCostCfgTips(mustInputDimName, costCfgTypeTips);
            CostExportCommonHelper.setCostCfgTypeTips(wb, headRow, costCfgTypeIndex, costCfgTypeTips);
        }
    }

    private static String getCostCfgTips(String mustInputDimName, String costCfgTypeTips) {
        if (SWCStringUtils.isNotEmpty((String)mustInputDimName)) {
            costCfgTypeTips = costCfgTypeTips.substring(0, costCfgTypeTips.length() - 1);
            String mustInputMessage = ResManager.loadKDString((String)"{0}{1}\u5fc5\u586b\u3002", (String)"CostExportCommonHelper_21", (String)"swc-pcs-business", (Object[])new Object[]{"\uff0c", mustInputDimName});
            costCfgTypeTips = costCfgTypeTips + mustInputMessage;
        }
        return costCfgTypeTips;
    }

    private static DynamicObjectCollection getMustInputDim(DynamicObjectCollection dimensionEntryColl) {
        DynamicObjectCollection needShowDimensionEntryColl = new DynamicObjectCollection();
        for (DynamicObject dimensionDy : dimensionEntryColl) {
            boolean isRequired = dimensionDy.getBoolean("isrequired");
            if (!isRequired) continue;
            needShowDimensionEntryColl.add((Object)dimensionDy);
        }
        return needShowDimensionEntryColl;
    }

    private static String getMustInputDimName(DynamicObjectCollection needShowDimensionEntryColl) {
        ArrayList<String> mustInputDimNameList = new ArrayList<String>();
        for (DynamicObject dimensionDy : needShowDimensionEntryColl) {
            String costDimensionName = dimensionDy.getString("costdimension.name");
            boolean isRequired = dimensionDy.getBoolean("isrequired");
            if (!isRequired) continue;
            mustInputDimNameList.add(costDimensionName);
        }
        return String.join((CharSequence)"\u3001", mustInputDimNameList);
    }

    private static void setBsedTips(SXSSFWorkbook wb, SXSSFRow headRow, int bsedTipsIndex, String tipsValue) {
        Font font = wb.createFont();
        font.setColor((short)10);
        CellStyle style = CostExportCommonHelper.getDefaultCellStyle(TEXT, wb);
        style.setFont(font);
        SXSSFCell dateCell = headRow.createCell(bsedTipsIndex);
        dateCell.setCellValue(tipsValue);
        dateCell.setCellStyle(style);
    }

    private static void setCostCfgTypeTips(SXSSFWorkbook wb, SXSSFRow headRow, int bsedTipsIndex, String tipsValue) {
        Font font = wb.createFont();
        font.setColor((short)10);
        CellStyle style = CostExportCommonHelper.getStringLeftCellStyle(wb);
        style.setFont(font);
        SXSSFCell dateCell = headRow.createCell(bsedTipsIndex);
        dateCell.setCellValue(tipsValue);
        dateCell.setCellStyle(style);
    }

    public static void write2ExportContent(SXSSFSheet sheet, Integer beginIndex, List<Map<String, Object>> exportDataList, Map<String, String> headData) {
        List<Map<String, String>> headList = CostExportCommonHelper.headMapToListMap(headData);
        CostExportCommonHelper.createContentColumn(sheet.getWorkbook(), sheet, beginIndex, exportDataList, headList);
    }

    public static void createValidation(SXSSFSheet sheet, Integer beginIndex, List<Map<String, String>> headList, String billFormId) {
        Map<String, String> costTypeNameByFormIdMap = CostExportCommonHelper.getCostTypeNameMapByFormId(billFormId);
        ArrayList<String> entryPullDownList = new ArrayList<String>(costTypeNameByFormIdMap.keySet());
        String[] entryOption = new String[entryPullDownList.size()];
        for (int i = 0; i < entryPullDownList.size(); ++i) {
            entryOption[i] = (String)entryPullDownList.get(i);
        }
        CellRangeAddressList costEntryCellList = new CellRangeAddressList();
        for (int rowIndex = beginIndex.intValue(); rowIndex < 200 + beginIndex; ++rowIndex) {
            for (int columnIndex = 0; columnIndex < headList.size(); ++columnIndex) {
                String key = headList.get(columnIndex).get("key");
                if (!"costCfgType".equals(key)) continue;
                CostExportCommonHelper.addValidationList(sheet, entryOption, costEntryCellList, rowIndex, columnIndex);
            }
        }
    }

    private static void addValidationList(SXSSFSheet sheet, String[] entryOption, CellRangeAddressList allowEntryModifyCellList, int rowIndex, int columnIndex) {
        CellRangeAddress region = new CellRangeAddress(rowIndex, rowIndex, columnIndex, columnIndex);
        allowEntryModifyCellList.addCellRangeAddress(region);
        ArrayList<Map<String, Object>> validationList = new ArrayList<Map<String, Object>>(10);
        HashMap<String, Object> validationMap = new HashMap<String, Object>(16);
        validationMap.put("option", entryOption);
        validationMap.put("celllist", allowEntryModifyCellList);
        validationMap.put("tips", "");
        validationList.add(validationMap);
        CostExportCommonHelper.addValidation(sheet, validationList);
    }

    public static List<Map<String, String>> headMapToListMap(Map<String, String> headData) {
        LinkedList<Map<String, String>> list = new LinkedList<Map<String, String>>();
        for (Map.Entry<String, String> entry : headData.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            if ("id".equals(key)) continue;
            HashMap<String, String> temp = new HashMap<String, String>(2);
            temp.put("key", key);
            temp.put("value", value);
            list.add(temp);
        }
        return list;
    }

    private static String getCellStyleKey(String dataType) {
        StringBuilder keyBuilder = new StringBuilder();
        keyBuilder.append(dataType);
        keyBuilder.append('#');
        keyBuilder.append(0);
        keyBuilder.append('#');
        keyBuilder.append(dataType);
        return keyBuilder.toString();
    }

    private static void parseCellValue(SXSSFCell cell, Object value, String dataType) throws ParseException {
        if (SWCStringUtils.equals((String)dataType, (String)TEXT)) {
            cell.setCellValue(value.toString());
        } else if (SWCStringUtils.equals((String)dataType, (String)DATE)) {
            String fmt = "yyyy-MM-dd";
            if (value instanceof Date) {
                String dateStr = SWCDateTimeUtils.format((Date)((Date)value), (String)fmt);
                cell.setCellValue(dateStr);
            } else if (value instanceof Number) {
                long dataLong = Long.parseLong(value.toString());
                Date dateValue = new Date(dataLong);
                String dateStr = SWCDateTimeUtils.format((Date)dateValue, (String)fmt);
                cell.setCellValue(dateStr);
            } else if (value instanceof String) {
                String valueStr = (String)value;
                cell.setCellValue(valueStr);
            } else {
                cell.setCellValue(value.toString());
            }
        } else if (SWCStringUtils.equals((String)dataType, (String)NUM) || SWCStringUtils.equals((String)dataType, (String)AMOUNT)) {
            cell.setCellValue(Double.parseDouble(value.toString()));
        } else {
            cell.setCellValue(String.valueOf(value));
        }
    }

    public static CellType getCellType(String dataType) {
        if (SWCStringUtils.isEmpty((String)dataType)) {
            return CellType.STRING;
        }
        if (SWCStringUtils.equals((String)dataType, (String)NUM)) {
            return CellType.NUMERIC;
        }
        if (SWCStringUtils.equals((String)dataType, (String)DATE)) {
            return CellType.STRING;
        }
        if (SWCStringUtils.equals((String)dataType, (String)AMOUNT)) {
            return CellType.NUMERIC;
        }
        return CellType.STRING;
    }

    private static void getDateCellStyle(SXSSFWorkbook wb, CellStyle cellStyle) {
        cellStyle.setAlignment(HorizontalAlignment.CENTER);
        cellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        DataFormat format = wb.createDataFormat();
        String styleStr = "yyyy-MM-dd";
        cellStyle.setDataFormat(format.getFormat(styleStr));
    }

    private static void getStringCellStyle(SXSSFWorkbook wb, CellStyle cellStyle) {
        cellStyle.setAlignment(HorizontalAlignment.CENTER);
        cellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        DataFormat format = wb.createDataFormat();
        String styleStr = "@";
        cellStyle.setDataFormat(format.getFormat(styleStr));
    }

    private static CellStyle getStringLeftCellStyle(SXSSFWorkbook wb) {
        CellStyle cellStyle = wb.createCellStyle();
        cellStyle.setAlignment(HorizontalAlignment.LEFT);
        cellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        DataFormat format = wb.createDataFormat();
        String styleStr = "@";
        cellStyle.setDataFormat(format.getFormat(styleStr));
        return cellStyle;
    }

    private static void getNumberCellStyle(SXSSFWorkbook wb, CellStyle cellStyle, int scale) {
        DataFormat format = wb.createDataFormat();
        String styleStr = "#,##0";
        StringBuilder sb = new StringBuilder(styleStr);
        if (scale > 0) {
            sb.append('.');
            for (int i = 0; i < scale; ++i) {
                sb.append('0');
            }
        }
        cellStyle.setDataFormat(format.getFormat(sb.toString()));
    }

    private static void getAmountCellStyle(SXSSFWorkbook wb, CellStyle cellStyle, String sign, int scale) {
        if (SWCStringUtils.isEmpty((String)sign)) {
            sign = "";
        }
        DataFormat format = wb.createDataFormat();
        String styleStr = sign + "#,##0";
        StringBuilder sb = new StringBuilder(styleStr);
        if (scale > 0) {
            sb.append('.');
            for (int i = 0; i < scale; ++i) {
                sb.append('0');
            }
        }
        cellStyle.setDataFormat(format.getFormat(sb.toString()));
    }

    private static void createHeadColumn(SXSSFWorkbook wb, SXSSFSheet sheet, List<Map<String, String>> headList, int row) {
        SXSSFRow headRow = sheet.createRow(row);
        int headSize = headList.size();
        List<String> mustColumn = CostCfgImportStrategy.getCostCfgAllMustInputColumn();
        for (int i = 0; i < headSize; ++i) {
            Font font;
            if (null == headList.get(i)) continue;
            SXSSFCell cell = headRow.createCell(i);
            String headString = headList.get(i).get("value");
            cell.setCellValue(headString);
            CellStyle headColumnStyle = CostExportCommonHelper.getHeadColumnStyle(wb);
            String headKey = headList.get(i).get("key");
            if (mustColumn.contains(headKey)) {
                headString = "* " + headString;
            }
            cell.setCellValue(headString);
            if (mustColumn.contains(headKey)) {
                font = wb.createFont();
                font.setColor((short)10);
                headColumnStyle.setFont(font);
            }
            if ("errorMessage".equals(headKey)) {
                font = wb.createFont();
                font.setColor((short)10);
                headColumnStyle.setFont(font);
            } else if ("bsed".equals(headKey)) {
                CellStyle style = CostExportCommonHelper.getDefaultCellStyle(DATE, wb);
                sheet.setDefaultColumnStyle(i, style);
            }
            cell.setCellStyle(headColumnStyle);
        }
    }

    private static CellStyle getDefaultCellStyle(String dataType, SXSSFWorkbook wb) {
        int scale = 0;
        CellStyle cellStyle = wb.createCellStyle();
        if (SWCStringUtils.equals((String)dataType, (String)NUM)) {
            CostExportCommonHelper.getNumberCellStyle(wb, cellStyle, scale);
        } else if (SWCStringUtils.equals((String)dataType, (String)DATE)) {
            CostExportCommonHelper.getDateCellStyle(wb, cellStyle);
        } else if (SWCStringUtils.equals((String)dataType, (String)AMOUNT)) {
            CostExportCommonHelper.getAmountCellStyle(wb, cellStyle, dataType, scale);
        } else {
            CostExportCommonHelper.getStringCellStyle(wb, cellStyle);
        }
        return cellStyle;
    }

    private static CellStyle getHeadColumnStyle(SXSSFWorkbook wb) {
        CellStyle headColumnStyle = wb.createCellStyle();
        headColumnStyle.setBorderBottom(BorderStyle.THIN);
        headColumnStyle.setBorderBottom(BorderStyle.THIN);
        headColumnStyle.setBorderTop(BorderStyle.THIN);
        headColumnStyle.setBorderLeft(BorderStyle.THIN);
        headColumnStyle.setBorderRight(BorderStyle.THIN);
        headColumnStyle.setFillForegroundColor(HSSFColor.HSSFColorPredefined.GREY_25_PERCENT.getIndex());
        headColumnStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        headColumnStyle.setAlignment(HorizontalAlignment.CENTER);
        headColumnStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        headColumnStyle.setHidden(true);
        return headColumnStyle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String writeFile(SXSSFWorkbook wb, String fileName) throws IOException {
        ByteArrayOutputStream outStream = null;
        ByteArrayInputStream inStream = null;
        try {
            outStream = new ByteArrayOutputStream();
            wb.write((OutputStream)outStream);
            outStream.flush();
            inStream = new ByteArrayInputStream(outStream.toByteArray());
            fileName = fileName + EXCEL_SUFFIX;
            String string = CostExportCommonHelper.getDownLoadUrl(inStream, fileName);
            return string;
        }
        catch (Exception e) {
            logger.error(e.getMessage());
            String string = "";
            return string;
        }
        finally {
            if (null != outStream) {
                outStream.close();
            }
            if (null != inStream) {
                inStream.close();
            }
        }
    }

    public static String getDownLoadUrl(InputStream inStream, String fileName) {
        FileService fileService = FileServiceFactory.getAttachmentFileService();
        RequestContext requestContext = RequestContext.get();
        String pathParam = FileNameUtils.getAttachmentFileName((String)requestContext.getTenantId(), (String)requestContext.getAccountId(), (Object)"costExport", (String)fileName);
        FileItem item = new FileItem(fileName, pathParam, inStream);
        String path = fileService.upload(item);
        return UrlService.getAttachmentFullUrl((String)path);
    }

    public static void createContentColumn(SXSSFWorkbook wb, SXSSFSheet sheet, Integer beginIndex, List<Map<String, Object>> exportDataList, List<Map<String, String>> headList) {
        if (exportDataList.isEmpty()) {
            return;
        }
        HashMap<String, CellStyle> cellStyleMap = new HashMap<String, CellStyle>(16);
        boolean flag = false;
        CellStyle errorCellStyleKey = CostExportCommonHelper.getDefaultCellStyle(TEXT, wb);
        for (int rowIndex = beginIndex.intValue(); rowIndex < exportDataList.size() + beginIndex; ++rowIndex) {
            SXSSFRow contentRow = sheet.createRow(rowIndex);
            Map<String, Object> exportDataMap = exportDataList.get(rowIndex - beginIndex);
            for (int columnIndex = 0; columnIndex < headList.size(); ++columnIndex) {
                String cellStyleKey;
                CellStyle defaultStyle;
                Object value;
                SXSSFCell columnCell = contentRow.createCell(columnIndex);
                String key = headList.get(columnIndex).get("key");
                if (null == key || null == (value = exportDataMap.get(key))) continue;
                if ("rowSeq".equals(key)) {
                    value = rowIndex;
                }
                if (!flag && "bsed".equals(key)) {
                    CellStyle style = CostExportCommonHelper.getDefaultCellStyle(DATE, wb);
                    sheet.setDefaultColumnStyle(columnIndex, style);
                    flag = true;
                }
                String dataType = TEXT;
                if ("bsed".equals(key)) {
                    dataType = DATE;
                }
                if ((defaultStyle = (CellStyle)cellStyleMap.get(cellStyleKey = CostExportCommonHelper.getCellStyleKey(dataType))) == null) {
                    defaultStyle = CostExportCommonHelper.getDefaultCellStyle(dataType, wb);
                    cellStyleMap.put(cellStyleKey, defaultStyle);
                }
                try {
                    CostExportCommonHelper.parseCellValue(columnCell, value, dataType);
                }
                catch (Exception e) {
                    columnCell.setCellValue(value.toString());
                    logger.error("parseCellValue error:", (Throwable)e);
                }
                columnCell.setCellType(CostExportCommonHelper.getCellType(dataType));
                if ("errorMessage".equals(key)) {
                    Font font = wb.createFont();
                    font.setColor((short)10);
                    errorCellStyleKey.setFont(font);
                    columnCell.setCellStyle(errorCellStyleKey);
                    continue;
                }
                columnCell.setCellStyle(defaultStyle);
            }
        }
    }

    private static void addValidation(SXSSFSheet sheet, List<Map<String, Object>> validationList) {
        for (Map<String, Object> validationMap : validationList) {
            String[] option = (String[])validationMap.get("option");
            CellRangeAddressList cellList = (CellRangeAddressList)validationMap.get("celllist");
            String tips = (String)validationMap.get("tips");
            DataValidationConstraint constraint = sheet.getDataValidationHelper().createExplicitListConstraint(option);
            DataValidation validation = sheet.getDataValidationHelper().createValidation(constraint, cellList);
            if (SWCStringUtils.isNotEmpty((String)tips)) {
                validation.createPromptBox("", tips);
                validation.setShowPromptBox(true);
            }
            if (validation instanceof XSSFDataValidation) {
                validation.setSuppressDropDownArrow(true);
                validation.setShowErrorBox(true);
            } else {
                validation.setSuppressDropDownArrow(false);
            }
            sheet.addValidationData(validation);
        }
    }

    public static void closeSafely(OutputStream ... oses) {
        if (oses != null) {
            for (OutputStream os : oses) {
                try {
                    if (os == null) continue;
                    os.close();
                }
                catch (Exception ignore) {
                    logger.error("OutputStream Error  when closeSafely", (Throwable)ignore);
                }
            }
        }
    }

    public static void closeSafely(InputStream ... ins) {
        if (ins != null) {
            for (InputStream in : ins) {
                try {
                    if (in == null) continue;
                    in.close();
                }
                catch (Exception ignore) {
                    logger.error("InputStream Error when closeSafely", (Throwable)ignore);
                }
            }
        }
    }

    public static void closeSafely(SXSSFWorkbook sheetAndWriteData) {
        if (sheetAndWriteData != null) {
            try {
                sheetAndWriteData.close();
            }
            catch (IOException e) {
                logger.error("CostExportCommonHelper SXSSFWorkbook closeSafely error", (Object)e.getMessage());
            }
        }
    }

    public static void closeSafely(Workbook workbook) {
        if (workbook != null) {
            try {
                workbook.close();
            }
            catch (IOException e) {
                logger.error("CostExportCommonHelper Workbook closeSafely error", (Object)e.getMessage());
            }
        }
    }

    public static List<String> getCostTypeNameList() {
        Map<String, String> costTypeNameMap = CostExportCommonHelper.getCostTypeNameMap();
        return new ArrayList<String>(costTypeNameMap.keySet());
    }

    public static Map<String, String> getCostTypeNameMap() {
        LinkedHashMap<String, String> costTypeNameMap = new LinkedHashMap<String, String>(16);
        costTypeNameMap.put(CostExportCommonHelper.getCostCfgTypeName(), "1");
        costTypeNameMap.put(CostExportCommonHelper.getPriorityTypeName(), "2");
        costTypeNameMap.put(CostExportCommonHelper.getRevealTypeName(), "3");
        return costTypeNameMap;
    }

    public static Map<String, String> getCostTypeNameMapByFormId(String billFormId) {
        LinkedHashMap<String, String> costTypeNameMap = new LinkedHashMap<String, String>(16);
        costTypeNameMap.put(CostExportCommonHelper.getCostCfgTypeName(), "1");
        if ("pcs_costitemcfg".equals(billFormId)) {
            costTypeNameMap.put(CostExportCommonHelper.getPriorityTypeName(), "2");
        } else if ("pcs_costdeptcfg".equals(billFormId)) {
            costTypeNameMap.put(CostExportCommonHelper.getRevealTypeName(), "3");
        }
        return costTypeNameMap;
    }

    public static String getCostCfgTypeName() {
        return ResManager.loadKDString((String)"\u6210\u672c\u8bbe\u7f6e", (String)"CostExportCommonHelper_7", (String)"swc-pcs-business", (Object[])new Object[0]);
    }

    public static String getPriorityTypeName() {
        return ResManager.loadKDString((String)"\u4f18\u5148\u6210\u672c\u8bbe\u7f6e", (String)"CostExportCommonHelper_8", (String)"swc-pcs-business", (Object[])new Object[0]);
    }

    public static String getRevealTypeName() {
        return ResManager.loadKDString((String)"\u515c\u5e95\u6210\u672c\u8bbe\u7f6e", (String)"CostExportCommonHelper_9", (String)"swc-pcs-business", (Object[])new Object[0]);
    }

    public static void writeWorkBookToFile(Map<Long, SXSSFWorkbook> workBookMap, IFormView view, Map<Long, String> numberMap, String type) {
        CostExportCommonHelper.updateExportProgress(workBookMap, view);
        CostExportCommonHelper.writeFile(workBookMap, view, numberMap, type);
    }

    private static void writeFile(Map<Long, SXSSFWorkbook> workBookMap, IFormView view, Map<Long, String> numberMap, String type) {
        try {
            logger.info("export data writeFile begin 8-1");
            String url = CostExportCommonHelper.uploadFile(workBookMap, numberMap, type);
            String billFormId = CostExportCommonHelper.getBillFormId(view);
            String safeUrl = SWCURLHelper.getSafeUrl((String)"pcs", (String)billFormId, (String)url);
            logger.info("export data writeFile url 8-2");
            if (!url.isEmpty()) {
                SWCPageCache pageCache = new SWCPageCache(view);
                pageCache.put("url", (Object)safeUrl);
                pageCache.put("progress", (Object)CostAllotBillConstants.PROGRESS_FINISH);
                pageCache.saveChanges();
            } else {
                view.showErrorNotification(ResManager.loadKDString((String)"\u6570\u636e\u5bfc\u51fa\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"CostExportCommonHelper_11", (String)"swc-pcs-business", (Object[])new Object[0]));
            }
            logger.info("export data writeFile end 8-3");
        }
        catch (Exception e) {
            logger.error("writeWorkBookToFile writeFile error", (Throwable)e);
        }
    }

    private static String getBillFormId(IFormView view) {
        if (view instanceof BillView) {
            BillView billView = (BillView)view;
            return billView.getFormId();
        }
        ListView listView = (ListView)view;
        return listView.getBillFormId();
    }

    private static void updateExportProgress(Map<Long, SXSSFWorkbook> workBookMap, IFormView view) {
        SWCPageCache pageCache = new SWCPageCache(view);
        if (workBookMap.isEmpty()) {
            pageCache.put("progress", (Object)CostAllotBillConstants.PROGRESS_FINISH);
            pageCache.saveChanges();
        } else {
            pageCache.put("progress", (Object)CostAllotBillConstants.PROGRESS_HALF);
            pageCache.saveChanges();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String uploadFile(Map<Long, SXSSFWorkbook> workBooksMap, Map<Long, String> numberMap, String type) {
        String iterator;
        ByteArrayInputStream inStream = null;
        ZipOutputStream zos = null;
        ByteArrayOutputStream outStream = null;
        ByteArrayOutputStream outputStream = null;
        SXSSFWorkbook workBook = null;
        String fileName = "";
        HashMap<String, byte[]> content = new HashMap<String, byte[]>(workBooksMap.size());
        try {
            if (workBooksMap.size() <= 1) {
                logger.info("CostExportCommonHelper writeFile begin 1-1");
                for (Map.Entry<Long, SXSSFWorkbook> next : workBooksMap.entrySet()) {
                    Long id = next.getKey();
                    workBook = next.getValue();
                    outStream = new ByteArrayOutputStream();
                    workBook.write((OutputStream)outStream);
                    outStream.flush();
                    inStream = new ByteArrayInputStream(outStream.toByteArray());
                    String number = numberMap.get(id);
                    fileName = CostExportCommonHelper.getExportFileName(number, type);
                }
                logger.info("CostExportCommonHelper begin 1-2");
            } else {
                logger.info("CostExportCommonHelper begin 2-1");
                for (Map.Entry<Long, SXSSFWorkbook> next : workBooksMap.entrySet()) {
                    Long id = next.getKey();
                    workBook = next.getValue();
                    outStream = new ByteArrayOutputStream();
                    workBook.write((OutputStream)outStream);
                    outStream.flush();
                    inStream = new ByteArrayInputStream(outStream.toByteArray());
                    String number = numberMap.get(id);
                    String excelFileName = CostExportCommonHelper.getExportFileName(number, type);
                    content.put(excelFileName, outStream.toByteArray());
                }
                logger.info("CostExportCommonHelper begin 2-2");
                outputStream = new ByteArrayOutputStream();
                zos = new ZipOutputStream(outputStream);
                for (Map.Entry entry : content.entrySet()) {
                    zos.putNextEntry(new ZipEntry((String)entry.getKey()));
                    zos.write((byte[])entry.getValue());
                    zos.closeEntry();
                }
                zos.finish();
                logger.info("CostExportCommonHelper writeFile begin 2-3");
                inStream = new ByteArrayInputStream(outputStream.toByteArray());
                fileName = CostExportCommonHelper.getZipExportFileName(type, numberMap);
                logger.info("CostExportCommonHelper writeFile begin 2-3");
            }
            iterator = CostExportCommonHelper.getDownLoadUrl(inStream, fileName);
        }
        catch (Exception e) {
            String string;
            try {
                logger.error("CostExportCommonHelper writeFile error", (Throwable)e);
                string = "";
            }
            catch (Throwable throwable) {
                CostExportCommonHelper.closeSafely(outStream, zos);
                CostExportCommonHelper.closeSafely(inStream);
                CostExportCommonHelper.closeSafely(workBook);
                CostExportCommonHelper.closeSafely(outputStream);
                throw throwable;
            }
            CostExportCommonHelper.closeSafely(outStream, zos);
            CostExportCommonHelper.closeSafely(inStream);
            CostExportCommonHelper.closeSafely(workBook);
            CostExportCommonHelper.closeSafely(outputStream);
            return string;
        }
        CostExportCommonHelper.closeSafely(outStream, zos);
        CostExportCommonHelper.closeSafely(inStream);
        CostExportCommonHelper.closeSafely(workBook);
        CostExportCommonHelper.closeSafely(outputStream);
        return iterator;
    }

    private static String getExportFileName(String number, String type) {
        Date date = new Date();
        if ("1".equals(type)) {
            String dateFormat = SWCDateTimeUtils.format((Date)date, (String)"yyyy-MM-dd");
            return ResManager.loadKDString((String)"\u5bfc\u51fa\u6570\u636e_{0}_{1}{2}", (String)"CostExportCommonHelper_12", (String)"swc-pcs-business", (Object[])new Object[]{number, dateFormat, EXCEL_SUFFIX});
        }
        String dateFormat = SWCDateTimeUtils.format((Date)date, (String)"yyyy-MM-dd");
        return ResManager.loadKDString((String)"\u6210\u672c\u5206\u914d\u5355\u5bfc\u51fa_{0}_{1}{2}", (String)"CostExportCommonHelper_13", (String)"swc-pcs-business", (Object[])new Object[]{number, dateFormat, EXCEL_SUFFIX});
    }

    private static String getZipExportFileName(String type, Map<Long, String> numberMap) {
        Date date = new Date();
        String exportZipName = "";
        if ("1".equals(type)) {
            for (Map.Entry<Long, String> next : numberMap.entrySet()) {
                String[] result;
                String billName;
                String value = next.getValue();
                if (!SWCStringUtils.isNotEmpty((String)value) || !value.contains("_") || !SWCStringUtils.isNotEmpty((String)(billName = (result = value.split("_"))[0]))) continue;
                String dateFormat = SWCDateTimeUtils.format((Date)date, (String)"yyyy-MM-dd");
                exportZipName = ResManager.loadKDString((String)"\u5bfc\u51fa\u6570\u636e_{0}_{1}{2}", (String)"CostExportCommonHelper_14", (String)"swc-pcs-business", (Object[])new Object[]{billName, dateFormat, FILE_NAME_SUFFIX});
            }
        } else {
            String dateFormat = SWCDateTimeUtils.format((Date)date, (String)"yyyy-MM-dd");
            exportZipName = ResManager.loadKDString((String)"\u6210\u672c\u5206\u914d\u5355\u5bfc\u51fa_{0}{1}", (String)"CostExportCommonHelper_15", (String)"swc-pcs-business", (Object[])new Object[]{dateFormat, FILE_NAME_SUFFIX});
        }
        return exportZipName;
    }
}

