/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.pcs.business.costcustomize.service;

import java.math.BigDecimal;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.swc.hsbp.common.cache.SWCPageCache;
import kd.swc.pcs.business.costcfg.CostAllocationHelper;

public class CostCustomizeService {
    public boolean validatorCostCustomizeInfo(IFormView view) {
        long costItemId = view.getModel().getDataEntity().getLong("costitem.id");
        if (costItemId == 0L) {
            view.showTipNotification(ResManager.loadKDString((String)"\u6210\u672c\u9879\u76ee\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"CostCustomizeService_8", (String)"swc-pcs-business", (Object[])new Object[0]));
            return false;
        }
        SWCPageCache pageCache = new SWCPageCache(view);
        String isDataChanged = (String)pageCache.get("isdatachanged", String.class);
        if (isDataChanged == null || "false".equals(isDataChanged)) {
            view.setReturnData(null);
            view.close();
            return false;
        }
        Long costStruId = (Long)pageCache.get("coststruid", Long.class);
        Map<String, String> mustInputFieldMap = CostAllocationHelper.queryCostStruMustInputField(costStruId);
        DynamicObjectCollection entryEntity = view.getModel().getEntryEntity("entryentity");
        BigDecimal hundred = new BigDecimal(100);
        BigDecimal costCfgTotal = BigDecimal.ZERO;
        int i = 0;
        boolean checkBoxIsRevealFlag = false;
        for (DynamicObject customizeEntryDy : entryEntity) {
            BigDecimal calCostProportion = customizeEntryDy.getBigDecimal("decimal10007");
            boolean checkBoxIsReveal = customizeEntryDy.getBoolean("checkbox10006");
            if (checkBoxIsReveal) {
                checkBoxIsRevealFlag = true;
            }
            if (!checkBoxIsReveal && calCostProportion.compareTo(BigDecimal.ZERO) == 0) {
                view.showTipNotification(ResManager.loadKDString((String)"\u767e\u5206\u6bd4\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"CostCustomizeService_2", (String)"swc-pcs-business", (Object[])new Object[0]));
                return false;
            }
            costCfgTotal = costCfgTotal.add(calCostProportion);
            String message = this.validatorCustomizeEntryInfo(mustInputFieldMap, customizeEntryDy);
            if (!message.isEmpty()) {
                view.showTipNotification(message);
                return false;
            }
            boolean isRevealDetail = customizeEntryDy.getBoolean("checkbox10006");
            if (!isRevealDetail) continue;
            ++i;
        }
        if (costCfgTotal.compareTo(hundred) > 0) {
            view.showTipNotification(ResManager.loadKDString((String)"\u6210\u672c\u8bbe\u7f6e\u767e\u5206\u6bd4\u5927\u4e8e100%\uff0c\u8bf7\u66f4\u6b63\u540e\u91cd\u65b0\u4fdd\u5b58\u3002", (String)"CostCustomizeService_40", (String)"swc-pcs-business", (Object[])new Object[0]));
            return false;
        }
        if (i > 1) {
            view.showTipNotification(ResManager.loadKDString((String)"\u53ea\u5141\u8bb8\u8bbe\u7f6e\u4e00\u4e2a\u515c\u5e95\u6210\u672c\u8bbe\u7f6e\u3002", (String)"CostCustomizeService_5", (String)"swc-pcs-business", (Object[])new Object[0]));
            return false;
        }
        if (entryEntity.isEmpty()) {
            view.showConfirm(ResManager.loadKDString((String)"\u6240\u6709\u8d39\u7528\u5206\u644a\u7ed3\u6784\u90fd\u5df2\u5220\u9664\uff0c\u8be5\u85aa\u8d44\u6863\u6848\u7684\u6240\u6709\u8d39\u7528\u4e0d\u4f1a\u8fdb\u884c\u5206\u644a\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"CostCustomizeService_6", (String)"swc-pcs-business", (Object[])new Object[0]), MessageBoxOptions.OKCancel, new ConfirmCallBackListener("costcustomizedeleteall_callback"));
            return false;
        }
        this.setRevealRow(entryEntity, hundred, costCfgTotal, checkBoxIsRevealFlag);
        return true;
    }

    private void setRevealRow(DynamicObjectCollection entryEntity, BigDecimal hundred, BigDecimal costCfgTotal, boolean checkBoxIsRevealFlag) {
        int revealRow = 0;
        for (DynamicObject customizeEntryDy : entryEntity) {
            boolean checkBoxIsReveal = customizeEntryDy.getBoolean("checkbox10006");
            if (checkBoxIsReveal) {
                BigDecimal resultPor = hundred.subtract(costCfgTotal);
                customizeEntryDy.set("decimal10007", (Object)resultPor);
                break;
            }
            ++revealRow;
        }
        if (checkBoxIsRevealFlag) {
            DynamicObject dynamicObject = (DynamicObject)entryEntity.get(revealRow);
            entryEntity.remove(revealRow);
            entryEntity.add((Object)dynamicObject);
        }
    }

    private String validatorCustomizeEntryInfo(Map<String, String> mustInputFieldMap, DynamicObject customizeEntryDy) {
        String message = "";
        for (Map.Entry<String, String> next : mustInputFieldMap.entrySet()) {
            Object object;
            String fieldKey = next.getKey();
            String value = next.getValue();
            DataEntityPropertyCollection properties = customizeEntryDy.getDataEntityType().getProperties();
            if (!properties.containsKey((Object)fieldKey) || (object = customizeEntryDy.get(fieldKey)) != null && !object.toString().isEmpty()) continue;
            message = ResManager.loadKDString((String)"{0}\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"CostCustomizeService_7", (String)"swc-pcs-business", (Object[])new Object[]{value});
            break;
        }
        return message;
    }
}

