/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.pcs.business.costthread;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.swc.pcs.business.costcfg.CostSetUpExportHelper;
import kd.swc.pcs.business.costcommon.CostCommonHelper;

public class CostSetUpExportThread
implements Callable<List<Map<String, Object>>> {
    protected static final Log logger = LogFactory.getLog(CostSetUpExportThread.class);
    private int pageIndex;
    private RequestContext requestContext;
    private List<Long> batchList;
    private Long calTaskId;
    private int pageSize;
    private Long costStruId;
    private Map<String, String> dynamicColumnMap;
    private List<QFilter> costSetUpFiltersFromCache;

    public CostSetUpExportThread(int pageIndex, RequestContext requestContext, List<Long> batchList, Long calTaskId, int pageSize, Long costStruId, Map<String, String> dynamicColumnMap, List<QFilter> costSetUpFiltersFromCache) {
        this.pageIndex = pageIndex;
        this.requestContext = requestContext;
        this.batchList = batchList;
        this.calTaskId = calTaskId;
        this.pageSize = pageSize;
        this.costStruId = costStruId;
        this.dynamicColumnMap = dynamicColumnMap;
        this.costSetUpFiltersFromCache = costSetUpFiltersFromCache;
    }

    @Override
    public List<Map<String, Object>> call() {
        RequestContext.copyAndSet((RequestContext)this.requestContext);
        return this.getExportData(this.batchList, this.calTaskId, this.pageIndex, this.pageSize, this.costStruId);
    }

    private List<Map<String, Object>> getExportData(List<Long> selectRows, Long calTaskId, int pageIndex, int pageSize, Long costStruId) {
        if (selectRows.size() > 0) {
            QFilter[] selectIdFilter = new QFilter[]{new QFilter("id", "in", selectRows)};
            return this.queryExportData(selectIdFilter, costStruId);
        }
        logger.info("CostSetUpExportThread getExportData begin, pageIndex : {}", (Object)pageIndex);
        QFilter calTaskIdFilter = new QFilter("caltask.id", "=", (Object)calTaskId);
        if (this.costSetUpFiltersFromCache != null) {
            for (QFilter filterFromCache : this.costSetUpFiltersFromCache) {
                calTaskIdFilter.and(filterFromCache);
            }
        }
        return this.queryExportData(new QFilter[]{calTaskIdFilter}, pageIndex, pageSize, costStruId);
    }

    private List<Map<String, Object>> queryExportData(QFilter[] filters, Long costStruId) {
        return this.queryExportData(filters, 0, Integer.MAX_VALUE, costStruId);
    }

    private List<Map<String, Object>> queryExportData(QFilter[] filters, int pageIndex, int pageSize, Long costStruId) {
        String selectField = this.getSelectField();
        ArrayList<Map<String, Object>> dataList = new ArrayList<Map<String, Object>>(10);
        logger.info("CostSetUpExportThread load data begin");
        DynamicObject[] coll = BusinessDataServiceHelper.load((String)"pcs_costsetuprst", (String)selectField, (QFilter[])filters, (String)"salaryfile.id asc, salaryitem.id asc", (int)pageIndex, (int)pageSize);
        logger.info("CostSetUpExportThread load data end");
        ArrayList<Long> defCostSetUpConstIds = new ArrayList<Long>(10);
        for (DynamicObject dy : coll) {
            DynamicObjectCollection salaryItemEntryDys = dy.getDynamicObjectCollection("entryentity");
            for (DynamicObject salaryItemEntryDy : salaryItemEntryDys) {
                long defCostSetUpConstId = salaryItemEntryDy.getLong("defcostsetupconst.id");
                defCostSetUpConstIds.add(defCostSetUpConstId);
            }
        }
        Map<Long, DynamicObject> constEntryIdMap = CostCommonHelper.getConstEntryIdMap(defCostSetUpConstIds);
        DynamicObjectCollection dimensionEntryColl = CostCommonHelper.getCostStruDimById(costStruId);
        Map<String, DynamicObject> allDimensionMap = CostCommonHelper.getAllDimensionMap(dimensionEntryColl);
        Map<String, List<Long>> constQueryResultMap = CostCommonHelper.getConstNeedQueryDbMap(constEntryIdMap, dimensionEntryColl);
        Map<String, HashMap<String, DynamicObject>> baseDataValueMap = CostCommonHelper.getBaseDataValueMap(constQueryResultMap);
        int rowSeq = pageIndex * pageSize;
        this.setColumnValue(dataList, coll, constEntryIdMap, allDimensionMap, rowSeq, baseDataValueMap);
        logger.info("CostSetUpExportThread getExportData end , pageIndex :{} ", (Object)pageIndex);
        return dataList;
    }

    private String getSelectField() {
        return "caltask,salaryfile,person,costadapter,enable,salaryitem,costitem,entryentity,percentage,aotucostsetupconst,defcostsetupconst,isrevealdetail,maxmount,aotucostsetupconstval,defcostsetupconstval";
    }

    private void setColumnValue(List<Map<String, Object>> dataList, DynamicObject[] coll, Map<Long, DynamicObject> constEntryIdMap, Map<String, DynamicObject> queryCostStruMap, int rowSeq, Map<String, HashMap<String, DynamicObject>> baseDataValueMap) {
        for (DynamicObject costSetUpDy : coll) {
            Map<String, Object> valueMap;
            DynamicObjectCollection salaryItemEntryDys = costSetUpDy.getDynamicObjectCollection("entryentity");
            if (salaryItemEntryDys.isEmpty()) {
                valueMap = CostSetUpExportHelper.setFixColumnValue(rowSeq, null, costSetUpDy);
                this.setDynamicColumnValue(valueMap);
                ++rowSeq;
                dataList.add(valueMap);
                continue;
            }
            for (DynamicObject salaryItemEntryDy : salaryItemEntryDys) {
                valueMap = CostSetUpExportHelper.setFixColumnValue(rowSeq, salaryItemEntryDy, costSetUpDy);
                this.setDynamicColumnValueByEntryInfo(constEntryIdMap, queryCostStruMap, valueMap, salaryItemEntryDy, baseDataValueMap);
                dataList.add(valueMap);
                ++rowSeq;
            }
        }
    }

    private void setDynamicColumnValueByEntryInfo(Map<Long, DynamicObject> constEntryIdMap, Map<String, DynamicObject> queryCostStruMap, Map<String, Object> valueMap, DynamicObject salaryItemEntryDy, Map<String, HashMap<String, DynamicObject>> baseDataValueMap) {
        long defCostSetUpConstId = salaryItemEntryDy.getLong("defcostsetupconst.id");
        DynamicObject constResult = constEntryIdMap.get(defCostSetUpConstId);
        if (constResult == null) {
            return;
        }
        Iterator<Map.Entry<String, String>> iterator = this.dynamicColumnMap.entrySet().iterator();
        CostCommonHelper.setDynamicColumnValue(valueMap, constResult, queryCostStruMap, iterator, baseDataValueMap);
    }

    private void setDynamicColumnValue(Map<String, Object> valueMap) {
        for (Map.Entry<String, String> next : this.dynamicColumnMap.entrySet()) {
            String key = next.getKey();
            valueMap.put(key, "");
        }
    }
}

