/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.pcs.opplugin.validator.costcfg;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.swc.hsbp.opplugin.validator.SWCDataBaseValidator;

public class CostCfgCountryValidator
extends SWCDataBaseValidator {
    public void validate() {
        ExtendedDataEntity[] extendedDataEntities = this.getDataEntities();
        if (extendedDataEntities.length == 0) {
            return;
        }
        ExtendedDataEntity extendedDataEntity = extendedDataEntities[0];
        String countryKey = this.getCountryKey(extendedDataEntity);
        String errorCountryMessage = this.getErrorCountryMessage(extendedDataEntity);
        this.validatorCountry(extendedDataEntities, countryKey, errorCountryMessage);
    }

    private void validatorCountry(ExtendedDataEntity[] extendedDataEntities, String countryKey, String errorCountryMessage) {
        String sourceCountryKey = countryKey + ".id";
        for (ExtendedDataEntity extendedDataEntity : extendedDataEntities) {
            long sourceCountryId;
            long costAdapterCountryId;
            DynamicObject costCfgDy = extendedDataEntity.getDataEntity();
            String costAdapterAreaType = costCfgDy.getString("costadapter.areatype");
            if (!"2".equals(costAdapterAreaType) || (costAdapterCountryId = costCfgDy.getLong("costadapter.country.id")) == (sourceCountryId = costCfgDy.getLong("source." + sourceCountryKey))) continue;
            this.addFatalErrorMessage(extendedDataEntity, errorCountryMessage);
        }
    }

    private String getCountryKey(ExtendedDataEntity extendedDataEntity) {
        String billName = extendedDataEntity.getDataEntity().getDataEntityType().getName();
        String countryKey = "pcs_costdeptcfg".equals(billName) ? "companyarea" : ("pcs_costpostcfg".equals(billName) ? "countryregion" : ("pcs_costsalaryfilecfg".equals(billName) ? "payrollregion" : "country"));
        return countryKey;
    }

    private String getErrorCountryMessage(ExtendedDataEntity extendedDataEntity) {
        String remark = "";
        String billFormId = extendedDataEntity.getDataEntity().getDataEntityType().getName();
        if ("pcs_costitemcfg".equals(billFormId)) {
            remark = ResManager.loadKDString((String)"\u85aa\u916c\u9879\u76ee\u4e0e\u4eba\u529b\u6210\u672c\u7ef4\u5ea6\u65b9\u6848\u7684\u201c\u56fd\u5bb6/\u5730\u533a\u201d\u5fc5\u987b\u4e00\u81f4\u3002", (String)"CostCfgCountryValidator_2", (String)"swc-pcs-opplugin", (Object[])new Object[0]);
        } else if ("pcs_costdeptcfg".equals(billFormId)) {
            remark = ResManager.loadKDString((String)"\u884c\u653f\u7ec4\u7ec7\u4e0e\u4eba\u529b\u6210\u672c\u7ef4\u5ea6\u65b9\u6848\u7684\u201c\u56fd\u5bb6/\u5730\u533a\u201d\u5fc5\u987b\u4e00\u81f4\u3002", (String)"CostCfgCountryValidator_3", (String)"swc-pcs-opplugin", (Object[])new Object[0]);
        } else if ("pcs_costpostcfg".equals(billFormId)) {
            remark = ResManager.loadKDString((String)"\u5c97\u4f4d\u4e0e\u4eba\u529b\u6210\u672c\u7ef4\u5ea6\u65b9\u6848\u7684\u201c\u56fd\u5bb6/\u5730\u533a\u201d\u5fc5\u987b\u4e00\u81f4\u3002", (String)"CostCfgCountryValidator_4", (String)"swc-pcs-opplugin", (Object[])new Object[0]);
        } else if ("pcs_costsalaryfilecfg".equals(billFormId)) {
            remark = ResManager.loadKDString((String)"\u4eba\u5458\u85aa\u8d44\u6863\u6848\u7684\u201c\u53d1\u85aa\u7ba1\u7406\u5c5e\u5730\u201d\uff0c\u4e0e\u4eba\u529b\u6210\u672c\u7ef4\u5ea6\u65b9\u6848\u7684\u201c\u56fd\u5bb6/\u5730\u533a\u201d\u5fc5\u987b\u4e00\u81f4\u3002", (String)"CostCfgCountryValidator_5", (String)"swc-pcs-opplugin", (Object[])new Object[0]);
        } else if ("pcs_costsalaryitemcfg".equals(billFormId)) {
            remark = ResManager.loadKDString((String)"\u4eba\u5458\u85aa\u8d44\u6863\u6848\u7684\u201c\u53d1\u85aa\u7ba1\u7406\u5c5e\u5730\u201d\u4e0e\u85aa\u916c\u9879\u76ee\u7684\u201c\u56fd\u5bb6/\u5730\u533a\u201d\u53ca\u4eba\u529b\u6210\u672c\u7ef4\u5ea6\u65b9\u6848\u7684\u201c\u56fd\u5bb6/\u5730\u533a\u201d\u5fc5\u987b\u4e00\u81f4\u3002", (String)"CostCfgCountryValidator_6", (String)"swc-pcs-opplugin", (Object[])new Object[0]);
        }
        return remark;
    }
}

