/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.pcs.opplugin.validator.costcfg;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.permission.api.HasPermOrgResult;
import kd.swc.hsbp.business.servicehelper.SWCDataServiceHelper;
import kd.swc.hsbp.business.servicehelper.SWCPermissionServiceHelper;
import kd.swc.hsbp.common.util.SWCStringUtils;
import kd.swc.hsbp.opplugin.validator.SWCDataBaseValidator;

public class CostCfgPermValidator
extends SWCDataBaseValidator {
    private static final Log LOGGER = LogFactory.getLog(CostCfgPermValidator.class);

    public void validate() {
        OperateOption option = this.getOption();
        Map variables = option.getVariables();
        String importType = (String)variables.get("isimport");
        if (!"1".equals(importType)) {
            return;
        }
        ExtendedDataEntity[] extendedDataEntities = this.getDataEntities();
        if (extendedDataEntities.length == 0) {
            return;
        }
        ExtendedDataEntity extendedDataEntityFirst = extendedDataEntities[0];
        String billFormId = extendedDataEntityFirst.getDataEntity().getDataEntityType().getName();
        HasPermOrgResult hasPermOrgResult = SWCPermissionServiceHelper.getPermOrgs((String)"38", (String)"1ANC8T4UC434", (String)billFormId, (String)"47150e89000000ac");
        List resultFilter = SWCPermissionServiceHelper.getAuthorizedDataRuleQFilter((String)"1ANC8T4UC434", (String)billFormId, (String)"4730fc9f000003ae");
        List<Long> sourceIdList = this.getDataRulePermId(billFormId, "source");
        ArrayList<Long> salaryFileIdList = new ArrayList(10);
        if ("pcs_costsalaryitemcfg".equals(billFormId)) {
            salaryFileIdList = this.getDataRulePermId(billFormId, "creatorobj");
        }
        ArrayList<Long> empIdList = new ArrayList(10);
        if ("pcs_costempcfg".equals(billFormId)) {
            empIdList = this.getDataRuleEmployeeQueryPermId();
        }
        for (ExtendedDataEntity extendedDataEntity : extendedDataEntities) {
            boolean isAllUser;
            if (hasPermOrgResult == null || (isAllUser = hasPermOrgResult.hasAllOrgPerm())) continue;
            this.checkImportPerm(resultFilter, extendedDataEntity);
            this.checkCreatorOrgPerm(hasPermOrgResult, extendedDataEntity);
            this.checkPermByBillType(billFormId, sourceIdList, salaryFileIdList, empIdList, extendedDataEntity);
        }
    }

    private void checkImportPerm(List<QFilter> resultFilter, ExtendedDataEntity extendedDataEntity) {
        if (resultFilter == null) {
            String errorMsg = ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u65e0\u5bfc\u5165\u6743\u9650\uff0c\u8bf7\u786e\u8ba4\u540e\u518d\u5bfc\u5165\u3002", (String)"CostCfgPermValidator_1", (String)"swc-pcs-opplugin", (Object[])new Object[0]);
            this.addFatalErrorMessage(extendedDataEntity, errorMsg);
        }
    }

    private void checkCreatorOrgPerm(HasPermOrgResult hasPermOrgResult, ExtendedDataEntity extendedDataEntity) {
        HashSet hasPermOrgSets;
        DynamicObject costCfgDy = extendedDataEntity.getDataEntity();
        long creatorOrgId = costCfgDy.getLong("createorg.id");
        ArrayList hasPermOrgList = hasPermOrgResult.getHasPermOrgs();
        if (hasPermOrgList == null) {
            hasPermOrgList = new ArrayList();
        }
        if (!(hasPermOrgSets = new HashSet(hasPermOrgList)).contains(creatorOrgId)) {
            String errorMsg = ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u65e0\u8be5\u6210\u672c\u8bbe\u7f6e\u7684\u6743\u9650\uff0c\u8bf7\u786e\u8ba4\u540e\u518d\u5bfc\u5165\u3002", (String)"CostCfgPermValidator_2", (String)"swc-pcs-opplugin", (Object[])new Object[0]);
            this.addFatalErrorMessage(extendedDataEntity, errorMsg);
        }
    }

    private void checkPermByBillType(String billFormId, List<Long> sourceIdList, List<Long> salaryFileIdList, List<Long> empIdList, ExtendedDataEntity extendedDataEntity) {
        switch (billFormId) {
            case "pcs_costitemcfg": {
                this.checkSalaryItemDataRule(sourceIdList, extendedDataEntity);
                break;
            }
            case "pcs_costpostcfg": {
                this.checkPostDataRule(sourceIdList, extendedDataEntity);
                break;
            }
            case "pcs_costempcfg": {
                this.checkEmpDataRule(sourceIdList, extendedDataEntity);
                this.checkEmpDataRule(empIdList, extendedDataEntity);
                break;
            }
            case "pcs_costdeptcfg": {
                this.checkDeptDataRule(sourceIdList, extendedDataEntity);
                break;
            }
            case "pcs_costsalaryfilecfg": {
                this.checkSalaryFileDataRule(sourceIdList, extendedDataEntity, "source.id");
                break;
            }
            case "pcs_costsalaryitemcfg": {
                this.checkSalaryItemDataRule(sourceIdList, extendedDataEntity);
                this.checkSalaryFileDataRule(salaryFileIdList, extendedDataEntity, "creatorobj.id");
                break;
            }
        }
    }

    private void checkSalaryFileDataRule(List<Long> salaryFileIdList, ExtendedDataEntity extendedDataEntity, String idKey) {
        DynamicObject costCfgDy = extendedDataEntity.getDataEntity();
        long salaryFileId = costCfgDy.getLong(idKey);
        String errorMsg = ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u65e0\u85aa\u8d44\u6863\u6848\u7684\u6743\u9650\uff0c\u8bf7\u786e\u8ba4\u540e\u518d\u5bfc\u5165\u3002", (String)"CostCfgPermValidator_4", (String)"swc-pcs-opplugin", (Object[])new Object[0]);
        this.validatorDataRule(salaryFileIdList, extendedDataEntity, salaryFileId, errorMsg);
    }

    private void validatorDataRule(List<Long> baseDateIdList, ExtendedDataEntity extendedDataEntity, long baseDateId, String errorMsg) {
        if (baseDateIdList != null && baseDateIdList.isEmpty()) {
            this.addFatalErrorMessage(extendedDataEntity, errorMsg);
            LOGGER.info("CostCfgPermValidator validatorDataRule baseDateIdList is empty");
        } else if (baseDateIdList != null && !baseDateIdList.contains(baseDateId)) {
            this.addFatalErrorMessage(extendedDataEntity, errorMsg);
            LOGGER.info("CostCfgPermValidator validatorDataRule baseDateIdList is not contains :{}", baseDateIdList);
        }
    }

    private void checkSalaryItemDataRule(List<Long> salaryItemIdList, ExtendedDataEntity extendedDataEntity) {
        DynamicObject costCfgDy = extendedDataEntity.getDataEntity();
        long costSalaryItemId = costCfgDy.getLong("source.id");
        String errorMsg = ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u65e0\u85aa\u916c\u9879\u76ee\u7684\u6743\u9650\uff0c\u8bf7\u786e\u8ba4\u540e\u518d\u5bfc\u5165\u3002", (String)"CostCfgPermValidator_5", (String)"swc-pcs-opplugin", (Object[])new Object[0]);
        this.validatorDataRule(salaryItemIdList, extendedDataEntity, costSalaryItemId, errorMsg);
    }

    private void checkDeptDataRule(List<Long> deptIdList, ExtendedDataEntity extendedDataEntity) {
        DynamicObject costCfgDy = extendedDataEntity.getDataEntity();
        long costDeptId = costCfgDy.getLong("source.id");
        String errorMsg = ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u65e0\u7ec4\u7ec7\u7684\u6743\u9650\uff0c\u8bf7\u786e\u8ba4\u540e\u518d\u5bfc\u5165\u3002", (String)"CostCfgPermValidator_6", (String)"swc-pcs-opplugin", (Object[])new Object[0]);
        this.validatorDataRule(deptIdList, extendedDataEntity, costDeptId, errorMsg);
    }

    private void checkEmpDataRule(List<Long> empIdList, ExtendedDataEntity extendedDataEntity) {
        DynamicObject costCfgDy = extendedDataEntity.getDataEntity();
        long empId = costCfgDy.getLong("source.id");
        String errorMsg = ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u65e0\u4eba\u5458\u7684\u6743\u9650\uff0c\u8bf7\u786e\u8ba4\u540e\u518d\u5bfc\u5165\u3002", (String)"CostCfgPermValidator_7", (String)"swc-pcs-opplugin", (Object[])new Object[0]);
        this.validatorDataRule(empIdList, extendedDataEntity, empId, errorMsg);
    }

    private void checkPostDataRule(List<Long> postIdList, ExtendedDataEntity extendedDataEntity) {
        DynamicObject costCfgDy = extendedDataEntity.getDataEntity();
        long postId = costCfgDy.getLong("source.id");
        String errorMsg = ResManager.loadKDString((String)"\u5f53\u524d\u7528\u6237\u65e0\u5c97\u4f4d\u7684\u6743\u9650\uff0c\u8bf7\u786e\u8ba4\u540e\u518d\u5bfc\u5165\u3002", (String)"CostCfgPermValidator_8", (String)"swc-pcs-opplugin", (Object[])new Object[0]);
        this.validatorDataRule(postIdList, extendedDataEntity, postId, errorMsg);
    }

    private List<Long> getDataRulePermId(String billFormId, String propertiesKey) {
        long currUserId = RequestContext.get().getCurrUserId();
        QFilter salaryFileFilter = SWCPermissionServiceHelper.getDataRuleForBdProp((long)currUserId, (String)"1ANC8T4UC434", (String)billFormId, (String)propertiesKey, (String)"47156aff000000ac");
        QFilter salaryItemBaseDataBuFilter = null;
        if (salaryFileFilter == null) {
            if ("pcs_costitemcfg".equals(billFormId)) {
                salaryItemBaseDataBuFilter = this.getSalaryItemBuFilter();
                if (salaryItemBaseDataBuFilter == null) {
                    return null;
                }
            } else {
                return null;
            }
        }
        if ("pcs_costitemcfg".equals(billFormId)) {
            if (salaryFileFilter != null && salaryItemBaseDataBuFilter != null) {
                salaryFileFilter.or(salaryItemBaseDataBuFilter);
            } else if (salaryItemBaseDataBuFilter != null) {
                salaryFileFilter = salaryItemBaseDataBuFilter;
            }
        }
        ArrayList<Long> salaryFileIds = new ArrayList<Long>(10);
        String number = this.getQueryBillNumber(billFormId);
        if (SWCStringUtils.isEmpty((String)number)) {
            return salaryFileIds;
        }
        if ("creatorobj".equals(propertiesKey)) {
            number = "hsas_salaryfile";
        }
        SWCDataServiceHelper helper = new SWCDataServiceHelper(number);
        DynamicObject[] salaryFileDys = helper.query("id", new QFilter[]{salaryFileFilter});
        for (int i = 0; i < salaryFileDys.length; ++i) {
            DynamicObject salaryFileDy = salaryFileDys[i];
            salaryFileIds.add(salaryFileDy.getLong("id"));
        }
        return salaryFileIds;
    }

    private List<Long> getDataRuleEmployeeQueryPermId() {
        DynamicObject[] queryResults;
        long currUserId = RequestContext.get().getCurrUserId();
        QFilter empDataRuleFilter = SWCPermissionServiceHelper.getDataRuleForBdProp((long)currUserId, (String)"1ANC8T4UC434", (String)"pcs_costempcfg", (String)"employee", (String)"47156aff000000ac");
        if (empDataRuleFilter == null) {
            return null;
        }
        ArrayList<Long> empIds = new ArrayList<Long>(10);
        SWCDataServiceHelper helper = new SWCDataServiceHelper("hrpi_employeef7query");
        for (DynamicObject queryResult : queryResults = helper.query("id,name,number", new QFilter[]{empDataRuleFilter})) {
            long id = queryResult.getLong("id");
            empIds.add(id);
        }
        return empIds;
    }

    private void addSalaryItemBuFilter(QFilter dataRuleFilter) {
    }

    private QFilter getSalaryItemBuFilter() {
        QFilter salaryItemBaseDataBuFilter = null;
        Set payrollCalSetByPermItem = SWCPermissionServiceHelper.getPayrollCalSetByPermItem((String)"1ANC8T4UC434", (String)"pcs_costitemcfgperm", (String)"47150e89000000ac");
        if (!CollectionUtils.isEmpty((Collection)payrollCalSetByPermItem)) {
            ArrayList payrollCalListByPermItem = new ArrayList(payrollCalSetByPermItem);
            salaryItemBaseDataBuFilter = SWCPermissionServiceHelper.getBaseDataFilter((String)"hsbs_salaryitem", payrollCalListByPermItem, (boolean)true);
        }
        return salaryItemBaseDataBuFilter;
    }

    private String getQueryBillNumber(String billFormId) {
        String number = "";
        if ("pcs_costdeptcfg".equals(billFormId)) {
            number = "haos_adminorghr";
        } else if ("pcs_costitemcfg".equals(billFormId)) {
            number = "hsbs_salaryitem";
        } else if ("pcs_costempcfg".equals(billFormId)) {
            number = "hrpi_employee";
        } else if ("pcs_costpostcfg".equals(billFormId)) {
            number = "hbpm_positionhr";
        } else if ("pcs_costsalaryitemcfg".equals(billFormId)) {
            number = "hsbs_salaryitem";
        } else if ("pcs_costsalaryfilecfg".equals(billFormId)) {
            number = "hsas_salaryfile";
        }
        return number;
    }
}

