/*
 * Decompiled with CFR 0.152.
 */
package kd.swc.pcs.opplugin.validator.costcfg;

import java.math.BigDecimal;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.ValidateContext;
import kd.bos.entity.validate.ValidateResultCollection;
import kd.swc.hsbp.opplugin.validator.SWCDataBaseValidator;
import kd.swc.pcs.business.costcfg.dataimport.helper.CostCfgImportHelper;
import kd.swc.pcs.business.costcommon.CostCommonHelper;

public class CostCfgSaveValidator
extends SWCDataBaseValidator {
    public void validate() {
        OperateOption option = this.getOption();
        Map variables = option.getVariables();
        String importType = (String)variables.get("isimport");
        if ("1".equals(importType) || "2".equals(importType)) {
            return;
        }
        ValidateContext validateContext = this.getValidateContext();
        ValidateResultCollection validateResults = validateContext.getValidateResults();
        List validateErrors = validateResults.getValidateErrors();
        if (validateErrors.isEmpty()) {
            ExtendedDataEntity[] extendedDataEntities = this.getDataEntities();
            DynamicObject dataEntity = extendedDataEntities[0].getDataEntity();
            String billFormId = dataEntity.getDataEntityType().getName();
            Long costBizObjId = CostCommonHelper.getCostCfgTypeIdByFormId((String)billFormId);
            boolean isAllowedSplit = CostCfgImportHelper.queryIsAllowedSplitById((Long)costBizObjId);
            for (ExtendedDataEntity extendedDataEntity : extendedDataEntities) {
                DynamicObject costCfgDy = extendedDataEntity.getDataEntity();
                DynamicObjectCollection costCfgEntryColl = costCfgDy.getDynamicObjectCollection("costcfgentryentity");
                boolean flag = this.validateCostCfgEntryInfo(extendedDataEntity, costCfgDy);
                if (!flag) {
                    return;
                }
                this.checkProportion(billFormId, isAllowedSplit, extendedDataEntity, costCfgEntryColl);
            }
        }
    }

    private void checkProportion(String billFormId, boolean isAllowedSplit, ExtendedDataEntity extendedDataEntity, DynamicObjectCollection costCfgEntryColl) {
        DynamicObject costCfgEntryDy;
        BigDecimal calCostProportion;
        BigDecimal costCfgTotal = BigDecimal.ZERO;
        if (isAllowedSplit) {
            for (DynamicObject costCfgEntryDy2 : costCfgEntryColl) {
                BigDecimal calCostProportion2 = costCfgEntryDy2.getBigDecimal("calcostproportion");
                if (calCostProportion2.compareTo(BigDecimal.ZERO) == 0) continue;
                costCfgTotal = costCfgTotal.add(calCostProportion2);
            }
        } else if (costCfgEntryColl != null && costCfgEntryColl.size() > 1) {
            String errorMsg = String.format(Locale.ROOT, ResManager.loadKDString((String)"%s\u4e0d\u652f\u6301\u6210\u672c\u5206\u62c6,\u6210\u672c\u8bbe\u7f6e\u767e\u5206\u6bd4\u5fc5\u987b\u8bbe\u7f6e\u4e3a100\u3002", (String)"CostCfgSaveValidator_12", (String)"swc-pcs-opplugin", (Object[])new Object[0]), billFormId);
            this.addFatalErrorMessage(extendedDataEntity, errorMsg);
        } else if (costCfgEntryColl != null && costCfgEntryColl.size() == 1 && new BigDecimal(100).compareTo(calCostProportion = (costCfgEntryDy = (DynamicObject)costCfgEntryColl.get(0)).getBigDecimal("calcostproportion")) != 0) {
            String errorMsg = String.format(Locale.ROOT, ResManager.loadKDString((String)"%s\u4e0d\u652f\u6301\u6210\u672c\u5206\u62c6,\u6210\u672c\u8bbe\u7f6e\u767e\u5206\u6bd4\u5fc5\u987b\u8bbe\u7f6e\u4e3a100\u3002", (String)"CostCfgSaveValidator_12", (String)"swc-pcs-opplugin", (Object[])new Object[0]), billFormId);
            this.addFatalErrorMessage(extendedDataEntity, errorMsg);
        }
        if (costCfgTotal.compareTo(new BigDecimal(100)) > 0) {
            this.addFatalErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u6210\u672c\u8bbe\u7f6e\u767e\u5206\u6bd4\u5927\u4e8e100%\uff0c\u8bf7\u66f4\u6b63\u540e\u91cd\u65b0\u4fdd\u5b58\u3002", (String)"CostCfgSaveValidator_1", (String)"swc-pcs-opplugin", (Object[])new Object[0]));
        }
    }

    private boolean validateCostCfgEntryInfo(ExtendedDataEntity extendedDataEntity, DynamicObject costCfgDy) {
        String name = costCfgDy.getDataEntityType().getName();
        if ("pcs_costitemcfg".equals(name)) {
            return this.validateCostItemCfgEntryInfo(extendedDataEntity, costCfgDy);
        }
        if ("pcs_costdeptcfg".equals(name)) {
            return this.validateCostDeptCfgEntryInfo(extendedDataEntity, costCfgDy);
        }
        return true;
    }

    private boolean validateCostItemCfgEntryInfo(ExtendedDataEntity extendedDataEntity, DynamicObject costCfgDy) {
        DynamicObjectCollection costCfgEntryDy = costCfgDy.getDynamicObjectCollection("costcfgentryentity");
        DynamicObjectCollection costCfgTypeEntryDy = costCfgDy.getDynamicObjectCollection("costcfgtypeentryentity");
        if (costCfgEntryDy.isEmpty() && costCfgTypeEntryDy.isEmpty()) {
            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u6210\u672c\u8bbe\u7f6e\u201d\u6216\u201c\u4f18\u5148\u6210\u672c\u8bbe\u7f6e\u201d\u3002", (String)"CostCfgSaveValidator_3", (String)"swc-pcs-opplugin", (Object[])new Object[0]));
            return false;
        }
        if (costCfgTypeEntryDy.size() > 1) {
            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u53ea\u5141\u8bb8\u8bbe\u7f6e\u4e00\u4e2a\u4f18\u5148\u6210\u672c\u8bbe\u7f6e\u3002", (String)"CostCfgSaveValidator_10", (String)"swc-pcs-opplugin", (Object[])new Object[0]));
            return false;
        }
        boolean costCfgFlag = this.validatorEntryInfo(extendedDataEntity, costCfgEntryDy, "calcostproportion", "coststrucfgvalue", "1");
        if (!costCfgFlag) {
            return false;
        }
        return this.validatorEntryInfo(extendedDataEntity, costCfgTypeEntryDy, "costcfgtypeproportion", "coststrutypecfgvalue", "2");
    }

    private boolean validateCostDeptCfgEntryInfo(ExtendedDataEntity extendedDataEntity, DynamicObject costCfgDy) {
        DynamicObjectCollection costCfgEntryDy = costCfgDy.getDynamicObjectCollection("costcfgentryentity");
        DynamicObjectCollection costCfgTypeEntryDy = costCfgDy.getDynamicObjectCollection("costcfgtypeentryentity");
        if (costCfgEntryDy.isEmpty() && costCfgTypeEntryDy.isEmpty()) {
            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u6210\u672c\u8bbe\u7f6e\u201d\u6216\u201c\u515c\u5e95\u6210\u672c\u8bbe\u7f6e\u201d\u3002", (String)"CostCfgSaveValidator_4", (String)"swc-pcs-opplugin", (Object[])new Object[0]));
            return false;
        }
        if (costCfgTypeEntryDy.size() > 1) {
            this.addErrorMessage(extendedDataEntity, ResManager.loadKDString((String)"\u53ea\u5141\u8bb8\u8bbe\u7f6e\u4e00\u4e2a\u515c\u5e95\u6210\u672c\u8bbe\u7f6e\u3002", (String)"CostCfgSaveValidator_11", (String)"swc-pcs-opplugin", (Object[])new Object[0]));
            return false;
        }
        return this.validatorEntryInfo(extendedDataEntity, costCfgEntryDy, "calcostproportion", "coststrucfgvalue", "1");
    }

    private boolean validatorEntryInfo(ExtendedDataEntity extendedDataEntity, DynamicObjectCollection costCfgTypeEntryDy, String proportionKey, String valueKey, String entryEntityType) {
        String entryEntityName = "";
        switch (entryEntityType) {
            case "1": {
                entryEntityName = ResManager.loadKDString((String)"\u201c\u6210\u672c\u8bbe\u7f6e\u201d", (String)"CostCfgSaveValidator_5", (String)"swc-pcs-opplugin", (Object[])new Object[0]);
                break;
            }
            case "2": {
                entryEntityName = ResManager.loadKDString((String)"\u201c\u4f18\u5148\u6210\u672c\u8bbe\u7f6e\u201d", (String)"CostCfgSaveValidator_6", (String)"swc-pcs-opplugin", (Object[])new Object[0]);
                break;
            }
            case "3": {
                entryEntityName = ResManager.loadKDString((String)"\u201c\u515c\u5e95\u6210\u672c\u8bbe\u7f6e\u201d", (String)"CostCfgSaveValidator_7", (String)"swc-pcs-opplugin", (Object[])new Object[0]);
                break;
            }
        }
        for (int i = 0; i < costCfgTypeEntryDy.size(); ++i) {
            DynamicObject costCfgEntryDy = (DynamicObject)costCfgTypeEntryDy.get(i);
            BigDecimal costCfgTypeProportion = costCfgEntryDy.getBigDecimal(proportionKey);
            String costStruTypeCfgValue = costCfgEntryDy.getString(valueKey);
            if (costStruTypeCfgValue.isEmpty()) {
                String errorInfo = ResManager.loadKDString((String)"\u8bf7\u586b\u5199{0}\u7b2c{1}\u884c:\u201c\u6210\u672c\u7ef4\u5ea6\u7ec4\u5408\u503c\u201d\u3002", (String)"CostCfgSaveValidator_8", (String)"swc-pcs-opplugin", (Object[])new Object[]{entryEntityName, i + 1});
                this.addErrorMessage(extendedDataEntity, errorInfo);
                return false;
            }
            if (BigDecimal.ZERO.compareTo(costCfgTypeProportion) != 0) continue;
            String errorInfo = ResManager.loadKDString((String)"\u8bf7\u586b\u5199{0}\u7b2c{1}\u884c:\u201c\u767e\u5206\u6bd4(%)\u201d\u3002", (String)"CostCfgSaveValidator_13", (String)"swc-pcs-opplugin", (Object[])new Object[]{entryEntityName, i + 1});
            this.addErrorMessage(extendedDataEntity, errorInfo);
            return false;
        }
        return true;
    }
}

