/*
 * Decompiled with CFR 0.152.
 */
package kd.sys.ricc.common.isc;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.sys.ricc.common.isc.IscCharBuffer;
import kd.sys.ricc.common.isc.IscCharReader;
import kd.sys.ricc.common.isc.IscObjectReader;
import kd.sys.ricc.common.isc.ReadLockFreeMap;
import kd.sys.ricc.common.util.Hex;
import kd.sys.ricc.common.util.StringUtils;
import kd.sys.ricc.exception.RiccBizException;

public class IscJson {
    public static final String BASE64_PREFIX = "data::base64encoded://";
    public static final int MAX_LEVEL = 64;
    public static final String JSON_PREFIX = "json:";
    public static final Object NULL = new Object();
    private static ReadLockFreeMap<Class<?>, Serializer> serializers = new ReadLockFreeMap();
    private static final Log logger = LogFactory.getLog(IscJson.class);

    public static void escape(String s, StringBuilder sb) {
        if (s == null) {
            sb.append("null");
        } else {
            sb.append('\"');
            if (s.startsWith(BASE64_PREFIX)) {
                sb.append(s);
            } else {
                IscJson.appendNormalString(s, sb);
            }
            sb.append('\"');
        }
    }

    private static void appendNormalString(String s, StringBuilder sb) {
        int j = s.length();
        block7: for (int i = 0; i < j; ++i) {
            char c = s.charAt(i);
            if (c > '\\') {
                sb.append(c);
                continue;
            }
            switch (c) {
                case '\t': {
                    sb.append("\\t");
                    continue block7;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block7;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block7;
                }
                case '\"': {
                    sb.append("\\\"");
                    continue block7;
                }
                case '\\': {
                    sb.append("\\\\");
                    continue block7;
                }
                default: {
                    sb.append(c);
                }
            }
        }
    }

    public static String toString(Object o) {
        return IscJson.toString(o, false);
    }

    public static String escapeHtml(Object o) {
        String s = IscJson.toString(o);
        if (s.indexOf(60) < 0) {
            return s;
        }
        int i = 0;
        int j = s.indexOf(60);
        StringBuilder sb = new StringBuilder();
        while (j > 0) {
            sb.append(s.substring(i, j));
            sb.append("<\"+\"");
            i = j + 1;
            j = s.indexOf(60, i);
        }
        if (i < s.length()) {
            sb.append(s.substring(i, s.length()));
        }
        return sb.toString();
    }

    public static String toString(Object o, boolean withoutBrackets) {
        String s;
        if (o instanceof String && (s = (String)o).startsWith(JSON_PREFIX)) {
            return s.substring(JSON_PREFIX.length());
        }
        StringBuilder sb = new StringBuilder();
        if (!withoutBrackets) {
            sb.append('(');
        }
        IscJson.toString(o, sb, 0);
        if (!withoutBrackets) {
            sb.append(')');
        }
        return sb.toString();
    }

    public static StringBuilder toString(Object o, StringBuilder buffer, int level) {
        if (level >= 64) {
            throw new RiccBizException("Collection or Map nested level is too deep, and there may be exist a recursive reference.");
        }
        if (o != null && o != NULL) {
            if (o instanceof Boolean) {
                return buffer.append(o);
            }
            if (o instanceof Number) {
                return IscJson.numberToString(o, buffer);
            }
            if (o instanceof CharSequence) {
                IscJson.escape(o.toString(), buffer);
                return buffer;
            }
            if (o instanceof byte[]) {
                String s = Hex.encode((byte[])o);
                buffer.append('\"').append(s).append('\"');
                return buffer;
            }
            if (o instanceof Object[]) {
                return IscJson.toString((Object[])o, buffer, level + 1);
            }
            if (o instanceof Collection) {
                return IscJson.toString((Collection)((Object)o), buffer, level + 1);
            }
            if (o.getClass().isArray()) {
                return IscJson.toString2(o, buffer, level + 1);
            }
            if (o instanceof Throwable) {
                o = IscJson.wrap((Throwable)((Object)o));
            }
            if (o instanceof Map) {
                return IscJson.toString(o, buffer, level + 1);
            }
            if (o instanceof Date) {
                return buffer.append('\"').append(o).append('\"');
            }
            if (o instanceof Time) {
                return buffer.append('\"').append(o).append('\"');
            }
            if (o instanceof java.util.Date) {
                return IscJson.dateToString((java.util.Date)((Object)o), buffer);
            }
            if (o instanceof Map.Entry) {
                return IscJson.entryToString((Map.Entry)((Object)o), buffer, level);
            }
            if (o instanceof IscObjectReader) {
                IscObjectReader reader = (IscObjectReader)((Object)o);
                return IscJson.readerToString(reader, buffer, level);
            }
            Serializer s = serializers.get(o.getClass());
            if (s != null) {
                buffer.append(s.toJson(o));
            } else {
                IscJson.escape(o.toString(), buffer);
            }
            return buffer;
        }
        return buffer.append("null");
    }

    private static StringBuilder readerToString(IscObjectReader<?> reader, StringBuilder buffer, int level) {
        StringBuilder var10;
        try {
            buffer.append('[');
            boolean first = true;
            Object item = reader.read();
            while (item != null) {
                if (first) {
                    first = false;
                } else {
                    buffer.append(',');
                }
                IscJson.toString(item, buffer, level + 1);
                item = reader.read();
            }
            buffer.append(']');
            var10 = buffer;
        }
        catch (Exception e) {
            throw new RiccBizException(e.getMessage(), e);
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (Exception e) {
                    logger.error("reader close error", (Throwable)e);
                }
            }
        }
        return var10;
    }

    private static StringBuilder entryToString(Map.Entry<?, ?> p, StringBuilder buffer, int level) {
        buffer.append('{');
        buffer.append("\"key\":");
        IscJson.toString(p.getKey(), buffer, level + 1);
        buffer.append(",\"value\":");
        IscJson.toString(p.getValue(), buffer, level + 1);
        buffer.append('}');
        return buffer;
    }

    private static StringBuilder dateToString(java.util.Date d, StringBuilder buffer) {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        return buffer.append('\"').append(df.format(d)).append('\"');
    }

    private static StringBuilder numberToString(Object o, StringBuilder buffer) {
        if (o instanceof BigDecimal) {
            return buffer.append('\"').append(((BigDecimal)o).toPlainString()).append('\"');
        }
        return !(o instanceof Integer) && !(o instanceof Byte) && !(o instanceof Short) && !(o instanceof Double) && !(o instanceof Float) ? buffer.append('\"').append(o).append('\"') : buffer.append(o).append(' ');
    }

    private static StringBuilder toString(Collection<?> l, StringBuilder buffer, int level) {
        buffer.append('[');
        boolean first = true;
        Iterator<?> it = l.iterator();
        while (it.hasNext()) {
            if (first) {
                first = false;
            } else {
                buffer.append(',');
            }
            IscJson.toString(it.next(), buffer, level + 1);
        }
        buffer.append(']');
        return buffer;
    }

    private static StringBuilder toString2(Object array, StringBuilder buffer, int level) {
        buffer.append('[');
        int len = Array.getLength(array);
        for (int i = 0; i < len; ++i) {
            if (i > 0) {
                buffer.append(',');
            }
            Object value = Array.get(array, i);
            IscJson.toString(value, buffer, level + 1);
        }
        buffer.append(']');
        return buffer;
    }

    private static StringBuilder toString(Object[] a, StringBuilder buffer, int level) {
        buffer.append('[');
        for (int i = 0; i < a.length; ++i) {
            if (i > 0) {
                buffer.append(',');
            }
            IscJson.toString(a[i], buffer, level + 1);
        }
        buffer.append(']');
        return buffer;
    }

    private static StringBuilder toString(Map<?, ?> m, StringBuilder buffer, int level) {
        buffer.append('{');
        boolean first = true;
        for (Map.Entry<?, ?> entry : m.entrySet()) {
            Object value = entry.getValue();
            if (first) {
                first = false;
            } else {
                buffer.append(',');
            }
            Object key = entry.getKey();
            IscJson.toString(key, buffer, level + 1);
            buffer.append(':');
            IscJson.toString(value, buffer, level + 1);
        }
        buffer.append('}');
        return buffer;
    }

    public static Object toObject(String json) {
        if (json != null && json.length() != 0) {
            StringReader sr = new StringReader(json);
            try {
                if (json.startsWith(JSON_PREFIX)) {
                    boolean srFlag = true;
                    while (srFlag) {
                        srFlag = sr.read() != 58;
                    }
                }
                return IscJson.toObject(sr);
            }
            catch (IOException var3) {
                throw new RiccBizException(var3);
            }
        }
        return null;
    }

    public static Object toObject(Reader sr) throws IOException {
        int i = sr.read();
        if (i == 65279) {
            i = sr.read();
        }
        if (i == 40) {
            i = sr.read();
        }
        switch (i) {
            case 34: 
            case 42: 
            case 45: 
            case 46: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 91: 
            case 102: 
            case 110: 
            case 116: 
            case 123: {
                IscCharBuffer cb = new IscCharBuffer();
                return IscJson.asObject(new IscCharReader(sr), i, cb);
            }
        }
        throw new RiccBizException("Invalid json format, unexpected char : " + (char)i + "(" + i + ")");
    }

    private static Object asObject(IscCharReader sr, int priorChar, IscCharBuffer cb) throws IOException {
        if (priorChar == 40) {
            priorChar = sr.read();
        }
        switch (priorChar) {
            case 34: {
                return IscJson.asString(sr, cb);
            }
            case 42: {
                return null;
            }
            case 45: 
            case 46: 
            case 48: 
            case 49: 
            case 50: 
            case 51: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 57: {
                return IscJson.asNumber(sr, priorChar, cb);
            }
            case 91: {
                return IscJson.asList(sr, cb);
            }
            case 102: 
            case 116: {
                return IscJson.asBoolean(sr);
            }
            case 110: {
                return IscJson.asNull(sr);
            }
            case 123: {
                return IscJson.asMap(sr, cb);
            }
        }
        throw new RiccBizException("invalid json format");
    }

    private static Object asNumber(IscCharReader sr, int priorChar, IscCharBuffer cb) throws IOException {
        String t;
        cb.clear();
        cb.append((char)priorChar);
        int c = sr.read();
        while (c >= 0 && c != 32) {
            if (c == 44 || c == 41 || c == 93 || c == 125 || c == 58) {
                sr.back(c);
                break;
            }
            cb.append((char)c);
            c = sr.read();
        }
        if ((t = cb.toString()).indexOf(46) >= 0) {
            return t.indexOf(69) <= 0 && t.indexOf(101) <= 0 ? new BigDecimal(t) : Double.valueOf(t);
        }
        if (t.length() > 18) {
            return new BigInteger(t);
        }
        return t.length() >= 9 ? Long.parseLong(t) : (long)Integer.parseInt(t);
    }

    private static Object asString(IscCharReader s, IscCharBuffer cb) throws IOException {
        cb.clear();
        int c = s.read();
        while (c >= 0) {
            block0 : switch (c) {
                case 34: {
                    return cb.toString();
                }
                case 92: {
                    c = s.read();
                    switch (c) {
                        case 34: {
                            cb.append('\"');
                            break block0;
                        }
                        case 39: {
                            cb.append('\'');
                            break block0;
                        }
                        case 47: {
                            cb.append('/');
                            break block0;
                        }
                        case 92: {
                            cb.append('\\');
                            break block0;
                        }
                        case 110: {
                            cb.append('\n');
                            break block0;
                        }
                        case 114: {
                            cb.append('\r');
                            break block0;
                        }
                        case 116: {
                            cb.append('\t');
                            break block0;
                        }
                    }
                    throw new RiccBizException("\\" + (char)c + " is not valid char.");
                }
                default: {
                    cb.append((char)c);
                }
            }
            c = s.read();
        }
        return cb.length() > 0 ? cb.toString() : null;
    }

    private static Object asNull(IscCharReader s) throws IOException {
        s.read();
        s.read();
        s.read();
        return null;
    }

    private static Object asBoolean(IscCharReader s) throws IOException {
        s.read();
        s.read();
        int i = s.read();
        if (i == 101) {
            return Boolean.TRUE;
        }
        s.read();
        return Boolean.FALSE;
    }

    private static ArrayList<Object> asList(IscCharReader s, IscCharBuffer cb) throws IOException {
        ArrayList<Object> list = new ArrayList<Object>();
        int c = s.read();
        block5: while (c >= 0) {
            switch (c) {
                case 34: 
                case 42: 
                case 45: 
                case 46: 
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: 
                case 91: 
                case 102: 
                case 110: 
                case 116: 
                case 123: {
                    list.add(IscJson.asObject(s, c, cb));
                    c = s.read();
                    continue block5;
                }
                default: {
                    throw new RiccBizException("char {" + (char)c + "} is an invalid char.");
                }
                case 40: 
                case 41: 
                case 44: {
                    c = s.read();
                    continue block5;
                }
                case 93: 
            }
            return list;
        }
        return list;
    }

    private static LinkedHashMap<Object, Object> asMap(IscCharReader s, IscCharBuffer cb) throws IOException {
        LinkedHashMap<Object, Object> map = new LinkedHashMap<Object, Object>();
        int c = s.read();
        block5: while (c >= 0) {
            switch (c) {
                case 34: 
                case 42: 
                case 45: 
                case 46: 
                case 48: 
                case 49: 
                case 50: 
                case 51: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 57: 
                case 91: 
                case 102: 
                case 110: 
                case 116: 
                case 123: {
                    Object key = IscJson.asObject(s, c, cb);
                    s.read();
                    Object value = IscJson.asObject(s, s.read(), cb);
                    map.put(key, value);
                    c = s.read();
                    continue block5;
                }
                default: {
                    throw new RiccBizException("char {" + (char)c + "} is an invalid char.");
                }
                case 40: 
                case 41: 
                case 44: {
                    c = s.read();
                    continue block5;
                }
                case 125: 
            }
            return map;
        }
        return map;
    }

    public static boolean isInteger(String name) {
        for (int i = 1; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (IscJson.isDigital(c)) continue;
            return false;
        }
        return true;
    }

    public static boolean isSpace(char c) {
        return c <= ' ';
    }

    public static boolean isLetterOrDigital(char c) {
        return IscJson.isLetter(c) || IscJson.isDigital(c);
    }

    public static boolean isLetter(char c) {
        return c == '_' || c == '$' || c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z';
    }

    public static boolean isDigital(char c) {
        return c >= '0' && c <= '9';
    }

    public static Map<String, Object> wrap(Throwable e) {
        String code;
        HashMap<String, Object> data = new HashMap<String, Object>();
        String message = e.getMessage();
        if (message == null) {
            message = e.getClass().getName();
        }
        data.put("#message", message);
        if (e instanceof RiccBizException && (code = ((RiccBizException)e).getCode()) != null) {
            data.put("#code", code);
        }
        data.put("#stack_trace", StringUtils.toString(e));
        return data;
    }

    public static <T> T copy(T value) {
        if (value == null) {
            return null;
        }
        if (value instanceof List) {
            return (T)IscJson.copyList((List)value);
        }
        if (value instanceof Set) {
            return (T)IscJson.copySet((Set)value);
        }
        if (value instanceof Map) {
            return (T)IscJson.copyMap((Map)value);
        }
        return (T)(value instanceof Object[] ? IscJson.copyArray((Object[])value) : value);
    }

    private static Object[] copyArray(Object[] value) {
        return Arrays.copyOf(value, value.length);
    }

    private static Map<?, ?> copyMap(Map<?, ?> value) {
        LinkedHashMap map = new LinkedHashMap(value.size());
        for (Map.Entry<?, ?> e : value.entrySet()) {
            map.put(e.getKey(), IscJson.copy(e.getValue()));
        }
        return map;
    }

    private static Set<?> copySet(Set<?> value) {
        HashSet set = new HashSet(value.size());
        set.addAll(value);
        return set;
    }

    private static List<?> copyList(List<?> value) {
        ArrayList list = new ArrayList(value.size());
        for (Object item : value) {
            list.add(IscJson.copy(item));
        }
        return list;
    }

    public static void register(Serializer s) {
        serializers.put(s.getTargetClass(), s);
    }

    public static interface Serializer {
        public Class<?> getTargetClass();

        public String toJson(Object var1);
    }
}

