/*
 * Decompiled with CFR 0.152.
 */
package kd.sys.ricc.common.log;

import kd.sys.ricc.common.log.AbstractLogRecord;
import kd.sys.ricc.common.util.CommonUtil;
import kd.sys.ricc.common.util.StringUtils;

public class LogRecorder
extends AbstractLogRecord {
    private static final long serialVersionUID = -6712451834532935337L;
    private StringBuffer message = new StringBuffer();
    private StringBuffer devMessage = new StringBuffer();
    private String entryLogs;

    public String getEntryLogs() {
        return this.entryLogs;
    }

    public void setEntryLogs(String entryLogs) {
        this.entryLogs = entryLogs;
    }

    @Override
    public LogRecorder append(String errorMsg) {
        this.message.append(errorMsg);
        return this;
    }

    @Override
    public LogRecorder insert(int pos, String str) {
        this.message.insert(pos, str);
        return this;
    }

    @Override
    public LogRecorder append(Object obj) {
        this.message.append(String.valueOf(obj));
        return this;
    }

    @Override
    public AbstractLogRecord appendDev(String devErrorMsg) {
        this.devMessage.append(devErrorMsg);
        return this;
    }

    public void setMessage(StringBuffer message) {
        this.message = message;
    }

    public void setMessage(String message) {
        this.message.append(message);
    }

    public void setDevMessage(StringBuffer devMessage) {
        this.devMessage = devMessage;
    }

    public void setDevMessage(String devMessage) {
        this.devMessage.append(devMessage);
    }

    public StringBuffer getMessage() {
        return this.message;
    }

    public StringBuffer getDevMessage() {
        return this.devMessage;
    }

    @Override
    public String getMessageStr() {
        return this.message.toString();
    }

    @Override
    public String getDevMessageStr() {
        return this.devMessage.toString();
    }

    @Override
    public LogRecorder append(String errorMsg, Throwable exception) {
        this.message.append(errorMsg);
        if (exception != null) {
            if (exception.getMessage() != null) {
                this.message.append(exception.getMessage());
            }
            this.devMessage.append(errorMsg).append(CommonUtil.getExceptionDetailInfo(exception));
        }
        return this;
    }

    @Override
    public LogRecorder append(String errorMsg, String devErrorMsg) {
        this.message.append(errorMsg);
        if (StringUtils.isNotEmpty(devErrorMsg)) {
            this.devMessage.append(errorMsg).append(devErrorMsg);
        }
        return this;
    }

    public int length() {
        return this.message.length();
    }
}

