/*
 * Decompiled with CFR 0.152.
 */
package kd.sys.ricc.common.query;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.BasedataEntityType;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.sys.ricc.common.util.StringUtils;
import kd.sys.ricc.common.util.SysParaUtil;
import kd.sys.ricc.exception.RiccBizException;

public class CommonQuery {
    private static final Log log = LogFactory.getLog(CommonQuery.class);

    private CommonQuery() {
        throw new IllegalStateException("Utility class");
    }

    public static DynamicObject[] getControlledItems() {
        QFilter qFilter = new QFilter("controlled", "=", (Object)Boolean.TRUE).and(new QFilter("enable", "=", (Object)"1"));
        return BusinessDataServiceHelper.load((String)"ricc_configitems", (String)"id,number,name,rightpage,controlled", (QFilter[])qFilter.toArray());
    }

    public static long getDefaultDataCenter() {
        long dataCenter = 0L;
        QFilter[] qfitlters = new QFilter[]{new QFilter("isdefault", "=", (Object)"1").and("enable", "=", (Object)Boolean.TRUE)};
        DynamicObject defaultDataCenter = BusinessDataServiceHelper.loadSingle((String)"ricc_destaccount", (String)"number", (QFilter[])qfitlters);
        if (!Objects.isNull(defaultDataCenter)) {
            dataCenter = (Long)defaultDataCenter.get("id");
        } else {
            QFilter enableFilter = new QFilter("enable", "=", (Object)Boolean.TRUE);
            DynamicObject destAccountDyo = QueryServiceHelper.queryOne((String)"ricc_destaccount", (String)"id", (QFilter[])enableFilter.toArray());
            if (destAccountDyo != null) {
                dataCenter = destAccountDyo.getLong("id");
            }
        }
        return dataCenter;
    }

    public static String getCurrentUserPhone() {
        long currentUserId = UserServiceHelper.getCurrentUserId();
        String phone = "";
        QFilter[] idFilter = new QFilter[]{new QFilter("id", "=", (Object)currentUserId)};
        DynamicObject currentUser = BusinessDataServiceHelper.loadSingle((String)"bos_user", (String)"phone", (QFilter[])idFilter);
        if (!Objects.isNull(currentUser)) {
            phone = currentUser.getString("phone");
        }
        return phone;
    }

    public static String getTransferLatestUserPhone(long centerId) {
        long currentUserId = UserServiceHelper.getCurrentUserId();
        String phone = "";
        QFilter[] idFilter = new QFilter[]{new QFilter("opuser.id", "=", (Object)currentUserId), new QFilter("targetdatacenter", "=", (Object)centerId)};
        DynamicObject[] currentUser = BusinessDataServiceHelper.load((String)"ricc_log", (String)"targetdatacenteruser", (QFilter[])idFilter, (String)"optime desc", (int)1);
        phone = !Objects.isNull(currentUser) && currentUser.length > 0 ? currentUser[0].getString("targetdatacenteruser") : CommonQuery.getCurrentUserPhone();
        return phone;
    }

    public static ListSelectedRowCollection getAllSelectData(String entityNumber, String filters) {
        QFilter qFilterPk = null;
        if (filters != null) {
            qFilterPk = QFilter.fromSerializedString((String)filters);
        }
        return CommonQuery.getAllSelectData(entityNumber, qFilterPk, false, null, Collections.emptySet());
    }

    public static ListSelectedRowCollection getAllSelectData(String entityNumber, QFilter qFilterPk, boolean isQueryCreateOrg, List<Map<String, Object>> customParam, Set<String> keyFieldSet) {
        boolean isOverPackLimit;
        IDataEntityProperty createOrgProp;
        BillEntityType billEntityType;
        IDataEntityProperty property;
        ListSelectedRowCollection rows = new ListSelectedRowCollection();
        StringBuilder selectFields = new StringBuilder("id");
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        String number = "";
        String name = "";
        String createOrg = "";
        DataEntityPropertyCollection properties = entityType.getProperties();
        LinkedHashSet<String> fields = new LinkedHashSet<String>(4);
        if (entityType instanceof BasedataEntityType) {
            BasedataEntityType basedataEntityType = (BasedataEntityType)entityType;
            number = basedataEntityType.getNumberProperty();
            name = basedataEntityType.getNameProperty();
        } else if (entityType instanceof BillEntityType && (property = (IDataEntityProperty)properties.get((Object)(number = (billEntityType = (BillEntityType)entityType).getBillNo()))) != null && StringUtils.isBlank(property.getAlias())) {
            number = "";
        }
        if (isQueryCreateOrg && properties.containsKey((Object)"createorg") && StringUtils.isNotBlank((createOrgProp = (IDataEntityProperty)properties.get((Object)"createorg")).getAlias())) {
            createOrg = createOrgProp.getName();
            fields.add(createOrg);
        }
        fields.add(number);
        fields.add(name);
        fields.add(createOrg);
        fields.addAll(keyFieldSet);
        fields.stream().filter(StringUtils::isNotBlank).forEach(y -> selectFields.append(',').append((String)y));
        log.info("\u914d\u7f6e\u9879 {} \u6253\u5305 \u67e5\u8be2\u5b57\u6bb5\u4e3a\uff1a{} ", (Object)entityNumber, (Object)selectFields);
        DynamicObject[] queryDataArr = StringUtils.isNotBlank(number) ? BusinessDataServiceHelper.load((String)entityNumber, (String)selectFields.toString(), (QFilter[])(qFilterPk == null ? new QFilter[]{} : qFilterPk.toArray()), (String)(number + " asc")) : BusinessDataServiceHelper.load((String)entityNumber, (String)selectFields.toString(), (QFilter[])(qFilterPk == null ? new QFilter[]{} : qFilterPk.toArray()));
        log.info("\u6253\u5305\u6570\u636e\u91cf\u4e3a {}", (Object)queryDataArr.length);
        int packDataLimit = SysParaUtil.getPackDataLimit();
        boolean bl = isOverPackLimit = queryDataArr.length > packDataLimit;
        if (isOverPackLimit) {
            String msg = ResManager.loadKDString((String)"\u6279\u91cf\u6253\u5305\u65f6\u6570\u636e\u91cf\u4e0d\u80fd\u8d85\u8fc7%d, \u8bf7\u8fc7\u6ee4\u6570\u636e\u5206\u6279\u6253\u5305\u6216\u8054\u7cfb\u7ba1\u7406\u5458\u8c03\u6574\u9650\u5236", (String)"CommonQuery_0", (String)"sys-ricc-common", (Object[])new Object[0]);
            throw new RiccBizException(String.format(msg, packDataLimit));
        }
        for (DynamicObject queryData : queryDataArr) {
            ListSelectedRow row = new ListSelectedRow();
            if (Objects.nonNull(customParam)) {
                Map<String, Object> oneDate = CommonQuery.getOneDateMap(keyFieldSet, number, name, properties, createOrg, queryData);
                customParam.add(oneDate);
            }
            row.setPrimaryKeyValue(queryData.get("id"));
            row.setNumber(StringUtils.isBlank(number) ? number : queryData.getString(number));
            row.setName(StringUtils.isBlank(name) ? name : queryData.getString(name));
            rows.add((Object)row);
        }
        return rows;
    }

    private static Map<String, Object> getOneDateMap(Set<String> keyFieldSet, String number, String name, DataEntityPropertyCollection properties, String createOrg, DynamicObject queryData) {
        DynamicObject valueDy;
        HashMap<String, Object> oneDate = new HashMap<String, Object>(8);
        oneDate.put("id", queryData.get("id"));
        oneDate.put("number", StringUtils.isBlank(number) ? number : queryData.getString(number));
        oneDate.put("name", StringUtils.isBlank(name) ? name : queryData.getString(name));
        String value = StringUtils.isBlank(createOrg) ? "" : ((valueDy = queryData.getDynamicObject(createOrg)) == null ? "" : valueDy.getString("name"));
        oneDate.put("createorg", value);
        for (String key : keyFieldSet) {
            Object keyFieldsValue;
            IDataEntityProperty prop = (IDataEntityProperty)properties.get((Object)key);
            if (prop instanceof MuliLangTextProp) {
                keyFieldsValue = ((Map)queryData.get(key)).get("zh_CN");
            } else if (prop instanceof BasedataProp) {
                DynamicObject dyValue = (DynamicObject)queryData.get(key);
                if (dyValue == null) {
                    log.info("\u6570\u636e {} \u7684{}\u5b57\u6bb5\u4e3anull", queryData.getPkValue(), (Object)key);
                    continue;
                }
                keyFieldsValue = dyValue.get("id");
            } else {
                keyFieldsValue = queryData.get(key);
            }
            if (StringUtils.equals("createorg", key)) {
                oneDate.put(key + "_" + "id", keyFieldsValue);
                continue;
            }
            oneDate.put(key, keyFieldsValue);
        }
        return oneDate;
    }
}

