/*
 * Decompiled with CFR 0.152.
 */
package kd.sys.ricc.common.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.net.ConnectException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bos.bill.BillShowParameter;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.FormConfig;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.bill.BillViewForWebApi;
import kd.bos.service.DispatchService;
import kd.bos.service.lookup.ServiceLookup;
import kd.sys.ricc.common.util.SSLClient;
import kd.sys.ricc.common.util.StringUtils;
import kd.sys.ricc.exception.RiccBizException;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.message.BasicHeader;
import org.apache.http.util.EntityUtils;

public class ApiUtil {
    private static final Log logger = LogFactory.getLog(ApiUtil.class);
    private static final String APPID = "ricc";
    private static final String API_TRANSFER = "transfer";
    private static final String APP_TOKEN = "app_token";
    private static final String ACCESS_TOKEN = "access_token";
    public static final String RICC_SERVICE_FACTORY = "kd.bamp.ricc.servicehelper.ServiceFactory";
    public static final String CONTENT_TYPE = "Content-Type";
    public static final String APPLICATION_JSON_CHARSET_UTF_8 = "application/json; charset=UTF-8";

    private ApiUtil() {
    }

    public static String transfer(Map<String, String> data, Map<String, Object> loginParam) {
        String accessToken = ApiUtil.doLogin(loginParam);
        String url = loginParam.get("evnurl") + "/kapi/app/" + APPID + "/" + API_TRANSFER + "?access_token=" + accessToken;
        data.put("apiName", API_TRANSFER);
        data.put("lang", RequestContext.getOrCreate().getLang().getLocale().toString());
        String jsonStr = JSON.toJSONString(data);
        return ApiUtil.doPostByHttpClient(url, jsonStr);
    }

    public static String getDestAccountData(Map<String, Object> data, Map<String, Object> loginParam, String type) {
        String accessToken = ApiUtil.doLogin(loginParam);
        data.put("bizType", type);
        data.put("lang", RequestContext.getOrCreate().getLang().getLocale().toString());
        String url = loginParam.get("evnurl") + "/kapi/v2/" + APPID + "/openApi/dataCompare/getTargetData?access_token=" + accessToken;
        String jsonStr = JSON.toJSONString(data);
        return ApiUtil.doPostByHttpClient(url, jsonStr);
    }

    public static String getDestAccountMetaLogData(Map<String, Object> data, Map<String, Object> loginParam, String type) {
        String accessToken = ApiUtil.doLogin(loginParam);
        data.put("bizType", type);
        data.put("lang", RequestContext.getOrCreate().getLang().getLocale().toString());
        String url = loginParam.get("evnurl") + "/kapi/v2/" + APPID + "/openApi/data/obtainData?access_token=" + accessToken;
        String jsonStr = JSON.toJSONString(data);
        return ApiUtil.doPostByHttpClient(url, jsonStr);
    }

    public static String doLogin(Map<String, Object> loginParam) {
        String phoneNumber = (String)loginParam.get("targetdatacenteruser");
        String number = (String)loginParam.get("accountId");
        String evnurl = (String)loginParam.get("evnurl");
        String appsecuret = (String)loginParam.get("appsecuret");
        Map<String, Object> mapAppToken = ApiUtil.getAppToken(number, evnurl, appsecuret);
        String appToken = (String)((Map)mapAppToken.get("data")).get(APP_TOKEN);
        Map<String, Object> mapUserToken = ApiUtil.getAccessToken(phoneNumber, number, evnurl, appToken);
        return (String)((Map)mapUserToken.get("data")).get(ACCESS_TOKEN);
    }

    public static Map<String, Object> getAccessToken(String phoneNumber, String number, String evnurl, String appToken) {
        String url = evnurl + "/api/login.do?language=" + RequestContext.getOrCreate().getLang().getLocale().toString();
        HashMap<String, String> param = new HashMap<String, String>(5);
        param.put("user", phoneNumber);
        param.put("apptoken", appToken);
        param.put("accountId", number);
        param.put("usertype", "Mobile");
        String data = JSON.toJSONString(param);
        String response = ApiUtil.doPostByHttpClient(url, data);
        Map mapUserToken = (Map)JSON.parseObject((String)response, Map.class);
        if (!StringUtils.equals((String)mapUserToken.get("state"), "success")) {
            logger.info("\u83b7\u53d6access_token\u5931\u8d25\uff01" + url + data);
            throw new RiccBizException(String.format(ResManager.loadKDString((String)"\u83b7\u53d6accessToken\u5931\u8d25\uff1a%s", (String)"ApiUtil_21", (String)"sys-ricc-common", (Object[])new Object[0]), mapUserToken.get("errorMsg")));
        }
        return mapUserToken;
    }

    public static Map<String, Object> getAppToken(String accountId, String evnUrl, String appSecuret) {
        String url = evnUrl + "/api/getAppToken.do?language=" + RequestContext.getOrCreate().getLang().getLocale().toString();
        HashMap<String, String> param = new HashMap<String, String>(5);
        param.put("appId", APPID);
        param.put("appSecuret", appSecuret);
        param.put("accountId", accountId);
        String data = JSON.toJSONString(param);
        String response = ApiUtil.doPostByHttpClient(url, data);
        Map mapAppToken = (Map)JSON.parseObject((String)response, Map.class);
        if (!StringUtils.equals((String)mapAppToken.get("state"), "success")) {
            logger.info("\u83b7\u53d6app_token\u5931\u8d25\uff01" + url + data);
            throw new RiccBizException(String.format(ResManager.loadKDString((String)"\u83b7\u53d6appToken\u5931\u8d25\uff1a%s", (String)"ApiUtil_22", (String)"sys-ricc-common", (Object[])new Object[0]), mapAppToken.get("errorMsg")));
        }
        return mapAppToken;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String doPostByHttpClient(String url, String data) {
        try (Object httpClient = url.toLowerCase(Locale.ENGLISH).startsWith("https://") ? new SSLClient() : HttpClients.createDefault();){
            HttpPost httpPost = ApiUtil.buildHttpPost(url);
            httpPost.addHeader(CONTENT_TYPE, APPLICATION_JSON_CHARSET_UTF_8);
            StringEntity se = new StringEntity(data, "UTF-8");
            se.setContentType("text/json");
            se.setContentEncoding((Header)new BasicHeader(CONTENT_TYPE, APPLICATION_JSON_CHARSET_UTF_8));
            httpPost.setEntity((HttpEntity)se);
            CloseableHttpResponse response = httpClient.execute((HttpUriRequest)httpPost);
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode != 200) {
                String outUrl = url;
                int index = url.indexOf(ACCESS_TOKEN);
                if (index != -1) {
                    outUrl = url.substring(0, index);
                }
                throw new RiccBizException(String.format(ResManager.loadKDString((String)"%n\u8fde\u63a5\u76ee\u6807\u82cd\u7a79\u670d\u52a1\u5668\u53d1\u751f\u9519\u8bef: %n%1$s%n \u8bbf\u95ee\u5730\u5740\uff1a%2$s", (String)"ApiUtil_23", (String)"sys-ricc-common", (Object[])new Object[0]), response, outUrl));
            }
            String string = EntityUtils.toString((HttpEntity)response.getEntity());
            return string;
        }
        catch (RiccBizException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RiccBizException(String.format(ResManager.loadKDString((String)"\u8fde\u63a5\u76ee\u6807\u82cd\u7a79\u670d\u52a1\u5668\u53d1\u751f\u5f02\u5e38\uff1a%s", (String)"ApiUtil_24", (String)"sys-ricc-common", (Object[])new Object[0]), e.getMessage()), e);
        }
    }

    private static HttpPost buildHttpPost(String url) {
        return new HttpPost(url);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String doGetByHttpClient(String url) {
        try (Object httpClient = url.toLowerCase(Locale.ENGLISH).startsWith("https://") ? new SSLClient() : HttpClients.createDefault();){
            URIBuilder uriBuilder = new URIBuilder(url);
            RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(10000).setConnectionRequestTimeout(10000).setSocketTimeout(10000).build();
            HttpUriRequest httpGet = RequestBuilder.get((URI)uriBuilder.build()).setConfig(requestConfig).addHeader(CONTENT_TYPE, APPLICATION_JSON_CHARSET_UTF_8).build();
            CloseableHttpResponse response = httpClient.execute(httpGet);
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode != 200) {
                logger.error(EntityUtils.toString((HttpEntity)response.getEntity()));
                throw new RiccBizException(String.format(ResManager.loadKDString((String)"\u8fde\u63a5\u670d\u52a1\u5668\u53d1\u751f\u9519\u8bef\uff01\u9519\u8bef\u4ee3\u7801\u4e3a%s", (String)"ApiUtil_25", (String)"sys-ricc-common", (Object[])new Object[0]), statusCode));
            }
            String string = EntityUtils.toString((HttpEntity)response.getEntity());
            return string;
        }
        catch (ConnectException e) {
            logger.error("\u7f51\u7edc\u8fde\u63a5\u8d85\u65f6\uff0c\u8bf7\u68c0\u67e5\u5f55\u5165\u7684\u73af\u5883\u5730\u5740\u662f\u5426\u6b63\u786e\uff0c\u6216\u8054\u7cfb\u7ba1\u7406\u5458\u68c0\u67e5\u5f53\u524d\u73af\u5883\u4e0e\u76ee\u6807\u73af\u5883\u7f51\u7edc\u8fde\u63a5\u662f\u5426\u6b63\u5e38\u3002", (Throwable)e);
            throw new RiccBizException(String.format(ResManager.loadKDString((String)"\u7f51\u7edc\u8fde\u63a5\u8d85\u65f6\uff0c\u8bf7\u68c0\u67e5\u5f55\u5165\u7684\u73af\u5883\u5730\u5740\u662f\u5426\u6b63\u786e\uff0c\u6216\u8054\u7cfb\u7ba1\u7406\u5458\u68c0\u67e5\u5f53\u524d\u73af\u5883\u4e0e\u76ee\u6807\u73af\u5883\u7f51\u7edc\u8fde\u63a5\u662f\u5426\u6b63\u5e38\u3002%s", (String)"ApiUtil_29", (String)"sys-ricc-common", (Object[])new Object[0]), ApiUtil.getEvnUrlMessage()), e);
        }
        catch (URISyntaxException | UnknownHostException e) {
            logger.error("\u4e0d\u6b63\u786e\u7684\u76ee\u6807\u73af\u5883\u5730\u5740\uff0c\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u76ee\u6807\u73af\u5883\u5730\u5740\u3002", (Throwable)e);
            throw new RiccBizException(String.format(ResManager.loadKDString((String)"\u4e0d\u6b63\u786e\u7684\u76ee\u6807\u73af\u5883\u5730\u5740\uff0c\u8bf7\u8f93\u5165\u6b63\u786e\u7684\u76ee\u6807\u73af\u5883\u5730\u5740\u3002%s", (String)"ApiUtil_30", (String)"sys-ricc-common", (Object[])new Object[0]), ApiUtil.getEvnUrlMessage()), e);
        }
        catch (Exception e) {
            logger.error("\u672a\u68c0\u6d4b\u5230\u76ee\u6807\u6570\u636e\u4e2d\u5fc3\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5\u5f55\u5165\u7684\u73af\u5883\u5730\u5740\u662f\u5426\u6b63\u786e\u6216\u73af\u5883\u662f\u5426\u670d\u52a1\u5f02\u5e38\u3002", (Throwable)e);
            throw new RiccBizException(String.format(ResManager.loadKDString((String)"\u672a\u68c0\u6d4b\u5230\u76ee\u6807\u6570\u636e\u4e2d\u5fc3\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5\u5f55\u5165\u7684\u73af\u5883\u5730\u5740\u662f\u5426\u6b63\u786e\u6216\u73af\u5883\u662f\u5426\u670d\u52a1\u5f02\u5e38\u3002%s", (String)"ApiUtil_31", (String)"sys-ricc-common", (Object[])new Object[0]), ApiUtil.getEvnUrlMessage()), e);
        }
    }

    public static IFormView createViewForApi(String formId, String app) {
        HashMap<String, Object> openParameter = new HashMap<String, Object>(8);
        openParameter.put("formId", formId);
        openParameter.put("type", "bos_dynamicform");
        openParameter.put("billFormId", "bos_dynamicform");
        openParameter.put("linkQueryPkIds", new ArrayList());
        openParameter.put("linkQueryPkIdIntervals", new ArrayList());
        openParameter.put("pkId", "");
        openParameter.put("Status", "VIEW");
        openParameter.put("app", app);
        BillShowParameter billShowParameter = new BillShowParameter();
        BillViewForWebApi formView = (BillViewForWebApi)billShowParameter.createViewForWebApi();
        FormShowParameter formShowParameter = FormShowParameter.createFormShowParameter(openParameter);
        FormConfig formConfig = new FormConfig();
        formConfig.setEntityTypeId("ricc_datapacket");
        formShowParameter.setFormConfig(formConfig);
        formView.initialize(formShowParameter);
        return formView;
    }

    public static IFormView createViewForApi() {
        return ApiUtil.createViewForApi("ricc_datapacket", "bos");
    }

    public static Object invokeRiccServiceByAppId(String appId, String serviceName, String methodName, Object ... params) {
        DispatchService dispatchService = (DispatchService)ServiceLookup.lookup(DispatchService.class, (String)appId);
        return dispatchService.invoke(RICC_SERVICE_FACTORY, serviceName, methodName, params);
    }

    public static List<JSONObject> getDestDataCenterList(String evnUrl) {
        List retList = null;
        String url = evnUrl + "/auth/getAllDatacenters.do";
        String response = ApiUtil.doGetByHttpClient(url);
        try {
            retList = (List)JSON.parseObject((String)response, List.class);
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u76ee\u6807\u6570\u636e\u4e2d\u5fc3\u8d26\u5957\u5931\u8d25,\u8bf7\u68c0\u67e5\u5f55\u5165\u7684\u73af\u5883\u5730\u5740\u662f\u5426\u6b63\u786e\u6216\u73af\u5883\u662f\u5426\u670d\u52a1\u5f02\u5e38\u3002" + url, (Throwable)e);
            throw new RiccBizException(String.format(ResManager.loadKDString((String)"\u83b7\u53d6\u76ee\u6807\u6570\u636e\u4e2d\u5fc3\u8d26\u5957\u5931\u8d25,\u8bf7\u68c0\u67e5\u5f55\u5165\u7684\u73af\u5883\u5730\u5740\u662f\u5426\u6b63\u786e\u6216\u73af\u5883\u662f\u5426\u670d\u52a1\u5f02\u5e38\u3002%s", (String)"ApiUtil_26", (String)"sys-ricc-common", (Object[])new Object[0]), ApiUtil.getEvnUrlMessage()), e);
        }
        for (JSONObject ret : retList) {
            String accountId = ret.getString("accountId");
            if (!StringUtils.isBlank(accountId)) continue;
            throw new RiccBizException(String.format(ResManager.loadKDString((String)"\u672a\u68c0\u6d4b\u5230\u76ee\u6807\u6570\u636e\u4e2d\u5fc3\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5\u5f55\u5165\u7684\u73af\u5883\u5730\u5740\u662f\u5426\u6b63\u786e\u6216\u73af\u5883\u662f\u5426\u670d\u52a1\u5f02\u5e38\u3002%s", (String)"ApiUtil_31", (String)"sys-ricc-common", (Object[])new Object[0]), ApiUtil.getEvnUrlMessage()));
        }
        return retList;
    }

    public static String getDestDataCenterStr(String evnUrl) {
        List<JSONObject> dataCenterList = ApiUtil.getDestDataCenterList(evnUrl);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(evnUrl);
        stringBuilder.append(ResManager.loadKDString((String)"\u73af\u5883\u6570\u636e\u4e2d\u5fc3\u4fe1\u606f", (String)"ApiUtil_27", (String)"sys-ricc-common", (Object[])new Object[0])).append('\n');
        stringBuilder.append(ResManager.loadKDString((String)"\u6570\u636e\u4e2d\u5fc3id---------\u6570\u636e\u4e2d\u5fc3\u540d\u79f0", (String)"ApiUtil_28", (String)"sys-ricc-common", (Object[])new Object[0])).append('\n');
        for (JSONObject oneCeneter : dataCenterList) {
            stringBuilder.append(oneCeneter.getString("accountId"));
            stringBuilder.append("---------");
            stringBuilder.append(oneCeneter.getString("accountName"));
            stringBuilder.append('\n');
        }
        return stringBuilder.toString();
    }

    private static String getEvnUrlMessage() {
        return String.format(ResManager.loadKDString((String)"\u73af\u5883\u5730\u5740\u7684\u5f55\u5165\u8bf7\u53c2\u8003\u793e\u533a\u6587\u6863\uff1a%1$s%2$s", (String)"ApiUtil_32", (String)"sys-ricc-common", (Object[])new Object[0]), System.lineSeparator(), "https://vip.kingdee.com/article/485100837476354048");
    }
}

