/*
 * Decompiled with CFR 0.152.
 */
package kd.sys.ricc.common.util;

import java.util.ArrayList;
import java.util.List;

public class BatchSplitUtil {
    private static final int DEFAULT_LIMIT = 1000;

    public static <T> void handle(List<T> srcList, int batchSize, IBaseBatchHandler handler) {
        List<List<T>> partitionList = BatchSplitUtil.splitBatch(srcList, batchSize);
        for (List<T> list : partitionList) {
            handler.handle(list);
        }
    }

    public static <T> List<List<T>> splitBatch(List<T> selectedRows, int billBatchSize) {
        List<T> subSelectedRows;
        if (billBatchSize <= 0) {
            billBatchSize = 1000;
        }
        int selectedSize = selectedRows.size();
        ArrayList<List<T>> selectedRowsGroups = new ArrayList<List<T>>(1);
        if (selectedSize <= billBatchSize) {
            selectedRowsGroups.add(selectedRows.subList(0, selectedSize));
            return selectedRowsGroups;
        }
        for (int subBatchAllCount = 0; subBatchAllCount < selectedSize; subBatchAllCount += subSelectedRows.size()) {
            subSelectedRows = selectedRows.subList(subBatchAllCount, Math.min(billBatchSize + subBatchAllCount, selectedSize));
            selectedRowsGroups.add(subSelectedRows);
        }
        return selectedRowsGroups;
    }

    @FunctionalInterface
    public static interface IBaseBatchHandler<T> {
        public void handle(List<T> var1);
    }
}

