/*
 * Decompiled with CFR 0.152.
 */
package kd.sys.ricc.common.util;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicLocaleProperty;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.property.AttachmentProp;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.FlexProp;
import kd.bos.entity.property.ItemClassProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.sys.ricc.common.util.setter.PropSetterFactory;
import kd.sys.ricc.common.util.setter.Setter;
import kd.sys.ricc.exception.RiccBizException;

public class DynamicObjectUtil {
    private DynamicObjectUtil() {
    }

    public static DynamicObject setDynamicObjectValues(DynamicObject obj, DataEntityPropertyCollection properties, Map<String, Object> map) {
        for (IDataEntityProperty property : properties) {
            String propName = property.getName();
            Object val = map.get(propName);
            if (ObjectUtils.isEmpty((Object)val)) continue;
            Setter setter = PropSetterFactory.createSetter(property);
            try {
                setter.setObjValue(obj, propName, val, map);
            }
            catch (Exception e) {
                String msg = ResManager.loadKDString((String)"\u7ed9\u5b57\u6bb5%1$s \u8d4b\u503c%2$s\uff0c\u51fa\u9519\uff0c\u539f\u56e0\uff1a%3$s", (String)"DynamicObjectUtil_8", (String)"sys-ricc-common", (Object[])new Object[0]);
                throw new RiccBizException(String.format(msg, propName, val, e.getMessage()), e);
            }
        }
        return obj;
    }

    public static Map<String, Object> object2Map(DynamicObject dynamicObject, Map<String, Object> requires) {
        if (null != requires && !requires.isEmpty()) {
            HashMap<String, Object> objectMap = new HashMap<String, Object>();
            if (dynamicObject != null) {
                objectMap.put("$id", dynamicObject.getPkValue());
                objectMap.put("$pk", "id");
                DataEntityPropertyCollection properties = dynamicObject.getDataEntityType().getProperties();
                for (IDataEntityProperty property : properties) {
                    String name;
                    if (property instanceof AttachmentProp || !requires.containsKey(name = property.getName()) || "multilanguagetext".equals(name)) continue;
                    Setter setter = PropSetterFactory.createSetter(property);
                    try {
                        setter.setMapValue(objectMap, requires, name, dynamicObject);
                    }
                    catch (Exception e) {
                        String message = ResManager.loadKDString((String)"\u7ed9map\u5b57\u6bb5%1$s\u8d4b\u503c\u51fa\u9519!%2$s", (String)"DynamicObjectUtil_9", (String)"sys-ricc-common", (Object[])new Object[0]);
                        throw new RiccBizException(String.format(message, name, e.getMessage()), e);
                    }
                }
            }
            return objectMap;
        }
        return DynamicObjectUtil.object2Map(dynamicObject);
    }

    public static Map<String, Object> object2Map(DynamicObject o) {
        HashMap<String, Object> objectMap = new HashMap<String, Object>();
        if (o != null) {
            objectMap.put("$id", o.getPkValue());
            objectMap.put("$pk", "id");
            DataEntityPropertyCollection properties = o.getDataEntityType().getProperties();
            for (IDataEntityProperty property : properties) {
                String name;
                if (property instanceof AttachmentProp || "multilanguagetext".equals(name = property.getName())) continue;
                Setter setter = PropSetterFactory.createSetter(property);
                try {
                    setter.setMapValue(objectMap, null, name, o);
                }
                catch (Exception e) {
                    String msg = ResManager.loadKDString((String)"\u7ed9map\u5b57\u6bb5%1$s\u8d4b\u503c\u51fa\u9519!%2$s", (String)"DynamicObjectUtil_9", (String)"sys-ricc-common", (Object[])new Object[0]);
                    throw new RiccBizException(String.format(msg, name, e.getMessage()), e);
                }
            }
        }
        return objectMap;
    }

    public static Map<String, Object> getDefaultPropertyMap(DataEntityPropertyCollection properties) {
        HashMap<String, Object> propertyMap = new HashMap<String, Object>(properties.size());
        for (IDataEntityProperty property : properties) {
            String numberProp;
            String propertyKey = property.getName();
            if (property instanceof ItemClassProp || property instanceof BasedataProp) {
                HashMap<String, String> baseDataMap = new HashMap<String, String>(2);
                numberProp = ((BasedataProp)property).getNumberProp();
                baseDataMap.put(numberProp, "");
                baseDataMap.put("name", "");
                propertyMap.put(propertyKey, baseDataMap);
                continue;
            }
            if (property instanceof MulBasedataProp) {
                HashMap<String, String> mulBaseDataMap = new HashMap<String, String>(2);
                numberProp = ((MulBasedataProp)property).getNumberProp();
                mulBaseDataMap.put(numberProp, "");
                mulBaseDataMap.put("name", "");
                propertyMap.put(propertyKey, mulBaseDataMap);
                continue;
            }
            if (property instanceof EntryProp) {
                DataEntityPropertyCollection entryProperties = ((EntryProp)property).getDynamicCollectionItemPropertyType().getProperties();
                Map<String, Object> entryMap = DynamicObjectUtil.getDefaultPropertyMap(entryProperties);
                propertyMap.put(propertyKey, entryMap);
                continue;
            }
            if (property instanceof FlexProp) {
                propertyMap.put(propertyKey, "");
                continue;
            }
            if (property instanceof DynamicLocaleProperty || property instanceof AttachmentProp) continue;
            propertyMap.put(propertyKey, "");
        }
        return propertyMap;
    }

    public static void setMapValByPropertyVal(DynamicObjectType entityType, Map<String, Object> targetMap, Map<String, Object> propertyValueMap, Set<String> ignorePropertyKeySet) {
        DataEntityPropertyCollection orgProperties = entityType.getProperties();
        for (IDataEntityProperty property : orgProperties) {
            String propertyKey = property.getName();
            if (ignorePropertyKeySet.contains(propertyKey)) continue;
            Setter setter = PropSetterFactory.createSetter(property);
            try {
                setter.setMapValByPropertyVal(targetMap, propertyKey, propertyValueMap, ignorePropertyKeySet);
            }
            catch (Exception e) {
                LocaleString displayName = property.getDisplayName();
                String columnName = "";
                if (displayName != null) {
                    columnName = property.getDisplayName().getLocaleValue();
                }
                String error = String.format(ResManager.loadKDString((String)"\u7ed9\u5b57\u6bb5%1$s(%2$s)\u8d4b\u503c\u51fa\u9519 %3$s", (String)"DynamicObjectUtil_10", (String)"sys-ricc-common", (Object[])new Object[0]), columnName, propertyKey, e.getMessage());
                throw new RiccBizException(error, e);
            }
        }
    }

    public static void copy(DynamicObject fromObj, DynamicObject toObj) {
        DynamicObjectUtil.copy(fromObj, toObj, null, null);
    }

    public static void copy(DynamicObject fromObj, DynamicObject toObj, Set<String> ignoreKeys, Map<String, String> transKeyMap) {
        if (fromObj == null || toObj == null) {
            return;
        }
        DataEntityPropertyCollection fromPros = fromObj.getDataEntityType().getProperties();
        if (fromPros == null || fromPros.size() == 0) {
            return;
        }
        DataEntityPropertyCollection toPros = toObj.getDataEntityType().getProperties();
        if (toPros == null || toPros.size() == 0) {
            return;
        }
        HashSet<String> fromPsSet = new HashSet<String>(fromPros.size());
        for (Object pro : fromPros) {
            fromPsSet.add(pro.getName());
        }
        HashSet<String> toPsSet = new HashSet<String>(fromPros.size());
        for (IDataEntityProperty pro : toPros) {
            toPsSet.add(pro.getName());
        }
        ISimpleProperty primaryKeyObj = toObj.getDataEntityType().getPrimaryKey();
        String primaryKey = "";
        if (primaryKeyObj != null) {
            primaryKey = primaryKeyObj.getName();
        }
        if (transKeyMap == null) {
            transKeyMap = new HashMap<String, String>(0);
        }
        for (IDataEntityProperty pro : toPros) {
            String toProName = pro.getName();
            String fromProName = toProName;
            String customKey = transKeyMap.get(fromProName);
            if (StringUtils.isNotBlank((CharSequence)customKey)) {
                toProName = customKey;
            } else if (ignoreKeys != null && ignoreKeys.contains(toProName)) continue;
            if (!fromPsSet.contains(fromProName) || !toPsSet.contains(toProName)) continue;
            if (toProName.equals(primaryKey)) {
                toObj.set(toProName, null);
                continue;
            }
            Object value = fromObj.get(fromProName);
            if (value instanceof DynamicObjectCollection) {
                DynamicObjectCollection toEntity = DynamicObjectUtil.copyEntryEntity(value, toObj, toProName, ignoreKeys, transKeyMap);
                toObj.set(toProName, (Object)toEntity);
                continue;
            }
            toObj.set(toProName, value);
        }
    }

    private static DynamicObjectCollection copyEntryEntity(Object value, DynamicObject toObj, String toProName, Set<String> ignoreKeys, Map<String, String> transKeyMap) {
        DynamicObjectCollection formEntity = (DynamicObjectCollection)value;
        DynamicObjectCollection toEntity = toObj.getDynamicObjectCollection(toProName);
        if (toEntity != null) {
            toEntity.clear();
            DynamicObjectType entityType = toEntity.getDynamicObjectType();
            for (DynamicObject baseEntry : formEntity) {
                DynamicObject newEntry = new DynamicObject(entityType);
                DynamicObjectUtil.copy(baseEntry, newEntry, ignoreKeys, transKeyMap);
                toEntity.add((Object)newEntry);
            }
        }
        return toEntity;
    }
}

