/*
 * Decompiled with CFR 0.152.
 */
package kd.sys.ricc.common.util;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.IFormView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class ImplOrderUtil {
    public static final String ORDER_DESC = " desc";
    private static final String FIELD_PARANT = "parent";
    private static final String FIELD_GROUP = "group";
    public static final String LEVEL = "level";

    private ImplOrderUtil() {
    }

    public static String getNewOder(String[] parentOrderArr) {
        int newEndOrder = Integer.parseInt(parentOrderArr[parentOrderArr.length - 1]) + 1;
        StringBuilder newOrder = new StringBuilder();
        for (int i = 0; i < parentOrderArr.length - 1; ++i) {
            newOrder.append(parentOrderArr[i]);
            newOrder.append('.');
        }
        if (newEndOrder < 10) {
            newOrder.append('0');
        }
        newOrder.append(newEndOrder);
        return newOrder.toString();
    }

    public static void treeParentChange(IFormView view, String orderKey) {
        int level = view.getModel().getDataEntity().getInt(LEVEL);
        DynamicObject thisParent = view.getModel().getDataEntity().getDynamicObject(FIELD_PARANT);
        long parentId = 0L;
        if (thisParent != null) {
            parentId = thisParent.getLong("id");
        }
        String newOder = ImplOrderUtil.getTreeNewOrder(view.getEntityId(), orderKey, level, parentId);
        view.getModel().setValue(orderKey, (Object)newOder);
    }

    public static String getTreeNewOrder(String entity, String orderKey, int level, long parentId) {
        String selectField = orderKey + ",parent,id,level";
        QFilter[] qfitlters = new QFilter[]{new QFilter(LEVEL, "=", (Object)level)};
        if (level != 1) {
            qfitlters = new QFilter[]{new QFilter(FIELD_PARANT, "=", (Object)parentId)};
        }
        DynamicObject[] parentOrder = BusinessDataServiceHelper.load((String)entity, (String)selectField, (QFilter[])qfitlters, (String)(orderKey + ORDER_DESC), (int)1);
        String newOder = "";
        if (parentOrder.length == 0) {
            qfitlters = new QFilter[]{new QFilter("id", "=", (Object)parentId)};
            parentOrder = BusinessDataServiceHelper.load((String)entity, (String)selectField, (QFilter[])qfitlters, (String)(orderKey + ORDER_DESC), (int)2);
        }
        if (parentOrder.length == 0 && level == 1) {
            newOder = "01";
        } else {
            DynamicObject one = parentOrder[0];
            DynamicObject tempDyn = (DynamicObject)one.get(FIELD_PARANT);
            if (tempDyn != null && parentId == tempDyn.getLong("id")) {
                String parentOrderStr = one.getString(orderKey);
                String[] parentOrderArr = parentOrderStr.split("\\.");
                newOder = ImplOrderUtil.getNewOder(parentOrderArr);
            } else {
                newOder = one.getString(orderKey) + ".01";
                if (level == 1) {
                    int newNum = Integer.parseInt(one.getString(orderKey)) + 1;
                    newOder = newNum > 10 ? "" + newNum : "0" + newNum;
                }
            }
        }
        return newOder;
    }

    public static void groupChange(IFormView view, String orderKey, String treeOrderKey, String groupEntity) {
        DynamicObject thisGroup = (DynamicObject)view.getModel().getValue(FIELD_GROUP);
        if (thisGroup == null) {
            return;
        }
        String newOder = ImplOrderUtil.getNewOder(view.getEntityId(), orderKey, treeOrderKey, groupEntity, thisGroup);
        view.getModel().setValue(orderKey, (Object)newOder);
    }

    public static String getNewOder(String entity, String orderKey, String treeOrderKey, String groupEntity, DynamicObject thisGroup) {
        if (thisGroup == null) {
            return "";
        }
        long groupId = thisGroup.getLong("id");
        String selectField = orderKey + ",group,id";
        QFilter[] qfitlters = new QFilter[]{new QFilter(FIELD_GROUP, "=", (Object)groupId)};
        DynamicObject[] parentOrder = BusinessDataServiceHelper.load((String)entity, (String)selectField, (QFilter[])qfitlters, (String)(orderKey + ORDER_DESC), (int)1);
        String newOder = "";
        if (parentOrder.length <= 0 || "".equals(parentOrder[0].getString(orderKey))) {
            qfitlters = new QFilter[]{new QFilter("id", "=", (Object)groupId)};
            parentOrder = BusinessDataServiceHelper.load((String)groupEntity, (String)(treeOrderKey + ",id"), (QFilter[])qfitlters, (String)(treeOrderKey + ORDER_DESC), (int)1);
            newOder = parentOrder[0].getString(orderKey) + ".01";
        } else {
            String parentOrderStr = parentOrder[0].getString(orderKey);
            String[] parentOrderArr = parentOrderStr.split("\\.");
            newOder = ImplOrderUtil.getNewOder(parentOrderArr);
        }
        return newOder;
    }
}

