/*
 * Decompiled with CFR 0.152.
 */
package kd.sys.ricc.common.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.service.DispatchServiceHelper;
import kd.sys.ricc.common.util.StringUtils;

public class InvokeActionUtil {
    private static final Log logger = LogFactory.getLog(InvokeActionUtil.class);
    private static final Pattern PAGEID_PATTERN = Pattern.compile(",\"pageId\":\"(.+?)\"");

    private InvokeActionUtil() {
    }

    public static String invokeActionByAppId(String appId, String currentPageId, String params) {
        return DispatchServiceHelper.invokeBOSServiceByAppId((String)appId, (String)"FormService", (String)"batchInvokeAction", (Object[])new Object[]{currentPageId, params}).toString();
    }

    public static String getPageIdByAppId(String appId, String currentPageId, String params) {
        Matcher m;
        String pageId = "";
        String callBackArg = InvokeActionUtil.invokeActionByAppId(appId, currentPageId, params);
        List results = (List)SerializationUtils.fromJsonString((String)callBackArg, List.class);
        for (int i = 0; i < results.size(); ++i) {
            ArrayList result = (ArrayList)((Map)results.get(i)).get("p");
            for (int j = 0; j < result.size(); ++j) {
                Map map;
                String pageIdStr;
                if (!(result.get(j) instanceof Map) || (pageIdStr = (String)(map = (Map)result.get(j)).get("pageId")) == null) continue;
                pageId = pageIdStr;
            }
        }
        if (StringUtils.isBlank(pageId) && (m = PAGEID_PATTERN.matcher(callBackArg)).find()) {
            pageId = m.group(1);
        }
        if (pageId == null || "".equals(pageId.trim())) {
            logger.error(callBackArg);
        }
        return pageId;
    }
}

