/*
 * Decompiled with CFR 0.152.
 */
package kd.sys.ricc.common.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.entity.OrmLocaleValue;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.ISimpleProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.BillEntityType;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.EntityType;
import kd.bos.entity.EntryType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.SubEntryType;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.property.AttachmentProp;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.FieldProp;
import kd.bos.entity.property.IFieldHandle;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.property.UserProp;
import kd.bos.form.FormConfig;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.IFormView;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.metadata.AbstractMetadata;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.EntityItem;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.EntryEntity;
import kd.bos.metadata.entity.businessfield.BasedataPropField;
import kd.bos.metadata.entity.businessfield.FlexField;
import kd.bos.metadata.entity.businessfield.ModifierField;
import kd.bos.metadata.entity.businessfield.MulBasedataField;
import kd.bos.metadata.entity.businessfield.PrintCountField;
import kd.bos.metadata.entity.businessfield.UserAvatarField;
import kd.bos.metadata.entity.commonfield.AttachmentCountField;
import kd.bos.metadata.entity.commonfield.AttachmentField;
import kd.bos.metadata.entity.commonfield.CheckBoxField;
import kd.bos.metadata.entity.commonfield.DateRangeField;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.entity.commonfield.IconField;
import kd.bos.metadata.entity.commonfield.PictureField;
import kd.bos.metadata.entity.commonfield.RadioField;
import kd.bos.metadata.entity.commonfield.RadioGroupField;
import kd.bos.metadata.entity.commonfield.TimeRangeField;
import kd.bos.metadata.form.BasedataFormAp;
import kd.bos.metadata.form.ControlAp;
import kd.bos.metadata.form.FormMetadata;
import kd.bos.metadata.form.control.AttachmentPanelAp;
import kd.bos.metadata.form.control.BarItemAp;
import kd.bos.orm.query.QFilter;
import kd.bos.param.ParameterReader;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.sys.ricc.common.constant.CommonConstant;
import kd.sys.ricc.common.util.StringUtils;

public class PageChangeUtil {
    private static final String PAGETYPE = "pagetype";
    private static final String CUSTOM_PAGE = "custompage";
    private static final String KEY_FIELDS = "keyfields";
    private static final String BILL_UNIQUE_KEYS = "billuniquekeys";

    private PageChangeUtil() {
        throw new IllegalStateException("Utility class");
    }

    public static void pageChangeEvent(DynamicObject pageValue, IFormView view) {
        if (pageValue == null) {
            view.getModel().setValue(PAGETYPE, null);
            return;
        }
        String formId = pageValue.getString("number");
        FormConfig listFormConfig = FormMetadataCache.getListFormConfig((String)formId);
        if (listFormConfig == null) {
            view.getModel().setValue(PAGETYPE, (Object)"bos_dynamicform");
            return;
        }
        String pageTypeList = listFormConfig.getListFormId();
        if (pageTypeList.equals("bos_list") || pageTypeList.equals("bos_templatetreelist") || pageTypeList.equals("bos_treelist")) {
            view.getModel().setValue(PAGETYPE, (Object)pageTypeList);
            return;
        }
        view.getModel().setValue(PAGETYPE, (Object)"custom");
        view.getModel().setValue(CUSTOM_PAGE, (Object)pageTypeList);
    }

    public static void getKeyFields(IFormView view, String entityNumber) {
        QFilter numberFilter = new QFilter("number", "=", (Object)entityNumber);
        DynamicObject formMeta = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_formmeta", (QFilter[])numberFilter.toArray());
        if (formMeta != null) {
            String modelType = formMeta.getString("modeltype");
            if (!StringUtils.equals(modelType, "BillFormModel") && !StringUtils.equals(modelType, "BaseFormModel")) {
                return;
            }
        } else {
            return;
        }
        ComboEdit keyFields = (ComboEdit)view.getControl(KEY_FIELDS);
        ComboEdit sortField = (ComboEdit)view.getControl("sortfield");
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        ArrayList<ComboItem> keyFieldItems = new ArrayList<ComboItem>(10);
        EntityMetadata entityMetadata = (EntityMetadata)MetadataDao.readRuntimeMeta((String)MetadataDao.getIdByNumber((String)entityType.getName(), (MetaCategory)MetaCategory.Entity), (MetaCategory)MetaCategory.Entity);
        List entityItems = entityMetadata.getItems();
        HashSet itemSet = new HashSet(16);
        entityItems.forEach(item -> {
            boolean valid = item instanceof Field;
            if (valid) {
                Field f = (Field)item;
                boolean bl = valid = StringUtils.isNotBlank(f.getFieldName()) && f.getFeatures().isImportable() && !(f instanceof CheckBoxField) && !(f instanceof RadioField) && !(f instanceof RadioGroupField) && !(f instanceof ModifierField) && !(f instanceof PictureField) && !(f instanceof UserAvatarField) && !(f instanceof IconField) && !(f instanceof AttachmentCountField) && !(f instanceof AttachmentField) && !(f instanceof PrintCountField) && !(f instanceof FlexField);
                if (valid) {
                    itemSet.add(item.getKey());
                }
                PageChangeUtil.getDateAndTimeRangeField(itemSet, item, f);
            }
        });
        for (IDataEntityProperty property : entityType.getProperties()) {
            if (!itemSet.contains(property.getName())) continue;
            keyFieldItems.add(new ComboItem(property.getDisplayName(), property.getName()));
        }
        if (entityType.getPrimaryKey() != null) {
            keyFieldItems.add(new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u5185\u7801", (String)"PageChangeUtil_1", (String)"sys-ricc-common", (Object[])new Object[0])), entityType.getPrimaryKey().getName()));
        }
        if (!keyFieldItems.isEmpty()) {
            PageChangeUtil.sortKeyFieldItems(keyFieldItems, entityType);
            keyFields.setComboItems(keyFieldItems);
            if (sortField != null) {
                sortField.setComboItems(keyFieldItems);
            }
        }
    }

    public static String getUniqueFieldStr(String entityNumber) {
        Map saveOperateMap = EntityMetadataCache.getDataEntityOperate((String)entityNumber, (String)"save");
        DataEntityPropertyCollection properties = EntityMetadataCache.getDataEntityType((String)entityNumber).getProperties();
        Object validations = saveOperateMap.get("validations");
        if (validations == null) {
            return "";
        }
        HashSet<String> uniqueFieldKeys = new HashSet<String>(16);
        List validationList = (List)validations;
        for (Map validation : validationList) {
            Object fields;
            Object ruleType;
            if (!((Boolean)validation.get("enabled")).booleanValue() || !"GroupFieldUnique".equals(ruleType = validation.get("ruleType")) || (fields = validation.get("fields")) == null) continue;
            List fieldsMap = (List)fields;
            for (Map fMap : fieldsMap) {
                String uniqueFieldKey = (String)fMap.get("id");
                if (uniqueFieldKey.contains(".")) {
                    uniqueFieldKey = uniqueFieldKey.split("\\.")[0];
                }
                uniqueFieldKeys.add(uniqueFieldKey);
            }
        }
        ArrayList<String> uniqueFieldVals = new ArrayList<String>(uniqueFieldKeys.size());
        for (IDataEntityProperty property : properties) {
            String propertyName = property.getName();
            if (!uniqueFieldKeys.contains(propertyName)) continue;
            uniqueFieldVals.add(property.getDisplayName().getLocaleValue());
        }
        return String.join((CharSequence)",", uniqueFieldVals);
    }

    public static void getDateAndTimeRangeField(Set<String> itemSet, EntityItem<?> item, Field<?> field) {
        if (item instanceof DateRangeField && field.getFeatures().isImportable()) {
            if (StringUtils.isNotBlank(((DateRangeField)item).getStartDateFieldName())) {
                itemSet.add(((DateRangeField)field).getStartDateFieldKey());
            }
            if (StringUtils.isNotBlank(((DateRangeField)item).getEndDateFieldName())) {
                itemSet.add(((DateRangeField)field).getEndDateFieldKey());
            }
        }
        if (item instanceof TimeRangeField && field.getFeatures().isImportable()) {
            if (StringUtils.isNotBlank(((TimeRangeField)item).getStartDateFieldName())) {
                itemSet.add(((TimeRangeField)field).getStartDateFieldKey());
            }
            if (StringUtils.isNotBlank(((TimeRangeField)item).getEndDateFieldName())) {
                itemSet.add(((TimeRangeField)field).getEndDateFieldKey());
            }
        }
    }

    public static String getBillUniqueKeys(String billFormId) {
        DynamicObject billObject = ParameterReader.getBillParameter((String)billFormId);
        if (billObject != null) {
            return billObject.getString(BILL_UNIQUE_KEYS);
        }
        return null;
    }

    public static void sortKeyFieldItems(List<ComboItem> keyFieldItems, MainEntityType entityType) {
        HashMap<String, Integer> sortMap = new HashMap<String, Integer>(4);
        ISimpleProperty primaryKey = entityType.getPrimaryKey();
        if (primaryKey != null) {
            String pk = primaryKey.getName();
            sortMap.put(pk, 10);
        }
        sortMap.put("billno", 8);
        sortMap.put("number", 8);
        if (entityType.getMainOrg() != null) {
            sortMap.put(entityType.getMainOrg(), 9);
        }
        keyFieldItems.sort((o1, o2) -> {
            String v1 = o1.getValue();
            String v2 = o2.getValue();
            return sortMap.getOrDefault(v2, 0) - sortMap.getOrDefault(v1, 0);
        });
    }

    public static String getOpKey(String entityNumber, String opType) {
        List ops = EntityMetadataCache.getDataEntityOperate((String)entityNumber);
        String opKey = "";
        for (Map op : ops) {
            String type = (String)op.get("type");
            if (!opType.equals(type)) continue;
            opKey = (String)op.get("key");
        }
        return opKey;
    }

    public static boolean isListHaveImportDataOp(String entityNumber, String itemKey) {
        boolean listHaveImportDataOp = false;
        Map<String, Object> itemInfo = PageChangeUtil.getItemInfo(entityNumber, itemKey);
        if (itemInfo.size() > 0) {
            listHaveImportDataOp = true;
        }
        return listHaveImportDataOp;
    }

    public static Map<String, Object> getItemInfo(String entityNumber, String itemKey) {
        Map listToolBar = FormMetadataCache.getListToolBar((String)entityNumber);
        if (listToolBar.size() > 0) {
            List itemsList = (List)listToolBar.get("items");
            for (Map item : itemsList) {
                List dropItemsList = (List)item.get("items");
                if (dropItemsList != null) {
                    for (Map dropItem : dropItemsList) {
                        String opk = (String)dropItem.get("operationKey");
                        if (!itemKey.equals(opk)) continue;
                        return item;
                    }
                    continue;
                }
                String opk = (String)item.get("opk");
                if (!itemKey.equals(opk)) continue;
                return item;
            }
        }
        return new HashMap<String, Object>(2);
    }

    public static boolean itemIsHidden(String entityNumber, String itemKey) {
        int itemViInt;
        Object itemVi;
        boolean isHidden = false;
        Map<String, Object> itemInfo = PageChangeUtil.getItemInfo(entityNumber, itemKey);
        if (itemInfo.size() > 0 && (itemVi = itemInfo.get("vi")) != null && ((itemViInt = ((Integer)itemVi).intValue()) == 0 || itemViInt == 10)) {
            isHidden = true;
        }
        return isHidden;
    }

    public static String getNoSaveFieldsOrEntry(String entityNumber) {
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        EntityMetadata entityMetadata = (EntityMetadata)MetadataDao.readRuntimeMeta((String)MetadataDao.getIdByNumber((String)entityType.getName(), (MetaCategory)MetaCategory.Entity), (MetaCategory)MetaCategory.Entity);
        StringBuilder noSaveFields = new StringBuilder();
        List entityFields = entityMetadata.getItems();
        HashSet<String> skipProp = new HashSet<String>();
        for (EntityItem entityField : entityFields) {
            if (!PageChangeUtil.isDataBaseField(entityField)) continue;
            if (entityField instanceof EntryEntity) {
                String tableName = ((EntryEntity)entityField).getTableName();
                if (!StringUtils.isBlank(tableName)) continue;
                PageChangeUtil.addSkipField(skipProp, (EntryEntity)entityField);
                noSaveFields.append(entityField.getName().getLocaleValue()).append('\u3001');
                continue;
            }
            if (skipProp.contains(entityField.getKey())) continue;
            PageChangeUtil.dealEntityField(noSaveFields, entityField);
        }
        if (StringUtils.isNotBlank(noSaveFields)) {
            noSaveFields.delete(noSaveFields.length() - 1, noSaveFields.length());
        }
        return noSaveFields.toString();
    }

    public static List<ComboItem> getConditionMustItems(String entityNumber) {
        ArrayList<ComboItem> conditionMustItems = new ArrayList<ComboItem>(16);
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        Map entities = entityType.getAllEntities();
        for (Map.Entry entityEntry : entities.entrySet()) {
            EntityType type = (EntityType)entityEntry.getValue();
            DataEntityPropertyCollection properties = type.getProperties();
            for (IDataEntityProperty property : properties) {
                MulBasedataProp mulBasedataProp;
                if (property instanceof FieldProp) {
                    FieldProp fieldProp = (FieldProp)property;
                    if (!fieldProp.isMustInput() || !StringUtils.isNotEmpty(fieldProp.getMustInputCondition())) continue;
                    conditionMustItems.add(new ComboItem(fieldProp.getDisplayName(), fieldProp.getName()));
                    continue;
                }
                if (property instanceof BasedataProp) {
                    BasedataProp basedataProp = (BasedataProp)property;
                    if (!basedataProp.isMustInput() || !StringUtils.isNotEmpty(basedataProp.getMustInputCondition())) continue;
                    conditionMustItems.add(new ComboItem(basedataProp.getDisplayName(), basedataProp.getName()));
                    continue;
                }
                if (!(property instanceof MulBasedataProp) || !(mulBasedataProp = (MulBasedataProp)property).isMustInput() || !StringUtils.isNotEmpty(mulBasedataProp.getMustInputCondition())) continue;
                conditionMustItems.add(new ComboItem(mulBasedataProp.getDisplayName(), mulBasedataProp.getName()));
            }
        }
        return conditionMustItems;
    }

    public static List<ComboItem> getCoverInformationItems(String entityNumber, String importType) {
        ArrayList<ComboItem> coverItems = new ArrayList<ComboItem>(16);
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        Map entities = entityType.getAllEntities();
        for (Map.Entry entityEntry : entities.entrySet()) {
            EntityType type = (EntityType)entityEntry.getValue();
            String typeName = "";
            if (type instanceof EntryType && !(type instanceof SubEntryType)) {
                typeName = type.getDisplayName().getLocaleValue();
            } else if (type instanceof SubEntryType) {
                typeName = type.getParent().getDisplayName().getLocaleValue() + "." + type.getDisplayName().getLocaleValue();
            }
            DataEntityPropertyCollection properties = type.getProperties();
            for (IDataEntityProperty property : properties) {
                String baseEntityId;
                if (!(property instanceof IFieldHandle)) continue;
                boolean isImportable = ((IFieldHandle)property).isImportable();
                if ("excel".equals(importType) && !isImportable) continue;
                LocaleString localeString = property.getDisplayName();
                if (StringUtils.isNotEmpty(typeName) && localeString != null) {
                    localeString = new LocaleString(typeName + "." + localeString.getLocaleValue());
                }
                if (property instanceof UserProp) {
                    coverItems.add(new ComboItem(localeString, property.getName()));
                    continue;
                }
                if (!(property instanceof BasedataProp) || !StringUtils.equals("bos_user", baseEntityId = ((BasedataProp)property).getBaseEntityId())) continue;
                coverItems.add(new ComboItem(localeString, property.getName()));
            }
        }
        return coverItems;
    }

    public static List<ComboItem> getAttachmentItems(String entityNumber) {
        ArrayList<ComboItem> attachmentItems = new ArrayList<ComboItem>(16);
        FormMetadata formMetadata = (FormMetadata)MetadataDao.readRuntimeMeta((String)MetadataDao.getIdByNumber((String)entityNumber, (MetaCategory)MetaCategory.Form), (MetaCategory)MetaCategory.Form);
        List aps = formMetadata.getItems();
        for (ControlAp controlAp : aps) {
            if (!(controlAp instanceof AttachmentPanelAp)) continue;
            String apKey = "#" + controlAp.getKey();
            attachmentItems.add(new ComboItem(controlAp.getName(), apKey));
        }
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        Map entities = entityType.getAllEntities();
        for (Map.Entry entityEntry : entities.entrySet()) {
            EntityType type = (EntityType)entityEntry.getValue();
            String typeName = "";
            if (type instanceof EntryType && !(type instanceof SubEntryType)) {
                typeName = type.getDisplayName().getLocaleValue();
            } else if (type instanceof SubEntryType) {
                typeName = type.getParent().getDisplayName().getLocaleValue() + "." + type.getDisplayName().getLocaleValue();
            }
            DataEntityPropertyCollection properties = type.getProperties();
            for (IDataEntityProperty property : properties) {
                LocaleString localeString = property.getDisplayName();
                String propertyName = property.getName();
                if (StringUtils.isNotEmpty(typeName) && localeString != null) {
                    localeString = new LocaleString(typeName + "." + localeString.getLocaleValue());
                }
                if (!(property instanceof AttachmentProp)) continue;
                attachmentItems.add(new ComboItem(localeString, propertyName));
            }
        }
        return attachmentItems;
    }

    public static List<ComboItem> getButtonItems(String entityNumber, IFormView formView) {
        Optional<ControlAp> first;
        ArrayList<ComboItem> buttonItems = new ArrayList<ComboItem>(16);
        FormMetadata formMetadata = (FormMetadata)MetadataDao.readRuntimeMeta((String)MetadataDao.getIdByNumber((String)entityNumber, (MetaCategory)MetaCategory.Form), (MetaCategory)MetaCategory.Form);
        String pageType = (String)formView.getModel().getValue(PAGETYPE);
        List items = formMetadata.getItems();
        if (!"bos_dynamicform".equals(pageType) && !CollectionUtils.isEmpty((Collection)formMetadata.getItems()) && (first = formMetadata.getItems().stream().filter(o -> o instanceof BasedataFormAp).findFirst()).isPresent()) {
            items = ((BasedataFormAp)first.get()).getListMeta().getItems();
        }
        for (ControlAp controlAp : items) {
            if (!(controlAp instanceof BarItemAp)) continue;
            buttonItems.add(new ComboItem(controlAp.getName(), controlAp.getKey()));
        }
        return buttonItems;
    }

    public static void setFieldComboItem(List<ComboItem> comboItems, String fieldKey, IFormView view) {
        IDataModel model = view.getModel();
        if (!comboItems.isEmpty()) {
            ComboEdit comboEdit = (ComboEdit)view.getControl(fieldKey);
            comboEdit.setComboItems(comboItems);
            String fieldValueStr = (String)model.getValue(fieldKey);
            if (StringUtils.isNotEmpty(fieldValueStr)) {
                List sysMustKeyList = comboItems.stream().map(ComboItem::getValue).collect(Collectors.toList());
                List<String> storeMustKeyList = Arrays.asList(fieldValueStr.trim().replaceFirst(",", "").split(","));
                storeMustKeyList = storeMustKeyList.stream().filter(sysMustKeyList::contains).collect(Collectors.toList());
                fieldValueStr = String.join((CharSequence)",", storeMustKeyList) + ",";
                model.setValue(fieldKey, (Object)fieldValueStr);
            }
        } else {
            model.setValue(fieldKey, null);
        }
    }

    private static void dealEntityField(StringBuilder noSaveFields, EntityItem<?> entityField) {
        String fieldName = ((Field)entityField).getFieldName();
        if (entityField instanceof MulBasedataField) {
            String tableName = ((MulBasedataField)entityField).getTableName();
            if (StringUtils.isEmpty(tableName)) {
                noSaveFields.append(entityField.getName().getLocaleValue()).append('\u3001');
            }
        } else if (entityField instanceof DateRangeField) {
            String startKey = ((DateRangeField)entityField).getStartDateFieldName();
            String endKey = ((DateRangeField)entityField).getEndDateFieldName();
            if (StringUtils.isEmpty(startKey) || StringUtils.isEmpty(endKey)) {
                noSaveFields.append(entityField.getName().getLocaleValue()).append('\u3001');
            }
        } else if (entityField instanceof TimeRangeField) {
            String startKey = ((TimeRangeField)entityField).getStartDateFieldName();
            String endKey = ((TimeRangeField)entityField).getEndDateFieldName();
            if (StringUtils.isEmpty(startKey) || StringUtils.isEmpty(endKey)) {
                noSaveFields.append(entityField.getName().getLocaleValue()).append('\u3001');
            }
        } else if (StringUtils.isBlank(fieldName)) {
            noSaveFields.append(entityField.getName().getLocaleValue()).append('\u3001');
        }
    }

    private static void addSkipField(Set<String> skipProp, EntryEntity entityField) {
        for (EntityItem entryField : entityField.getItems()) {
            if (entryField instanceof EntryEntity) {
                for (EntityItem subEntryField : ((EntryEntity)entryField).getItems()) {
                    skipProp.add(subEntryField.getKey());
                }
                continue;
            }
            skipProp.add(entryField.getKey());
        }
    }

    public static boolean isDataBaseField(EntityItem<?> entityItem) {
        return entityItem instanceof Field && !(entityItem instanceof RadioField) && !(entityItem instanceof BasedataPropField) || entityItem instanceof EntryEntity;
    }

    public static boolean isExtendModel(FormMetadata formMetadata) {
        String inheritPath = formMetadata.getInheritPath();
        boolean isExtendBaseOrBill = false;
        if (StringUtils.isNotBlank(inheritPath)) {
            String[] parentIds;
            for (String parentId : parentIds = inheritPath.split(",")) {
                String parentNumber = MetadataDao.getNumberById((String)parentId);
                if (!StringUtils.equals(parentNumber, "bos_basetpl") && !StringUtils.equals(parentNumber, "bos_billtpl")) continue;
                isExtendBaseOrBill = true;
            }
        }
        return isExtendBaseOrBill;
    }

    public static String getConfigItemPageType(String pageNumber) {
        AbstractMetadata metadata = MetadataDao.readRuntimeMeta((String)MetadataDao.getIdByNumber((String)pageNumber, (MetaCategory)MetaCategory.Form), (MetaCategory)MetaCategory.Form);
        String modelType = metadata.getModelType();
        if (metadata instanceof FormMetadata) {
            String entityId;
            boolean isPcLayout;
            String formId = metadata.getId();
            boolean bl = isPcLayout = !formId.equals(entityId = ((FormMetadata)metadata).getEntityId()) && ("BillFormModel".equals(modelType) || "BaseFormModel".equals(modelType));
            if (isPcLayout) {
                return "PCLayout";
            }
        }
        return modelType;
    }

    public static void copyNumberAndName(IDataModel model) {
        String number = (String)model.getValue("number");
        String name = ((OrmLocaleValue)model.getValue("name")).getLocaleValue();
        String nameSuffix = CommonConstant.getNameSuffix();
        model.setValue("name", (Object)(name + "_" + nameSuffix));
        if (!number.startsWith("c_")) {
            model.setValue("number", (Object)("c_" + number + "_copy"));
        } else {
            model.setValue("number", (Object)(number + "_copy"));
        }
    }

    public static String getDefaultDataStatus(String modelType, String entityNumber) {
        Object billStatus;
        DynamicProperty property;
        BillEntityType dataEntityType;
        String billStatusKey;
        MainEntityType mainEntityType;
        String displayName = null;
        if ((StringUtils.equals(modelType, "BillFormModel") || StringUtils.equals(modelType, "BaseFormModel")) && (mainEntityType = EntityMetadataCache.getDataEntityType((String)entityNumber)) instanceof BillEntityType && (billStatusKey = (dataEntityType = (BillEntityType)mainEntityType).getBillStatus()) != null && (property = dataEntityType.getProperty(billStatusKey)) != null && (billStatus = ((FieldProp)property).getDefValue()) != null) {
            ComboProp comboProp = (ComboProp)property;
            displayName = comboProp.getItemByName(billStatus.toString());
        }
        return displayName;
    }
}

