/*
 * Decompiled with CFR 0.152.
 */
package kd.sys.ricc.common.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.DistributeSessionlessCache;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.property.BooleanProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.parameter.SystemParamServiceHelper;
import kd.sys.ricc.common.enums.BaseDataRightEnum;
import kd.sys.ricc.common.enums.ConfigControlItems;
import kd.sys.ricc.common.enums.ControlMode;
import kd.sys.ricc.common.util.CommonUtil;
import kd.sys.ricc.common.util.FileUtils;
import kd.sys.ricc.common.util.ObjectConverter;
import kd.sys.ricc.common.util.StringUtils;
import kd.sys.ricc.exception.RiccBizException;

public class SysParaUtil {
    private static final Log log = LogFactory.getLog(SysParaUtil.class);
    private static final String SAVE_PATH_STR = "storagepath";
    private static final String ENVROLE = "envrole";
    private static final String DEFAULTPATH = "/ricc_datapacket/";
    public static final long SCHEME_CONFIG_PK = 1384008697021203456L;
    public static final String PREINS_ISC_LINK_NUMBER = "ricc_ierp_link";
    public static final long PREINS_ISC_LINK_ID = 1437037436273191936L;
    public static final String ENVTYPEINFO = "envtypeinfo";
    public static final String CONTROLLED_CONFIG_KEY = "riccControlledConfigKey";
    public static final long PREINS_ISC_SELFLINK_ID = 1533952130870752256L;
    public static final String ENV_ENTRY = "enventry";
    public static final String PRE_CONTROL_TEXT_PATH = "/kd/sys/ricc/initconfig/preset_control_mode.json";
    public static final long INIT_CONFIG_PK_ID = 1367275628033736704L;
    public static final String BILL_CREATOR_COVER = "billcreatorcover";
    public static final int DEFAULT_PACK_DATA_LIMIT = 100000;
    public static final int DEFAULT_PACK_SIZE_LIMIT = 200;

    public static String getPreIscSelfLinkName() {
        return ResManager.loadKDString((String)"\u5b9e\u65bd\u914d\u7f6e\u4e2d\u5fc3_\u5f53\u524d\u6570\u636e\u4e2d\u5fc3", (String)"SysParaUtil_0", (String)"sys-ricc-common", (Object[])new Object[0]);
    }

    public static String getSavePath() {
        String prefix = FileUtils.getUploadPrefixPath();
        DynamicObject path = BusinessDataServiceHelper.loadSingleFromCache((String)"ricc_initconfig", (String)SAVE_PATH_STR, (QFilter[])null);
        if (!Objects.isNull(path)) {
            String savePath = path.getString(SAVE_PATH_STR);
            if (!savePath.endsWith("/")) {
                savePath = savePath + "/";
            }
            return prefix + savePath;
        }
        return prefix + DEFAULTPATH;
    }

    public static String getenvRole() {
        DynamicObject envrole = QueryServiceHelper.queryOne((String)"ricc_initconfig", (String)ENVROLE, null);
        if (!Objects.isNull(envrole)) {
            return envrole.getString(ENVROLE);
        }
        return null;
    }

    public static String getBillCreateInfoCoverConfig() {
        DynamicObject initConfig = SysParaUtil.getInitConfig();
        if (initConfig == null) {
            throw new RiccBizException(ResManager.loadKDString((String)"\u7cfb\u7edf\u8fd8\u6ca1\u8fdb\u884c\u53c2\u6570\u914d\u7f6e\uff0c\u8bf7\u5148\u5230\u5b9e\u65bd\u914d\u7f6e\u4e2d\u5fc3\u3010\u57fa\u7840\u8bbe\u7f6e\u3011->\u3010\u53c2\u6570\u8bbe\u7f6e\u3011\u8fdb\u884c\u53c2\u6570\u914d\u7f6e\u3002", (String)"SysParaUtil_1", (String)"sys-ricc-common", (Object[])new Object[0]));
        }
        return initConfig.getString(BILL_CREATOR_COVER);
    }

    public static DynamicObject getInitConfig() {
        return BusinessDataServiceHelper.loadSingleFromCache((Object)1367275628033736704L, (String)"ricc_initconfig");
    }

    public static boolean isIscConfigOk() {
        DynamicObject iscConfig = QueryServiceHelper.queryOne((String)"ricc_schemeconfig", (String)"init_status", (QFilter[])new QFilter("id", "=", (Object)1384008697021203456L).toArray());
        if (iscConfig == null) {
            return false;
        }
        int initStatus = iscConfig.getInt("init_status");
        return initStatus == 3;
    }

    public static DynamicObject getSchemeConfig() {
        return BusinessDataServiceHelper.loadSingleFromCache((Object)1384008697021203456L, (String)"ricc_schemeconfig");
    }

    public static boolean iscLinkDelete() {
        try (TXHandle h1 = TX.required();){
            try {
                DynamicObject iscSource = BusinessDataServiceHelper.loadSingleFromCache((String)"isc_data_source", (QFilter[])new QFilter("dblink.id", "=", (Object)1437037436273191936L).toArray());
                if (iscSource != null) {
                    iscSource.set("dblink", (Object)0L);
                    SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{iscSource});
                }
                DeleteServiceHelper.delete((String)"isc_database_link", (QFilter[])new QFilter("id", "=", (Object)1437037436273191936L).or("number", "=", (Object)PREINS_ISC_LINK_NUMBER).toArray());
            }
            catch (Exception e) {
                log.error("SysParaUtil.iscLinkDelete.error:" + CommonUtil.getExceptionDetailInfo(e));
                h1.markRollback();
                boolean bl = false;
                if (h1 != null) {
                    if (var1_1 != null) {
                        try {
                            h1.close();
                        }
                        catch (Throwable throwable) {
                            var1_1.addSuppressed(throwable);
                        }
                    } else {
                        h1.close();
                    }
                }
                return bl;
            }
        }
        return true;
    }

    public static JSONArray getControlEntryPreData(String controlMode) {
        JSONArray controlJsonArr = new JSONArray();
        String filePath = PRE_CONTROL_TEXT_PATH;
        StringBuilder preStrategyStr = new StringBuilder();
        try (InputStream in = SysParaUtil.class.getResourceAsStream(filePath);
             InputStreamReader inReader = new InputStreamReader(in, StandardCharsets.UTF_8);
             BufferedReader reader = new BufferedReader(inReader);){
            String tempStr;
            while ((tempStr = reader.readLine()) != null) {
                preStrategyStr.append(tempStr);
            }
        }
        catch (IOException e) {
            log.error("\u8bfb\u53d6\u9884\u7f6e\u7ba1\u63a7\u6a21\u5f0f\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (Throwable)e);
            return controlJsonArr;
        }
        JSONObject preStrategyObj = JSON.parseObject((String)preStrategyStr.toString());
        controlJsonArr = ControlMode.WEAK_CONTROL.getMode().equals(controlMode) ? preStrategyObj.getJSONArray("weak_control") : preStrategyObj.getJSONArray("strong_control");
        return controlJsonArr;
    }

    public static void setControlEntry(ControlMode controlMode, DynamicObjectCollection controlEnv) {
        controlEnv.clear();
        JSONArray controlEntryPreData = SysParaUtil.getControlEntryPreData(controlMode.getMode());
        if (controlEntryPreData == null || controlEntryPreData.isEmpty()) {
            throw new RiccBizException(ResManager.loadKDString((String)"\u8bfb\u53d6\u9884\u7f6e\u7ba1\u63a7\u6a21\u5f0f\u5206\u5f55\u6570\u636e\u5931\u8d25\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"SysParaUtil_2", (String)"sys-ricc-common", (Object[])new Object[0]));
        }
        for (int i = 0; i < controlEntryPreData.size(); ++i) {
            JSONObject controlItem = controlEntryPreData.getJSONObject(i);
            Integer seq = controlItem.getInteger("seq");
            Set controlItemEntries = controlItem.entrySet();
            DynamicObject oneEnvInfo = controlEnv.addNew();
            for (Map.Entry controlItemEntrie : controlItemEntries) {
                if ("seq".equals(controlItemEntrie.getKey())) continue;
                oneEnvInfo.set((String)controlItemEntrie.getKey(), controlItemEntrie.getValue());
            }
            controlEnv.set(seq - 1, (Object)oneEnvInfo);
        }
    }

    public static Map<String, Object> getConfigControlMap() {
        DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache();
        String cacheData = (String)cache.get(SysParaUtil.getControlledConfigKey());
        if (!StringUtils.isEmpty(cacheData)) {
            log.info("SysParaUtil.getConfigControlMap\u5339\u914d\u5230\u7f13\u5b58\u7684\u6570\u636e\u3002" + cacheData);
            return (Map)SerializationUtils.fromJsonString((String)cacheData, Map.class);
        }
        DynamicObject envEntryInfo = SysParaUtil.getConfigControlDy();
        Map<String, Object> controlledMap = SysParaUtil.controlledDyToMap(envEntryInfo);
        String envEntryDataToString = SerializationUtils.toJsonString(controlledMap);
        cache.put(SysParaUtil.getControlledConfigKey(), (Object)envEntryDataToString);
        return controlledMap;
    }

    public static DynamicObject getConfigControlDy() {
        DynamicObject initConfig = SysParaUtil.getInitConfig();
        if (initConfig == null) {
            throw new RiccBizException(ResManager.loadKDString((String)"\u7cfb\u7edf\u8fd8\u6ca1\u8fdb\u884c\u53c2\u6570\u914d\u7f6e\uff0c\u8bf7\u5148\u5230\u5b9e\u65bd\u914d\u7f6e\u4e2d\u5fc3\u3010\u57fa\u7840\u8bbe\u7f6e\u3011->\u3010\u53c2\u6570\u8bbe\u7f6e\u3011\u8fdb\u884c\u53c2\u6570\u914d\u7f6e\u3002", (String)"SysParaUtil_1", (String)"sys-ricc-common", (Object[])new Object[0]));
        }
        String envRole = initConfig.getString(ENVROLE);
        DynamicObjectCollection envEntryData = initConfig.getDynamicObjectCollection(ENV_ENTRY);
        for (DynamicObject envEntryInfo : envEntryData) {
            String envTypeInfo = envEntryInfo.getString(ENVTYPEINFO);
            if (!envTypeInfo.equals(envRole)) continue;
            return envEntryInfo;
        }
        throw new RiccBizException(ResManager.loadKDString((String)"\u7cfb\u7edf\u8fd8\u6ca1\u8fdb\u884c\u53c2\u6570\u914d\u7f6e\uff0c\u8bf7\u5148\u5230\u5b9e\u65bd\u914d\u7f6e\u4e2d\u5fc3\u3010\u57fa\u7840\u8bbe\u7f6e\u3011->\u3010\u53c2\u6570\u8bbe\u7f6e\u3011\u8fdb\u884c\u53c2\u6570\u914d\u7f6e\u3002", (String)"SysParaUtil_1", (String)"sys-ricc-common", (Object[])new Object[0]));
    }

    private static Map<String, Object> controlledDyToMap(DynamicObject envEntryInfo) {
        HashMap<String, Object> controlledMap = new HashMap<String, Object>(10);
        controlledMap.put(ConfigControlItems.CAN_CREATE_PACKET.getValue(), envEntryInfo.getBoolean(ConfigControlItems.CAN_CREATE_PACKET.getValue()));
        controlledMap.put(ConfigControlItems.CAN_ADD_PACKET.getValue(), envEntryInfo.getBoolean(ConfigControlItems.CAN_ADD_PACKET.getValue()));
        controlledMap.put(ConfigControlItems.CAN_DOWNLOAD_PACKET.getValue(), envEntryInfo.getBoolean(ConfigControlItems.CAN_DOWNLOAD_PACKET.getValue()));
        controlledMap.put(ConfigControlItems.CAN_UPLOAD_PACKET.getValue(), envEntryInfo.getBoolean(ConfigControlItems.CAN_UPLOAD_PACKET.getValue()));
        controlledMap.put(ConfigControlItems.CAN_REMOTE_SYNC.getValue(), envEntryInfo.getBoolean(ConfigControlItems.CAN_REMOTE_SYNC.getValue()));
        controlledMap.put(ConfigControlItems.CAN_ONEKEY_PACK.getValue(), envEntryInfo.getBoolean(ConfigControlItems.CAN_ONEKEY_PACK.getValue()));
        controlledMap.put(ConfigControlItems.CAN_META_PACK.getValue(), envEntryInfo.getBoolean(ConfigControlItems.CAN_META_PACK.getValue()));
        controlledMap.put(ConfigControlItems.UPLOAD_PACKET_STATUS.getValue(), envEntryInfo.getString(ConfigControlItems.UPLOAD_PACKET_STATUS.getValue()));
        controlledMap.put(ConfigControlItems.CHANGE_PERM_TYPE.getValue(), envEntryInfo.getString(ConfigControlItems.CHANGE_PERM_TYPE.getValue()));
        controlledMap.put(ENVTYPEINFO, envEntryInfo.getString(ENVTYPEINFO));
        return controlledMap;
    }

    public static Object getConfigControlItem(ConfigControlItems configControlItems) {
        Map<String, Object> configControlMap = SysParaUtil.getConfigControlMap();
        if (configControlMap != null) {
            return configControlMap.get(configControlItems.getValue());
        }
        log.info("SysParaUtil.getConfigControlItem\u83b7\u53d6\u7684\u6570\u636e\u4e3a\u4e3a\u7a7a");
        return null;
    }

    public static boolean canAddPacket() {
        return ObjectConverter.toBoolean(SysParaUtil.getConfigControlItem(ConfigControlItems.CAN_ADD_PACKET));
    }

    public static boolean canCreatePacket() {
        return ObjectConverter.toBoolean(SysParaUtil.getConfigControlItem(ConfigControlItems.CAN_CREATE_PACKET));
    }

    public static boolean canUploadPacket() {
        return ObjectConverter.toBoolean(SysParaUtil.getConfigControlItem(ConfigControlItems.CAN_UPLOAD_PACKET));
    }

    public static boolean canDownLoadPacket() {
        return ObjectConverter.toBoolean(SysParaUtil.getConfigControlItem(ConfigControlItems.CAN_DOWNLOAD_PACKET));
    }

    public static boolean canBatchPack() {
        return ObjectConverter.toBoolean(SysParaUtil.getConfigControlItem(ConfigControlItems.CAN_ONEKEY_PACK));
    }

    public static boolean canMetaPacket() {
        return ObjectConverter.toBoolean(SysParaUtil.getConfigControlItem(ConfigControlItems.CAN_META_PACK));
    }

    public static boolean canRemoteSync() {
        return ObjectConverter.toBoolean(SysParaUtil.getConfigControlItem(ConfigControlItems.CAN_REMOTE_SYNC));
    }

    public static String getUploadPacketStatus() {
        return ObjectConverter.toString(SysParaUtil.getConfigControlItem(ConfigControlItems.UPLOAD_PACKET_STATUS));
    }

    public static boolean isAllowUploadWithPacketStatus(String packetStatus) {
        String uploadPacketStatus = SysParaUtil.getUploadPacketStatus();
        return !"audit".equals(uploadPacketStatus) || "C".equals(packetStatus);
    }

    public static boolean canSyncPacketStatus(String status) {
        return SysParaUtil.isAllowUploadWithPacketStatus(status);
    }

    public static String getChangePermType() {
        String changePermType = ObjectConverter.toString(SysParaUtil.getConfigControlItem(ConfigControlItems.CHANGE_PERM_TYPE));
        if (StringUtils.isEmpty(changePermType)) {
            return BaseDataRightEnum.NO_DATA.getVal();
        }
        return changePermType;
    }

    public static boolean isOpenImportTemplateId() {
        Object importtrmplatehasid = SystemParamServiceHelper.loadPublicParameterFromCache((String)"importtrmplatehasid");
        if (importtrmplatehasid != null) {
            return (Boolean)importtrmplatehasid;
        }
        return false;
    }

    public static void savePublicParameter(String key, Object value) {
        HashMap<String, Object> newParam = new HashMap<String, Object>(1);
        newParam.put(key, value);
        SystemParamServiceHelper.savePublicParameter(newParam);
    }

    private static String getControlledConfigKey() {
        return RequestContext.get().getTenantId() + "_" + RequestContext.get().getAccountId() + "_" + CONTROLLED_CONFIG_KEY;
    }

    public static void cleanControlConfigCache() {
        DistributeSessionlessCache cache = CacheFactory.getCommonCacheFactory().getDistributeSessionlessCache();
        cache.remove(SysParaUtil.getControlledConfigKey());
    }

    public static boolean hasPermInEnvType(String envType, String permItem) {
        DynamicObject initConfig = SysParaUtil.getInitConfig();
        if (initConfig != null) {
            DynamicObjectCollection envEntryData = initConfig.getDynamicObjectCollection(ENV_ENTRY);
            for (DynamicObject envEntryInfo : envEntryData) {
                IDataEntityProperty prop;
                String envTypeInfo = envEntryInfo.getString(ENVTYPEINFO);
                if (!envTypeInfo.equals(envType) || !envEntryInfo.containsProperty(permItem) || !((prop = (IDataEntityProperty)envEntryInfo.getDataEntityType().getProperties().get((Object)permItem)) instanceof BooleanProp)) continue;
                return envEntryInfo.getBoolean(permItem);
            }
        } else {
            throw new RiccBizException(ResManager.loadKDString((String)"\u7cfb\u7edf\u8fd8\u6ca1\u8fdb\u884c\u53c2\u6570\u914d\u7f6e\uff0c\u8bf7\u5148\u5230\u5b9e\u65bd\u914d\u7f6e\u4e2d\u5fc3\u3010\u57fa\u7840\u8bbe\u7f6e\u3011->\u3010\u53c2\u6570\u8bbe\u7f6e\u3011\u8fdb\u884c\u53c2\u6570\u914d\u7f6e\u3002", (String)"SysParaUtil_1", (String)"sys-ricc-common", (Object[])new Object[0]));
        }
        return false;
    }

    public static List<String> getSyncEnvTypes(String permItem) {
        ArrayList<String> syncEnvTypes = new ArrayList<String>(16);
        DynamicObject initConfig = SysParaUtil.getInitConfig();
        if (initConfig != null) {
            DynamicObjectCollection envEntryData = initConfig.getDynamicObjectCollection(ENV_ENTRY);
            for (DynamicObject envEntryInfo : envEntryData) {
                IDataEntityProperty prop;
                String envTypeInfo = envEntryInfo.getString(ENVTYPEINFO);
                if (!envEntryInfo.containsProperty(permItem) || !((prop = (IDataEntityProperty)envEntryInfo.getDataEntityType().getProperties().get((Object)permItem)) instanceof BooleanProp) || !envEntryInfo.getBoolean(permItem)) continue;
                syncEnvTypes.add(envTypeInfo);
            }
        } else {
            throw new RiccBizException(ResManager.loadKDString((String)"\u7cfb\u7edf\u8fd8\u6ca1\u8fdb\u884c\u53c2\u6570\u914d\u7f6e\uff0c\u8bf7\u5148\u5230\u5b9e\u65bd\u914d\u7f6e\u4e2d\u5fc3\u3010\u57fa\u7840\u8bbe\u7f6e\u3011->\u3010\u53c2\u6570\u8bbe\u7f6e\u3011\u8fdb\u884c\u53c2\u6570\u914d\u7f6e\u3002", (String)"SysParaUtil_1", (String)"sys-ricc-common", (Object[])new Object[0]));
        }
        return syncEnvTypes;
    }

    public static boolean canUploadPacketStatusInEnvType(String envType, String packetStatus) {
        DynamicObject initConfig = SysParaUtil.getInitConfig();
        if (initConfig != null) {
            DynamicObjectCollection envEntryData = initConfig.getDynamicObjectCollection(ENV_ENTRY);
            for (DynamicObject envEntryInfo : envEntryData) {
                String envTypeInfo = envEntryInfo.getString(ENVTYPEINFO);
                if (!envTypeInfo.equals(envType) || !envEntryInfo.containsProperty(ConfigControlItems.UPLOAD_PACKET_STATUS.getValue())) continue;
                String value = envEntryInfo.getString(ConfigControlItems.UPLOAD_PACKET_STATUS.getValue());
                if (StringUtils.isEmpty(value) || "all".equals(value)) {
                    return true;
                }
                return "C".equals(packetStatus);
            }
        } else {
            throw new RiccBizException(ResManager.loadKDString((String)"\u7cfb\u7edf\u8fd8\u6ca1\u8fdb\u884c\u53c2\u6570\u914d\u7f6e\uff0c\u8bf7\u5148\u5230\u5b9e\u65bd\u914d\u7f6e\u4e2d\u5fc3\u3010\u57fa\u7840\u8bbe\u7f6e\u3011->\u3010\u53c2\u6570\u8bbe\u7f6e\u3011\u8fdb\u884c\u53c2\u6570\u914d\u7f6e\u3002", (String)"SysParaUtil_1", (String)"sys-ricc-common", (Object[])new Object[0]));
        }
        return false;
    }

    public static int getPackDataLimit() {
        DynamicObject initConfig = SysParaUtil.getInitConfig();
        int limit = initConfig.getInt("packdatalimit");
        if (limit > 1000000) {
            limit = 100000;
        }
        return limit;
    }

    public static int getPackSizeLimit() {
        DynamicObject initConfig = SysParaUtil.getInitConfig();
        int limit = initConfig.getInt("packsizelimit");
        if (limit > 500) {
            limit = 200;
        }
        return limit;
    }

    public static String getPacketSecret() {
        DynamicObject initConfig = SysParaUtil.getInitConfig();
        String packetSecret = "";
        if (initConfig != null && StringUtils.isEmpty(packetSecret = initConfig.getString("packetsecret"))) {
            packetSecret = "";
        }
        return packetSecret;
    }
}

