/*
 * Decompiled with CFR 0.152.
 */
package kd.sys.ricc.common.util;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.IFormView;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.sys.ricc.common.enums.ConfigControlItems;
import kd.sys.ricc.common.enums.EnvRoleEnum;
import kd.sys.ricc.common.query.CommonQuery;
import kd.sys.ricc.common.util.CommonUtil;
import kd.sys.ricc.common.util.StringUtils;
import kd.sys.ricc.common.util.SysParaUtil;

public class TransferUtil {
    private TransferUtil() {
        throw new IllegalStateException("Utility class");
    }

    public static void setDefaultCenterAndUser(IFormView view) {
        Object td = view.getModel().getValue("targetdatacenter");
        if (td == null) {
            long dataCenter = TransferUtil.getDataCenter();
            view.getModel().setValue("targetdatacenter", (Object)dataCenter);
            String phone = (String)view.getModel().getValue("targetdatacenteruser");
            if (StringUtils.isEmpty(phone)) {
                view.getModel().setValue("targetdatacenteruser", (Object)CommonQuery.getTransferLatestUserPhone(dataCenter));
            }
        }
    }

    public static void setDefaultLogCenter(IFormView view) {
        Object td = view.getModel().getValue("logcenter");
        if (td == null) {
            long dataCenter = TransferUtil.getLogCenter();
            view.getModel().setValue("logcenter", (Object)dataCenter);
        }
    }

    public static void setDefaultCenterAndUserMulti(IFormView view) {
        Object td = view.getModel().getValue("targetdatacenter", 0);
        if (td == null) {
            long dataCenter = TransferUtil.getDataCenter();
            view.getModel().setValue("targetdatacenter", (Object)dataCenter, 0);
            String phone = (String)view.getModel().getValue("targetdatacenteruser", 0);
            if (StringUtils.isEmpty(phone)) {
                view.getModel().setValue("targetdatacenteruser", (Object)CommonQuery.getTransferLatestUserPhone(dataCenter), 0);
            }
        }
    }

    public static void setEntryTransferType(IFormView view) {
        DynamicObjectCollection targetDataEntry = view.getModel().getEntryEntity("targetdataentry");
        if (targetDataEntry != null && !targetDataEntry.isEmpty()) {
            for (DynamicObject targetData : targetDataEntry) {
                DynamicObject targetDataCenter = targetData.getDynamicObject("targetdatacenter");
                if (targetDataCenter == null) continue;
                String tarEvnType = targetDataCenter.getString("evnType");
                String transferType = "4".equals(tarEvnType) ? "transferandsyn" : "transfer";
                targetData.set("transfertype", (Object)transferType);
            }
            view.updateView("targetdataentry");
        }
    }

    public static void fillTransTipEntry(IFormView view, LinkedHashMap<String, String> transTipMap) {
        IDataModel model = view.getModel();
        boolean hasTransTip = transTipMap != null && !transTipMap.isEmpty();
        view.setVisible(Boolean.valueOf(hasTransTip), new String[]{"transtippanelap"});
        if (transTipMap != null && !transTipMap.isEmpty()) {
            model.batchCreateNewEntryRow("entryentity", transTipMap.size());
            int i = 0;
            for (Map.Entry<String, String> transTipEntry : transTipMap.entrySet()) {
                String guideName = transTipEntry.getKey();
                String transTip = transTipEntry.getValue();
                model.setValue("guidename", (Object)guideName, i);
                model.setValue("transtips", (Object)transTip, i);
                ++i;
            }
        }
    }

    private static long getDataCenter() {
        long currentUserId = UserServiceHelper.getCurrentUserId();
        long dataCenter = 0L;
        QFilter logsFilter = new QFilter("opuser.id", "=", (Object)currentUserId);
        logsFilter.and(new QFilter("optype", "in", (Object)new String[]{"1", "4", "5"}));
        List<Long> authorizedUserIdList = CommonUtil.getAuthorizedUserIdList(currentUserId);
        if (!authorizedUserIdList.isEmpty()) {
            logsFilter.and("targetdatacenter.id", "in", authorizedUserIdList);
            DynamicObject[] logs = BusinessDataServiceHelper.load((String)"ricc_log", (String)"targetdatacenter", (QFilter[])logsFilter.toArray(), (String)"optime desc", (int)1);
            dataCenter = logs != null && logs.length > 0 ? ((DynamicObject)logs[0].get("targetdatacenter")).getLong("id") : CommonQuery.getDefaultDataCenter();
        }
        return dataCenter;
    }

    public static long getLogCenter() {
        Optional<DynamicObject> objs;
        String accountId = RequestContext.get().getAccountId();
        QFilter logsFilter = new QFilter("enable", "=", (Object)"1");
        DynamicObjectCollection enableDataCenter = QueryServiceHelper.query((String)"ricc_destaccount", (String)"id,number", (QFilter[])logsFilter.toArray(), null, (int)-1);
        if (CollectionUtils.isNotEmpty((Collection)enableDataCenter) && (objs = enableDataCenter.stream().filter(o -> StringUtils.equals(o.getString("number"), accountId)).findAny()).isPresent()) {
            return objs.get().getLong("id");
        }
        return CommonQuery.getDefaultDataCenter();
    }

    public static Map<String, Object> destAccountLoginParams(long id, String targetDataCenter) {
        HashMap<String, Object> loginParams = new HashMap<String, Object>(5);
        boolean isExists = QueryServiceHelper.exists((String)"ricc_destaccount", (Object)id);
        if (!isExists) {
            return loginParams;
        }
        DynamicObject destAccount = BusinessDataServiceHelper.loadSingle((Object)id, (String)"ricc_destaccount");
        loginParams.put("evnurl", destAccount.getString("evnurl"));
        loginParams.put("appsecuret", destAccount.getString("appsecuret"));
        loginParams.put("targetdatacenteruser", targetDataCenter);
        loginParams.put("accountId", destAccount.getString("number"));
        loginParams.put("evntype", destAccount.getString("evntype"));
        return loginParams;
    }

    public static void setTransferAndSynEnable(IFormView view) {
        DynamicObjectCollection targetDataEntry = view.getModel().getDataEntity(true).getDynamicObjectCollection("targetdataentry");
        boolean canRemoteSyn = true;
        if (targetDataEntry != null && !targetDataEntry.isEmpty()) {
            List<String> syncEnvTypes = SysParaUtil.getSyncEnvTypes(ConfigControlItems.CAN_REMOTE_SYNC.getValue());
            for (DynamicObject targetData : targetDataEntry) {
                String tarEvnType;
                DynamicObject targetDataCenter = targetData.getDynamicObject("targetdatacenter");
                if (targetDataCenter == null || syncEnvTypes.contains(tarEvnType = targetDataCenter.getString("evnType"))) continue;
                canRemoteSyn = false;
            }
        }
        if (!canRemoteSyn) {
            view.setEnable(Boolean.FALSE, new String[]{"transferandsyn"});
            view.getModel().setValue("transfercontrol", (Object)"transfer");
        } else {
            view.setEnable(Boolean.TRUE, new String[]{"transferandsyn"});
        }
    }

    public static String mustInputValidate(DynamicObjectCollection targetDataEntrys) {
        if (targetDataEntrys.isEmpty()) {
            return ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u76ee\u6807\u6570\u636e\u4e2d\u5fc3\u548c\u76ee\u6807\u6570\u636e\u4e2d\u5fc3\u7528\u6237\u3002", (String)"TransferUtil_0", (String)"sys-ricc-common", (Object[])new Object[0]);
        }
        for (DynamicObject targetData : targetDataEntrys) {
            String validateResult = TransferUtil.mustInputValidateRow(targetData);
            if (!StringUtils.isNotEmpty(validateResult)) continue;
            return validateResult;
        }
        return null;
    }

    public static String mustInputValidateRow(DynamicObject targetData) {
        DynamicObject targetDataCenter = targetData.getDynamicObject("targetdatacenter");
        String targetDataCenterUser = targetData.getString("targetdatacenteruser");
        String transferType = targetData.getString("transfertype");
        if (targetDataCenter == null && StringUtils.isEmpty(targetDataCenterUser)) {
            return ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u76ee\u6807\u6570\u636e\u4e2d\u5fc3\u548c\u76ee\u6807\u6570\u636e\u4e2d\u5fc3\u7528\u6237\u3002", (String)"TransferUtil_0", (String)"sys-ricc-common", (Object[])new Object[0]);
        }
        if (targetDataCenter == null) {
            return ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u76ee\u6807\u6570\u636e\u4e2d\u5fc3\u3002", (String)"TransferUtil_1", (String)"sys-ricc-common", (Object[])new Object[0]);
        }
        if (StringUtils.isBlank(transferType)) {
            return ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u4f20\u8f93\u7c7b\u578b\u3002", (String)"TransferUtil_5", (String)"sys-ricc-common", (Object[])new Object[0]);
        }
        String tarEvnType = targetDataCenter.getString("evnType");
        EnvRoleEnum tarEnvRole = EnvRoleEnum.fromVal(tarEvnType);
        if (tarEnvRole == null) {
            return ResManager.loadKDString((String)"\u60a8\u9009\u62e9\u7684\u76ee\u6807\u6570\u636e\u4e2d\u5fc3[%s]\u7684\u73af\u5883\u7c7b\u578b\u65e0\u6cd5\u8bc6\u522b\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002", (String)"TransferUtil_2", (String)"sys-ricc-common", (Object[])new Object[]{targetDataCenter.getString("name")});
        }
        if (StringUtils.isEmpty(targetDataCenterUser)) {
            return ResManager.loadKDString((String)"\u8bf7\u5148\u5f55\u5165\u76ee\u6807\u6570\u636e\u4e2d\u5fc3\u7528\u6237\u3002", (String)"TransferUtil_3", (String)"sys-ricc-common", (Object[])new Object[0]);
        }
        if (!StringUtils.isPhone(targetDataCenterUser)) {
            return ResManager.loadKDString((String)"\u76ee\u6807\u6570\u636e\u4e2d\u5fc3\u7528\u6237\u624b\u673a\u53f7\u7801[%s]\u683c\u5f0f\u4e0d\u6b63\u786e\u3002", (String)"TransferUtil_4", (String)"sys-ricc-common", (Object[])new Object[]{targetDataCenterUser});
        }
        return "";
    }

    public static boolean isHasSyn(DynamicObjectCollection targetDataEntry) {
        boolean isHasSyn = false;
        for (DynamicObject entryRow : targetDataEntry) {
            String transferType = entryRow.getString("transfertype");
            if (!StringUtils.equals(transferType, "transferandsyn")) continue;
            isHasSyn = true;
            break;
        }
        return isHasSyn;
    }
}

