/*
 * Decompiled with CFR 0.152.
 */
package kd.sys.ricc.business.datapacket.core.impl.plugin;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.basedata.cache.BaseDataCtrlCache;
import kd.bos.basedata.cache.BaseDataCtrlCacheMrg;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.Propagation;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.sys.ricc.business.datapacket.core.helper.DataPacketHelper;
import kd.sys.ricc.business.datapacket.core.impl.json.JsonDataPacketImpl;
import kd.sys.ricc.business.datapacket.core.impl.json.JsonSupportSubEntityImpl;
import kd.sys.ricc.business.datapacket.core.model.SdpInputParams;
import kd.sys.ricc.business.datapacket.core.model.SdpOutputParams;
import kd.sys.ricc.exception.RiccBizException;

public class BdCtrlImpl
extends JsonSupportSubEntityImpl {
    private static final Log logger = LogFactory.getLog(BdCtrlImpl.class);
    private static final String BD_DEF_CTRL_STRATEGY = "bd_bddefctrlstrtgy";
    private static final String BD_BASE_DATA_VIEW = "bd_basedataview";
    private static final String CTRL_VIEW_ID = "ctrlview_id";
    private static final String BASE_DATA_ID_ID = "basedataid_id";
    private static final String BASE_DATA_ID = "basedata_id";
    private static final String BD_CTRL_STRATEGY = "bd_bdctrlstrtgy";
    private static final String CTRL_VIEW = "ctrlview";

    public SdpOutputParams exportPacket(SdpInputParams sdpInputParams) {
        return this.jsonExportPacket(sdpInputParams, false);
    }

    protected List<JsonSupportSubEntityImpl.EntityMappingInfo> getSubEntityList() {
        ArrayList<JsonSupportSubEntityImpl.EntityMappingInfo> entityMappingInfoList = new ArrayList<JsonSupportSubEntityImpl.EntityMappingInfo>();
        entityMappingInfoList.add(new JsonSupportSubEntityImpl.EntityMappingInfo("bd_ctrlstgyfieldcfg", BASE_DATA_ID_ID, BASE_DATA_ID, ",number,basedata_id"));
        entityMappingInfoList.add(new JsonSupportSubEntityImpl.EntityMappingInfo(BD_CTRL_STRATEGY, null, null, ",basedataview_id,cu", JsonDataPacketImpl.BatchSaveType.SAVE));
        return entityMappingInfoList;
    }

    protected void beforeImportPacket(SdpInputParams sdpInputParams, SdpOutputParams sdpOutputParams) {
        super.beforeImportPacket(sdpInputParams, sdpOutputParams);
        Map param = sdpInputParams.getParam();
        DynamicObject guideInfo = (DynamicObject)param.get("guideInfo");
        String formId = guideInfo.getString("page.number");
        String entityName = guideInfo.getString("name");
        String appId = guideInfo.getString("page.bizappid");
        if (!PermissionServiceHelper.isAdminUser((long)UserServiceHelper.getCurrentUserId())) {
            String permTips = ResManager.loadKDString((String)"\u7ba1\u7406\u5458\u624d\u53ef\u4ee5\u8bbe\u7f6e\u7ba1\u63a7\u7b56\u7565\uff0c\u8bf7\u6dfb\u52a0\u6743\u9650\u540e\u518d\u8bd5", (String)"BdCtrlImpl_1", (String)"sys-ricc-business", (Object[])new Object[0]);
            sdpOutputParams.append(permTips).append((Object)Character.valueOf('\n'));
            sdpOutputParams.setSuccess(false);
            return;
        }
        boolean hasPermission = DataPacketHelper.checkPermissions(UserServiceHelper.getCurrentUserId(), appId, formId, entityName, sdpOutputParams, "47150e89000000ac");
        sdpOutputParams.setSuccess(hasPermission);
    }

    protected String getEntityNumber(Map<String, Object> customParam) {
        return BD_DEF_CTRL_STRATEGY;
    }

    protected int getImportBatchSize() {
        return 1;
    }

    protected String getKeyFields() {
        return BASE_DATA_ID_ID;
    }

    protected Propagation getImportTransactionType() {
        return Propagation.REQUIRED;
    }

    protected Map<String, Map<String, Object>> getBatchSubContentMap(DynamicObject[] batchData, Map<String, Object> batchContentMap, JsonSupportSubEntityImpl.EntityMappingInfo entityMappingInfo) {
        String entityNumber = entityMappingInfo.getEntityNumber();
        if (BD_CTRL_STRATEGY.equals(entityNumber)) {
            return this.getControlStrategeDataMap(batchData);
        }
        return super.getBatchSubContentMap(batchData, batchContentMap, entityMappingInfo);
    }

    private Map<String, Map<String, Object>> getControlStrategeDataMap(DynamicObject[] batchData) {
        Map<String, List<Object>> viewRelationMainAndSubValueMap = this.getViewRelationMainAndSubValueMap(batchData);
        if (viewRelationMainAndSubValueMap.isEmpty()) {
            return Collections.emptyMap();
        }
        Map batchSubDataMap = this.batchExportData(BD_CTRL_STRATEGY, "basedataview_id", viewRelationMainAndSubValueMap);
        return this.getMainIdAndSubDataMap("basedataview_id", viewRelationMainAndSubValueMap, batchSubDataMap);
    }

    private Map<String, List<Object>> getViewRelationMainAndSubValueMap(DynamicObject[] batchData) {
        Set entitySet = Arrays.stream(batchData).map(p -> p.getString(BASE_DATA_ID_ID)).collect(Collectors.toSet());
        Set ctlViewSet = Arrays.stream(batchData).map(p -> p.getLong(CTRL_VIEW_ID)).collect(Collectors.toSet());
        QFilter qFilter = new QFilter(BASE_DATA_ID, "in", entitySet);
        qFilter.and(new QFilter(CTRL_VIEW, "in", ctlViewSet));
        List baseDataViewIdList = QueryServiceHelper.queryPrimaryKeys((String)BD_BASE_DATA_VIEW, (QFilter[])qFilter.toArray(), null, (int)-1);
        DynamicObject[] viewRelationArr = BusinessDataServiceHelper.load((Object[])baseDataViewIdList.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)BD_BASE_DATA_VIEW));
        HashMap<String, List<Object>> subContentMap = new HashMap<String, List<Object>>(batchData.length);
        for (DynamicObject data : batchData) {
            String id = data.getString("id");
            String baseDataId = data.getString(BASE_DATA_ID_ID);
            String ctrlViewId = data.getString(CTRL_VIEW_ID);
            ArrayList<Object> subDataList = new ArrayList<Object>(4);
            subContentMap.put(id, subDataList);
            for (DynamicObject dynamicObject : viewRelationArr) {
                Object relationId = dynamicObject.get("id");
                String relationBaseDataId = dynamicObject.getString(BASE_DATA_ID);
                String relationCtrlViewId = dynamicObject.getString(CTRL_VIEW_ID);
                if (!baseDataId.equals(relationBaseDataId) || !ctrlViewId.equals(relationCtrlViewId)) continue;
                subDataList.add(relationId);
            }
        }
        return subContentMap;
    }

    protected void subEntityImport(List<Object> idList, JSONObject dataMap, SdpOutputParams outputParams, JsonSupportSubEntityImpl.EntityMappingInfo subEntityInfo) {
        String entityNumber = subEntityInfo.getEntityNumber();
        if (!BD_CTRL_STRATEGY.equals(entityNumber)) {
            super.subEntityImport(idList, dataMap, outputParams, subEntityInfo);
            return;
        }
        String keyFields = subEntityInfo.getKeyFields();
        JsonDataPacketImpl.BatchSaveType batchSaveType = subEntityInfo.getBatchSaveType();
        for (Object id : idList) {
            Map entityDataMap;
            Map allData = (Map)dataMap.get((Object)id.toString());
            Map mainBdMap = (Map)allData.get("bd");
            Map subDataMap = (Map)allData.get("subData");
            if (subDataMap == null || subDataMap.isEmpty() || (entityDataMap = (Map)subDataMap.get(entityNumber)) == null || entityDataMap.isEmpty()) continue;
            List baseData = (List)mainBdMap.get("basedataid");
            List ctrlViewList = (List)mainBdMap.get(CTRL_VIEW);
            String baseDataNumber = (String)baseData.get(3);
            String ctrlViewNumber = (String)ctrlViewList.get(3);
            DynamicObject ctrlView = BusinessDataServiceHelper.loadSingle((String)"bos_org_viewschema", (String)"id,name,number", (QFilter[])new QFilter("number", "=", (Object)ctrlViewNumber).toArray());
            DynamicObject baseView = this.newOrUpdateRelationView(ctrlView, baseDataNumber);
            List<String> viewOrgNumberList = this.getOrgByViewNumber(ctrlViewNumber);
            for (Map.Entry ctrlRuleEntryData : entityDataMap.entrySet()) {
                Map entityAllData = (Map)ctrlRuleEntryData.getValue();
                Map entityBdMap = (Map)entityAllData.get("bd");
                List cu = (List)entityBdMap.get("cu");
                String orgNumber = (String)cu.get(3);
                if (!viewOrgNumberList.contains(orgNumber)) {
                    String entityName = EntityMetadataCache.getDataEntityType((String)baseDataNumber).getDisplayName().getLocaleValue();
                    String msgTpl = String.format(ResManager.loadKDString((String)"\u540c\u6b65\u57fa\u7840\u8d44\u6599\u201c%1$s\u201d\u51fa\u9519\uff0c\u4e3b\u6570\u636e\u63a7\u5236\u89c6\u56fe\u201c%2$s\u201d\u4e2d\u4e0d\u5b58\u5728\u7f16\u7801\u4e3a\u201c%3$s\u201d\u7684\u7ec4\u7ec7\uff0c\u65e0\u6cd5\u5728\u57fa\u7840\u6570\u636e\u7ba1\u63a7\u7b56\u7565\u63a7\u5236\u89c4\u5219\u65b0\u589e\u8be5\u7ec4\u7ec7\u7684\u63a7\u5236\u89c4\u5219\uff0c\u8bf7\u5148\u5c06\u8be5\u7ec4\u7ec7\u52a0\u5165\u4e3b\u6570\u636e\u63a7\u5236\u89c6\u56fe\u4e2d\uff0c\u518d\u91cd\u65b0\u6267\u884c\u540c\u6b65 %n", (String)"BdCtrlImpl_0", (String)"sys-ricc-business", (Object[])new Object[0]), entityName, ctrlView.getString("name"), orgNumber);
                    outputParams.append(msgTpl);
                    throw new RiccBizException(msgTpl);
                }
                List baseDataView = (List)entityBdMap.get("basedataview");
                baseDataView.set(2, baseView.getString("id"));
                Map ctrlDataMap = (Map)entityAllData.get("data");
                ctrlDataMap.put("basedataview_id", baseView.getString("id"));
            }
            int successCount = this.batchImportSave(entityNumber, idList, entityDataMap, outputParams, keyFields, batchSaveType);
            if (successCount >= entityDataMap.size()) continue;
            String error = ResManager.loadKDString((String)"\u5b50\u5b9e\u4f53\u201d%1$s\u201c\u603b\u6570 \u201d%2$s\u201c \u5bfc\u5165\u6210\u529f\u6570\u91cf\u201d%3$s\u201c", (String)"JsonSupportSubEntityImpl_0", (String)"sys-ricc-platform", (Object[])new Object[]{entityNumber, entityDataMap.size(), successCount});
            throw new RiccBizException(error);
        }
    }

    protected void afterBatchImport(List<Object> idList, JSONObject dataMap, SdpOutputParams outputParams) {
        for (Object id : idList) {
            JSONObject ctrlObj = dataMap.getJSONObject(id.toString());
            JSONObject ctrlData = ctrlObj.getJSONObject("data");
            String entityNumber = ctrlData.getString(BASE_DATA_ID_ID);
            String plugin = ctrlData.getString("plugin");
            String type = BaseDataCtrlCacheMrg.getType4BaseDataCtrlPlugin();
            if (StringUtils.isNotBlank((CharSequence)plugin)) {
                BaseDataCtrlCacheMrg.putCache((String)type, (String)entityNumber, (String)plugin);
            } else {
                BaseDataCtrlCacheMrg.clearCache((String)type, (String)entityNumber);
            }
            BaseDataCtrlCacheMrg.getLocalCtrlCache().clear();
            BaseDataCtrlCache.clearWithPrefixBaseDataUseRange((String)entityNumber);
        }
    }

    private DynamicObject newOrUpdateRelationView(DynamicObject ctrlView, String baseDataNumber) {
        DynamicObject baseView = BusinessDataServiceHelper.loadSingle((String)BD_BASE_DATA_VIEW, (String)"basedata,ctrlview", (QFilter[])new QFilter[]{new QFilter("basedata", "=", (Object)baseDataNumber)});
        if (baseView != null) {
            baseView.set(CTRL_VIEW, (Object)ctrlView);
        } else {
            baseView = BusinessDataServiceHelper.newDynamicObject((String)BD_BASE_DATA_VIEW);
            baseView.set("basedata", (Object)baseDataNumber);
            baseView.set(CTRL_VIEW, (Object)ctrlView);
        }
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{baseView});
        return baseView;
    }

    private List<String> getOrgByViewNumber(String viewSchemaNumber) {
        QFilter viewFilter = new QFilter("view.number", "=", (Object)viewSchemaNumber);
        viewFilter = viewFilter.and(new QFilter("org.enable", "=", (Object)Boolean.TRUE));
        viewFilter = viewFilter.and(new QFilter("isfreeze", "=", (Object)Boolean.FALSE));
        DynamicObjectCollection orgCollection = QueryServiceHelper.query((String)"bos_org_structure", (String)"org.number number", (QFilter[])viewFilter.toArray());
        return orgCollection.stream().map(org -> org.getString("number")).collect(Collectors.toList());
    }

    public Map<String, Object> provideData(Map<String, Object> params) {
        return null;
    }
}

