/*
 * Decompiled with CFR 0.152.
 */
package kd.sys.ricc.business.datapacket.core.impl.plugin;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.util.CollectionUtils;
import kd.sys.ricc.business.datapacket.core.impl.json.JsonDataPacketImpl;
import kd.sys.ricc.business.datapacket.core.impl.json.JsonSupportSubEntityImpl;
import kd.sys.ricc.business.datapacket.core.model.SdpOutputParams;

public class BusinessItemImpl
extends JsonSupportSubEntityImpl {
    private static final Log logger = LogFactory.getLog(BusinessItemImpl.class);

    protected void beforeConvertToMap(DynamicObject[] batchData) {
        if (batchData != null && batchData.length > 0) {
            Arrays.stream(batchData).forEach(o -> this.fillBillTypeEntry((DynamicObject)o));
        }
    }

    protected List<JsonSupportSubEntityImpl.EntityMappingInfo> getSubEntityList() {
        ArrayList<JsonSupportSubEntityImpl.EntityMappingInfo> entityMappingInfoList = new ArrayList<JsonSupportSubEntityImpl.EntityMappingInfo>(2);
        entityMappingInfoList.add(new JsonSupportSubEntityImpl.EntityMappingInfo("bd_busitemrelparam", "paramnumber_id", "paramid_id", ",businessitem_id,paramid_id", JsonDataPacketImpl.BatchSaveType.SAVE));
        entityMappingInfoList.add(new JsonSupportSubEntityImpl.EntityMappingInfo("bd_businessitembill", "billtype_id", "billtype_id", ",businessitem_id,billtype_id", JsonDataPacketImpl.BatchSaveType.SAVE));
        return entityMappingInfoList;
    }

    protected void beforeBatchImport(List<Object> idList, JSONObject dataMap, SdpOutputParams outputParams) {
    }

    protected void afterBatchImportForSpecial(List<Object> idList, JSONObject dataMap, SdpOutputParams outputParams) {
        List<JsonSupportSubEntityImpl.EntityMappingInfo> subEntityList = this.getSubEntityList();
        if (subEntityList == null || subEntityList.isEmpty()) {
            return;
        }
        for (JsonSupportSubEntityImpl.EntityMappingInfo subEntityInfo : subEntityList) {
            logger.info("\u62a5\u8d26\u4e1a\u52a1\u7c7b\u578b\u5b50\u5b9e\u4f53\u5904\u7406{}", (Object)JSONObject.toJSONString(idList));
            if (CollectionUtils.isNotEmpty(idList)) {
                DeleteServiceHelper.delete((String)subEntityInfo.getEntityNumber(), (QFilter[])new QFilter[]{new QFilter("businessitem.id", "in", idList)});
            }
            this.subEntityImport(idList, dataMap, outputParams, subEntityInfo);
        }
    }

    private void fillBillTypeEntry(DynamicObject obj) {
        DynamicObject[] relatedParam = BusinessDataServiceHelper.load((String)"bd_busitemrelparam", (String)"paramid.id,value", (QFilter[])new QFilter[]{new QFilter("businessitem.id", "=", obj.getPkValue())});
        DynamicObjectCollection paramentry = obj.getDynamicObjectCollection("paramentry");
        for (DynamicObject param : relatedParam) {
            DynamicObject[] entryObj = paramentry.addNew();
            entryObj.set("paramnumber", (Object)param.getDynamicObject("paramid"));
            entryObj.set("paramvalue", param.get("value"));
        }
        DynamicObject[] allBillTypes = BusinessDataServiceHelper.load((String)"er_billtype", (String)"id", (QFilter[])new QFilter("enable", "=", (Object)Boolean.TRUE).toArray());
        DynamicObject[] relatedBillType = BusinessDataServiceHelper.load((String)"bd_businessitembill", (String)"billtype.id", (QFilter[])new QFilter[]{new QFilter("businessitem.id", "=", obj.getPkValue())});
        Set relatedBillTypePks = Stream.of(relatedBillType).map(v -> v.getDynamicObject("billtype").getPkValue()).collect(Collectors.toSet());
        HashMap<Object, DynamicObject> selectObjMap = new HashMap<Object, DynamicObject>(10);
        for (DynamicObject billType : allBillTypes) {
            if (!relatedBillTypePks.contains(billType.getPkValue())) continue;
            selectObjMap.put(billType.getPkValue(), billType);
        }
        DynamicObjectCollection billTypeEntry = obj.getDynamicObjectCollection("billtypeentry");
        for (Map.Entry entry : selectObjMap.entrySet()) {
            DynamicObject entryObj = billTypeEntry.addNew();
            entryObj.set("billtype", entry.getValue());
            entryObj.set("setrelate", (Object)Boolean.TRUE);
        }
        obj.getDynamicObjectCollection("billtypeentry");
    }

    protected void afterBatchExport(DynamicObject[] batchData, Map<String, Object> batchContentMap) {
        super.afterBatchExport(batchData, batchContentMap);
        List entityNumberList = this.getSubEntityList().stream().map(o -> o.getEntityNumber()).collect(Collectors.toList());
        Arrays.stream(batchData).forEach(o -> {
            Object pkValue = o.getPkValue();
            Map contentMap = (Map)batchContentMap.get(String.valueOf(pkValue));
            if (contentMap.get("subData") != null) {
                Map subDataMap = (Map)contentMap.get("subData");
                for (String entityNumber : entityNumberList) {
                    if (subDataMap.get(entityNumber) == null) continue;
                    Map entityDataMap = (Map)subDataMap.get(entityNumber);
                    Iterator iterator = entityDataMap.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map dataMap;
                        String businessItemId;
                        Map map = (Map)iterator.next().getValue();
                        if (map == null || map.get("data") == null || StringUtils.equals((CharSequence)(businessItemId = String.valueOf((dataMap = (Map)map.get("data")).get("businessitem_id"))), (CharSequence)String.valueOf(pkValue))) continue;
                        iterator.remove();
                    }
                }
            }
        });
    }

    public Map<String, Object> provideData(Map<String, Object> params) {
        return null;
    }

    protected JsonDataPacketImpl.BatchSaveType getBatchSaveType() {
        return JsonDataPacketImpl.BatchSaveType.SAVE;
    }
}

