/*
 * Decompiled with CFR 0.152.
 */
package kd.sys.ricc.business.datapacket.core.impl.plugin;

import java.io.File;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.sys.ricc.business.datapacket.core.ISubDataPacket;
import kd.sys.ricc.business.datapacket.core.helper.DataPacketHelper;
import kd.sys.ricc.business.datapacket.core.model.SdpInputParams;
import kd.sys.ricc.business.datapacket.core.model.SdpOutputParams;
import kd.sys.ricc.business.datapacket.schedule.AddPacketProgress;
import kd.sys.ricc.business.schedule.ScheduleUtil;
import kd.sys.ricc.common.constant.CommonConstant;
import kd.sys.ricc.common.query.CommonQuery;
import kd.sys.ricc.common.util.BatchSplitUtil;
import kd.sys.ricc.common.util.CommonUtil;
import kd.sys.ricc.common.util.FileUtils;
import kd.sys.ricc.common.util.StringUtils;

public class IscImpl
implements ISubDataPacket {
    private static final Log logger = LogFactory.getLog(IscImpl.class);
    private static final int BATCH_SIZE = 100;
    private static final String ISC_EXPORT_PERM = "1O5+W+HT1WD4";
    private static final String ENTITY_NAME = "entityName";

    public SdpOutputParams exportPacket(SdpInputParams sdpInputParams) {
        SdpOutputParams sdpOutputParams = new SdpOutputParams();
        if (sdpInputParams == null) {
            sdpOutputParams.append(ResManager.loadKDString((String)"\u8f93\u5165\u53c2\u6570\u6709\u8bef\uff0c\u5bfc\u5165\u5931\u8d25\u3002", (String)"IscImpl_0", (String)"sys-ricc-business", (Object[])new Object[0]));
            return sdpOutputParams;
        }
        ListSelectedRowCollection selectRows = sdpInputParams.getSelectRows();
        Map customParam = sdpInputParams.getParam();
        String entityName = (String)customParam.get("entityname");
        String entityNumber = (String)customParam.get("entitynumber");
        if (selectRows.isEmpty()) {
            logger.info("\u96c6\u6210\u670d\u52a1\u4e91\u914d\u7f6e\u9879\u4e00\u952e\u6253\u5305\u5bfc\u51fa\u6570\u636e\u5f00\u59cb");
            String filters = DataPacketHelper.getFilters(customParam);
            selectRows = CommonQuery.getAllSelectData((String)entityNumber, (String)filters);
        }
        if (selectRows.isEmpty()) {
            sdpOutputParams.append(ResManager.loadKDString((String)"\u6682\u65e0\u53ef\u5bfc\u51fa\u6570\u636e\u3002", (String)"IscImpl_1", (String)"sys-ricc-business", (Object[])new Object[0])).append((Object)Character.valueOf('\n'));
            sdpOutputParams.setSuccess(false);
            return sdpOutputParams;
        }
        int totalSize = selectRows.size();
        AddPacketProgress addPacketProgress = sdpInputParams.getAddPacketProgress();
        List spitBatchList = BatchSplitUtil.splitBatch((List)selectRows, (int)100);
        int completeNum = 0;
        for (int i = 0; i < spitBatchList.size(); ++i) {
            List oneBatchList = (List)spitBatchList.get(i);
            ArrayList<Object> selectedIds = new ArrayList<Object>(4);
            for (ListSelectedRow selectedRow : oneBatchList) {
                selectedIds.add(selectedRow.getPrimaryKeyValue());
            }
            String filename = i + "_" + System.currentTimeMillis() + ".json";
            String fullFilePath = sdpInputParams.getLocalPath() + File.separator + filename;
            try {
                String oneBatchString = this.exportResourceByMultiId(entityNumber, selectedIds);
                FileUtils.writeStr2File((String)fullFilePath, (String)oneBatchString);
            }
            catch (Exception e) {
                logger.error("\u96c6\u6210\u4e91\u914d\u7f6e\u9879\u5bfc\u51fa\u6570\u636e\u5199\u5165\u6587\u4ef6\u51fa\u9519\u3002", (Throwable)e);
                sdpOutputParams.append(String.format(ResManager.loadKDString((String)"\u96c6\u6210\u4e91\u914d\u7f6e\u9879\u5bfc\u51fa\u6570\u636e\u5199\u5165\u6587\u4ef6\u51fa\u9519\uff0c\u6587\u4ef6\u540d\uff1a%1$s %2$s\u3002", (String)"IscImpl_2", (String)"sys-ricc-business", (Object[])new Object[0]), filename, e.getMessage()), (Throwable)e).append((Object)Character.valueOf('\n'));
                sdpOutputParams.setSuccess(false);
                return sdpOutputParams;
            }
            ScheduleUtil.addPacketFeedbackProgress((AddPacketProgress)addPacketProgress, (int)totalSize, (int)(completeNum += oneBatchList.size()));
        }
        String zipName = FileUtils.dirToZip((String)sdpInputParams.getLocalPath(), (String)entityName);
        sdpOutputParams.setExportFilePath(zipName);
        StringBuilder selectedInfo = new StringBuilder();
        selectedInfo.append(String.format(CommonConstant.getSelectedTitle(), entityName, entityName));
        for (int j = 0; j < selectRows.size(); ++j) {
            selectedInfo.append(String.format("%1$s\t\t%2$s\t\t%3$s %n", j + 1, selectRows.get(j).getNumber(), selectRows.get(j).getName()));
        }
        sdpOutputParams.setSelectedInfo(selectedInfo.toString());
        sdpOutputParams.setSuccess(true);
        return sdpOutputParams;
    }

    public SdpOutputParams importPacket(SdpInputParams sdpInputParams) {
        SdpOutputParams sdpOutputParams = new SdpOutputParams();
        Map param = sdpInputParams.getParam();
        DynamicObject guideInfo = (DynamicObject)param.get("guideInfo");
        String entityNumber = guideInfo.getString("page.number");
        String entityName = guideInfo.getString("name");
        String appId = guideInfo.getString("page.bizappid");
        boolean hashPermissions = DataPacketHelper.checkPermissions(UserServiceHelper.getCurrentUserId(), appId, entityNumber, entityName, sdpOutputParams, "47150e89000000ac", ISC_EXPORT_PERM);
        if (!hashPermissions) {
            sdpOutputParams.setSuccess(false);
            return sdpOutputParams;
        }
        FileService fileService = FileServiceFactory.getAttachmentFileService();
        String fileUrl = (String)sdpInputParams.getParam().get("fileUrl");
        if (!fileService.exists(fileUrl = CommonUtil.checkUrl((String)fileUrl))) {
            sdpOutputParams.setSuccess(false);
            sdpOutputParams.append(String.format(ResManager.loadKDString((String)"\u6839\u636e\u5730\u5740%s\u6ca1\u6709\u83b7\u53d6\u5230\u6709\u6548\u7684\u6587\u4ef6\u3002", (String)"IscImpl_3", (String)"sys-ricc-business", (Object[])new Object[0]), fileUrl));
            return sdpOutputParams;
        }
        int successCount = 0;
        int failedCount = 0;
        try (InputStream inputStream = fileService.getInputStream(fileUrl);
             ZipInputStream zipIn = new ZipInputStream(inputStream, Charset.forName("GBK"));){
            ZipEntry zipEntry;
            String zipFileName = (String)param.get("fileName");
            while ((zipEntry = zipIn.getNextEntry()) != null) {
                String content = DataPacketHelper.getZipFileContent(zipIn);
                String fileName = zipEntry.getName();
                if (StringUtils.isEmpty((String)content)) {
                    String msgTpl = ResManager.loadKDString((String)"%1$s: %2$s \u6587\u4ef6\u5185\u5bb9\u4e3a\u7a7a\u3002", (String)"IscImpl_4", (String)"sys-ricc-business", (Object[])new Object[0]);
                    sdpOutputParams.append(String.format(msgTpl, zipFileName, fileName)).append((Object)Character.valueOf('\n'));
                    continue;
                }
                try {
                    String fileMessage = String.format(ResManager.loadKDString((String)"\u6587\u4ef6%1$s\u5bfc\u5165\u7ed3\u679c\u8be6\u60c5\uff1a", (String)"IscImpl_5", (String)"sys-ricc-business", (Object[])new Object[0]), fileName);
                    sdpOutputParams.append(fileMessage).append((Object)Character.valueOf('\n'));
                    List<Map<String, Object>> resultList = this.importResourceWithResponse(content);
                    ArrayList<Map<String, Object>> refList = new ArrayList<Map<String, Object>>(4);
                    ArrayList<Map<String, Object>> mainResourceList = new ArrayList<Map<String, Object>>(4);
                    for (Map<String, Object> result : resultList) {
                        boolean isRef = (Boolean)result.get("isref");
                        if (isRef) {
                            refList.add(result);
                            continue;
                        }
                        mainResourceList.add(result);
                    }
                    ArrayList<Map<String, Object>> mainResourceFailList = new ArrayList<Map<String, Object>>(4);
                    ArrayList<Map<String, Object>> mainResourceSuccessList = new ArrayList<Map<String, Object>>(4);
                    for (Map map : mainResourceList) {
                        String status = (String)map.get("status");
                        if (StringUtils.equals((String)"failed", (String)status)) {
                            mainResourceFailList.add(map);
                            ++failedCount;
                            continue;
                        }
                        mainResourceSuccessList.add(map);
                        ++successCount;
                    }
                    this.writeMainResourceImportMessage(sdpOutputParams, mainResourceFailList, mainResourceSuccessList);
                    String refTitle = ResManager.loadKDString((String)"\u4e8c\u3001\u4f9d\u8d56\u8d44\u6e90\uff1a%s", (String)"IscImpl_7", (String)"sys-ricc-business", (Object[])new Object[]{System.lineSeparator()});
                    if (refList.isEmpty()) {
                        String string = ResManager.loadKDString((String)"\u65e0\u4f9d\u8d56\u8d44\u6e90\u9700\u8981\u5bfc\u5165\u3002", (String)"IscImpl_20", (String)"sys-ricc-business", (Object[])new Object[0]);
                        sdpOutputParams.append(refTitle).append(string);
                        continue;
                    }
                    this.writeRefResourceImportMessage(sdpOutputParams, refList, refTitle);
                }
                catch (Exception e) {
                    logger.error("\u96c6\u6210\u4e91\u914d\u7f6e\u9879\u5bfc\u5165\u6570\u636e\u51fa\u9519\u3002", (Throwable)e);
                    sdpOutputParams.append(String.format(ResManager.loadKDString((String)"\u96c6\u6210\u4e91\u914d\u7f6e\u9879\u5bfc\u5165\u6570\u636e\u51fa\u9519\uff0c\u6587\u4ef6\u540d\uff1a%1$s %2$s\u3002", (String)"IscImpl_6", (String)"sys-ricc-business", (Object[])new Object[0]), fileName, e.getMessage()), (Throwable)e).append((Object)Character.valueOf('\n'));
                    sdpOutputParams.setSuccess(false);
                }
            }
        }
        catch (Exception e) {
            sdpOutputParams.setSuccess(false);
            String msg = String.format(CommonConstant.getImportFileErrorTip(), entityName);
            sdpOutputParams.append(msg, (Throwable)e);
            logger.error(msg, (Throwable)e);
            return sdpOutputParams;
        }
        boolean success = failedCount <= 0;
        sdpOutputParams.setSuccess(success);
        Map params = sdpOutputParams.getParam();
        params.put("successCount", successCount);
        params.put("failedCount", failedCount);
        sdpOutputParams.setParam(params);
        return sdpOutputParams;
    }

    private void writeRefResourceImportMessage(SdpOutputParams sdpOutputParams, List<Map<String, Object>> refList, String refTitle) {
        ArrayList<Map<String, Object>> refFailList = new ArrayList<Map<String, Object>>(4);
        ArrayList<Map<String, Object>> refIgnoreList = new ArrayList<Map<String, Object>>(4);
        ArrayList<Map<String, Object>> refSuccessList = new ArrayList<Map<String, Object>>(4);
        for (Map<String, Object> ref : refList) {
            String string = (String)ref.get("status");
            if (StringUtils.equals((String)"failed", (String)string)) {
                refFailList.add(ref);
                continue;
            }
            String omittedMsg = (String)ref.get("omittedMessage");
            if (StringUtils.isNotBlank((CharSequence)omittedMsg)) {
                refIgnoreList.add(ref);
                continue;
            }
            refSuccessList.add(ref);
        }
        String refResourceDesc = refTitle + String.format(ResManager.loadKDString((String)"1\u3001\u5931\u8d25%1$d\u6761", (String)"IscImpl_8", (String)"sys-ricc-business", (Object[])new Object[0]), refFailList.size());
        sdpOutputParams.append(refResourceDesc).append((Object)Character.valueOf('\n'));
        if (!refFailList.isEmpty()) {
            for (Map map : refFailList) {
                String refFailEntityName = ((LocaleString)map.get(ENTITY_NAME)).getLocaleValue();
                String refFailNumber = (String)map.get("number");
                String refFailError = (String)map.get("error");
                String errorMessage = String.format(ResManager.loadKDString((String)"\"%1$s\"\u7f16\u7801\u4e3a%2$s\u7684\u6570\u636e\u5bfc\u5165\u5931\u8d25, %3$s", (String)"IscImpl_9", (String)"sys-ricc-business", (Object[])new Object[0]), refFailEntityName, refFailNumber, refFailError);
                sdpOutputParams.append(errorMessage).append((Object)Character.valueOf('\n'));
            }
        }
        String ignoreDesc = String.format(ResManager.loadKDString((String)"2\u3001\u5ffd\u7565%1$d\u6761", (String)"IscImpl_10", (String)"sys-ricc-business", (Object[])new Object[0]), refIgnoreList.size());
        sdpOutputParams.append(ignoreDesc);
        if (!refIgnoreList.isEmpty()) {
            String string = '\t' + String.format(ResManager.loadKDString((String)"\u5ffd\u7565\u7684\u539f\u56e0\u5747\u4e3a\uff1a%1$s", (String)"IscImpl_11", (String)"sys-ricc-business", (Object[])new Object[0]), ((Map)refIgnoreList.get(0)).get("omittedMessage"));
            sdpOutputParams.append(string).append((Object)Character.valueOf('\n')).append((Object)Character.valueOf('\n'));
            String ignoreMessage = ResManager.loadKDString((String)"\"%1$s\"\u7f16\u7801\u4e3a\uff08%2$s\uff09\u7684\u6570\u636e\u5ffd\u7565\u5bfc\u5165\u3002", (String)"IscImpl_12", (String)"sys-ricc-business", (Object[])new Object[0]);
            this.accordingToEntitySortRef(sdpOutputParams, refIgnoreList, ignoreMessage);
        } else {
            sdpOutputParams.append((Object)Character.valueOf('\n'));
        }
        String string = String.format(ResManager.loadKDString((String)"3\u3001\u6210\u529f%1$d\u6761", (String)"IscImpl_13", (String)"sys-ricc-business", (Object[])new Object[0]), refSuccessList.size());
        sdpOutputParams.append(string).append((Object)Character.valueOf('\n'));
        if (!refSuccessList.isEmpty()) {
            String successMessage = ResManager.loadKDString((String)"\"%1$s\"\u7f16\u7801\u4e3a\uff08%2$s\uff09\u7684\u6570\u636e\u5bfc\u5165\u6210\u529f\u3002", (String)"IscImpl_14", (String)"sys-ricc-business", (Object[])new Object[0]);
            this.accordingToEntitySortRef(sdpOutputParams, refSuccessList, successMessage);
        }
    }

    private void accordingToEntitySortRef(SdpOutputParams sdpOutputParams, List<Map<String, Object>> refList, String message) {
        HashMap<String, List> refMap = new HashMap<String, List>(4);
        for (Map<String, Object> ref : refList) {
            String refEntityName = ((LocaleString)ref.get(ENTITY_NAME)).getLocaleValue();
            refMap.computeIfAbsent(refEntityName, k -> new ArrayList());
            ((List)refMap.get(refEntityName)).add((String)ref.get("number"));
        }
        for (Map.Entry entry : refMap.entrySet()) {
            String refNumbers = String.join((CharSequence)"\u3001", (Iterable)entry.getValue());
            String refMessage = String.format(message, entry.getKey(), refNumbers);
            sdpOutputParams.append(refMessage).append((Object)Character.valueOf('\n')).append((Object)Character.valueOf('\n'));
        }
    }

    private void writeMainResourceImportMessage(SdpOutputParams sdpOutputParams, List<Map<String, Object>> mainResourceFailList, List<Map<String, Object>> mainResourceSuccessList) {
        sdpOutputParams.append(String.format(ResManager.loadKDString((String)"\u4e00\u3001\u4e3b\u8d44\u6e90\uff1a\n1\u3001\u5931\u8d25%1$d\u6761", (String)"IscImpl_15", (String)"sys-ricc-business", (Object[])new Object[0]), mainResourceFailList.size())).append((Object)Character.valueOf('\n'));
        if (!mainResourceFailList.isEmpty()) {
            for (Map<String, Object> mainResourceFail : mainResourceFailList) {
                String mainResourceFailEntityName = ((LocaleString)mainResourceFail.get(ENTITY_NAME)).getLocaleValue();
                String mainResourceFailNumber = (String)mainResourceFail.get("number");
                String string = (String)mainResourceFail.get("error");
                String errorMessage = String.format(ResManager.loadKDString((String)"\"%1$s\"\u7f16\u7801\u4e3a%2$s\u7684\u6570\u636e\u5bfc\u5165\u5931\u8d25, %3$s\u3002", (String)"IscImpl_17", (String)"sys-ricc-business", (Object[])new Object[0]), mainResourceFailEntityName, mainResourceFailNumber, string);
                sdpOutputParams.append(errorMessage).append((Object)Character.valueOf('\n'));
            }
        }
        String successMessage = String.format(ResManager.loadKDString((String)"2\u3001\u6210\u529f%1$d\u6761", (String)"IscImpl_18", (String)"sys-ricc-business", (Object[])new Object[0]), mainResourceSuccessList.size());
        sdpOutputParams.append(successMessage).append((Object)Character.valueOf('\n'));
        if (!mainResourceSuccessList.isEmpty()) {
            String mainResourceSuccessEntityName = "";
            StringBuilder mainResourceSuccessNumber = new StringBuilder();
            for (Map map : mainResourceSuccessList) {
                mainResourceSuccessEntityName = ((LocaleString)map.get(ENTITY_NAME)).getLocaleValue();
                mainResourceSuccessNumber.append(map.get("number")).append("\u3001");
            }
            String mainResourceSuccessNumberSt = mainResourceSuccessNumber.substring(0, mainResourceSuccessNumber.length() - 1);
            String string = String.format(ResManager.loadKDString((String)"\"%1$s\"\u7f16\u7801\u4e3a\uff08%2$s\uff09\u7684\u6570\u636e\u5bfc\u5165\u6210\u529f\u3002", (String)"IscImpl_19", (String)"sys-ricc-business", (Object[])new Object[0]), mainResourceSuccessEntityName, mainResourceSuccessNumberSt);
            sdpOutputParams.append(string).append((Object)Character.valueOf('\n'));
        }
    }

    private String exportResourceByMultiId(String entityNumber, List<Object> selectedIds) {
        return (String)DispatchServiceHelper.invokeBizService((String)"isc", (String)"iscb", (String)"IscResourceService", (String)"exportResourceByMultiId", (Object[])new Object[]{entityNumber, selectedIds});
    }

    private List<Map<String, Object>> importResourceWithResponse(String content) {
        return (List)DispatchServiceHelper.invokeBizService((String)"isc", (String)"iscb", (String)"IscResourceService", (String)"importResourceWithResponse", (Object[])new Object[]{content});
    }
}

