/*
 * Decompiled with CFR 0.152.
 */
package kd.sys.ricc.business.datapacket.core.impl.plugin;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.message.channel.cache.MsgServiceCacheHelper;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.sys.ricc.business.datapacket.core.impl.json.JsonDataPacketImpl;
import kd.sys.ricc.business.datapacket.core.model.SdpOutputParams;

public class MsgTplImpl
extends JsonDataPacketImpl {
    private static final Log logger = LogFactory.getLog(MsgTplImpl.class);
    private static final String NUMBER = "number";
    private static final String MSGTYPE = "msgtype";
    private static final String MSGCHANNEL = "msgchannel";
    private static final String MSGENTITY = "msgentity";
    private static final String MSGSCENE = "msgscene";
    private static final String MSGTEMPLATE = "msgtemplate";
    private static final String BIZPLUGIN = "bizPlugin";
    private static final String TPLCONTENT = "tplContent";
    private static final String MSG_TEMPLATE = "msg_template";

    protected void afterBatchImport(List<Object> ids, JSONObject dataMap, SdpOutputParams outputParams) {
        DynamicObject[] msgTpls;
        for (DynamicObject msgTpl : msgTpls = BusinessDataServiceHelper.load((Object[])ids.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)MSG_TEMPLATE))) {
            this.updateCache(msgTpl);
        }
    }

    private void updateCache(DynamicObject msgTpl) {
        String[] sceneArray;
        boolean isModify = msgTpl.getDataEntityState().getFromDatabase();
        if (isModify) {
            String[] orginalScene = msgTpl.getString(MSGSCENE).split(",");
            String orginalEntity = msgTpl.getDynamicObject(MSGENTITY).getString(NUMBER);
            String orginalType = msgTpl.getString(MSGTYPE);
            String orginalChannel = msgTpl.getString(MSGCHANNEL);
            ArrayList<String> cacheKeys = new ArrayList<String>(orginalScene.length * 2);
            for (String s : orginalScene) {
                String k = MsgServiceCacheHelper.getTemplateCacheKey((String)orginalType, (String)orginalChannel, (String)s, (String)orginalEntity);
                cacheKeys.add(k);
            }
            String number = msgTpl.getString(NUMBER);
            if (StringUtils.isNotBlank((CharSequence)number)) {
                String k = MsgServiceCacheHelper.getTemplateCacheKey((String)number);
                cacheKeys.add(k);
            }
            Object[] deleteCacheKeys = cacheKeys.toArray(new String[0]);
            MsgServiceCacheHelper.deleteCache((String[])deleteCacheKeys);
            logger.info("\u4fee\u6539\u72b6\u6001\u4e0b\u5220\u9664\u7684key--" + Arrays.toString(deleteCacheKeys));
        }
        String bizPlugin = msgTpl.getString(BIZPLUGIN);
        String entityNumber = msgTpl.getDynamicObject(MSGENTITY).getString(NUMBER);
        String msgType = msgTpl.getString(MSGTYPE);
        String msgChannel = msgTpl.getString(MSGCHANNEL);
        String msgScene = msgTpl.getString(MSGSCENE);
        String templateNumber = msgTpl.getString(NUMBER);
        ILocaleString msgTplStr = msgTpl.getLocaleString(MSGTEMPLATE);
        LocaleString tplContent = new LocaleString();
        tplContent.putAll((Map)msgTplStr);
        tplContent.put((Object)"commonlang", msgTplStr.get((Object)Lang.get().toString()));
        HashMap<String, String> cacheData = new HashMap<String, String>(8);
        cacheData.put(TPLCONTENT, SerializationUtils.toJsonString((Object)tplContent));
        cacheData.put(BIZPLUGIN, bizPlugin);
        cacheData.put("tplNumber", templateNumber);
        for (String scene : sceneArray = msgScene.split(",")) {
            MsgServiceCacheHelper.putTemplateCache((String)msgType, (String)msgChannel, (String)scene, (String)entityNumber, (String)SerializationUtils.toJsonString(cacheData));
        }
        if (StringUtils.isNotBlank((CharSequence)templateNumber)) {
            MsgServiceCacheHelper.putTemplateCache((String)templateNumber, (String)SerializationUtils.toJsonString(cacheData));
        }
    }

    public Map<String, Object> provideData(Map<String, Object> params) {
        return null;
    }
}

