/*
 * Decompiled with CFR 0.152.
 */
package kd.sys.ricc.business.datapacket.core.impl.plugin;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.property.EntryProp;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.EntityItem;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.org.model.OrgDutyView;
import kd.bos.org.model.OrgParam;
import kd.bos.org.utils.OrgUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.org.OrgUnitServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.sys.ricc.business.datapacket.core.ISubDataPacket;
import kd.sys.ricc.business.datapacket.core.helper.DataPacketHelper;
import kd.sys.ricc.business.datapacket.core.model.SdpInputParams;
import kd.sys.ricc.business.datapacket.core.model.SdpOutputParams;
import kd.sys.ricc.business.datapacket.schedule.AddPacketProgress;
import kd.sys.ricc.business.schedule.ScheduleUtil;
import kd.sys.ricc.common.constant.CommonConstant;
import kd.sys.ricc.common.query.CommonQuery;
import kd.sys.ricc.common.util.BatchSplitUtil;
import kd.sys.ricc.common.util.CommonUtil;
import kd.sys.ricc.common.util.DynamicObjectUtil;
import kd.sys.ricc.common.util.FileUtils;
import kd.sys.ricc.common.util.PageChangeUtil;
import kd.sys.ricc.common.util.StringUtils;
import kd.sys.ricc.common.util.setter.D;

public class OrgImpl
implements ISubDataPacket {
    private static final Log logger = LogFactory.getLog(OrgImpl.class);
    private static final int BATCH_SIZE = 1000;
    private static final String STRUCTURE = "structure";
    private static final String VIEW_PARENT = "viewparent";
    private static final long SCHEMA_ADMIN_ORG_ID = 1L;
    private Map<String, Long> patternNumberMap;

    public SdpOutputParams exportPacket(SdpInputParams sdpInputParams) {
        SdpOutputParams sdpOutputParams = new SdpOutputParams();
        if (sdpInputParams == null) {
            sdpOutputParams.append(ResManager.loadKDString((String)"\u8f93\u5165\u53c2\u6570\u6709\u8bef\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u52fe\u9009\u6570\u636e\u3002", (String)"OrgImpl_0", (String)"sys-ricc-business", (Object[])new Object[0]));
            return sdpOutputParams;
        }
        ListSelectedRowCollection selectRows = sdpInputParams.getSelectRows();
        Map customParam = sdpInputParams.getParam();
        String entityName = (String)customParam.get("entityname");
        String entityNumber = (String)customParam.get("entitynumber");
        if (selectRows.isEmpty()) {
            logger.info("\u7ec4\u7ec7\u4e00\u952e\u6253\u5305\u5bfc\u51fa\u6570\u636e\u5f00\u59cb");
            String filters = DataPacketHelper.getFilters(customParam);
            selectRows = CommonQuery.getAllSelectData((String)entityNumber, (String)filters);
        }
        if (selectRows.isEmpty()) {
            sdpOutputParams.append(ResManager.loadKDString((String)"\u6682\u65e0\u53ef\u5bfc\u51fa\u6570\u636e\u3002", (String)"OrgImpl_8", (String)"sys-ricc-business", (Object[])new Object[0])).append("\n");
            sdpOutputParams.setSuccess(false);
            return sdpOutputParams;
        }
        int totalSize = selectRows.size();
        logger.info("\u7ec4\u7ec7\u5bfc\u51fa\u6570\u636e\uff0c\u603b\u6570\uff1a" + totalSize);
        AddPacketProgress addPacketProgress = sdpInputParams.getAddPacketProgress();
        Set<String> canExportFieldsSet = this.getCanImportFields(entityNumber);
        String canExportFields = String.join((CharSequence)",", canExportFieldsSet);
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        int completeNum = 0;
        List spitBatchList = BatchSplitUtil.splitBatch((List)selectRows, (int)1000);
        for (int i = 0; i < spitBatchList.size(); ++i) {
            List oneBatchList = (List)spitBatchList.get(i);
            String oneBatchOrgString = this.getOneBatchOrgString(oneBatchList, entityType, canExportFields);
            String filename = i + "_" + System.currentTimeMillis() + ".json";
            String fullFilePath = sdpInputParams.getLocalPath() + File.separator + filename;
            try {
                FileUtils.writeStr2File((String)fullFilePath, (String)oneBatchOrgString);
            }
            catch (Exception e) {
                logger.error("\u7ec4\u7ec7\u5bfc\u51fa\u6570\u636e\u5199\u5165\u6587\u4ef6\u51fa\u9519\u3002", (Throwable)e);
                sdpOutputParams.append(String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\u5bfc\u51fa\u6570\u636e\u5199\u5165\u6587\u4ef6\u51fa\u9519\uff0c\u6587\u4ef6\u540d\uff1a%1$s %2$s", (String)"OrgImpl_9", (String)"sys-ricc-business", (Object[])new Object[0]), filename, e.getMessage()), (Throwable)e).append("\n");
                sdpOutputParams.setSuccess(false);
                return sdpOutputParams;
            }
            ScheduleUtil.addPacketFeedbackProgress((AddPacketProgress)addPacketProgress, (int)totalSize, (int)(completeNum += oneBatchList.size()));
        }
        String zipName = FileUtils.dirToZip((String)sdpInputParams.getLocalPath(), (String)entityName);
        sdpOutputParams.setExportFilePath(zipName);
        StringBuilder selectedInfo = new StringBuilder();
        selectedInfo.append(String.format(CommonConstant.getSelectedTitle(), entityName, entityName));
        for (int j = 0; j < selectRows.size(); ++j) {
            selectedInfo.append(String.format("%1$s\t\t%2$s\t\t%3$s %n", j + 1, selectRows.get(j).getNumber(), selectRows.get(j).getName()));
        }
        sdpOutputParams.setSelectedInfo(selectedInfo.toString());
        sdpOutputParams.setSuccess(true);
        return sdpOutputParams;
    }

    public SdpOutputParams importPacket(SdpInputParams sdpInputParams) {
        SdpOutputParams sdpOutputParams = new SdpOutputParams();
        Map param = sdpInputParams.getParam();
        DynamicObject guideInfo = (DynamicObject)param.get("guideInfo");
        String formId = guideInfo.getString("page.number");
        String entityName = guideInfo.getString("name");
        String appId = guideInfo.getString("page.bizappid");
        boolean hashPermissions = DataPacketHelper.checkPermissions(UserServiceHelper.getCurrentUserId(), appId, formId, entityName, sdpOutputParams, "47150e89000000ac", "0=KX5+QVF5+R");
        if (!hashPermissions) {
            sdpOutputParams.setSuccess(false);
            return sdpOutputParams;
        }
        FileService fs = FileServiceFactory.getAttachmentFileService();
        String fileUrl = (String)sdpInputParams.getParam().get("fileUrl");
        if (!fs.exists(fileUrl = CommonUtil.checkUrl((String)fileUrl))) {
            sdpOutputParams.setSuccess(false);
            sdpOutputParams.append(String.format(ResManager.loadKDString((String)"\u6839\u636e\u5730\u5740%s\u6ca1\u6709\u83b7\u53d6\u5230\u6709\u6548\u7684\u6587\u4ef6\u3002", (String)"OrgImpl_3", (String)"sys-ricc-business", (Object[])new Object[0]), fileUrl));
            return sdpOutputParams;
        }
        Set<String> select = this.getCanImportFields(formId);
        DynamicObjectType entityType = EntityMetadataCache.getSubDataEntityType((String)formId, select);
        int successCount = 0;
        int totalCount = 0;
        HashMap<String, Long> importOrgNumberMap = new HashMap<String, Long>(16);
        try (InputStream inputStream = fs.getInputStream(fileUrl);
             ZipInputStream zipInputStream = new ZipInputStream(inputStream);){
            ZipEntry entry;
            while ((entry = zipInputStream.getNextEntry()) != null) {
                String fileStr = FileUtils.inputStreamToString((InputStream)zipInputStream);
                List orgList = (List)JSON.parseObject((String)fileStr, (TypeReference)new TypeReference<List<Map<String, Object>>>(){}, (Feature[])new Feature[0]);
                this.setImportOrgNumberMap(orgList, importOrgNumberMap);
                logger.info("\u5f00\u59cb\u5bfc\u5165\u7ec4\u7ec7\uff0c\u6587\u4ef6\u540d: " + entry.getName());
                totalCount += orgList.size();
                successCount += this.importOrg(entityType, orgList, importOrgNumberMap, sdpOutputParams);
            }
        }
        catch (IOException e) {
            logger.error("OrgImpl.importPacket()\u5bfc\u5165\u7ec4\u7ec7\u6587\u4ef6\u89e3\u6790\u5f02\u5e38\u3002", (Throwable)e);
            sdpOutputParams.setSuccess(false);
            sdpOutputParams.append(String.format(CommonConstant.getImportFileErrorTip(), entityName), (Throwable)e);
        }
        HashMap<String, Integer> params = new HashMap<String, Integer>(2);
        params.put("successCount", successCount);
        params.put("failedCount", totalCount - successCount);
        sdpOutputParams.setParam(params);
        boolean success = sdpOutputParams.getError().length() <= 0;
        sdpOutputParams.setSuccess(success);
        return sdpOutputParams;
    }

    private String getOneBatchOrgString(List<ListSelectedRow> oneBatchList, MainEntityType entityType, String canExportFields) {
        Object[] ids = new Object[oneBatchList.size()];
        for (int j = 0; j < oneBatchList.size(); ++j) {
            ids[j] = oneBatchList.get(j).getPrimaryKeyValue();
        }
        QFilter qFilters = new QFilter("id", "in", (Object)ids);
        DynamicObject[] orgObjects = BusinessDataServiceHelper.load((String)entityType.getName(), (String)canExportFields, (QFilter[])qFilters.toArray(), (String)"structure.longnumber");
        this.filterBeforeOrgToStr(entityType.getName(), orgObjects);
        DataEntityPropertyCollection properties = orgObjects[0].getDynamicObjectType().getProperties();
        Map propertyMap = DynamicObjectUtil.getDefaultPropertyMap((DataEntityPropertyCollection)properties);
        ArrayList<Map> orgMapData = new ArrayList<Map>(orgObjects.length);
        for (DynamicObject orgObject : orgObjects) {
            Map orgDataMap = DynamicObjectUtil.object2Map((DynamicObject)orgObject, (Map)propertyMap);
            orgMapData.add(orgDataMap);
        }
        return JSON.toJSONString(orgMapData);
    }

    private void filterBeforeOrgToStr(String entityNumber, DynamicObject[] orgObjects) {
        if ("bos_adminorg".equals(entityNumber)) {
            this.adminOrgFilter(orgObjects);
        } else if ("bos_org".equals(entityNumber)) {
            this.orgUnitFilter(orgObjects);
        }
    }

    private void orgUnitFilter(DynamicObject[] orgObjects) {
        Map notBaseMaintainViewNumberMap = OrgUtils.getNotBaseMaintainViewMap();
        for (DynamicObject orgObj : orgObjects) {
            DynamicObjectCollection structureCol = orgObj.getDynamicObjectCollection(STRUCTURE);
            Iterator iterator = structureCol.iterator();
            while (iterator.hasNext()) {
                boolean isNotBaseMaintainView;
                DynamicObject structureObj = (DynamicObject)iterator.next();
                DynamicObject viewObj = structureObj.getDynamicObject("view");
                if (viewObj == null) continue;
                boolean isAdminOrg = viewObj.getLong("id") == 1L;
                boolean bl = isNotBaseMaintainView = notBaseMaintainViewNumberMap != null && notBaseMaintainViewNumberMap.containsKey(viewObj.getString("number"));
                if (!isAdminOrg && !isNotBaseMaintainView) continue;
                iterator.remove();
            }
        }
    }

    private void adminOrgFilter(DynamicObject[] orgObjects) {
        for (DynamicObject orgObj : orgObjects) {
            DynamicObjectCollection structureCol = orgObj.getDynamicObjectCollection(STRUCTURE);
            Iterator iterator = structureCol.iterator();
            while (iterator.hasNext()) {
                DynamicObject structureObj = (DynamicObject)iterator.next();
                DynamicObject viewObj = structureObj.getDynamicObject("view");
                if (viewObj != null && 1L == viewObj.getLong("id")) continue;
                iterator.remove();
            }
        }
    }

    private int importOrg(DynamicObjectType entityType, List<Map<String, Object>> orgList, Map<String, Long> importOrgNumberMap, SdpOutputParams sdpOutputParams) {
        OrgParam orgParam;
        Map<String, DynamicObject> databaseOrgMap = this.getDatabaseOrgMap(entityType.getName(), orgList);
        ArrayList<OrgParam> orgParamList = new ArrayList<OrgParam>(orgList.size());
        for (int i = 0; i < orgList.size(); ++i) {
            Map<String, Object> orgMap = orgList.get(i);
            orgParam = this.genOrgParam(entityType, orgMap, importOrgNumberMap, databaseOrgMap);
            if (orgParam.isSuccess()) {
                orgParamList.add(orgParam);
                continue;
            }
            sdpOutputParams.append(orgParam.getMsg());
        }
        int successCount = 0;
        if (!orgParamList.isEmpty()) {
            OrgUnitServiceHelper.addOrUpdate(orgParamList);
            for (int i = 0; i < orgParamList.size(); ++i) {
                orgParam = (OrgParam)orgParamList.get(i);
                if (!orgParam.isSuccess()) {
                    long orgFid = orgParam.getId() > 0L ? orgParam.getId() : orgParam.getCustomOrgId();
                    String error = String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\u5355\u5143\u5185\u7801%1$s\uff0c\u7ec4\u7ec7\u5355\u5143\u7f16\u7801%2$s\uff0c\u8c03\u7528\u7ec4\u7ec7\u5355\u5143\u670d\u52a1\u5931\u8d25\uff0c\u8fd4\u56de\u7684\u9519\u8bef\uff1a%3$s %n", (String)"OrgImpl_4", (String)"sys-ricc-business", (Object[])new Object[0]), orgFid, orgParam.getNumber(), orgParam.getMsg());
                    sdpOutputParams.append(error);
                    continue;
                }
                ++successCount;
            }
        }
        return successCount;
    }

    public OrgParam genOrgParam(DynamicObjectType entityType, Map<String, Object> orgMap, Map<String, Long> importOrgNumberMap, Map<String, DynamicObject> databaseOrgMap) {
        String number = D.s((Object)orgMap.get("number"));
        long orgId = D.l((Object)orgMap.get("id"));
        OrgParam orgParam = new OrgParam();
        orgParam.setNumber(number);
        Map nameMap = (Map)orgMap.get("name");
        orgParam.setName(D.s(nameMap.get("zh_CN")));
        DynamicObject databaseOrg = databaseOrgMap.get(number);
        if (databaseOrg != null) {
            orgParam.setId(databaseOrg.getLong("id"));
        } else {
            orgParam.setCustomOrgId(orgId);
        }
        Map orgPatternMap = (Map)orgMap.get("orgpattern");
        long orgPatternId = this.getPattern(orgPatternMap, orgParam);
        if (!orgParam.isSuccess()) {
            return orgParam;
        }
        orgParam.setOrgPatternId(orgPatternId);
        HashMap<String, Object> propertyMap = new HashMap<String, Object>(16);
        orgParam.setPropertyMap(propertyMap);
        this.setPropertyMap(orgParam, entityType, orgMap, propertyMap);
        if (!orgParam.isSuccess()) {
            return orgParam;
        }
        orgParam.setMultiViewMap(new TreeMap());
        this.setOrgView(orgParam, entityType, orgMap, importOrgNumberMap, databaseOrgMap);
        return orgParam;
    }

    private long getPattern(Map<String, Object> orgPatternMap, OrgParam orgParam) {
        if (orgPatternMap == null) {
            return 0L;
        }
        Object patternNumber = orgPatternMap.get("number");
        if (StringUtils.isEmpty((String)patternNumber.toString())) {
            return 0L;
        }
        if (this.patternNumberMap == null || this.patternNumberMap.isEmpty()) {
            DynamicObject[] bosOrgPatterns = BusinessDataServiceHelper.load((String)"bos_org_pattern", (String)"id,number,name", null);
            this.patternNumberMap = new HashMap<String, Long>(16);
            for (DynamicObject bosOrgPattern : bosOrgPatterns) {
                this.patternNumberMap.put(bosOrgPattern.getString("number"), bosOrgPattern.getLong("id"));
            }
        }
        if (!this.patternNumberMap.containsKey(patternNumber)) {
            QFilter qFilter = new QFilter("number", "=", patternNumber);
            DynamicObject bosOrgPattern = BusinessDataServiceHelper.loadSingle((String)"bos_org_pattern", (String)"id,number,name", (QFilter[])qFilter.toArray());
            if (bosOrgPattern == null) {
                String errorMsg = String.format(ResManager.loadKDString((String)"\u5728\u5f53\u524d\u7cfb\u7edf\u627e\u4e0d\u5230\u7f16\u7801\u4e3a\u3010%1$s\u3011\u7684\u7ec4\u7ec7\u5f62\u6001\u3002", (String)"OrgImpl_5", (String)"sys-ricc-business", (Object[])new Object[0]), patternNumber);
                this.setOrgParamMsg(orgParam, errorMsg);
                return 0L;
            }
            this.patternNumberMap.put(patternNumber.toString(), bosOrgPattern.getLong("id"));
        }
        return this.patternNumberMap.get(patternNumber);
    }

    private void setOrgParamMsg(OrgParam orgParam, String errorMsg) {
        orgParam.setSuccess(false);
        long orgFid = orgParam.getId() > 0L ? orgParam.getId() : orgParam.getCustomOrgId();
        String error = String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\u5355\u5143\u5185\u7801%1$s\uff0c\u7ec4\u7ec7\u5355\u5143\u7f16\u7801%2$s\uff0c\u5bfc\u5165\u5931\u8d25\uff0c%3$s %n", (String)"OrgImpl_6", (String)"sys-ricc-business", (Object[])new Object[0]), orgFid, orgParam.getNumber(), errorMsg);
        String orgMsg = orgParam.getMsg();
        if (StringUtils.isEmpty((String)orgMsg)) {
            orgParam.setMsg(error);
        } else {
            orgParam.setMsg(orgMsg + error);
        }
    }

    public void setOrgView(OrgParam orgParam, DynamicObjectType entityType, Map<String, Object> orgMap, Map<String, Long> importOrgNumberMap, Map<String, DynamicObject> databaseOrgMap) {
        TreeMap multiViewMap = orgParam.getMultiViewMap();
        DynamicObjectType structurePropertyType = ((EntryProp)entityType.getProperties().get((Object)STRUCTURE)).getDynamicCollectionItemPropertyType();
        List structures = (List)orgMap.get(STRUCTURE);
        for (Map structure : structures) {
            Map view = (Map)structure.get("view");
            String viewNumber = D.s(view.get("number"));
            OrgDutyView orgDutyView = new OrgDutyView();
            Map viewParent = (Map)structure.get(VIEW_PARENT);
            if (viewParent != null) {
                String viewParentNumber = D.s(viewParent.get("number"));
                DynamicObject databaseOrg = databaseOrgMap.get(viewParentNumber);
                if (databaseOrg != null) {
                    orgDutyView.setParentId(databaseOrg.getLong("id"));
                } else if (importOrgNumberMap.containsKey(viewParentNumber)) {
                    long id = D.l(viewParent.get("$id"));
                    orgDutyView.setParentId(id);
                } else {
                    orgParam.setSuccess(false);
                    Map viewNameMap = (Map)viewParent.get("name");
                    String viewParentName = (String)viewNameMap.get("zh_CN");
                    String msg = String.format(ResManager.loadKDString((String)"\u5f53\u524d\u73af\u5883\u627e\u4e0d\u5230\u7ec4\u7ec7\u7f16\u7801\u3010%1$s\u3011\u540d\u79f0\u3010%2$s\u3011\u7684\u4e0a\u7ea7\u7ec4\u7ec7\uff0c\u8bf7\u5148\u5c06\u4e0a\u7ea7\u7ec4\u7ec7\u5bfc\u5165\u5f53\u524d\u73af\u5883\u3002%n", (String)"OrgImpl_7", (String)"sys-ricc-business", (Object[])new Object[0]), viewParentNumber, viewParentName);
                    this.setOrgParamMsg(orgParam, msg);
                    break;
                }
            }
            HashMap<String, Object> propertyMap = new HashMap<String, Object>(16);
            orgDutyView.setPropertyMap(propertyMap);
            this.setPropertyMap(orgParam, structurePropertyType, structure, propertyMap);
            multiViewMap.put(viewNumber, orgDutyView);
        }
    }

    private void setPropertyMap(OrgParam orgParam, DynamicObjectType entityType, Map<String, Object> orgMap, Map<String, Object> propertyMap) {
        HashSet<String> propertiesIgnoreSet = new HashSet<String>(16);
        propertiesIgnoreSet.add("id");
        propertiesIgnoreSet.add("masterid");
        propertiesIgnoreSet.add("number");
        propertiesIgnoreSet.add("name");
        propertiesIgnoreSet.add("orgpattern");
        propertiesIgnoreSet.add("orgpattern_id");
        propertiesIgnoreSet.add(STRUCTURE);
        propertiesIgnoreSet.add("view");
        propertiesIgnoreSet.add("view_id");
        propertiesIgnoreSet.add("vieworg");
        propertiesIgnoreSet.add(VIEW_PARENT);
        propertiesIgnoreSet.add("viewparent_id");
        propertiesIgnoreSet.add("multilanguagetext");
        try {
            DynamicObjectUtil.setMapValByPropertyVal((DynamicObjectType)entityType, propertyMap, orgMap, propertiesIgnoreSet);
        }
        catch (Exception e) {
            logger.error("\u7ec4\u7ec7\u5355\u5143\u5b57\u6bb5\u8d4b\u503c\u51fa\u9519\u3002", (Throwable)e);
            this.setOrgParamMsg(orgParam, e.getMessage());
        }
    }

    private Map<String, DynamicObject> getDatabaseOrgMap(String formId, List<Map<String, Object>> orgList) {
        HashSet<String> numbers = new HashSet<String>(orgList.size());
        for (int i = 0; i < orgList.size(); ++i) {
            Map<String, Object> orgMap = orgList.get(i);
            String number = orgMap.get("number").toString();
            numbers.add(number);
            List structures = (List)orgMap.get(STRUCTURE);
            for (Map structure : structures) {
                Map viewParent = (Map)structure.get(VIEW_PARENT);
                if (viewParent == null) continue;
                numbers.add(viewParent.get("number").toString());
            }
        }
        QFilter qFilter = new QFilter("number", "in", numbers);
        DynamicObject[] dataBaseOrgObjects = BusinessDataServiceHelper.load((String)formId, (String)"id,number,name", (QFilter[])qFilter.toArray());
        HashMap<String, DynamicObject> dataBaseOrgMap = new HashMap<String, DynamicObject>(dataBaseOrgObjects.length);
        for (DynamicObject dataBaseOrgObject : dataBaseOrgObjects) {
            dataBaseOrgMap.put(dataBaseOrgObject.getString("number"), dataBaseOrgObject);
        }
        return dataBaseOrgMap;
    }

    private void setImportOrgNumberMap(List<Map<String, Object>> orgList, Map<String, Long> importOrgNumberMap) {
        for (int i = 0; i < orgList.size(); ++i) {
            Map<String, Object> orgMap = orgList.get(i);
            String number = orgMap.get("number").toString();
            long orgId = D.l((Object)orgMap.get("id"));
            importOrgNumberMap.put(number, orgId);
        }
    }

    private Set<String> getCanImportFields(String entityFormId) {
        EntityMetadata entityMetadata = (EntityMetadata)MetadataDao.readRuntimeMeta((String)MetadataDao.getIdByNumber((String)entityFormId, (MetaCategory)MetaCategory.Entity), (MetaCategory)MetaCategory.Entity);
        List entityItems = entityMetadata.getItems();
        HashSet<String> itemSet = new HashSet<String>(16);
        entityItems.stream().forEach(item -> {
            boolean valid = item instanceof Field;
            if (valid) {
                Field f = (Field)item;
                if (StringUtils.isNotBlank((CharSequence)f.getFieldName()) && f.getFeatures().isImportable()) {
                    itemSet.add(item.getKey());
                }
                PageChangeUtil.getDateAndTimeRangeField((Set)itemSet, (EntityItem)item, (Field)f);
            }
        });
        return itemSet;
    }
}

