/*
 * Decompiled with CFR 0.152.
 */
package kd.sys.ricc.formplugin.bdctrl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.entity.tree.TreeNode;
import kd.bos.filter.FilterColumn;
import kd.bos.filter.FilterContainer;
import kd.bos.filter.SchemeBaseDataFilterColumn;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IConfirmCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.Search;
import kd.bos.form.control.TreeView;
import kd.bos.form.control.events.BeforeItemClickEvent;
import kd.bos.form.control.events.FilterContainerInitEvent;
import kd.bos.form.control.events.FilterContainerInitListener;
import kd.bos.form.control.events.ItemClickEvent;
import kd.bos.form.control.events.SearchClickEvent;
import kd.bos.form.control.events.SearchClickListener;
import kd.bos.form.control.events.SearchEnterEvent;
import kd.bos.form.control.events.SearchEnterListener;
import kd.bos.form.control.events.TreeNodeClickListener;
import kd.bos.form.control.events.TreeNodeEvent;
import kd.bos.form.control.events.TreeNodeQueryListener;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.events.CreateListDataProviderListener;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.dao.MetadataReader;
import kd.bos.metadata.entity.EntityItem;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.commonfield.ComboField;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.runmode.RunModeServiceHelper;
import kd.sys.ricc.business.configitem.ConfigItemHelper;
import kd.sys.ricc.common.enums.DataPacketTypeEnum;
import kd.sys.ricc.common.util.FormViewUtil;
import kd.sys.ricc.common.util.SysParaUtil;

public class CtrlStrategyTransferFormPlugin
extends AbstractFormPlugin
implements TreeNodeClickListener,
TreeNodeQueryListener,
IConfirmCallBack,
SearchEnterListener,
FilterContainerInitListener,
SearchClickListener,
CreateListDataProviderListener {
    private static final Log logger = LogFactory.getLog(CtrlStrategyTransferFormPlugin.class);
    private static final String BILL_LIST_AP = "billlistap";
    private static final String TOOL_BAR_AP = "toolbarap";
    private static final String BD_CTR_STRATEGY_FORM_CARD = "bd_bdctrstratege_formcard";
    private static final String ROOT_ID = "-1";
    private static final String DATA_CLOUD = "DATA_CLOUD";
    private static final String TREE_VIEW = "treeview";
    private static final String CACHE_KEY_SEARCH_NODES = "_searchNodes";
    private static final String CACHE_KEY_OLD_SEARCH_TEXT = "_oldSearchText";
    private static final String F_APP_ID = ":FAPPID";
    private static final String FAST_TRANSFER_KEY = "fasttransfer";
    private static final String ADD_PACKET_KEY = "addpacket";
    private static final String BD_DEF_CTRL_STRTGY = "bd_bddefctrlstrtgy";
    private static final String FAST_TRANSFER_ACTION_KEY = "fasttransfer_action";
    private static final String ADD_PACKET_ACTION_KEY = "addpacket_action";

    public void initialize() {
        FilterContainer filterContainer = (FilterContainer)this.getControl("filtercontainerap");
        if (filterContainer != null) {
            filterContainer.setBillFormId(BD_DEF_CTRL_STRTGY);
            filterContainer.setEntityId(BD_DEF_CTRL_STRTGY);
        }
    }

    public void registerListener(EventObject e) {
        Search search = (Search)this.getControl("searchap");
        search.addEnterListener((SearchEnterListener)this);
        TreeView tree = (TreeView)this.getControl(TREE_VIEW);
        tree.addTreeNodeQueryListener((TreeNodeQueryListener)this);
        tree.addTreeNodeClickListener((TreeNodeClickListener)this);
        this.addItemClickListeners(new String[]{TOOL_BAR_AP});
    }

    public void afterCreateNewData(EventObject e) {
        FilterContainer filterContainer = (FilterContainer)this.getControl("filtercontainerap");
        filterContainer.addFilterContainerInitListener((FilterContainerInitListener)this);
        filterContainer.addSearchClickListener((SearchClickListener)this);
        BillList billList = (BillList)this.getControl(BILL_LIST_AP);
        billList.addCreateListDataProviderListener((CreateListDataProviderListener)this);
        billList.setFilter(new QFilter("basedataid.name", "is not null", (Object)""));
        this.loadAllCloudTree();
        this.addPacketBtStatusProcess();
    }

    private void addPacketBtStatusProcess() {
        boolean canAddPacket = SysParaUtil.canAddPacket();
        if (canAddPacket) {
            FormViewUtil.cleanButtonTips((IFormView)this.getView(), (String[])new String[]{FAST_TRANSFER_KEY, ADD_PACKET_KEY});
        }
        this.getView().setEnable(Boolean.valueOf(canAddPacket), new String[]{FAST_TRANSFER_KEY, ADD_PACKET_KEY});
    }

    public void createListDataProvider(BeforeCreateListDataProviderArgs args) {
        args.setListDataProvider((IListDataProvider)new CtrlStrategyListDataProvider());
    }

    public void itemClick(ItemClickEvent evt) {
        String itemKey = evt.getItemKey();
        if ("refresh".equals(itemKey)) {
            TreeView treeView = (TreeView)this.getControl(TREE_VIEW);
            treeView.focusNode(this.createRootNode());
            treeView.treeNodeClick(ROOT_ID, ROOT_ID);
        } else if (ADD_PACKET_KEY.equalsIgnoreCase(itemKey) || FAST_TRANSFER_KEY.equals(itemKey)) {
            String actionId = ADD_PACKET_ACTION_KEY;
            if (FAST_TRANSFER_KEY.equals(itemKey)) {
                actionId = FAST_TRANSFER_ACTION_KEY;
            }
            ConfirmCallBackListener confirmCallBackListener = new ConfirmCallBackListener(actionId, (IFormPlugin)this);
            this.getView().showConfirm(ResManager.loadKDString((String)"\u57fa\u7840\u6570\u636e\u7ba1\u63a7\u7b56\u7565\u662f\u7cfb\u7edf\u5173\u952e\u914d\u7f6e\uff0c\u4f20\u8f93\u4f1a\u5f71\u54cd\u7cfb\u7edf\u4e2d\u6570\u636e\u7684\u7ba1\u63a7\u65b9\u5f0f\uff0c\u9700\u8c28\u614e\u6838\u5bf9\u4f20\u8f93\u5185\u5bb9\u540e\u64cd\u4f5c\u3002\u8bf7\u518d\u6b21\u786e\u8ba4\u662f\u5426\u4f20\u8f93\uff1f", (String)"CtrlStrategyListDataProvider_5", (String)"sys-ricc-business", (Object[])new Object[0]), MessageBoxOptions.YesNo, confirmCallBackListener);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        String callBackId = messageBoxClosedEvent.getCallBackId();
        if (messageBoxClosedEvent.getResult() == MessageBoxResult.No) {
            return;
        }
        BillList billList = (BillList)this.getControl(BILL_LIST_AP);
        ListSelectedRowCollection listSelectedRows = billList.getSelectedRows();
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Object guideId = formShowParameter.getCustomParam("guideId");
        if (guideId == null || StringUtils.isEmpty((CharSequence)guideId.toString())) {
            DynamicObject bdCtlTransfer = ConfigItemHelper.queryGuideByNumber((Object)BD_CTR_STRATEGY_FORM_CARD, (String)"id,name");
            formShowParameter.setCustomParam("riccFormId", (Object)BD_CTR_STRATEGY_FORM_CARD);
            formShowParameter.setCustomParam("packettype", (Object)DataPacketTypeEnum.CONFIG.getVal());
            formShowParameter.setCustomParam("guideId", bdCtlTransfer.get("id"));
            formShowParameter.setCustomParam("guideName", (Object)bdCtlTransfer.getString("name"));
            formShowParameter.setCustomParam("canAddPacket", (Object)Boolean.TRUE);
        }
        if (ADD_PACKET_ACTION_KEY.equalsIgnoreCase(callBackId)) {
            ConfigItemHelper.openAddPacketForm((ListSelectedRowCollection)listSelectedRows, (String)this.getView().getPageId(), null, (IFormView)this.getView(), (String)this.getPluginName());
        } else if (FAST_TRANSFER_ACTION_KEY.equals(callBackId)) {
            ConfigItemHelper.openAddTransferForm((ListSelectedRowCollection)listSelectedRows, (String)this.getView().getPageId(), null, (IFormView)this.getView(), (String)this.getPluginName());
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        Object returnData;
        String actionId = closedCallBackEvent.getActionId();
        if ("addPacketClose".equalsIgnoreCase(actionId) && "success".equals(returnData = closedCallBackEvent.getReturnData())) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u6dfb\u52a0\u5230\u4f20\u8f93\u5305\u6210\u529f", (String)"CtrlStrategyTransferFormPlugin_0", (String)"sys-ricc-business", (Object[])new Object[0]));
        }
    }

    public void filterContainerInit(FilterContainerInitEvent evt) {
        this.removeEnableFieldFilter(evt);
        FilterColumn appSystemColumn = new FilterColumn();
        appSystemColumn.setFieldName("appsystem.name");
        LocaleString appSystemLocalStr = new LocaleString(ResManager.loadKDString((String)"\u5e94\u7528\u7cfb\u7edf", (String)"CtrlStrategyTransferFormPlugin_5", (String)"sys-ricc-business", (Object[])new Object[0]));
        appSystemColumn.setCaption(appSystemLocalStr);
        evt.getFastFilterColumns().add(appSystemColumn);
        List schemeFilterColumns = evt.getSchemeFilterColumns();
        SchemeBaseDataFilterColumn systemSchemeFilterColumn = this.buildSchemeFilterColumn("appsystem.name", appSystemLocalStr);
        schemeFilterColumns.add(systemSchemeFilterColumn);
        SchemeBaseDataFilterColumn viewSchemeFilterColumn = this.buildSchemeFilterColumn("ctrlview.name", new LocaleString(ResManager.loadKDString((String)"\u63a7\u5236\u89c6\u56fe", (String)"CtrlStrategyTransferFormPlugin_6", (String)"sys-ricc-business", (Object[])new Object[0])));
        schemeFilterColumns.add(viewSchemeFilterColumn);
        SchemeBaseDataFilterColumn baseDataSchemeFilterColumn = this.buildSchemeFilterColumn("basedataid.name", new LocaleString(ResManager.loadKDString((String)"\u57fa\u7840\u8d44\u6599", (String)"CtrlStrategyTransferFormPlugin_7", (String)"sys-ricc-business", (Object[])new Object[0])));
        schemeFilterColumns.add(baseDataSchemeFilterColumn);
    }

    private void removeEnableFieldFilter(FilterContainerInitEvent evt) {
        FilterColumn commonEnableFilterColumn = null;
        for (FilterColumn commonFilterColumn : evt.getCommonFilterColumns()) {
            if (!"enable".equals(commonFilterColumn.getFieldName())) continue;
            commonEnableFilterColumn = commonFilterColumn;
            break;
        }
        if (commonEnableFilterColumn != null) {
            evt.getCommonFilterColumns().remove(commonEnableFilterColumn);
        }
        FilterColumn schemeEnableFilterColumn = null;
        for (FilterColumn commonFilterColumn : evt.getSchemeFilterColumns()) {
            if (!"enable".equals(commonFilterColumn.getFieldName())) continue;
            schemeEnableFilterColumn = commonFilterColumn;
            break;
        }
        if (schemeEnableFilterColumn != null) {
            evt.getSchemeFilterColumns().remove(schemeEnableFilterColumn);
        }
    }

    private SchemeBaseDataFilterColumn buildSchemeFilterColumn(String fieldName, LocaleString caption) {
        MainEntityType ctrlEntityType = EntityMetadataCache.getDataEntityType((String)BD_DEF_CTRL_STRTGY);
        SchemeBaseDataFilterColumn schemeFilterColumn = new SchemeBaseDataFilterColumn();
        schemeFilterColumn.setFieldName(fieldName);
        schemeFilterColumn.setEntityType(ctrlEntityType);
        schemeFilterColumn.setCaption(caption);
        return schemeFilterColumn;
    }

    public void click(SearchClickEvent evt) {
        BillList billList = (BillList)this.getControl(BILL_LIST_AP);
        List clientQueryFilter = billList.getClientQueryFilterParameter().getQFilters();
        clientQueryFilter.addAll(evt.getFilterParameter().getQFilters());
        List qFilters = evt.getFastQFilters();
        List fastQueryFilters = billList.getQueryFilterParameter().getQFilters();
        fastQueryFilters.addAll(qFilters);
        TreeView treeView = (TreeView)this.getControl(TREE_VIEW);
        String focusNodeId = treeView.getTreeState().getFocusNodeId();
        if (ROOT_ID.equals(focusNodeId)) {
            this.getView().updateView(billList.getKey());
            return;
        }
        boolean isCloud = this.isCloudTreeNode(focusNodeId);
        if (isCloud) {
            Set<String> appSet = this.getCloudAppIdSet(focusNodeId);
            QFilter appSystemIdQf = new QFilter("appsystem", "in", appSet);
            fastQueryFilters.add(appSystemIdQf);
        } else {
            QFilter appSystemIdQf = new QFilter("basedataid", "=", (Object)focusNodeId);
            fastQueryFilters.add(appSystemIdQf);
        }
        this.getView().updateView(billList.getKey());
    }

    public void search(SearchEnterEvent event) {
        TreeView treeView = (TreeView)this.getControl(TREE_VIEW);
        String searchText = event.getText();
        if (StringUtils.isBlank((CharSequence)searchText)) {
            treeView.deleteAllNodes();
            this.loadAllCloudTree();
            return;
        }
        this.searchAllCloudTreeByText(searchText, treeView);
    }

    private void loadAllCloudTree() {
        List<Map<String, String>> bizCloudNodeList = this.getBizCloud();
        TreeNode rootNode = this.createRootNode();
        if (bizCloudNodeList != null && !bizCloudNodeList.isEmpty()) {
            ArrayList<String> cloudDataList = new ArrayList<String>(16);
            for (Map<String, String> cloud : bizCloudNodeList) {
                TreeNode treeNode = new TreeNode();
                String cid = cloud.get("id");
                treeNode.setId(cid);
                treeNode.setText(cloud.get("name"));
                treeNode.addChildren(new ArrayList());
                treeNode.setParentid(ROOT_ID);
                rootNode.addChild(treeNode);
                cloudDataList.add(cid);
            }
            this.getPageCache().put(DATA_CLOUD, SerializationUtils.toJsonString(cloudDataList));
        }
        TreeView treeView = (TreeView)this.getControl(TREE_VIEW);
        treeView.addNode(rootNode);
        treeView.focusNode(rootNode);
        treeView.expand(ROOT_ID);
    }

    private void searchAllCloudTreeByText(String searchText, TreeView tree) {
        List<Object> treeNodes = new ArrayList();
        IPageCache pageCache = (IPageCache)this.getView().getService(IPageCache.class);
        String searchNodesCacheKey = this.getView().getPageId() + CACHE_KEY_SEARCH_NODES;
        String oldSearchTextCacheKey = this.getView().getPageId() + CACHE_KEY_OLD_SEARCH_TEXT;
        String oldSearchText = pageCache.get(oldSearchTextCacheKey);
        pageCache.put(oldSearchTextCacheKey, searchText);
        if (searchText.equals(oldSearchText)) {
            String searchNodesCache = pageCache.get(searchNodesCacheKey);
            if (StringUtils.isNotBlank((CharSequence)searchNodesCache)) {
                treeNodes = SerializationUtils.fromJsonStringToList((String)searchNodesCache, TreeNode.class);
            }
        } else {
            treeNodes = this.searchTreeNode(searchText);
            pageCache.put(searchNodesCacheKey, SerializationUtils.toJsonString(treeNodes));
        }
        String lastCheckNodeIndexKey = "last_check_node_index";
        if (null == treeNodes || treeNodes.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e1a\u52a1\u5bf9\u8c61\u4e0d\u5b58\u5728", (String)"CtrlStrategyTransferFormPlugin_1", (String)"sys-ricc-business", (Object[])new Object[0]));
            this.getPageCache().remove(lastCheckNodeIndexKey);
            return;
        }
        if (!searchText.equals(oldSearchText)) {
            TreeNode node = (TreeNode)treeNodes.get(0);
            tree.queryTreeNodeChildren("", node.getParentid());
            tree.focusNode(node);
            tree.treeNodeClick(node.getParentid(), node.getId());
            this.getPageCache().put(lastCheckNodeIndexKey, "0");
            return;
        }
        if (treeNodes.size() > 1) {
            int lastIndex = Integer.parseInt(this.getPageCache().get(lastCheckNodeIndexKey));
            int newIndex = lastIndex + 1 >= treeNodes.size() ? 0 : lastIndex + 1;
            TreeNode node = (TreeNode)treeNodes.get(newIndex);
            tree.queryTreeNodeChildren("", node.getParentid());
            tree.focusNode(node);
            tree.treeNodeClick(node.getParentid(), node.getId());
            this.getPageCache().put(lastCheckNodeIndexKey, String.valueOf(newIndex));
            if (lastIndex + 1 == treeNodes.size()) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5df2\u641c\u7d22\u5b8c\u6210", (String)"CtrlStrategyTransferFormPlugin_2", (String)"sys-ricc-business", (Object[])new Object[0]));
            }
        } else {
            TreeNode node = (TreeNode)treeNodes.get(0);
            if (!node.getId().equals(tree.getTreeState().getFocusNodeId())) {
                tree.queryTreeNodeChildren("", node.getParentid());
                tree.focusNode(node);
                tree.treeNodeClick(node.getParentid(), node.getId());
            }
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5df2\u641c\u7d22\u5b8c\u6210", (String)"CtrlStrategyTransferFormPlugin_2", (String)"sys-ricc-business", (Object[])new Object[0]));
        }
    }

    private List<TreeNode> searchTreeNode(String searchText) {
        String localeId = RequestContext.get().getLang().name();
        QFilter[] entityFilters = new QFilter[]{new QFilter("name", "like", (Object)("%" + searchText + "%")), new QFilter("name.localeid", "=", (Object)localeId)};
        DynamicObjectCollection entityData = QueryServiceHelper.query((String)"bos_entitymeta", (String)"number, name", (QFilter[])entityFilters);
        Map<String, String> entityDataMap = entityData.stream().collect(Collectors.toMap(p -> p.getString("number"), p -> p.getString("name")));
        if (entityDataMap.size() == 0) {
            return Collections.emptyList();
        }
        StringBuilder paramsStr = new StringBuilder();
        Object[] params = new SqlParameter[entityDataMap.size()];
        int i = 0;
        for (String entity : entityDataMap.keySet()) {
            if (i > 0) {
                paramsStr.append(',');
            }
            paramsStr.append('?');
            params[i] = new SqlParameter(":FBASEDATAID", 12, (Object)entity);
            ++i;
        }
        String dcssql = "select bct.FBASEDATAID, bct.FAPPSYSTEMID from T_BD_DefaultCtrlStrategy bct  where bct.FBASEDATAID in(" + paramsStr + ") ";
        Map bdAppMap = (Map)DB.query((DBRoute)DBRoute.basedata, (String)dcssql, (Object[])params, rs -> {
            HashMap<String, String> bdAppMapping = new HashMap<String, String>(16);
            while (rs.next()) {
                bdAppMapping.put(rs.getString(1), rs.getString(2));
            }
            return bdAppMapping;
        });
        if (bdAppMap == null || bdAppMap.size() == 0) {
            return Collections.emptyList();
        }
        HashSet appSet = new HashSet(bdAppMap.size());
        appSet.addAll(bdAppMap.values());
        QFilter[] bizAppF = new QFilter[]{new QFilter("id", "in", appSet), new QFilter("deploystatus", "=", (Object)"2")};
        DynamicObjectCollection bizApp = QueryServiceHelper.query((String)"bos_devportal_bizapp", (String)"id, bizcloud", (QFilter[])bizAppF);
        Map<String, String> appCloudMap = bizApp.stream().collect(Collectors.toMap(p -> p.getString("id"), p -> p.getString("bizcloud")));
        ArrayList<TreeNode> treeNodes = new ArrayList<TreeNode>(32);
        for (Map.Entry entry : bdAppMap.entrySet()) {
            String cloudId = appCloudMap.get(entry.getValue());
            if (!StringUtils.isNotEmpty((CharSequence)cloudId)) continue;
            String entityName = entityDataMap.get(entry.getKey());
            treeNodes.add(new TreeNode(cloudId, (String)entry.getKey(), entityName));
        }
        return treeNodes;
    }

    private List<Map<String, String>> getBizCloud() {
        String dcssql = "select FAPPSYSTEMID from T_BD_DefaultCtrlStrategy ";
        Set appSet = (Set)DB.query((DBRoute)DBRoute.basedata, (String)dcssql, rs -> {
            HashSet<String> appSet1 = new HashSet<String>(32);
            while (rs.next()) {
                String app = rs.getString(1);
                appSet1.add(app);
            }
            return appSet1;
        });
        Map cloudBlackListMap = RunModeServiceHelper.getCloudBlacklist();
        String localeId = RequestContext.get().getLang().name();
        QFilter[] bizAppF = new QFilter[]{new QFilter("deploystatus", "=", (Object)"2"), new QFilter("visible", "=", (Object)"1"), new QFilter("id", "in", (Object)appSet)};
        DynamicObjectCollection bizApps = QueryServiceHelper.query((String)"bos_devportal_bizapp", (String)"bizcloud", (QFilter[])bizAppF);
        ArrayList<String> bizCloudId = new ArrayList<String>(bizApps.size());
        for (DynamicObject bizApp : bizApps) {
            bizCloudId.add(bizApp.getString("bizcloud"));
        }
        QFilter[] cloudF = new QFilter[]{new QFilter("visible", "=", (Object)"1"), new QFilter("name.localeid", "=", (Object)localeId), new QFilter("id", "in", bizCloudId), new QFilter("id", "not in", cloudBlackListMap.keySet())};
        DynamicObjectCollection clouds = QueryServiceHelper.query((String)"bos_devportal_bizcloud", (String)"id, name", (QFilter[])cloudF);
        ArrayList<Map<String, String>> result = new ArrayList<Map<String, String>>(clouds.size());
        for (DynamicObject cloud : clouds) {
            HashMap<String, String> cloudMap = new HashMap<String, String>();
            cloudMap.put("id", cloud.getString("id"));
            cloudMap.put("name", cloud.getString("name"));
            result.add(cloudMap);
        }
        return result;
    }

    public void treeNodeClick(TreeNodeEvent tne) {
        String nodeId = this.getNodeId(tne);
        if (StringUtils.isEmpty((CharSequence)nodeId)) {
            return;
        }
        boolean isCloud = this.isCloudTreeNode(nodeId);
        BillList billList = (BillList)this.getControl(BILL_LIST_AP);
        List queryFilters = billList.getQueryFilterParameter().getQFilters();
        if (ROOT_ID.equals(nodeId)) {
            queryFilters.clear();
        } else if (isCloud) {
            Set<String> appSet = this.getCloudAppIdSet(nodeId);
            QFilter appSystemIdQf = new QFilter("appsystem", "in", appSet);
            queryFilters.add(appSystemIdQf);
        } else {
            QFilter appSystemIdQf = new QFilter("basedataid", "=", (Object)nodeId);
            queryFilters.add(appSystemIdQf);
        }
        this.getView().updateView(billList.getKey());
    }

    public void queryTreeNodeChildren(TreeNodeEvent tne) {
        String nodeId = this.getNodeId(tne);
        if (StringUtils.isEmpty((CharSequence)nodeId)) {
            return;
        }
        boolean isCloud = this.isCloudTreeNode(nodeId);
        if (!isCloud) {
            return;
        }
        List<Map<String, String>> baseList = this.getBaseDataByCloud(nodeId);
        if (baseList != null && !baseList.isEmpty()) {
            TreeView tv = (TreeView)this.getControl(TREE_VIEW);
            for (Map<String, String> baseObjMap : baseList) {
                TreeNode treeNode = new TreeNode();
                treeNode.setParentid(nodeId);
                treeNode.setText(baseObjMap.get("name"));
                treeNode.setId(baseObjMap.get("number"));
                tv.addNode(treeNode);
            }
            tv.expand(nodeId);
        }
    }

    private List<Map<String, String>> getBaseDataByCloud(String nodeId) {
        ArrayList<Map<String, String>> baseList = new ArrayList<Map<String, String>>(2);
        Set<String> appSet = this.getCloudAppIdSet(nodeId);
        if (appSet == null || appSet.isEmpty()) {
            return baseList;
        }
        StringBuilder paramsStr = new StringBuilder();
        Object[] params = new SqlParameter[appSet.size()];
        int i = 0;
        for (String app : appSet) {
            if (i > 0) {
                paramsStr.append(',');
            }
            paramsStr.append('?');
            params[i] = new SqlParameter(F_APP_ID, 12, (Object)app);
            ++i;
        }
        String entityNumberSql = " select bct.FBASEDATAID from T_BD_DefaultCtrlStrategy bct  where bct.FAPPSYSTEMID in (" + paramsStr + ") ";
        Set entityNumberSet = (Set)DB.query((DBRoute)DBRoute.basedata, (String)entityNumberSql, (Object[])params, rs -> {
            HashSet<String> entityNumberSet1 = new HashSet<String>(32);
            while (rs.next()) {
                entityNumberSet1.add(rs.getString(1));
            }
            return entityNumberSet1;
        });
        if (entityNumberSet == null || entityNumberSet.isEmpty()) {
            return baseList;
        }
        return this.getBaseDataByEntityNumber(entityNumberSet);
    }

    private Set<String> getCloudAppIdSet(String cloudId) {
        QFilter[] appF = new QFilter[]{new QFilter("deploystatus", "=", (Object)"2"), new QFilter("bizcloud", "=", (Object)cloudId)};
        DynamicObjectCollection apps = QueryServiceHelper.query((String)"bos_devportal_bizapp", (String)"id", (QFilter[])appF);
        return apps.stream().map(f -> f.get("id").toString()).collect(Collectors.toSet());
    }

    private List<Map<String, String>> getBaseDataByEntityNumber(Set<String> entityNumberSet) {
        String localeId = RequestContext.get().getLang().name();
        QFilter[] entityF = new QFilter[]{new QFilter("number", "in", entityNumberSet), new QFilter("name.localeid", "=", (Object)localeId)};
        DynamicObjectCollection entities = QueryServiceHelper.query((String)"bos_entitymeta", (String)"number, name", (QFilter[])entityF);
        ArrayList<Map<String, String>> result = new ArrayList<Map<String, String>>(entities.size());
        for (DynamicObject entry : entities) {
            HashMap<String, String> entity = new HashMap<String, String>();
            entity.put("number", entry.getString("number"));
            entity.put("name", entry.getString("name"));
            result.add(entity);
        }
        return result;
    }

    private String getNodeId(TreeNodeEvent treeNodeEvent) {
        String nodeId = null;
        if (treeNodeEvent.getNodeId() != null) {
            nodeId = (String)treeNodeEvent.getNodeId();
        }
        return nodeId;
    }

    private boolean isCloudTreeNode(String nodeId) {
        boolean isCloud = false;
        List cloudList = null;
        if (this.getPageCache().get(DATA_CLOUD) != null) {
            cloudList = SerializationUtils.fromJsonStringToList((String)this.getPageCache().get(DATA_CLOUD), String.class);
        }
        if (cloudList != null) {
            for (String cloudId : cloudList) {
                if (!cloudId.equals(nodeId)) continue;
                isCloud = true;
                break;
            }
        }
        return isCloud;
    }

    private TreeNode createRootNode() {
        return new TreeNode("", ROOT_ID, ResManager.loadKDString((String)"\u5168\u90e8", (String)"CtrlStrategyTransferFormPlugin_3", (String)"sys-ricc-business", (Object[])new Object[0]), true);
    }

    public void beforeItemClick(BeforeItemClickEvent evt) {
        BillList billList;
        ListSelectedRowCollection selectedRows;
        String key = evt.getItemKey();
        if ((ADD_PACKET_KEY.equals(key) || FAST_TRANSFER_KEY.equals(key)) && (selectedRows = (billList = (BillList)this.getControl(BILL_LIST_AP)).getSelectedRows()).isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u5148\u9009\u62e9\u9700\u8981\u4f20\u8f93\u7684\u6570\u636e", (String)"CtrlStrategyTransferFormPlugin_4", (String)"sys-ricc-business", (Object[])new Object[0]));
            evt.setCancel(true);
        }
    }

    private static class CtrlStrategyListDataProvider
    extends ListDataProvider {
        private static final String CTRL_STRATEGY_CU_ASSIGN = "1";
        private static final String CTRL_STRATEGY_CU_FREE_ASSIGN = "2";
        private static final String CTRL_STRATEGY_GLOBAL_SHARE = "5";
        private static final String CTRL_STRATEGY_CU_SHARE = "6";
        private static final String CTRL_STRATEGY_PRIVATE = "7";

        private CtrlStrategyListDataProvider() {
        }

        public DynamicObjectCollection getData(int start, int limit) {
            DynamicObjectCollection rows = super.getData(start, limit);
            if (rows.isEmpty()) {
                return rows;
            }
            for (DynamicObject row : rows) {
                String defaultCtrlStrategyValue = row.getString("defaultctrlstrategy");
                String baseDataId = row.getString("basedataid_id");
                row.set("defaultctrlstrategy", (Object)this.getCtrlStrategy(baseDataId, defaultCtrlStrategyValue));
            }
            return rows;
        }

        private String getCtrlStrategyByEntity(String entityNumber, String ctrlStrategyValue) {
            MetadataReader reader = new MetadataReader();
            String formId = reader.loadIdByNumber(entityNumber, MetaCategory.Form);
            EntityMetadata entityMetadata = null;
            try {
                entityMetadata = (EntityMetadata)MetadataDao.readRuntimeMeta((String)formId, (MetaCategory)MetaCategory.Entity);
            }
            catch (Exception e) {
                logger.error("\u83b7\u53d6\u5b9e\u4f53\u6807\u8bc6\uff1a" + entityNumber + "\u8868\u5355id\uff1a" + formId + "\u5143\u6570\u636e\u5931\u8d25", (Throwable)e);
            }
            if (entityMetadata == null) {
                return ctrlStrategyValue;
            }
            List items = entityMetadata.getItems();
            ComboField comboField = null;
            for (EntityItem item : items) {
                if (!"ctrlstrategy".equals(item.getKey()) || !(item instanceof ComboField)) continue;
                comboField = (ComboField)item;
                break;
            }
            if (null != comboField) {
                for (EntityItem item : comboField.getItems()) {
                    LocaleString localeString = item.getCaption();
                    String value = item.getValue();
                    if (!ctrlStrategyValue.equals(value)) continue;
                    return localeString.getLocaleValue();
                }
            }
            return ctrlStrategyValue;
        }

        private String getCtrlStrategy(String entityNumber, String ctrlStrategyValue) {
            String strName = "";
            switch (ctrlStrategyValue) {
                case "1": {
                    strName = ResManager.loadKDString((String)"\u9010\u7ea7\u5206\u914d", (String)"CtrlStrategyListDataProvider_0", (String)"sys-ricc-business", (Object[])new Object[0]);
                    break;
                }
                case "2": {
                    strName = ResManager.loadKDString((String)"\u81ea\u7531\u5206\u914d", (String)"CtrlStrategyListDataProvider_1", (String)"sys-ricc-business", (Object[])new Object[0]);
                    break;
                }
                case "5": {
                    strName = ResManager.loadKDString((String)"\u5168\u5c40\u5171\u4eab", (String)"CtrlStrategyListDataProvider_2", (String)"sys-ricc-business", (Object[])new Object[0]);
                    break;
                }
                case "6": {
                    strName = ResManager.loadKDString((String)"\u7ba1\u63a7\u8303\u56f4\u5185\u5171\u4eab", (String)"CtrlStrategyListDataProvider_3", (String)"sys-ricc-business", (Object[])new Object[0]);
                    break;
                }
                case "7": {
                    strName = ResManager.loadKDString((String)"\u79c1\u6709", (String)"CtrlStrategyListDataProvider_4", (String)"sys-ricc-business", (Object[])new Object[0]);
                    break;
                }
                default: {
                    strName = this.getCtrlStrategyByEntity(entityNumber, ctrlStrategyValue);
                }
            }
            return strName;
        }
    }
}

