/*
 * Decompiled with CFR 0.152.
 */
package kd.sys.ricc.api;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.MuliLangTextProp;
import kd.bos.lang.Lang;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.openapi.common.custom.annotation.ApiController;
import kd.bos.openapi.common.custom.annotation.ApiMapping;
import kd.bos.openapi.common.custom.annotation.ApiPostMapping;
import kd.bos.openapi.common.custom.annotation.ApiRequestBody;
import kd.bos.openapi.common.result.CustomApiResult;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.util.DynamicObjectSerializeUtil;
import kd.sys.ricc.business.datapacket.core.ISubDataPacket;
import kd.sys.ricc.business.metadata.compare.MetaDataCompareHelper;
import kd.sys.ricc.business.metadata.compare.RuntimeMetaInfo;
import kd.sys.ricc.common.util.CompareDataUtil;
import kd.sys.ricc.common.util.DynamicObjectUtil;
import kd.sys.ricc.common.util.PermissionUtil;
import kd.sys.ricc.common.util.StringUtils;

@ApiController(value="ricc", desc="riccWeb")
@ApiMapping(value="openApi/dataCompare")
public class RiccDataCompareApi {
    private static final Log logger = LogFactory.getLog(RiccDataCompareApi.class);
    private static final String ID_TYPE_LONG = "0";
    private static final String ID_TYPE_STRING = "1";

    @ApiPostMapping(value="/getTargetData", desc="\u83b7\u53d6\u76ee\u6807\u6570\u636e\u4e2d\u5fc3\u7684\u6570\u636e")
    public CustomApiResult<Object> getTargetData(@ApiRequestBody(value="\u9700\u8981\u7684\u53c2\u6570") Map<String, Object> params) {
        String type;
        logger.info("\u76ee\u6807\u6570\u636e\u4e2d\u5fc3\u63a5\u53e3\u8c03\u7528\u6210\u529f\uff0c\u6570\u636e\u5904\u7406\u4e2d...");
        if (params.get("lang") != null) {
            String locale = (String)params.get("lang");
            RequestContext.getOrCreate().setLang(Lang.from((String)locale));
        }
        if ("biz".equals(type = (String)params.get("bizType"))) {
            return this.bizDataCompare(params);
        }
        if ("meta".equals(type)) {
            return this.metaDataCompare(params);
        }
        if ("batchdatacompare".equals(type)) {
            return this.batchDataCompareGetData(params);
        }
        if ("preview".equals(type)) {
            return this.bizDataPreView(params);
        }
        String errorMsg = String.format(ResManager.loadKDString((String)"\u53c2\u6570\u7c7b\u578b\u5f02\u5e38\uff0c\u627e\u4e0d\u5230\u7c7b\u578b\u4e3a\u3010%s\u3011\u6570\u636e\u5bf9\u6bd4\u5b9e\u73b0\u65b9\u6cd5\u3002", (String)"RiccDataCompareApi_0", (String)"sys-ricc-platform", (Object[])new Object[0]), type);
        logger.info("kd.sys.ricc.api.RiccDataCompareApi.getTargetData:" + errorMsg);
        return CustomApiResult.fail((String)"500", (String)errorMsg);
    }

    private CustomApiResult<Object> bizDataPreView(Map<String, Object> params) {
        String preViewPlugin = (String)params.get("preViewPlugin");
        ISubDataPacket service = (ISubDataPacket)TypesContainer.getOrRegisterSingletonInstance((String)preViewPlugin);
        Map<String, Object> data = service.provideData(params);
        String result = JSON.toJSONStringWithDateFormat(data, (String)"yyyy-MM-dd HH:mm:ss.SSS", (SerializerFeature[])new SerializerFeature[0]);
        return CustomApiResult.success((Object)result);
    }

    private CustomApiResult<Object> bizDataCompare(Map<String, Object> params) {
        String idType = (String)params.get("idtype");
        String paramName = params.get("uniquekeytype").toString();
        String paramValue = (String)params.get("uniquekeyvalue");
        if (StringUtils.isEmpty((String)paramName) || paramName.length() > 25) {
            logger.error("\u53c2\u6570\u5f02\u5e38\uff0c\u53c2\u6570\u540d" + paramName + "\u4e3a\u7a7a\u6216\u957f\u5ea6\u8d85\u8fc7\u9650\u5236\u3002");
            String errorMsg = ResManager.loadKDString((String)"\u53c2\u6570\u5f02\u5e38\uff0c\u53c2\u6570\u540d\u4e3a\u7a7a\u6216\u957f\u5ea6\u8d85\u8fc7\u9650\u5236", (String)"RiccDataCompareApi_6", (String)"sys-ricc-platform", (Object[])new Object[0]);
            return CustomApiResult.fail((String)"ParamError", (String)errorMsg);
        }
        if (StringUtils.isEmpty((String)paramValue) || paramValue.length() > 1000) {
            logger.error("\u53c2\u6570\u5f02\u5e38\uff0c\u53c2\u6570\u503c" + paramValue + "\u4e3a\u7a7a\u6216\u8005\u957f\u5ea6\u8d85\u8fc7\u9650\u5236\u9519\u8bef\u3002");
            String errorMsg = ResManager.loadKDString((String)"\u53c2\u6570\u5f02\u5e38\uff0c\u53c2\u6570\u503c\uff0c\u4e3a\u7a7a\u6216\u8005\u957f\u5ea6\u8d85\u8fc7\u9650\u5236\u9519\u8bef", (String)"RiccDataCompareApi_7", (String)"sys-ricc-platform", (Object[])new Object[0]);
            return CustomApiResult.fail((String)"ParamError", (String)errorMsg);
        }
        QFilter qFilter = ID_TYPE_LONG.equals(idType) ? new QFilter("id", "=", (Object)Long.valueOf(paramValue)) : new QFilter(paramName, "=", (Object)paramValue);
        String entityNumber = params.get("billNumber").toString();
        DynamicObject targetData = BusinessDataServiceHelper.loadSingle((String)entityNumber, (QFilter[])qFilter.toArray());
        String result = null;
        if (targetData != null) {
            MainEntityType dtType = EntityMetadataCache.getDataEntityType((String)entityNumber);
            result = DynamicObjectSerializeUtil.serialize((Object[])new Object[]{targetData}, (DynamicObjectType)dtType);
        } else {
            logger.info(String.format("\u76ee\u6807\u6570\u636e\u4e2d\u5fc3\u4e2d\u7684\u5b9e\u4f53\u7c7b\u578b:%1$s\u4e2d\u627e\u4e0d\u5230%2$s\u4e3a%3$s\u7684\u6570\u636e\uff0c\u8bf7\u68c0\u67e5\u540e\u91cd\u65b0\u586b\u5199", entityNumber, paramName, paramValue));
        }
        return CustomApiResult.success((Object)result);
    }

    private CustomApiResult<Object> metaDataCompare(Map<String, Object> params) {
        if (params.get("number") == null || params.get("iscompareext") == null) {
            return CustomApiResult.success(new ArrayList());
        }
        List numbers = (List)params.get("number");
        boolean isCompareExt = (Boolean)params.get("iscompareext");
        List<RuntimeMetaInfo> runtimeMetaInfos = MetaDataCompareHelper.getRuntimeMetaInfoByNumbers(numbers, isCompareExt);
        return CustomApiResult.success(runtimeMetaInfos);
    }

    private CustomApiResult<Object> batchDataCompareGetData(Map<String, Object> params) {
        String qFilter = (String)params.get("qFilter");
        QFilter[] tarFilter = null;
        if (!StringUtils.isBlank((CharSequence)qFilter)) {
            tarFilter = new QFilter[]{QFilter.fromSerializedString((String)qFilter)};
        }
        if (tarFilter == null) {
            logger.error("\u53c2\u6570\u5f02\u5e38\uff0c\u8fc7\u6ee4\u6761\u4ef6\u4e3a\u7a7a\u3002" + qFilter);
            String errorMsg = ResManager.loadKDString((String)"\u53c2\u6570\u5f02\u5e38\uff0c\u8fc7\u6ee4\u6761\u4ef6\u4e3a\u7a7a", (String)"RiccDataCompareApi_3", (String)"sys-ricc-platform", (Object[])new Object[0]);
            return CustomApiResult.fail((String)"ParamError", (String)errorMsg);
        }
        String entityNumber = (String)params.get("entitynumber");
        JSONArray compareDataKeys = (JSONArray)params.get("compareDataKeys");
        JSONArray keyFieldsSet = (JSONArray)params.get("keyFieldsSet");
        DynamicObject runtimeMetaInfo = BusinessDataServiceHelper.loadSingleFromCache((String)"bos_formmeta", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)entityNumber)});
        if (runtimeMetaInfo == null) {
            String errorMsg = String.format(ResManager.loadKDString((String)"\u627e\u4e0d\u5230\u7f16\u7801\u4e3a%s\u7684\u5143\u6570\u636e\u3002", (String)"RiccDataCompareApi_2", (String)"sys-ricc-platform", (Object[])new Object[0]), entityNumber);
            logger.info("kd.sys.ricc.api.RiccDataCompareApi.batchDataCompare" + errorMsg);
            return CustomApiResult.fail((String)"FormNotFound", (String)errorMsg);
        }
        boolean hasQueryPer = PermissionUtil.checkPagePermission((String)entityNumber, (String)"47150e89000000ac");
        if (!hasQueryPer) {
            String errorMsg = String.format(ResManager.loadKDString((String)"\u6267\u884c\u5bf9\u6bd4\u5931\u8d25\uff0c\u76ee\u6807\u6570\u636e\u4e2d\u5fc3\u7528\u6237\u6ca1\u6709\u5f53\u524d\u914d\u7f6e\u9879\u7684\u67e5\u8be2\u6743\u9650\uff0c\u65e0\u6cd5\u6267\u884c\u5bf9\u6bd4\u3002", (String)"RiccDataCompareApi_5", (String)"sys-ricc-platform", (Object[])new Object[0]), entityNumber);
            logger.info("kd.sys.ricc.api.RiccDataCompareApi.batchDataCompare" + errorMsg);
            return CustomApiResult.fail((String)"NoQueryPerm", (String)errorMsg);
        }
        String result = null;
        Map targetDataMap = BusinessDataServiceHelper.loadFromCache((String)entityNumber, (QFilter[])tarFilter);
        if (!targetDataMap.isEmpty()) {
            Collection<DynamicObject> tarValues = targetDataMap.values();
            MainEntityType dtType = EntityMetadataCache.getDataEntityType((String)entityNumber);
            Map<String, List<Map<String, Object>>> fieldKeyValueMap = this.getNecessaryData(keyFieldsSet, tarValues, dtType, compareDataKeys);
            result = JSON.toJSONStringWithDateFormat(fieldKeyValueMap, (String)"yyyy-MM-dd HH:mm:ss.SSS", (SerializerFeature[])new SerializerFeature[0]);
        }
        return CustomApiResult.success(result);
    }

    private Map<String, List<Map<String, Object>>> getNecessaryData(JSONArray keyFieldsSet, Collection<DynamicObject> targetData, MainEntityType entityType, JSONArray compareDataKeys) {
        HashMap<String, List<Map<String, Object>>> keyFieldsValueToMap = new HashMap<String, List<Map<String, Object>>>(4);
        for (DynamicObject tarDataDyo : targetData) {
            StringBuilder tarKey = new StringBuilder();
            for (Object key : keyFieldsSet) {
                String keyStr = (String)key;
                IDataEntityProperty property = (IDataEntityProperty)entityType.getProperties().get((Object)keyStr);
                if (property instanceof BasedataProp) {
                    tarKey.append(tarDataDyo.getDynamicObject(keyStr).get("number")).append("$$$");
                    continue;
                }
                if (property instanceof MuliLangTextProp) {
                    tarKey.append(((Map)tarDataDyo.get(keyStr)).get("zh_CN")).append("$$$");
                    continue;
                }
                tarKey.append(tarDataDyo.getString(keyStr)).append("$$$");
            }
            tarKey.delete(tarKey.length() - 3, tarKey.length());
            Map requiresPropMap = CompareDataUtil.getCompareRequiresPropMap((DataEntityPropertyCollection)entityType.getProperties());
            if (!compareDataKeys.contains((Object)tarKey.toString())) continue;
            Map result = DynamicObjectUtil.object2Map((DynamicObject)tarDataDyo, (Map)requiresPropMap);
            this.getKeyFieldsValueToMap(tarKey.toString(), result, keyFieldsValueToMap);
        }
        return keyFieldsValueToMap;
    }

    private void getKeyFieldsValueToMap(String key, Map<String, Object> results, Map<String, List<Map<String, Object>>> fieldKeyValueMap) {
        List<Map<String, Object>> dyoList = fieldKeyValueMap.get(key);
        if (dyoList != null) {
            dyoList.add(results);
        } else {
            ArrayList<Map<String, Object>> compareDataList = new ArrayList<Map<String, Object>>(2);
            compareDataList.add(results);
            fieldKeyValueMap.put(key, compareDataList);
        }
    }
}

