/*
 * Decompiled with CFR 0.152.
 */
package kd.sys.ricc.business.configitem.check.configcheckitems;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.form.field.ComboItem;
import kd.sys.ricc.business.configitem.check.AbstractConfigCheckItem;
import kd.sys.ricc.common.util.PageChangeUtil;

public class ConditionMustFieldCheck
extends AbstractConfigCheckItem {
    @Override
    public void doAction(Map<String, Object> paramsMap) {
        List<String> excludePageNumbers = Arrays.asList("am_accountbank", "bd_accountbanks", "am_accountbank2", "srm_index", "im_invqueryconf");
        DynamicObject configItem = (DynamicObject)paramsMap.get("configItem");
        String pageNumber = ((DynamicObject)configItem.get("page")).getString("basedatafield.number");
        String pageType = configItem.getString("pagetype");
        Boolean supportAddToPacket = configItem.getBoolean("supportaddtopacket");
        String importType = configItem.getString("importtype");
        if ("bos_dynamicform".equals(pageType)) {
            this.setCheckResult("ignore");
            String log = ResManager.loadKDString((String)"\u914d\u7f6e\u9879\u4e3a\u52a8\u6001\u8868\u5355\uff0c\u65e0\u9700\u68c0\u67e5\u3002", (String)"ConditionMustFieldCheck_1", (String)"sys-ricc-platform", (Object[])new Object[0]);
            this.setLog(log);
            return;
        }
        if (Boolean.FALSE.equals(supportAddToPacket)) {
            this.setCheckResult("ignore");
            String log = ResManager.loadKDString((String)"\u914d\u7f6e\u9879\u4e0d\u652f\u6301\u4f20\u8f93\uff0c\u65e0\u9700\u68c0\u67e5\u3002", (String)"ConditionMustFieldCheck_2", (String)"sys-ricc-platform", (Object[])new Object[0]);
            this.setLog(log);
            return;
        }
        if (!"excel".equals(importType)) {
            this.setCheckResult("ignore");
            String log = ResManager.loadKDString((String)"\u914d\u7f6e\u9879\u4f20\u8f93\u65b9\u5f0f\u4e0d\u4e3aExcel\u5bfc\u5165\u5bfc\u51fa\uff0c\u65e0\u9700\u68c0\u67e5\u3002", (String)"ConditionMustFieldCheck_3", (String)"sys-ricc-platform", (Object[])new Object[0]);
            this.setLog(log);
            return;
        }
        List conditionMustItems = PageChangeUtil.getConditionMustItems((String)pageNumber);
        if (!conditionMustItems.isEmpty()) {
            this.setCheckResult("failed");
            List conditionMustFields = conditionMustItems.stream().map(ComboItem::getValue).collect(Collectors.toList());
            StringBuilder stringBuilder = new StringBuilder(ResManager.loadKDString((String)"\u5b58\u5728\u6761\u4ef6\u5fc5\u5f55\u5b57\u6bb5\u3010%1$s\u3011\u3002", (String)"ConditionMustFieldCheck_4", (String)"sys-ricc-platform", (Object[])new Object[]{String.join((CharSequence)",", conditionMustFields)}));
            if (excludePageNumbers.contains(pageNumber)) {
                stringBuilder.append(ResManager.loadKDString((String)"\u5df2\u7279\u6b8a\u5904\u7406\u3002", (String)"ConditionMustFieldCheck_0", (String)"sys-ricc-platform", (Object[])new Object[0]));
            }
            this.setLog(stringBuilder.toString());
            return;
        }
        this.setCheckResult("success");
    }
}

