/*
 * Decompiled with CFR 0.152.
 */
package kd.sys.ricc.business.configitem.check.configcheckitems;

import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.sys.ricc.business.configitem.check.AbstractConfigCheckItem;
import kd.sys.ricc.common.util.StringUtils;

public class MustInputFieldsCheck
extends AbstractConfigCheckItem {
    @Override
    public void doAction(Map<String, Object> paramsMap) {
        DynamicObject configItem = (DynamicObject)paramsMap.get("configItem");
        boolean isBaseInfoMustInput = this.baseInfoMustInputCheck(configItem);
        boolean isImportTypeMustInput = this.importTypeMustInputCheck(configItem);
        boolean isTransferPluginMustInput = this.transferPluginMustInputCheck(configItem);
        boolean isRelyItemMustInput = this.relyItemMustInputCheck(configItem);
        boolean isSchemeMustInput = this.schemeMustInputCheck(configItem);
        if (isBaseInfoMustInput && isImportTypeMustInput && isTransferPluginMustInput && isRelyItemMustInput && isSchemeMustInput) {
            this.setCheckResult("success");
            return;
        }
        this.setCheckResult("failed");
        String log = ResManager.loadKDString((String)"\u5b58\u5728\u5fc5\u5f55\u5b57\u6bb5\u9519\u8bef\uff0c\u53ef\u80fd\u4f1a\u9020\u6210\u7cfb\u7edf\u5904\u7406\u5f02\u5e38,\u5efa\u8bae\u4fee\u6539\u5b8c\u5584\u5fc5\u5f55\u5b57\u6bb5\u3002", (String)"MustInputFieldsCheck_0", (String)"sys-ricc-platform", (Object[])new Object[0]);
        this.setLog(log);
    }

    private boolean baseInfoMustInputCheck(DynamicObject configItem) {
        String page = configItem.getString("page");
        String number = configItem.getString("number");
        String name = configItem.getString("name");
        String configType = configItem.getString("configtype");
        String group = configItem.getString("group");
        String pageType = configItem.getString("pagetype");
        String rightPage = configItem.getString("rightpage");
        return StringUtils.isNotBlank((CharSequence)page) && StringUtils.isNotBlank((CharSequence)number) && StringUtils.isNotBlank((CharSequence)name) && StringUtils.isNotBlank((CharSequence)configType) && StringUtils.isNotBlank((CharSequence)group) && StringUtils.isNotBlank((CharSequence)pageType) && StringUtils.isNotBlank((CharSequence)rightPage);
    }

    private boolean importTypeMustInputCheck(DynamicObject configItem) {
        boolean isSupportAddToPacket = configItem.getBoolean("supportaddtopacket");
        if (isSupportAddToPacket) {
            String importType = configItem.getString("importtype");
            return StringUtils.isNotBlank((CharSequence)importType);
        }
        return true;
    }

    private boolean transferPluginMustInputCheck(DynamicObject configItem) {
        String importType = configItem.getString("importtype");
        if ("custom".equals(importType) || "microService".equals(importType)) {
            String plugin = configItem.getString("plugin");
            return StringUtils.isNotBlank((CharSequence)plugin);
        }
        return true;
    }

    private boolean relyItemMustInputCheck(DynamicObject configItem) {
        DynamicObjectCollection relyItemEntrys = configItem.getDynamicObjectCollection("relyitementry");
        for (DynamicObject relyItemEntry : relyItemEntrys) {
            DynamicObject relyItem = relyItemEntry.getDynamicObject("relyitem");
            if (relyItem != null) continue;
            return false;
        }
        return true;
    }

    private boolean schemeMustInputCheck(DynamicObject configItem) {
        DynamicObjectCollection schemeEntrys = configItem.getDynamicObjectCollection("ricc_schemeentry");
        for (DynamicObject schemeEntry : schemeEntrys) {
            DynamicObject scheme = schemeEntry.getDynamicObject("scheme");
            if (scheme != null) continue;
            return false;
        }
        return true;
    }
}

