/*
 * Decompiled with CFR 0.152.
 */
package kd.sys.ricc.business.configitem.check.configcheckitems;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.Features;
import kd.bos.entity.MainEntityType;
import kd.bos.metadata.dao.MetaCategory;
import kd.bos.metadata.dao.MetadataDao;
import kd.bos.metadata.entity.EntityItem;
import kd.bos.metadata.entity.EntityMetadata;
import kd.bos.metadata.entity.EntryEntity;
import kd.bos.metadata.entity.businessfield.BasedataPropField;
import kd.bos.metadata.entity.businessfield.MulBasedataField;
import kd.bos.metadata.entity.commonfield.ComboField;
import kd.bos.metadata.entity.commonfield.DateRangeField;
import kd.bos.metadata.entity.commonfield.Field;
import kd.bos.metadata.entity.commonfield.RadioField;
import kd.bos.metadata.entity.commonfield.TextField;
import kd.bos.metadata.entity.commonfield.TimeRangeField;
import kd.sys.ricc.business.configitem.check.AbstractConfigCheckItem;
import kd.sys.ricc.common.util.StringUtils;

public class NoSaveMustFieldEntryCheck
extends AbstractConfigCheckItem {
    @Override
    public void doAction(Map<String, Object> paramsMap) {
        List<String> excludePageNumbers = Arrays.asList("bd_admindivision", "er_entrustreimburse", "tctb_custom_datasource", "evt_event", "fcm_checkitem");
        DynamicObject configItem = (DynamicObject)paramsMap.get("configItem");
        String pageNumber = ((DynamicObject)configItem.get("page")).getString("basedatafield.number");
        String pageType = configItem.getString("pagetype");
        Boolean supportAddToPacket = configItem.getBoolean("supportaddtopacket");
        String importType = configItem.getString("importtype");
        if ("bos_dynamicform".equals(pageType)) {
            this.setCheckResult("ignore");
            String log = ResManager.loadKDString((String)"\u914d\u7f6e\u9879\u4e3a\u52a8\u6001\u8868\u5355\uff0c\u65e0\u9700\u68c0\u67e5\u3002", (String)"NoSaveMustFieldCheck_1", (String)"sys-ricc-platform", (Object[])new Object[0]);
            this.setLog(log);
            return;
        }
        if (Boolean.FALSE.equals(supportAddToPacket)) {
            this.setCheckResult("ignore");
            String log = ResManager.loadKDString((String)"\u914d\u7f6e\u9879\u4e0d\u652f\u6301\u4f20\u8f93\uff0c\u65e0\u9700\u68c0\u67e5\u3002", (String)"NoSaveMustFieldCheck_2", (String)"sys-ricc-platform", (Object[])new Object[0]);
            this.setLog(log);
            return;
        }
        List<String> noSaveFieldsOrEntry = this.getNoSaveFieldsOrEntry(pageNumber, importType);
        if (!noSaveFieldsOrEntry.isEmpty()) {
            this.setCheckResult("failed");
            StringBuilder stringBuilder = new StringBuilder(ResManager.loadKDString((String)"\u5b58\u5728\u6570\u636e\u5e93\u4e3a\u7a7a\u5fc5\u5f55\u5b57\u6bb5\u6216\u5206\u5f55\u3010%1$s\u3011\u3002", (String)"NoSaveMustFieldCheck_3", (String)"sys-ricc-platform", (Object[])new Object[]{String.join((CharSequence)",", noSaveFieldsOrEntry)}));
            if (excludePageNumbers.contains(pageNumber)) {
                stringBuilder.append(ResManager.loadKDString((String)"\u5df2\u7279\u6b8a\u5904\u7406\u3002", (String)"NoSaveMustFieldCheck_0", (String)"sys-ricc-platform", (Object[])new Object[0]));
            }
            this.setLog(stringBuilder.toString());
            return;
        }
        this.setCheckResult("success");
    }

    private List<String> getNoSaveFieldsOrEntry(String entityNumber, String importType) {
        ArrayList<String> noSaveMustFields = new ArrayList<String>(16);
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        EntityMetadata entityMetadata = (EntityMetadata)MetadataDao.readRuntimeMeta((String)MetadataDao.getIdByNumber((String)entityType.getName(), (MetaCategory)MetaCategory.Entity), (MetaCategory)MetaCategory.Entity);
        List entityFields = entityMetadata.getItems();
        HashSet<String> skipProp = new HashSet<String>(16);
        for (EntityItem entityField : entityFields) {
            if (!this.isDataBaseField(entityField)) continue;
            if (entityField instanceof EntryEntity) {
                String tableName = ((EntryEntity)entityField).getTableName();
                if (!StringUtils.isBlank((CharSequence)tableName)) continue;
                this.addSkipField(skipProp, (EntryEntity)entityField);
                if (!((EntryEntity)entityField).isEntryMustInput()) continue;
                noSaveMustFields.add(entityField.getKey());
                continue;
            }
            if (skipProp.contains(entityField.getKey())) continue;
            NoSaveMustFieldEntryCheck.dealEntityField(importType, entityField, noSaveMustFields);
        }
        return noSaveMustFields;
    }

    private static void dealEntityField(String importType, EntityItem<?> entityField, List<String> noSaveMustFields) {
        String fieldName = ((Field)entityField).getFieldName();
        if (entityField instanceof MulBasedataField) {
            String tableName = ((MulBasedataField)entityField).getTableName();
            if (StringUtils.isEmpty((String)tableName) && ((MulBasedataField)entityField).isMustInput()) {
                noSaveMustFields.add(entityField.getKey());
            }
        } else if (entityField instanceof DateRangeField) {
            String startKey = ((DateRangeField)entityField).getStartDateFieldName();
            String endKey = ((DateRangeField)entityField).getEndDateFieldName();
            if ((StringUtils.isEmpty((String)startKey) || StringUtils.isEmpty((String)endKey)) && ((DateRangeField)entityField).isMustInput()) {
                noSaveMustFields.add(entityField.getKey());
            }
        } else if (entityField instanceof TimeRangeField) {
            String startKey = ((TimeRangeField)entityField).getStartDateFieldName();
            String endKey = ((TimeRangeField)entityField).getEndDateFieldName();
            if ((StringUtils.isEmpty((String)startKey) || StringUtils.isEmpty((String)endKey)) && ((TimeRangeField)entityField).isMustInput()) {
                noSaveMustFields.add(entityField.getKey());
            }
        } else if (StringUtils.isBlank((CharSequence)fieldName) && ((Field)entityField).isMustInput()) {
            boolean hasDefValue;
            Features features = ((Field)entityField).getFeatures();
            if ("excel".equals(importType) && !features.isImportable()) {
                return;
            }
            boolean bl = hasDefValue = entityField instanceof ComboField && StringUtils.isNotEmpty((String)((ComboField)entityField).getDefValue()) || entityField instanceof TextField && StringUtils.isNotEmpty((String)((TextField)entityField).getDefValue());
            if ("json".equals(importType) && hasDefValue) {
                return;
            }
            noSaveMustFields.add(entityField.getKey());
        }
    }

    public boolean isDataBaseField(EntityItem<?> entityItem) {
        return entityItem instanceof Field && !(entityItem instanceof RadioField) && !(entityItem instanceof BasedataPropField) || entityItem instanceof EntryEntity;
    }

    private void addSkipField(Set<String> skipProp, EntryEntity entityField) {
        for (EntityItem entryField : entityField.getItems()) {
            if (entryField instanceof EntryEntity) {
                for (EntityItem subEntryField : ((EntryEntity)entryField).getItems()) {
                    skipProp.add(subEntryField.getKey());
                }
                continue;
            }
            skipProp.add(entryField.getKey());
        }
    }
}

