/*
 * Decompiled with CFR 0.152.
 */
package kd.sys.ricc.business.datapacket.core.impl.json;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.ICollectionProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.EntryProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.sys.ricc.business.datapacket.core.impl.json.JsonDataPacketImpl;
import kd.sys.ricc.business.datapacket.core.impl.json.JsonImportHelper;
import kd.sys.ricc.business.datapacket.core.model.SdpOutputParams;
import kd.sys.ricc.exception.RiccBizException;

public class JsonSupportSubEntityImpl
extends JsonDataPacketImpl {
    private static final Log logger = LogFactory.getLog(JsonSupportSubEntityImpl.class);
    protected static final String SUB_DATA = "subData";

    protected List<EntityMappingInfo> getSubEntityList() {
        return Collections.emptyList();
    }

    @Override
    protected void afterBatchExport(DynamicObject[] batchData, Map<String, Object> batchContentMap) {
        List<EntityMappingInfo> entityMappingInfoList = this.getSubEntityList();
        if (entityMappingInfoList == null || entityMappingInfoList.isEmpty()) {
            logger.info("\u6ca1\u6709\u9700\u8981\u5bfc\u51fa\u7684\u5b50\u5b9e\u4f53\u6570\u636e\u3002");
            return;
        }
        for (EntityMappingInfo entityMappingInfo : entityMappingInfoList) {
            String entityNumber = entityMappingInfo.getEntityNumber();
            Map<String, Map<String, Object>> batchSubContentMap = this.getBatchSubContentMap(batchData, batchContentMap, entityMappingInfo);
            this.buildData(batchContentMap, batchSubContentMap, entityNumber);
        }
    }

    @Override
    protected void beforeBatchImport(List<Object> idList, JSONObject dataMap, SdpOutputParams outputParams) {
        List<EntityMappingInfo> subEntityList = this.getSubEntityList();
        if (subEntityList == null || subEntityList.isEmpty()) {
            logger.info("\u6ca1\u6709\u9700\u8981\u5bfc\u5165\u7684\u5b50\u5b9e\u4f53\u6570\u636e\u3002");
            return;
        }
        for (EntityMappingInfo subEntityInfo : subEntityList) {
            this.subEntityImport(idList, dataMap, outputParams, subEntityInfo);
        }
    }

    protected void subEntityImport(List<Object> idList, JSONObject dataMap, SdpOutputParams outputParams, EntityMappingInfo subEntityInfo) {
        String entityNumber = subEntityInfo.getEntityNumber();
        String keyFields = subEntityInfo.getKeyFields();
        JsonDataPacketImpl.BatchSaveType batchSaveType = subEntityInfo.getBatchSaveType();
        HashMap<String, Object> subEntityDataMap = new HashMap<String, Object>(idList.size());
        for (Object id : idList) {
            Map entityDataMap;
            Map allData = (Map)dataMap.get(id);
            Map subDataMap = (Map)allData.get(SUB_DATA);
            if (subDataMap == null || subDataMap.isEmpty() || (entityDataMap = (Map)subDataMap.get(entityNumber)) == null || entityDataMap.isEmpty()) continue;
            subEntityDataMap.putAll(entityDataMap);
        }
        if (!subEntityDataMap.isEmpty()) {
            int successCount = this.batchImportSave(entityNumber, idList, subEntityDataMap, outputParams, keyFields, batchSaveType);
            logger.info("\u5b9e\u4f53" + entityNumber + "\u6210\u529f\u6570\u91cf\uff1a" + successCount);
            if (successCount < subEntityDataMap.size()) {
                String error = ResManager.loadKDString((String)"\u5b50\u5b9e\u4f53\u201d%1$s\u201c\u603b\u6570 \u201d%2$s\u201c \u5bfc\u5165\u6210\u529f\u6570\u91cf\u201d%3$s\u201c", (String)"JsonSupportSubEntityImpl_0", (String)"sys-ricc-platform", (Object[])new Object[]{entityNumber, subEntityDataMap.size(), successCount});
                throw new RiccBizException(error);
            }
        }
    }

    protected Map<String, Map<String, Object>> getBatchSubContentMap(DynamicObject[] batchData, Map<String, Object> batchContentMap, EntityMappingInfo entityMappingInfo) {
        String entityNumber = entityMappingInfo.getEntityNumber();
        String mainEntityRelationKey = entityMappingInfo.getMainEntityRelationKey();
        String subEntityQueryKey = entityMappingInfo.getSubEntityQueryKey();
        Map<String, List<Object>> mainAndSubValueMap = this.buildQueryParam(batchData, mainEntityRelationKey);
        Map<String, Object> batchSubDataMap = this.batchExportData(entityNumber, subEntityQueryKey, mainAndSubValueMap);
        return this.getMainIdAndSubDataMap(subEntityQueryKey, mainAndSubValueMap, batchSubDataMap);
    }

    private void buildData(Map<String, Object> batchContentMap, Map<String, Map<String, Object>> batchSubContentMap, String entityNumber) {
        if (batchSubContentMap == null || batchSubContentMap.isEmpty()) {
            return;
        }
        Set<Map.Entry<String, Object>> batchDataEntries = batchContentMap.entrySet();
        for (Map.Entry<String, Object> batchDataEntry : batchDataEntries) {
            String mainId = batchDataEntry.getKey();
            Map contentMap = (Map)batchDataEntry.getValue();
            Map<String, Object> subEntityDataMap = batchSubContentMap.get(mainId);
            if (subEntityDataMap == null || subEntityDataMap.isEmpty()) continue;
            HashMap<String, Map<String, Object>> dataMap = new HashMap<String, Map<String, Object>>(1);
            dataMap.put(entityNumber, subEntityDataMap);
            Object subDataVal = contentMap.get(SUB_DATA);
            if (subDataVal != null) {
                if (!(subDataVal instanceof Map)) continue;
                Map subDataContentMap = (Map)subDataVal;
                Map entityMap = (Map)subDataContentMap.get(entityNumber);
                if (entityMap != null) {
                    entityMap.putAll(subEntityDataMap);
                    continue;
                }
                subDataContentMap.putAll(dataMap);
                continue;
            }
            contentMap.put(SUB_DATA, dataMap);
        }
    }

    protected Map<String, Map<String, Object>> getMainIdAndSubDataMap(String subEntityQueryKey, Map<String, List<Object>> mainAndSubValueMap, Map<String, Object> batchSubDataMap) {
        if (batchSubDataMap.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, HashMap<String, Map>> subDataMap = new HashMap<String, HashMap<String, Map>>(16);
        Set<Map.Entry<String, Object>> subContentEntries = batchSubDataMap.entrySet();
        for (Map.Entry<String, Object> subContentEntry : subContentEntries) {
            Map subContentMap = (Map)subContentEntry.getValue();
            Map subContentDataMap = (Map)subContentMap.get("data");
            String subMatchValue = String.valueOf(subContentDataMap.get(subEntityQueryKey));
            HashMap<String, Map> dataMap = (HashMap<String, Map>)subDataMap.get(subMatchValue);
            if (null == dataMap) {
                dataMap = new HashMap<String, Map>(8);
                subDataMap.put(subMatchValue, dataMap);
            }
            dataMap.put(subContentEntry.getKey(), subContentMap);
        }
        HashMap<String, Map<String, Object>> mainIdAndSubDataMap = new HashMap<String, Map<String, Object>>(16);
        Set<Map.Entry<String, List<Object>>> mainAndSubValueEntry = mainAndSubValueMap.entrySet();
        for (Map.Entry<String, List<Object>> mainAndSubValue : mainAndSubValueEntry) {
            String mainId = mainAndSubValue.getKey();
            List<Object> subValueList = mainAndSubValue.getValue();
            if (subValueList.isEmpty()) continue;
            HashMap dataMap = new HashMap(subValueList.size());
            for (Object subValue : subValueList) {
                Map subDataValueMap = (Map)subDataMap.get(String.valueOf(subValue));
                if (subDataValueMap == null || subDataValueMap.isEmpty()) continue;
                dataMap.putAll(subDataValueMap);
            }
            mainIdAndSubDataMap.put(mainId, dataMap);
        }
        return mainIdAndSubDataMap;
    }

    private Map<String, List<Object>> buildQueryParam(DynamicObject[] batchData, String matchKey) {
        HashMap<String, List<Object>> mainAndSubIdMap = new HashMap<String, List<Object>>(batchData.length);
        for (DynamicObject dataObj : batchData) {
            DataEntityPropertyCollection properties = dataObj.getDataEntityType().getProperties();
            boolean containsKey = properties.containsKey((Object)matchKey);
            ArrayList<Object> matchValueList = new ArrayList<Object>(16);
            String id = dataObj.getString("id");
            mainAndSubIdMap.put(id, matchValueList);
            if (containsKey) {
                this.getObjValue(dataObj, matchKey, matchValueList);
                continue;
            }
            List collectionProperties = properties.getCollectionProperties(false);
            this.getMatchValueFromDynamicCollection(dataObj, matchKey, matchValueList, collectionProperties);
        }
        return mainAndSubIdMap;
    }

    private void getMatchValueFromDynamicCollection(DynamicObject dataObj, String matchKey, List<Object> matchValueList, List<ICollectionProperty> collectionProperties) {
        for (ICollectionProperty collectionProperty : collectionProperties) {
            if (!(collectionProperty instanceof EntryProp)) continue;
            DynamicObjectType entryItemPropertyType = ((EntryProp)collectionProperty).getDynamicCollectionItemPropertyType();
            DataEntityPropertyCollection entryDynamicProperties = entryItemPropertyType.getProperties();
            String collectionKey = collectionProperty.getName();
            DynamicObjectCollection dynamicObjectCollection = dataObj.getDynamicObjectCollection(collectionKey);
            if (entryDynamicProperties.containsKey((Object)matchKey)) {
                for (DynamicObject dynamicObject : dynamicObjectCollection) {
                    this.getObjValue(dynamicObject, matchKey, matchValueList);
                }
                return;
            }
            List entryCollectionProperties = entryDynamicProperties.getCollectionProperties(false);
            if (entryCollectionProperties.isEmpty()) continue;
            for (DynamicObject dynamicObject : dynamicObjectCollection) {
                this.getMatchValueFromDynamicCollection(dynamicObject, matchKey, matchValueList, entryCollectionProperties);
            }
        }
    }

    private void getObjValue(DynamicObject valueObj, String matchKey, List<Object> matchValueList) {
        Object keyValueObj = valueObj.get(matchKey);
        if (Objects.isNull(keyValueObj)) {
            return;
        }
        if (keyValueObj instanceof DynamicObjectCollection) {
            for (DynamicObject collectionObject : (DynamicObjectCollection)keyValueObj) {
                matchValueList.add(collectionObject.get("fbasedataid_id"));
            }
        } else if (keyValueObj instanceof DynamicObject) {
            matchValueList.add(((DynamicObject)keyValueObj).get("id"));
        } else {
            matchValueList.add(keyValueObj);
        }
    }

    protected Map<String, Object> batchExportData(String entityNumber, String subEntityQueryKey, Map<String, List<Object>> mainAndSubValueMap) {
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityNumber);
        Collection<List<Object>> matchValueCol = mainAndSubValueMap.values();
        HashSet<Object> matchValueSet = new HashSet<Object>(16);
        for (List<Object> matchValues : matchValueCol) {
            matchValueSet.addAll(matchValues);
        }
        if (matchValueSet.isEmpty()) {
            return Collections.emptyMap();
        }
        QFilter qFilter = new QFilter(subEntityQueryKey, "in", matchValueSet);
        DynamicObject[] subDataObj = null;
        if ("id".equals(subEntityQueryKey)) {
            subDataObj = BusinessDataServiceHelper.load((Object[])matchValueSet.toArray(), (DynamicObjectType)entityType);
        } else {
            List matchValueIdList = QueryServiceHelper.queryPrimaryKeys((String)entityNumber, (QFilter[])qFilter.toArray(), null, (int)-1);
            subDataObj = BusinessDataServiceHelper.load((Object[])matchValueIdList.toArray(), (DynamicObjectType)entityType);
        }
        return this.getDataMap(subDataObj, null, 0, 0);
    }

    protected int batchImportSave(String entityNumber, List<Object> mainIdList, Map<String, Object> subDataEntityMap, SdpOutputParams outputParams, String keyFields, JsonDataPacketImpl.BatchSaveType batchSaveType) {
        JSONObject subDataEntityJsonObj = new JSONObject();
        subDataEntityJsonObj.putAll(subDataEntityMap);
        ArrayList<Object> subIdList = new ArrayList<Object>(mainIdList.size());
        Set<String> subIdSet = subDataEntityMap.keySet();
        subIdSet.forEach(id -> subIdList.add(JsonImportHelper.idCovert(entityNumber, id)));
        return this.batchImport(entityNumber, subIdList, subDataEntityJsonObj, outputParams, keyFields, batchSaveType);
    }

    public static class EntityMappingInfo {
        private String entityNumber;
        private String mainEntityRelationKey;
        private String subEntityQueryKey;
        private String keyFields = "id";
        private JsonDataPacketImpl.BatchSaveType batchSaveType = JsonDataPacketImpl.BatchSaveType.AUTO;

        public EntityMappingInfo(String entityNumber, String mainEntityRelationKey, String subEntityQueryKey, String keyFields) {
            this(entityNumber, mainEntityRelationKey, subEntityQueryKey, keyFields, JsonDataPacketImpl.BatchSaveType.AUTO);
        }

        public EntityMappingInfo(String entityNumber, String mainEntityRelationKey, String subEntityQueryKey) {
            this(entityNumber, mainEntityRelationKey, subEntityQueryKey, "id", JsonDataPacketImpl.BatchSaveType.AUTO);
        }

        public EntityMappingInfo(String entityNumber, String mainEntityRelationKey, String subEntityQueryKey, String keyFields, JsonDataPacketImpl.BatchSaveType batchSaveType) {
            this.entityNumber = entityNumber;
            this.mainEntityRelationKey = mainEntityRelationKey;
            this.subEntityQueryKey = subEntityQueryKey;
            this.keyFields = keyFields;
            this.batchSaveType = batchSaveType;
        }

        public String getEntityNumber() {
            return this.entityNumber;
        }

        public void setEntityNumber(String entityNumber) {
            this.entityNumber = entityNumber;
        }

        public String getMainEntityRelationKey() {
            return this.mainEntityRelationKey;
        }

        public void setMainEntityRelationKey(String mainEntityRelationKey) {
            this.mainEntityRelationKey = mainEntityRelationKey;
        }

        public String getSubEntityQueryKey() {
            return this.subEntityQueryKey;
        }

        public void setSubEntityQueryKey(String subEntityQueryKey) {
            this.subEntityQueryKey = subEntityQueryKey;
        }

        public String getKeyFields() {
            return this.keyFields;
        }

        public void setKeyFields(String keyFields) {
            this.keyFields = keyFields;
        }

        public JsonDataPacketImpl.BatchSaveType getBatchSaveType() {
            return this.batchSaveType;
        }
    }
}

