/*
 * Decompiled with CFR 0.152.
 */
package kd.sys.ricc.business.datapacket.download;

import com.alibaba.fastjson.JSONObject;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.sys.ricc.business.datapacket.core.impl.json.JsonDataPacketImpl;
import kd.sys.ricc.common.enums.EnvRoleEnum;
import kd.sys.ricc.common.util.CommonUtil;
import kd.sys.ricc.common.util.DynamicObjectUtil;
import kd.sys.ricc.common.util.FileUtils;
import kd.sys.ricc.common.util.Sha256Util;
import kd.sys.ricc.common.util.StringUtils;
import kd.sys.ricc.common.util.SysParaUtil;
import kd.sys.ricc.exception.RiccBizException;
import org.apache.commons.io.FilenameUtils;

public class PacketDownLoadUtil {
    private static final Log logger = LogFactory.getLog(PacketDownLoadUtil.class);

    private PacketDownLoadUtil() {
        throw new IllegalStateException("Utility class");
    }

    public static void findConfigAndTree(DynamicObject packet, List<DynamicObject> itemList, List<DynamicObject> treeList) {
        DynamicObjectCollection subDataPackets = packet.getDynamicObjectCollection("subdatapacket");
        ArrayList<Object> idList = new ArrayList<Object>(10);
        for (DynamicObject subDataPacketRow : subDataPackets) {
            String subPacketType = subDataPacketRow.getString("subpackettype");
            if (!StringUtils.equals((String)"ricc_configitems", (String)subPacketType)) continue;
            DynamicObject bizObject = subDataPacketRow.getDynamicObject("bizobject");
            idList.add(bizObject.getPkValue());
        }
        PacketDownLoadUtil.loopFindRelyItemAndTree(idList, itemList, treeList);
    }

    private static void loopFindTree(List<Object> treeIdList, List<DynamicObject> treeList) {
        ArrayList<Object> parentTreeIdList = new ArrayList<Object>(10);
        treeIdList = treeIdList.stream().filter(id -> treeList.stream().noneMatch(dyo -> dyo.getPkValue().equals(id))).collect(Collectors.toList());
        Map configTreesMap = BusinessDataServiceHelper.loadFromCache((Object[])treeIdList.toArray(), (String)"ricc_configtree");
        for (DynamicObject treeDyo : configTreesMap.values()) {
            boolean treeIsPreset = treeDyo.getBoolean("ispreset");
            if (treeIsPreset) continue;
            treeList.add(treeDyo);
            DynamicObject parentTree = treeDyo.getDynamicObject("parent");
            if (parentTree == null) continue;
            parentTreeIdList.add(parentTree.getPkValue());
        }
        if (parentTreeIdList.isEmpty()) {
            return;
        }
        PacketDownLoadUtil.loopFindTree(parentTreeIdList, treeList);
    }

    public static void sortTree(List<DynamicObject> treeList) {
        treeList.sort((tree, otherTree) -> {
            int treeCount = PacketDownLoadUtil.countSegments(tree.getString("longnumber"));
            int otherCount = PacketDownLoadUtil.countSegments(otherTree.getString("longnumber"));
            return treeCount - otherCount;
        });
    }

    private static int countSegments(String str) {
        return str.split("\\.").length;
    }

    private static void loopFindRelyItemAndTree(List<Object> idList, List<DynamicObject> itemList, List<DynamicObject> treeList) {
        idList = idList.stream().filter(id -> itemList.stream().noneMatch(dyo -> dyo.getPkValue().equals(id))).collect(Collectors.toList());
        MainEntityType configItemsType = EntityMetadataCache.getDataEntityType((String)"ricc_configitems");
        DynamicObject[] loadData = BusinessDataServiceHelper.load((Object[])idList.toArray(), (DynamicObjectType)configItemsType);
        ArrayList<Object> relyIdList = new ArrayList<Object>(10);
        ArrayList<Object> treeIdList = new ArrayList<Object>(10);
        for (DynamicObject loadDatum : loadData) {
            boolean isPreset = loadDatum.getBoolean("ispreset");
            if (isPreset) continue;
            itemList.add(loadDatum);
            treeIdList.add(loadDatum.getDynamicObject("group").getPkValue());
            DynamicObjectCollection relyItemEntry = loadDatum.getDynamicObjectCollection("relyitementry");
            for (DynamicObject relyItemRow : relyItemEntry) {
                DynamicObject relyItem = relyItemRow.getDynamicObject("relyitem");
                if (relyItem == null) continue;
                relyIdList.add(relyItem.getPkValue());
            }
        }
        if (!treeIdList.isEmpty()) {
            PacketDownLoadUtil.loopFindTree(treeIdList, treeList);
        }
        if (relyIdList.isEmpty()) {
            return;
        }
        PacketDownLoadUtil.loopFindRelyItemAndTree(relyIdList, itemList, treeList);
    }

    public static void writeConfig2Map(DynamicObjectCollection subDataPacketEntry, List<Map<String, Object>> subDataList) {
        HashMap<Long, String> configMap = new HashMap<Long, String>(subDataList.size());
        for (DynamicObject subDataPacket : subDataPacketEntry) {
            DynamicObject bizObject = (DynamicObject)subDataPacket.get("bizobject");
            StringBuilder itemName = new StringBuilder(bizObject.getString("name"));
            itemName.append('(');
            itemName.append(bizObject.getString("number"));
            itemName.append(')');
            configMap.put((Long)bizObject.getPkValue(), itemName.toString());
        }
        for (Map<String, Object> subdatapacketMap : subDataList) {
            String configitemName = (String)configMap.get(subdatapacketMap.get("bizobject_id"));
            subdatapacketMap.put("configitemname", configitemName);
        }
    }

    public static void writeToJson(DynamicObject packet, String filePath, Map<String, String> md5Map, boolean hasItem, boolean hasTree) {
        String fileName = "ricc_datapacket.json";
        Map objectMap = DynamicObjectUtil.object2Map((DynamicObject)packet);
        PacketDownLoadUtil.writeConfig2Map((DynamicObjectCollection)packet.get("subdatapacket"), (ArrayList)objectMap.get("subdatapacket"));
        DynamicObject versionObject = packet.getDynamicObject("packetversion");
        String versionNumber = null;
        if (versionObject != null) {
            versionNumber = versionObject.getString("number");
        }
        objectMap.put("packetversion_number", versionNumber);
        objectMap.putAll(md5Map);
        EnvRoleEnum role = EnvRoleEnum.fromVal((String)SysParaUtil.getenvRole());
        if (role == null) {
            throw new RiccBizException(ResManager.loadKDString((String)"\u83b7\u53d6\u73af\u5883\u89d2\u8272\u4e3a\u7a7a", (String)"DataPacketDownLoaderUtil_3", (String)"sys-ricc-platform", (Object[])new Object[0]));
        }
        String srcdatacenter = (String)objectMap.get("srcdatacenter");
        if (StringUtils.isEmpty((String)srcdatacenter)) {
            objectMap.put("srcdatacenter", role.getName() + "(" + RequestContext.get().getAccountId() + ") -> ");
        } else {
            objectMap.put("srcdatacenter", srcdatacenter + "->" + role.getName() + "(" + RequestContext.get().getAccountId() + ") -> ");
        }
        JSONObject configInfo = new JSONObject();
        if (hasItem) {
            PacketDownLoadUtil.setConfigInfo(filePath, "ricc_configitems.json", configInfo, "configItem");
        }
        if (hasTree) {
            PacketDownLoadUtil.setConfigInfo(filePath, "ricc_configtree.json", configInfo, "configTree");
        }
        objectMap.put("configInfo", configInfo);
        String fullFilePath = filePath + File.separator + fileName;
        try {
            FileUtils.writeMap2File((String)fullFilePath, (Map)objectMap);
        }
        catch (Exception e) {
            throw new RiccBizException(ResManager.loadKDString((String)"\u4f20\u8f93\u5305\u4fe1\u606f\u5199\u5165json\u6587\u4ef6\u5931\u8d25\u3002", (String)"DataPacketDownLoaderUtil_0", (String)"sys-ricc-platform", (Object[])new Object[0]), (Throwable)e);
        }
    }

    private static void setConfigInfo(String filePath, String fileName, JSONObject configInfo, String configKey) {
        File treeFile = new File(filePath, FilenameUtils.getName((String)fileName));
        String treeSignStr = Sha256Util.fileToSha256((File)treeFile);
        JSONObject config = new JSONObject();
        config.put("name", (Object)fileName);
        config.put("sign", (Object)treeSignStr);
        configInfo.put(configKey, (Object)config);
    }

    public static void writeSubPacketToFile(String filePath, DynamicObjectCollection subDataPackets, Map<String, String> signMap) {
        ArrayList<DynamicObject> invalidList = new ArrayList<DynamicObject>();
        for (int i = 0; i < subDataPackets.size(); ++i) {
            DynamicObject row = (DynamicObject)subDataPackets.get(i);
            String subFileName = (String)row.get("filename");
            int status = row.getInt("entrystatus");
            if (status == 1) {
                invalidList.add(row);
                continue;
            }
            DynamicObjectCollection fileDy = (DynamicObjectCollection)row.get("subdatapacketfile");
            if (Objects.isNull(fileDy) || fileDy.isEmpty()) {
                throw new RiccBizException(String.format(ResManager.loadKDString((String)"\u5b50\u4f20\u8f93\u5305\u7b2c%s\u884c\uff0c\u6587\u4ef6\u627e\u4e0d\u5230\uff01", (String)"DataPacketDownLoaderUtil_1", (String)"sys-ricc-platform", (Object[])new Object[0]), i + 1));
            }
            DynamicObject dataPackage = (DynamicObject)fileDy.get(0);
            DynamicObject fileBaseDataId = dataPackage.getDynamicObject("fbasedataid");
            String fileUrl = (String)fileBaseDataId.get("url");
            String realFileUrl = CommonUtil.checkUrl((String)fileUrl);
            File subZipFile = new File(filePath, FilenameUtils.getName((String)subFileName));
            try (ByteArrayOutputStream by = FileUtils.getFileOutputStream((String)realFileUrl);
                 FileOutputStream downloadFile = new FileOutputStream(subZipFile);){
                downloadFile.write(by.toByteArray());
            }
            catch (IOException e) {
                throw new RiccBizException(String.format(ResManager.loadKDString((String)"----\u5b50\u4f20\u8f93\u5305\u5199\u5165\u4e34\u65f6\u6587\u4ef6\u5939\u5931\u8d25---- %s", (String)"DataPacketDownLoaderUtil_2", (String)"sys-ricc-platform", (Object[])new Object[0]), e), (Throwable)e);
            }
            String signStr = Sha256Util.fileToSha256((File)subZipFile);
            signMap.put(subFileName, signStr);
        }
        subDataPackets.removeAll(invalidList);
    }

    public static void writeItemsAndTreeToFile(String filePath, List<DynamicObject> itemList, List<DynamicObject> treeList) {
        if (!itemList.isEmpty()) {
            PacketDownLoadUtil.writeCarryDataToFile(itemList, "ricc_configitems.json", filePath);
        }
        if (!treeList.isEmpty()) {
            PacketDownLoadUtil.writeCarryDataToFile(treeList, "ricc_configtree.json", filePath);
        }
    }

    private static void writeCarryDataToFile(List<DynamicObject> dataList, String fileName, String filePath) {
        JsonDataPacketImpl jsonDataPacket = new JsonDataPacketImpl();
        Map<String, Object> treeDataMap = jsonDataPacket.getDataMap(dataList.toArray(new DynamicObject[0]), null, 0, 0);
        String fullFilePath = filePath + File.separator + fileName;
        FileUtils.writeMap2File((String)fullFilePath, treeDataMap);
    }
}

