/*
 * Decompiled with CFR 0.152.
 */
package kd.sys.ricc.business.datapacket.upload;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONException;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.TempFileCache;
import kd.bos.cache.tempfile.TempFileCacheDownloadable;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.MulBasedataDynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.fileservice.FileItem;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.ORM;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.attachment.AttachmentFieldServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.zip.io.inputstream.ZipInputStream;
import kd.bos.zip.model.LocalFileHeader;
import kd.sys.ricc.business.datapacket.core.impl.json.JsonDataPacketImpl;
import kd.sys.ricc.business.datapacket.core.model.SdpOutputParams;
import kd.sys.ricc.business.datapacket.upload.DataPackageUploadUtil;
import kd.sys.ricc.business.datapacket.upload.PackageUploadValidator;
import kd.sys.ricc.common.enums.PacketDataSourceTypeEnum;
import kd.sys.ricc.common.enums.PacketEntryStatusEnum;
import kd.sys.ricc.common.enums.PacketLockEnum;
import kd.sys.ricc.common.util.CommonUtil;
import kd.sys.ricc.common.util.FileUtils;
import kd.sys.ricc.common.util.StringUtils;
import kd.sys.ricc.common.util.SysParaUtil;
import kd.sys.ricc.common.util.TimeCostUtil;
import kd.sys.ricc.exception.RiccBizException;

public class DataPackageUploader {
    private static final Log logger = LogFactory.getLog(DataPackageUploader.class);
    private static final String CONFIG_KEY = "configKey";
    private final String storagePath = SysParaUtil.getSavePath();
    private final HashMap<String, Object> uploadResult = new HashMap(2);
    private final StringBuilder msg = new StringBuilder();
    private boolean success = true;
    private String url;
    private JSONObject dataPacketJson;
    private String configItemJson;
    private String configTreeJson;
    private Map<String, Integer> nameSizeMap;
    private String packageName;
    private ZipInputStream zipInputStream;
    private final Map<String, Map<String, String>> nameTempFileInfoMap = new HashMap<String, Map<String, String>>();
    private Date startTime;
    private PacketDataSourceTypeEnum packetDataSourceTypeEnum;
    private long packetId;
    private static final String LOCKED_STATUS = "lockedstatus";
    private static final String DATASOURCE = "datasource";

    public long getPacketId() {
        return this.packetId;
    }

    public void setDatasourceType(PacketDataSourceTypeEnum packetDataSourceTypeEnum) {
        this.packetDataSourceTypeEnum = packetDataSourceTypeEnum;
    }

    public DataPackageUploader(String url) {
        this.url = url;
        this.init();
    }

    public DataPackageUploader(ZipInputStream zipInputStream) {
        this.zipInputStream = zipInputStream;
        this.init();
    }

    private void init() {
        this.startTime = new Date();
        logger.info("\u5f00\u59cb\u89e3\u6790\u5305\u6587\u4ef6\uff0curl\uff1a" + this.url);
        try {
            this.getZipFileFromUrl();
            this.getJsonFromFile();
        }
        catch (RiccBizException e) {
            logger.info("\u89e3\u6790\u5305\u6587\u4ef6\u65f6\u53d1\u751f\u5f02\u5e38\u3002", (Object)e);
            String errorMessage = ResManager.loadKDString((String)"\u89e3\u6790\u5305\u6587\u4ef6\u65f6\u53d1\u751f\u5f02\u5e38\uff1a", (String)"DataPackageUploader_0", (String)"sys-ricc-platform", (Object[])new Object[0]);
            if (StringUtils.isNotBlank((CharSequence)this.url)) {
                this.msg.append(errorMessage).append(e.getMessage()).append("url:").append(this.url);
            } else {
                this.msg.append(errorMessage).append(e.getMessage());
            }
            this.setFailure();
        }
        catch (Exception e) {
            logger.info("\u89e3\u6790\u5305\u6587\u4ef6\u65f6\u53d1\u751f\u672a\u77e5\u5f02\u5e38\u3002", (Object)e);
            this.setFailure();
            this.msg.append(ResManager.loadKDString((String)"\u89e3\u6790\u5305\u6587\u4ef6\u65f6\u53d1\u751f\u672a\u77e5\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u670d\u52a1\u7aef\u65e5\u5fd7\u83b7\u53d6\u8be6\u60c5\uff1a", (String)"DataPackageUploader_1", (String)"sys-ricc-platform", (Object[])new Object[0])).append(e.getMessage());
        }
    }

    public boolean isSuccess() {
        return this.success;
    }

    public void setFailure() {
        boolean isupload;
        this.success = false;
        if (this.zipInputStream != null) {
            try {
                this.zipInputStream.close();
            }
            catch (IOException e) {
                logger.error("\u4e0a\u4f20\u5173\u6d41\u5931\u8d25setfail\u3002", (Throwable)e);
            }
        }
        if (!this.uploadResult.isEmpty() && (isupload = ((Boolean)this.uploadResult.get("isupload")).booleanValue())) {
            FileService fs = FileServiceFactory.getAttachmentFileService();
            Map nameUrlMap = (Map)this.uploadResult.get("urls");
            nameUrlMap.values().forEach(arg_0 -> ((FileService)fs).delete(arg_0));
        }
        this.removeSubPacketTempFiles();
    }

    public String getMsg() {
        return this.msg.toString();
    }

    public void doUpload() {
        logger.info("\u5f00\u59cb\u6267\u884c\u4e0a\u4f20\uff0c\u6587\u4ef6\u6570\uff1a" + this.nameTempFileInfoMap.size());
        if (!this.isSuccess()) {
            this.recordLog();
            return;
        }
        try {
            this.synCarryData();
            this.afterSynCarryValidate();
            this.dealUpload();
        }
        catch (RiccBizException e) {
            logger.error("\u4e0a\u4f20\u65f6\u51fa\u73b0\u5f02\u5e38\u3002", (Throwable)e);
            this.msg.append(ResManager.loadKDString((String)"\u4e0a\u4f20\u65f6\u51fa\u73b0\u5f02\u5e38\uff0c", (String)"DataPackageUploader_2", (String)"sys-ricc-platform", (Object[])new Object[0])).append(e.getMessage());
            this.setFailure();
        }
        catch (Exception e) {
            logger.error("\u4e0a\u4f20\u903b\u8f91\u51fa\u73b0\u4ee3\u7801\u672a\u68c0\u67e5\u5f02\u5e38\u3002", (Throwable)e);
            this.msg.append(ResManager.loadKDString((String)"\u4e0a\u4f20\u903b\u8f91\u51fa\u73b0\u5f02\u5e38\uff0c\u8bf7\u68c0\u67e5\u670d\u52a1\u7aef\u65e5\u5fd7\u83b7\u53d6\u8be6\u60c5\uff1a", (String)"DataPackageUploader_3", (String)"sys-ricc-platform", (Object[])new Object[0])).append(CommonUtil.getExceptionDetailInfo((Throwable)e));
            this.setFailure();
        }
        finally {
            this.recordLog();
            this.removeSubPacketTempFiles();
        }
    }

    private void synCarryData() {
        if (StringUtils.isNotEmpty((String)this.configTreeJson)) {
            logger.info("\u57fa\u7840\u914d\u7f6e\u5de6\u6811\u643a\u5e26\u6570\u636e: {}", (Object)this.configTreeJson);
            LinkedHashMap configTreeMap = (LinkedHashMap)JSON.parseObject((String)this.configTreeJson, (TypeReference)new TypeReference<LinkedHashMap<String, Map<String, Object>>>(){}, (Feature[])new Feature[]{Feature.OrderedField});
            for (Map.Entry entry : configTreeMap.entrySet()) {
                JSONObject oneTree = new JSONObject();
                oneTree.put((String)entry.getKey(), entry.getValue());
                SdpOutputParams treeSynResult = this.executeImport(oneTree, "ricc_configtree");
                boolean treeSuccess = treeSynResult.getError().length() <= 0;
                if (treeSuccess) continue;
                logger.error(treeSynResult.getError() + treeSynResult.getDevErrorStr());
                String message = ResManager.loadKDString((String)"\u643a\u5e26\u5de6\u6811\u6570\u636e\u540c\u6b65\u5f02\u5e38: ", (String)"DataPackageUploader_15", (String)"sys-ricc-platform", (Object[])new Object[0]);
                throw new RiccBizException(message + treeSynResult.getError());
            }
        }
        if (StringUtils.isNotEmpty((String)this.configItemJson)) {
            boolean secSuccess;
            logger.info("\u57fa\u7840\u914d\u7f6e\u9879\u643a\u5e26\u6570\u636e: {}", (Object)this.configItemJson);
            JSONObject configItemMap = (JSONObject)JSON.parse((String)this.configItemJson);
            JSONObject copyConfigItem = this.deepCopyJsonObject(configItemMap);
            for (Map.Entry stringObjectEntry : configItemMap.entrySet()) {
                if (!(stringObjectEntry.getValue() instanceof JSONObject)) continue;
                JSONObject value = (JSONObject)stringObjectEntry.getValue();
                value.remove((Object)"relyitementry");
                JSONObject dataMap = (JSONObject)value.get((Object)"data");
                dataMap.remove((Object)"relyitementry");
            }
            SdpOutputParams sdpOutputParams = this.executeImport(configItemMap, "ricc_configitems");
            boolean itemFirstSuccess = sdpOutputParams.getError().length() <= 0;
            String message = ResManager.loadKDString((String)"\u643a\u5e26\u914d\u7f6e\u6570\u636e\u540c\u6b65\u5f02\u5e38:", (String)"DataPackageUploader_16", (String)"sys-ricc-platform", (Object[])new Object[0]);
            if (!itemFirstSuccess) {
                logger.error(sdpOutputParams.getError() + sdpOutputParams.getDevErrorStr());
                throw new RiccBizException(message + sdpOutputParams.getError());
            }
            SdpOutputParams itemSecSynResult = this.executeImport(copyConfigItem, "ricc_configitems");
            boolean bl = secSuccess = itemSecSynResult.getError().length() <= 0;
            if (!secSuccess) {
                logger.error(itemSecSynResult.getError() + itemSecSynResult.getDevErrorStr());
                throw new RiccBizException(message + itemSecSynResult.getError());
            }
        }
    }

    private JSONObject deepCopyJsonObject(JSONObject originalObject) {
        JSONObject copiedObject = new JSONObject();
        originalObject.keySet().forEach(key -> {
            Object value = originalObject.get(key);
            if (value instanceof JSONObject) {
                copiedObject.put(key, (Object)this.deepCopyJsonObject((JSONObject)value));
            } else {
                copiedObject.put(key, value);
            }
        });
        return copiedObject;
    }

    private SdpOutputParams executeImport(JSONObject json, String entityType) {
        JsonDataPacketImpl impl = new JsonDataPacketImpl();
        SdpOutputParams outputParams = new SdpOutputParams();
        impl.synOnBatchResumeMode(outputParams, json, entityType, json.keySet(), "id", JsonDataPacketImpl.BatchSaveType.AUTO);
        return outputParams;
    }

    private void dealUpload() throws IOException {
        String number = this.dataPacketJson.getString("number");
        QFilter[] packetFilter = new QFilter[]{new QFilter("number", "=", (Object)number)};
        boolean isExist = QueryServiceHelper.exists((String)"ricc_datapacket", (QFilter[])packetFilter);
        if (!isExist) {
            this.uploadSubPackage();
            this.createDataPackageObject();
        } else {
            DynamicObject curPkg = BusinessDataServiceHelper.loadSingleFromCache((String)"ricc_datapacket", (QFilter[])packetFilter);
            this.packetId = (Long)curPkg.getPkValue();
            this.updateBillHead(curPkg);
            String jsonStatus = this.dataPacketJson.getString("status");
            if (!"A".equals(jsonStatus)) {
                curPkg.set("status", (Object)jsonStatus);
            }
            this.addPackageEntry(curPkg);
        }
    }

    private void addPackageEntry(DynamicObject pkg) throws IOException {
        DynamicObjectCollection pkgEntrys = pkg.getDynamicObjectCollection("subdatapacket");
        JSONArray jsonEntrys = this.dataPacketJson.getJSONArray("subdatapacket");
        for (DynamicObject pkgEntry : pkgEntrys) {
            String pkgEntryFileName = pkgEntry.getString("filename");
            for (int j = 0; j < jsonEntrys.size(); ++j) {
                String jsonEntryFileName = jsonEntrys.getJSONObject(j).getString("filename");
                if (!pkgEntryFileName.equals(jsonEntryFileName)) continue;
                Map<String, String> tempFileInfo = this.nameTempFileInfoMap.remove(jsonEntryFileName);
                this.removeTempFile(tempFileInfo);
                jsonEntrys.remove(j);
            }
        }
        if (!this.nameTempFileInfoMap.isEmpty()) {
            this.uploadSubPackage();
            Map<String, String> filenameAttId = this.saveAttachInfo(pkg.getPkValue().toString(), jsonEntrys);
            this.createBillEntry(pkgEntrys, jsonEntrys, filenameAttId);
            pkg.set("subpacketcount", (Object)pkgEntrys.size());
            String pkgSyncState = pkg.getString("syncstate");
            if (!StringUtils.equals((String)pkgSyncState, (String)"0")) {
                pkg.set("syncstate", (Object)"3");
            }
        }
        this.savePacket(pkg);
    }

    private void validate() {
        PackageUploadValidator uploadValidator = new PackageUploadValidator();
        if (!uploadValidator.validate(this.nameTempFileInfoMap, this.configTreeJson, this.configItemJson, this.dataPacketJson)) {
            throw new RiccBizException(uploadValidator.errorMessage.toString());
        }
    }

    private void afterSynCarryValidate() {
        PackageUploadValidator uploadValidator = new PackageUploadValidator();
        if (!uploadValidator.jsonItemExistCheck(this.dataPacketJson)) {
            throw new RiccBizException(uploadValidator.errorMessage.toString());
        }
    }

    private void getZipFileFromUrl() throws MalformedURLException {
        if (StringUtils.isEmpty((String)this.url)) {
            return;
        }
        RiccBizException bizException = null;
        TempFileCacheDownloadable downLoad = (TempFileCacheDownloadable)CacheFactory.getCommonCacheFactory().getTempFileCache();
        String[] queryParams = new URL(this.url).getQuery().split("&");
        HashMap<String, String> downloadFileParams = new HashMap<String, String>(queryParams.length);
        for (String queryParam : queryParams) {
            String[] p = queryParam.split("=");
            downloadFileParams.put(p[0], p[1]);
        }
        try {
            TempFileCacheDownloadable.Content content = downLoad.get((String)downloadFileParams.get(CONFIG_KEY), (String)downloadFileParams.get("id"));
            InputStream in = content.getInputStream();
            String packetSecret = SysParaUtil.getPacketSecret();
            this.zipInputStream = StringUtils.isNotBlank((CharSequence)packetSecret) ? new ZipInputStream(in, packetSecret.toCharArray(), Charset.forName("GBK")) : new ZipInputStream(in, Charset.forName("GBK"));
        }
        catch (Exception e) {
            logger.error("\u4f20\u8f93\u5305\u4ece\u4e34\u65f6\u6587\u4ef6\u4e0a\u4f20\u51fa\u73b0\u5f02\u5e38", (Throwable)e);
            String msgTpl = ResManager.loadKDString((String)"\u4f20\u8f93\u5305\u4eceredis\u7f13\u5b58 %s\u4e2d\u4e0b\u8f7d\u5931\u8d25\uff0c\u65e0\u6cd5\u5bfc\u5165\uff01", (String)"DataPackageUploader_6", (String)"sys-ricc-platform", (Object[])new Object[0]);
            bizException = new RiccBizException(String.format(msgTpl, this.url), (Throwable)e);
        }
        if (bizException != null) {
            throw bizException;
        }
    }

    private void uploadSubPackage() throws IOException {
        FileService fs = FileServiceFactory.getAttachmentFileService();
        TempFileCacheDownloadable downLoad = (TempFileCacheDownloadable)CacheFactory.getCommonCacheFactory().getTempFileCache();
        String uploadPath = this.storagePath + this.packageName + File.separator;
        boolean upload = true;
        HashMap<String, Integer> uploadNameSizeMap = new HashMap<String, Integer>(this.nameTempFileInfoMap.size());
        HashMap<String, String> nameUrlMap = new HashMap<String, String>(this.nameTempFileInfoMap.size());
        for (Map.Entry<String, Map<String, String>> entry : this.nameTempFileInfoMap.entrySet()) {
            String fileName = entry.getKey();
            String fileFullPath = uploadPath + fileName;
            Map<String, String> tempFileInfo = entry.getValue();
            TempFileCacheDownloadable.Content content = downLoad.get(tempFileInfo.get(CONFIG_KEY), tempFileInfo.get("id"));
            InputStream inputStream = content.getInputStream();
            Throwable throwable = null;
            try {
                uploadNameSizeMap.put(fileName, inputStream.available());
                FileItem fileItem = new FileItem(fileName, fileFullPath, inputStream);
                String realUrl = DataPackageUploadUtil.uploadToFileService(fs, fileItem);
                nameUrlMap.put(fileName, realUrl);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (inputStream == null) continue;
                if (throwable != null) {
                    try {
                        inputStream.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                inputStream.close();
            }
        }
        this.uploadResult.put("isupload", upload);
        this.uploadResult.put("urls", nameUrlMap);
        this.nameSizeMap = uploadNameSizeMap;
    }

    private void createDataPackageObject() {
        DynamicObject newPkg = ORM.create().newDynamicObject("ricc_datapacket");
        this.createBillHead(this.dataPacketJson, newPkg);
        DynamicObjectCollection dCollection = newPkg.getDynamicObjectCollection("subdatapacket");
        JSONArray jsonEntrys = this.dataPacketJson.getJSONArray("subdatapacket");
        Map<String, String> filenameAttId = this.saveAttachInfo(newPkg.getPkValue().toString(), jsonEntrys);
        this.createBillEntry(dCollection, jsonEntrys, filenameAttId);
        newPkg.set("subpacketcount", (Object)dCollection.size());
        this.packetId = (Long)this.savePacket(newPkg);
    }

    private Object savePacket(DynamicObject pkg) {
        OperateOption option = OperateOption.create();
        option.setVariableValue("importtag_of_datasource", "true");
        OperationResult result = SaveServiceHelper.saveOperate((String)"ricc_datapacket", (DynamicObject[])new DynamicObject[]{pkg}, (OperateOption)option);
        if (!result.isSuccess()) {
            StringBuilder opErr = new StringBuilder();
            opErr.append(result.getMessage());
            result.getAllErrorOrValidateInfo().forEach(validateInfo -> opErr.append(validateInfo.getMessage()));
            String msgTpl = ResManager.loadKDString((String)"\u4fdd\u5b58\u4e0a\u4f20\u4f20\u8f93\u5305\u65f6\u5931\u8d25\uff1a%s", (String)"DataPackageUploader_7", (String)"sys-ricc-platform", (Object[])new Object[0]);
            throw new RiccBizException(String.format(msgTpl, opErr));
        }
        return result.getSuccessPkIds().get(0);
    }

    private void createBillEntry(DynamicObjectCollection dCollection, JSONArray jsonEntrys, Map<String, String> filenameAttId) {
        ArrayList<DynamicObject> entryList = new ArrayList<DynamicObject>();
        for (Object jsonEntry : jsonEntrys) {
            JSONObject value = (JSONObject)jsonEntry;
            int index = Integer.parseInt(value.getString("seq"));
            DynamicObject entry = new DynamicObject(dCollection.getDynamicObjectType());
            entry.set("seq", (Object)index);
            entry.set("entrycreatetime", (Object)value.getDate("entrycreatetime"));
            entry.set("entryupdatetime", (Object)System.currentTimeMillis());
            entry.set("subpackettype", (Object)value.getString("subpackettype"));
            entry.set("bizobject_id", (Object)value.getString("bizobject"));
            entry.set("entrysyncstate", (Object)"0");
            entry.set("entrystatus", (Object)PacketEntryStatusEnum.NORMAL.getVal());
            entry.set("custparam", (Object)value.getString("custparam"));
            entry.set("custparam_tag", (Object)value.getString("custparam_tag"));
            entry.set("packetdata", (Object)value.getString("packetdata"));
            entry.set("packetdata_tag", (Object)value.getString("packetdata_tag"));
            entry.set("relylevel", (Object)value.getIntValue("relylevel"));
            entry.set("packetnum", value.get((Object)"packetnum"));
            String filename = value.getString("filename");
            MulBasedataDynamicObjectCollection fileList = CommonUtil.createAttachmentField((DynamicObjectType)entry.getDynamicObjectCollection("subdatapacketfile").getDynamicObjectType(), (long)Long.parseLong(filenameAttId.get(filename)));
            entry.set("filename", (Object)filename);
            entry.set("subdatapacketfile", (Object)fileList);
            entryList.add(entry);
        }
        dCollection.addAll(entryList);
    }

    private void createBillHead(JSONObject fileJson, DynamicObject newPkg) {
        newPkg.set("name", (Object)fileJson.getJSONObject("name"));
        Object id = fileJson.get((Object)"id");
        if (!(id instanceof Long)) {
            id = DB.genLongId((String)"ricc_datapacket");
        }
        newPkg.set("id", id);
        newPkg.set("status", (Object)fileJson.getString("status"));
        newPkg.set("creator", (Object)RequestContext.get().getCurrUserId());
        newPkg.set("createtime", (Object)System.currentTimeMillis());
        newPkg.set("dltrcount", (Object)0);
        newPkg.set("enable", (Object)"1");
        newPkg.set("srcdatacenter", (Object)fileJson.getString("srcdatacenter"));
        newPkg.set("number", (Object)fileJson.getString("number"));
        newPkg.set("syncstate", (Object)"0");
        newPkg.set("packettype", (Object)fileJson.getString("packettype"));
        newPkg.set("packetversion_id", (Object)this.queryVersionIdByNumber(fileJson.getString("packetversion_number")));
        newPkg.set("remarks", (Object)fileJson.getString("remarks"));
        newPkg.set(LOCKED_STATUS, (Object)PacketLockEnum.NOT_LOCKED.getVal());
        newPkg.set(DATASOURCE, (Object)this.packetDataSourceTypeEnum.getVal());
        QFilter filter = new QFilter("enable", "=", (Object)"1").and("status", "=", (Object)"C");
        DynamicObjectCollection dests = QueryServiceHelper.query((String)"ricc_destaccount", (String)"id, number", (QFilter[])filter.toArray());
        StringBuilder sb = new StringBuilder();
        for (DynamicObject dyo : dests) {
            sb.append(dyo.get("number")).append(" | ");
        }
        if (sb.length() > 3) {
            newPkg.set("destdatacenter", (Object)sb.substring(0, sb.length() - 3));
        }
        newPkg.set("synmode", (Object)"ResumeOnError");
    }

    private void updateBillHead(DynamicObject pkg) {
        pkg.set("name", (Object)this.dataPacketJson.getJSONObject("name"));
        pkg.set("packetversion_id", (Object)this.queryVersionIdByNumber(this.dataPacketJson.getString("packetversion_number")));
        pkg.set("packettype", (Object)this.dataPacketJson.getString("packettype"));
        pkg.set("remarks", (Object)this.dataPacketJson.getString("remarks"));
        pkg.set(DATASOURCE, (Object)this.packetDataSourceTypeEnum.getVal());
    }

    private Map<String, String> saveAttachInfo(Object pkgId, JSONArray jsonEntrys) {
        ArrayList<Map> attachments = new ArrayList<Map>();
        Map nameUrlMap = (Map)this.uploadResult.get("urls");
        for (Object jsonEntry : jsonEntrys) {
            JSONObject value = (JSONObject)jsonEntry;
            String fileName = value.getString("filename");
            String realUrl = (String)nameUrlMap.get(fileName);
            if (StringUtils.isEmpty((String)realUrl)) {
                String errTpl = ResManager.loadKDString((String)"\u901a\u8fc7\u6587\u4ef6\u540d\u201c%1$s\u201d\u83b7\u53d6\u4e0a\u4f20\u6587\u4ef6\u5730\u5740\u5931\u8d25\uff0c\u53ef\u80fd\u662f\u4f20\u8f93\u5305\u5185\u5bb9\u5df2\u88ab\u7be1\u6539\uff0c\u8bf7\u91cd\u65b0\u5230\u914d\u7f6e\u73af\u5883\u4e0b\u8f7d\u4f20\u8f93\u5305\u4e0a\u4f20", (String)"DataPackageUploader_14", (String)"sys-ricc-platform", (Object[])new Object[0]);
                String error = String.format(errTpl, fileName);
                throw new RiccBizException(error);
            }
            String type = fileName.substring(fileName.lastIndexOf(46) + 1);
            Map uploadFileMap = CommonUtil.createUploadFileMap((String)"ricc_datapacket", (Object)pkgId, (String)"subdatapacketfile", (String)realUrl, (String)fileName, (long)this.nameSizeMap.get(fileName).intValue(), (String)type);
            attachments.add(uploadFileMap);
        }
        List attList = AttachmentFieldServiceHelper.saveAttachments((String)"ricc_datapacket", (String)"", attachments);
        return DataPackageUploadUtil.attListToNameIdMap(attList);
    }

    private void getJsonFromFile() {
        JSONObject fileJsonObj;
        if (this.zipInputStream == null) {
            throw new RiccBizException(ResManager.loadKDString((String)"\u5728\u7ebf\u4f20\u8f93\u670d\u52a1\u7aef\u63a5\u6536\u5230\u7684\u538b\u7f29\u6587\u4ef6\u4e3a\u7a7a\uff0c\u8bf7\u91cd\u65b0\u4e0a\u4f20\u8bd5\u8bd5", (String)"DataPackageUploader_8", (String)"sys-ricc-platform", (Object[])new Object[0]));
        }
        String jsonStr = "";
        TempFileCache tempFileCache = CacheFactory.getCommonCacheFactory().getTempFileCache();
        try {
            LocalFileHeader entry;
            while ((entry = this.zipInputStream.getNextEntry()) != null) {
                String entryName = entry.getFileName();
                byte[] fileBytes = FileUtils.inputStreamToByte((InputStream)this.zipInputStream);
                if ("ricc_datapacket.json".equals(entryName)) {
                    jsonStr = new String(fileBytes, StandardCharsets.UTF_8);
                    continue;
                }
                if (StringUtils.equals((String)"ricc_configitems.json", (String)entryName)) {
                    this.configItemJson = new String(fileBytes, StandardCharsets.UTF_8);
                    continue;
                }
                if (StringUtils.equals((String)"ricc_configtree.json", (String)entryName)) {
                    this.configTreeJson = new String(fileBytes, StandardCharsets.UTF_8);
                    continue;
                }
                Map tempFileInfo = tempFileCache.save(entryName, fileBytes, 18000);
                this.nameTempFileInfoMap.put(entryName, tempFileInfo);
            }
            if (StringUtils.isEmpty((String)jsonStr)) {
                throw new RiccBizException(ResManager.loadKDString((String)"\u5305\u6587\u4ef6\u4e2d\u83b7\u53d6\u4e0d\u5230\u5b50\u5305\u914d\u7f6e\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5\u5904\u7406\u540e\u4e0a\u4f20", (String)"DataPackageUploader_9", (String)"sys-ricc-platform", (Object[])new Object[0]));
            }
        }
        catch (Exception e) {
            String message = e.getMessage();
            String errorTips = String.format(ResManager.loadKDString((String)"\u89e3\u538b\u5904\u7406\u5f02\u5e38 %s", (String)"DataPackageUploader_10", (String)"sys-ricc-platform", (Object[])new Object[0]), e.getMessage());
            if (message.contains("Wrong Password") || message.contains("empty or null password")) {
                errorTips = ResManager.loadKDString((String)"\u89e3\u538b\u5904\u7406\u5f02\u5e38\uff0c\u4f20\u8f93\u5305\u52a0\u5bc6\u5bc6\u94a5\u4e0d\u6b63\u786e\uff0c\u8bf7\u786e\u4fdd\u914d\u7f6e\u73af\u5883\u548c\u76ee\u6807\u73af\u5883\u7684\u4f20\u8f93\u5305\u52a0\u5bc6\u5bc6\u94a5\u4e00\u81f4", (String)"DataPackageUploader_17", (String)"sys-ricc-platform", (Object[])new Object[0]);
            }
            throw new RiccBizException(errorTips, (Throwable)e);
        }
        try {
            fileJsonObj = (JSONObject)JSON.parse((String)jsonStr);
        }
        catch (JSONException e) {
            String msgTpl = ResManager.loadKDString((String)"Json\u683c\u5f0f\u5316\u5f02\u5e38\uff1a%1$s%n \u9519\u8bef\u539f\u56e0:", (String)"DataPackageUploader_11", (String)"sys-ricc-platform", (Object[])new Object[0]);
            throw new RiccBizException(String.format(msgTpl, jsonStr), (Throwable)e);
        }
        this.dataPacketJson = fileJsonObj;
        if (!fileJsonObj.containsKey((Object)"number")) {
            throw new RiccBizException(ResManager.loadKDString((String)"\u4f20\u8f93\u5305\u914d\u7f6e\u6587\u4ef6\u4e2d\u672a\u83b7\u53d6\u5230\u7f16\u7801number\uff0c\u65e0\u6cd5\u4e0a\u4f20", (String)"DataPackageUploader_12", (String)"sys-ricc-platform", (Object[])new Object[0]));
        }
        this.packageName = fileJsonObj.getString("number");
    }

    private long queryVersionIdByNumber(String number) {
        QFilter qFilter;
        DynamicObject versionObject;
        long versionId = 0L;
        if (StringUtils.isNotEmpty((String)number) && (versionObject = QueryServiceHelper.queryOne((String)"ricc_version", (String)"id", (QFilter[])(qFilter = new QFilter("number", "=", (Object)number)).toArray())) != null) {
            versionId = versionObject.getLong("id");
        }
        return versionId;
    }

    private void recordLog() {
        String message;
        DynamicObject log = BusinessDataServiceHelper.newDynamicObject((String)"ricc_log");
        log.set("id", (Object)DB.genLongId((String)"ricc_log"));
        String logNumber = CodeRuleServiceHelper.getNumber((String)"ricc_log", (DynamicObject)log, null);
        log.set("billno", (Object)logNumber);
        log.set("packet", (Object)this.packetId);
        log.set("opuser", (Object)UserServiceHelper.getCurrentUserId());
        log.set("optime", (Object)this.startTime);
        long opEndTime = System.currentTimeMillis();
        log.set("opendtime", (Object)opEndTime);
        String timeCost = TimeCostUtil.getUsedTime((long)this.startTime.getTime(), (long)opEndTime);
        log.set("usetime", (Object)timeCost);
        log.set("optype", (Object)"6");
        if (this.isSuccess()) {
            message = ResManager.loadKDString((String)"\u4e0a\u4f20\u6210\u529f\u3002", (String)"DataPackageUploader_13", (String)"sys-ricc-platform", (Object[])new Object[0]);
            log.set("state", (Object)"1");
            log.set("successcount", (Object)1);
            log.set("failedcount", (Object)0);
        } else {
            message = this.msg.toString();
            log.set("state", (Object)"2");
            log.set("successcount", (Object)0);
            log.set("failedcount", (Object)1);
        }
        log.set("message", (Object)(message.length() > 255 ? message.substring(0, 200) + "..." : message));
        log.set("message_tag", (Object)message);
        log.set("traceid", (Object)RequestContext.get().getTraceId());
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{log});
    }

    private void removeSubPacketTempFiles() {
        if (this.nameTempFileInfoMap.isEmpty()) {
            return;
        }
        for (Map.Entry<String, Map<String, String>> nameTempFileInfo : this.nameTempFileInfoMap.entrySet()) {
            Map<String, String> tempFileInfo = nameTempFileInfo.getValue();
            this.removeTempFile(tempFileInfo);
        }
    }

    private void removeTempFile(Map<String, String> tempFileInfo) {
        TempFileCache tempFileCache = CacheFactory.getCommonCacheFactory().getTempFileCache();
        String tempUrl = DataPackageUploader.getTempUrl(tempFileInfo);
        tempFileCache.remove(tempUrl);
    }

    private static String getTempUrl(Map<String, String> tempFileInfo) {
        return String.format("tempfile/download.do?configKey=%s&id=%s", tempFileInfo.get(CONFIG_KEY), tempFileInfo.get("id"));
    }
}

