/*
 * Decompiled with CFR 0.152.
 */
package kd.sys.ricc.business.datapacket.upload;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.cache.CacheFactory;
import kd.bos.cache.tempfile.TempFileCacheDownloadable;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.sys.ricc.common.enums.PacketDataSourceTypeEnum;
import kd.sys.ricc.common.util.MD5Util;
import kd.sys.ricc.common.util.Sha256Util;
import kd.sys.ricc.common.util.SysParaUtil;

public class PackageUploadValidator {
    public StringBuilder errorMessage = new StringBuilder(ResManager.loadKDString((String)"\u6821\u9a8c\u5931\u8d25\uff0c", (String)"PackageUploadValidator_0", (String)"sys-ricc-platform", (Object[])new Object[0]));

    public boolean validate(Map<String, Map<String, String>> nameByteMap, String configTreeJson, String configItemJson, JSONObject json) {
        boolean jsonFormatCheck = this.jsonContainNumberCheck(json);
        boolean subFileCheck = this.subFileCheck(nameByteMap, json);
        boolean carryTreeCheck = this.carryDataCheck(configTreeJson, json, "configTree");
        boolean carryItemCheck = this.carryDataCheck(configItemJson, json, "configItem");
        boolean isAllowUpload = this.packetUploadCheck(json);
        boolean isExistsPacket = this.isExistsPacket(json);
        return jsonFormatCheck && carryTreeCheck && carryItemCheck && subFileCheck && isAllowUpload && isExistsPacket;
    }

    public boolean packetUploadCheck(JSONObject json) {
        if (!SysParaUtil.canUploadPacket()) {
            this.errorMessage.append(ResManager.loadKDString((String)"\u5f53\u524d\u73af\u5883\u4e0d\u652f\u6301\u4e0a\u4f20\u4f20\u8f93\u5305\uff0c\u5982\u9700\u652f\u6301\uff0c\u8bf7\u5148\u5230\u5b9e\u65bd\u914d\u7f6e\u4e2d\u5fc3\u3010\u57fa\u7840\u8bbe\u7f6e\u3011->\u3010\u53c2\u6570\u8bbe\u7f6e\u3011\u8fdb\u884c\u914d\u7f6e\u3002", (String)"PackageUploadValidator_1", (String)"sys-ricc-platform", (Object[])new Object[0]));
            return false;
        }
        String jsonStatus = json.getString("status");
        if (!SysParaUtil.isAllowUploadWithPacketStatus((String)jsonStatus)) {
            this.errorMessage.append(ResManager.loadKDString((String)"\u5f53\u524d\u73af\u5883\u53ea\u80fd\u4e0a\u4f20\u5ba1\u6838\u72b6\u6001\u7684\u4f20\u8f93\u5305\u3002\u5982\u9700\u652f\u6301\u5176\u5b83\u72b6\u6001\u4f20\u8f93\u5305\u4e0a\u4f20\uff0c\u8bf7\u5148\u5230\u5b9e\u65bd\u914d\u7f6e\u4e2d\u5fc3\u3010\u57fa\u7840\u8bbe\u7f6e\u3011->\u3010\u53c2\u6570\u8bbe\u7f6e\u3011\u8fdb\u884c\u914d\u7f6e\u3002", (String)"PackageUploadValidator_2", (String)"sys-ricc-platform", (Object[])new Object[0]));
            return false;
        }
        String number = json.getString("number");
        QFilter[] qFilters = new QFilter[]{new QFilter("number", "=", (Object)number), new QFilter("status", "=", (Object)"C")};
        boolean isExistAuditPacket = QueryServiceHelper.exists((String)"ricc_datapacket", (QFilter[])qFilters);
        if (isExistAuditPacket) {
            String msg = ResManager.loadKDString((String)"\u76ee\u6807\u73af\u5883\u5df2\u7ecf\u5b58\u5728\u5df2\u5ba1\u6838\u7684\u76f8\u540c\u7f16\u7801\u7684\u4f20\u8f93\u5305\uff0c\u4e0d\u5141\u8bb8\u4fee\u6539\u3002", (String)"PackageUploadValidator_3", (String)"sys-ricc-platform", (Object[])new Object[0]);
            this.errorMessage.append(msg);
            return false;
        }
        return true;
    }

    public boolean isExistsPacket(JSONObject json) {
        long dataPacketId = json.getLong("id");
        QFilter qFilter = new QFilter("id", "=", (Object)dataPacketId);
        DynamicObject dataPacket = QueryServiceHelper.queryOne((String)"ricc_datapacket", (String)"datasource", (QFilter[])qFilter.toArray());
        if (dataPacket != null) {
            String dataSource = dataPacket.getString("datasource");
            if (StringUtils.equals((CharSequence)PacketDataSourceTypeEnum.DATASOURCE_NEW.getVal(), (CharSequence)dataSource)) {
                String message = ResManager.loadKDString((String)"\u7981\u6b62\u624b\u5de5\u65b0\u589e\u7684\u4f20\u8f93\u5305\u4ece\u5f53\u524d\u73af\u5883\u4f20\u8f93\u5230\u5f53\u524d\u73af\u5883", (String)"PackageUploadValidator_4", (String)"sys-ricc-platform", (Object[])new Object[0]);
                this.errorMessage.append(message);
                return false;
            }
        }
        return true;
    }

    public boolean jsonContainNumberCheck(JSONObject json) {
        if (json.containsKey((Object)"number")) {
            String number = json.getString("number");
            if (StringUtils.isEmpty((CharSequence)number)) {
                this.errorMessage.append(ResManager.loadKDString((String)"\u4f20\u8f93\u5305\u4e2d\u7684\u7f16\u53f7\u4fe1\u606f\u4e3a\u7a7a\uff0c\u8bf7\u91cd\u65b0\u4e0b\u8f7d\u8bd5\u8bd5", (String)"PackageUploadValidator_5", (String)"sys-ricc-platform", (Object[])new Object[0]));
                return false;
            }
        } else {
            this.errorMessage.append(ResManager.loadKDString((String)"\u4f20\u8f93\u5305\u4e2d\u672a\u8bb0\u5f55\u7f16\u7801\u4fe1\u606f,\u8bf7\u91cd\u65b0\u4e0b\u8f7d\u8bd5\u8bd5", (String)"PackageUploadValidator_6", (String)"sys-ricc-platform", (Object[])new Object[0]));
            return false;
        }
        return true;
    }

    public boolean jsonItemExistCheck(JSONObject json) {
        List bcItemPks;
        QFilter[] filters;
        List bdItemPks;
        JSONArray jsonEntrys = json.getJSONArray("subdatapacket");
        HashSet<Long> bdItemIds = new HashSet<Long>();
        HashSet<Long> bcItemIds = new HashSet<Long>();
        HashMap<Long, String> configItemName = new HashMap<Long, String>(jsonEntrys.size());
        for (Object o : jsonEntrys) {
            JSONObject value = (JSONObject)o;
            long itemId = Long.parseLong(value.getString("bizobject"));
            if ("ricc_configitems".equals(value.getString("subpackettype"))) {
                bcItemIds.add(itemId);
            } else {
                bdItemIds.add(itemId);
            }
            configItemName.put(itemId, value.getString("configitemname"));
        }
        if (!bdItemIds.isEmpty() && (bdItemPks = QueryServiceHelper.queryPrimaryKeys((String)"ricc_basedata_item", (QFilter[])(filters = new QFilter("id", "in", bdItemIds).toArray()), null, (int)-1)).size() < bdItemIds.size()) {
            StringBuilder bdConfigItemsNames = new StringBuilder();
            Iterator iterator = bdItemIds.iterator();
            while (iterator.hasNext()) {
                long bdConfigitemId = (Long)iterator.next();
                if (bdItemPks.contains(bdConfigitemId)) continue;
                if (bdConfigItemsNames.length() > 0) {
                    bdConfigItemsNames.append('\u3001');
                }
                bdConfigItemsNames.append((String)configItemName.get(bdConfigitemId));
            }
            this.errorMessage.append(String.format(ResManager.loadKDString((String)"\u4f20\u8f93\u5305\u4e2d\u5b58\u5728\u67e5\u8be2\u4e0d\u5230\u7684\u57fa\u7840\u6570\u636e\u9879\uff1a\u3010%s\u3011\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u6709\u57fa\u7840\u6570\u636e\u9879\u6ca1\u6709\u5148\u540c\u6b65\u4e0a\u4f20\uff0c\u53c2\u8003\u793e\u533a\u77e5\u8bc6\uff1ahttps://vip.kingdee.com/link/s/lzS4O", (String)"PackageUploadValidator_7", (String)"sys-ricc-platform", (Object[])new Object[0]), bdConfigItemsNames));
            return false;
        }
        if (!bcItemIds.isEmpty() && (bcItemPks = QueryServiceHelper.queryPrimaryKeys((String)"ricc_configitems", (QFilter[])(filters = new QFilter("id", "in", bcItemIds).toArray()), null, (int)-1)).size() < bcItemIds.size()) {
            StringBuilder bcConfigItemsNames = new StringBuilder();
            Iterator iterator = bcItemIds.iterator();
            while (iterator.hasNext()) {
                long bcConfigitemId = (Long)iterator.next();
                if (bcItemPks.contains(bcConfigitemId)) continue;
                if (bcConfigItemsNames.length() > 0) {
                    bcConfigItemsNames.append('\u3001');
                }
                bcConfigItemsNames.append((String)configItemName.get(bcConfigitemId));
            }
            this.errorMessage.append(String.format(ResManager.loadKDString((String)"\u4f20\u8f93\u5305\u4e2d\u5b58\u5728\u67e5\u8be2\u4e0d\u5230\u7684\u57fa\u7840\u914d\u7f6e\u9879\uff1a\u3010%s\u3011\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u6709\u57fa\u7840\u914d\u7f6e\u9879\u6ca1\u6709\u5148\u540c\u6b65\u4e0a\u4f20\uff0c\u53c2\u8003\u793e\u533a\u77e5\u8bc6\uff1ahttps://vip.kingdee.com/link/s/lzS4O", (String)"PackageUploadValidator_8", (String)"sys-ricc-platform", (Object[])new Object[0]), bcConfigItemsNames));
            return false;
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean subFileCheck(Map<String, Map<String, String>> nameTempFileInfoMap, JSONObject json) {
        TempFileCacheDownloadable downLoad = (TempFileCacheDownloadable)CacheFactory.getCommonCacheFactory().getTempFileCache();
        try {
            Iterator<Map.Entry<String, Map<String, String>>> iterator = nameTempFileInfoMap.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, Map<String, String>> entry = iterator.next();
                String entryName = entry.getKey();
                if (entryName.equals("ricc_datapacket.json")) continue;
                if (!json.containsKey((Object)entryName)) {
                    String msgTpl = ResManager.loadKDString((String)"\u914d\u7f6e\u6587\u4ef6\u4e2d\u627e\u4e0d\u5230\u5b50\u6587\u4ef6[%s]\u7684\u6570\u5b57\u7b7e\u540d\u4fe1\u606f\uff0c\u4f20\u8f93\u5305\u5185\u5bb9\u88ab\u7be1\u6539\u4e0d\u5141\u8bb8\u4e0a\u4f20", (String)"PackageUploadValidator_11", (String)"sys-ricc-platform", (Object[])new Object[0]);
                    this.errorMessage.append(String.format(msgTpl, entryName));
                    return false;
                }
                String signStr = json.getString(entryName);
                Map<String, String> tempFileInfo = entry.getValue();
                TempFileCacheDownloadable.Content content = downLoad.get(tempFileInfo.get("configKey"), tempFileInfo.get("id"));
                InputStream fileInputStream = content.getInputStream();
                Throwable throwable = null;
                try {
                    boolean sha256Match = Sha256Util.signCheckForInputStream((InputStream)fileInputStream, (String)signStr);
                    if (sha256Match) continue;
                    content = downLoad.get(tempFileInfo.get("configKey"), tempFileInfo.get("id"));
                    try (InputStream fis = content.getInputStream();){
                        boolean md5Match = MD5Util.md5CheckForInputStream((InputStream)fis, (String)signStr);
                        if (md5Match) {
                            String msg = ResManager.loadKDString((String)"\u4f20\u8f93\u5305\u9a8c\u8bc1\u7b97\u6cd5\u5df2\u5347\u7ea7\uff0c\u8bf7\u91cd\u65b0\u4e0b\u8f7d\u6216\u91cd\u65b0\u5728\u7ebf\u4f20\u8f93", (String)"PackageUploadValidator_9", (String)"sys-ricc-platform", (Object[])new Object[0]);
                            this.errorMessage.append(msg);
                        } else {
                            String msgTpl = ResManager.loadKDString((String)"\u5b50\u5305\u6587\u4ef6[%s]\u4e0e\u914d\u7f6e\u6587\u4ef6\u4e2d\u8bb0\u5f55\u7684\u7b7e\u540d\u4fe1\u606f\u4e0d\u5339\u914d\uff0c\u4f20\u8f93\u5305\u5185\u5bb9\u88ab\u7be1\u6539\u4e0d\u5141\u8bb8\u4e0a\u4f20", (String)"PackageUploadValidator_10", (String)"sys-ricc-platform", (Object[])new Object[0]);
                            this.errorMessage.append(String.format(msgTpl, entryName));
                        }
                    }
                    boolean bl = false;
                    return bl;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (fileInputStream == null) continue;
                    if (throwable != null) {
                        try {
                            fileInputStream.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    fileInputStream.close();
                }
            }
            return true;
        }
        catch (IOException e) {
            this.errorMessage.append(ResManager.loadKDString((String)"\u5b50\u6587\u4ef6\u5185\u5bb9\u6821\u9a8c\u53d1\u751f\u5f02\u5e38\uff1a ", (String)"PackageUploadValidator_12", (String)"sys-ricc-platform", (Object[])new Object[0])).append(e);
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean carryDataCheck(String carryData, JSONObject dataPacketJson, String key) {
        if (carryData == null) {
            return true;
        }
        Object configInfo = dataPacketJson.get((Object)"configInfo");
        if (configInfo == null) {
            String synErrorMessage = ResManager.loadKDString((String)"ricc_dataPacket.json\u6587\u4ef6\u4e2d\u7f3a\u5c11configInfo\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5\u540e\u518d\u4e0a\u4f20", (String)"PackageUploadValidator_13", (String)"sys-ricc-platform", (Object[])new Object[0]);
            this.errorMessage.append(synErrorMessage);
            return false;
        }
        JSONObject itemInfo = (JSONObject)configInfo;
        JSONObject carryInfo = itemInfo.getJSONObject(key);
        if (carryInfo == null) {
            String synErrorMessage = ResManager.loadKDString((String)"ricc_dataPacket.json\u6587\u4ef6\u4e2d\u7f3a\u5c11\u914d\u7f6e\u643a\u5e26\u4fe1\u606f\uff0c\u8bf7\u68c0\u67e5\u540e\u518d\u4e0a\u4f20", (String)"PackageUploadValidator_14", (String)"sys-ricc-platform", (Object[])new Object[0]);
            this.errorMessage.append(synErrorMessage);
            return false;
        }
        try (ByteArrayInputStream treeInputStream = new ByteArrayInputStream(carryData.getBytes(StandardCharsets.UTF_8));){
            String dataSign = carryInfo.getString("sign");
            boolean dataSha256Match = Sha256Util.signCheckForInputStream((InputStream)treeInputStream, (String)dataSign);
            if (dataSha256Match) return true;
            String msgTpl = ResManager.loadKDString((String)"\u5b50\u5305\u6587\u4ef6[%s]\u4e0e\u914d\u7f6e\u6587\u4ef6\u4e2d\u8bb0\u5f55\u7684\u7b7e\u540d\u4fe1\u606f\u4e0d\u5339\u914d\uff0c\u4f20\u8f93\u5305\u5185\u5bb9\u88ab\u7be1\u6539\u4e0d\u5141\u8bb8\u4e0a\u4f20", (String)"PackageUploadValidator_10", (String)"sys-ricc-platform", (Object[])new Object[0]);
            this.errorMessage.append(String.format(msgTpl, carryInfo.getString("name")));
            boolean bl = false;
            return bl;
        }
        catch (IOException e) {
            this.errorMessage.append(ResManager.loadKDString((String)"\u5b50\u6587\u4ef6\u5185\u5bb9\u6821\u9a8c\u53d1\u751f\u5f02\u5e38\uff1a ", (String)"PackageUploadValidator_12", (String)"sys-ricc-platform", (Object[])new Object[0])).append(e);
            return false;
        }
    }
}

