/*
 * Decompiled with CFR 0.152.
 */
package kd.sys.ricc.business.impt;

import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.plugin.impt.ImportHelper;
import kd.bos.impt.SheetHandler;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.sys.ricc.common.util.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.Comment;
import org.apache.poi.ss.usermodel.DataValidation;
import org.apache.poi.ss.usermodel.DataValidationConstraint;
import org.apache.poi.ss.usermodel.DataValidationHelper;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.util.CellAddress;
import org.apache.poi.ss.util.CellRangeAddressList;
import org.apache.poi.xssf.model.CommentsTable;
import org.apache.poi.xssf.streaming.SXSSFCell;
import org.apache.poi.xssf.streaming.SXSSFDrawing;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFClientAnchor;
import org.apache.poi.xssf.usermodel.XSSFComment;
import org.apache.poi.xssf.usermodel.XSSFDataValidation;

public class BillCoverSheetHandler
extends SheetHandler {
    private static final String KEY_COLOR = "color";
    private static final int FIELDTITLE_ROW_INDEX = 3;
    private static final int FIELDNAME_ROW_INDEX = 2;
    private static final int HEAD_ROW_INDEX = 0;
    private static final int FIRSTDATA_ROW_INDEX = 4;
    private static final String DATA_SHEET_NAME = "sheet1";
    private static final String DROPDOWN_ITEMS_SHEET_NAME = "dropdown_items_sheet";
    private static final Log log = LogFactory.getLog(BillCoverSheetHandler.class);
    private static final int MAX_COL_COUNT = 16383;
    private final List<String> coverProps;
    private final Set<Integer> needCoverCols = new HashSet<Integer>(16);
    private final String entityNumber;
    private final Map<String, SXSSFSheet> sheets = new HashMap<String, SXSSFSheet>(16);
    private final Map<String, CellStyle> styles = new HashMap<String, CellStyle>(16);
    private final Map<String, SXSSFRow> nameRows = new HashMap<String, SXSSFRow>(16);
    private SXSSFWorkbook book;
    private boolean isDropdownItemsSheet = false;
    private boolean isDataSheet = false;
    private SheetHandler.ParsedRow currentParsedRow;
    private List<String> conditionMustFields;
    private List<String> coverUserFields;
    private Set<Integer> coverUserIdCols = new HashSet<Integer>(16);
    private Set<Integer> coverUserNumCols = new HashSet<Integer>(16);
    private Set<Integer> coverUserNameCols = new HashSet<Integer>(16);
    private Set<Integer> modifyMustCols = new HashSet<Integer>(16);
    private String currUserId;
    private String curUserNum;
    private String curUserName;

    public BillCoverSheetHandler(SXSSFWorkbook book, List<String> coverProps, List<String> conditionMustFields, List<String> coverUserFields, String entityNumber) {
        this.book = book;
        this.coverProps = coverProps;
        this.entityNumber = entityNumber;
        this.conditionMustFields = conditionMustFields;
        this.coverUserFields = coverUserFields;
        DynamicObject curUser = BusinessDataServiceHelper.loadSingle((String)"bos_user", (String)"id,number,name", (QFilter[])new QFilter("id", "=", (Object)RequestContext.get().getCurrUserId()).toArray());
        this.currUserId = curUser.getString("id");
        this.curUserNum = curUser.getString("number");
        this.curUserName = curUser.getString("name");
        super.setInterrupt(false);
    }

    private void loadNeedCoverColIndexes(Row fieldNameRow) {
        for (int colIndex = 0; colIndex < fieldNameRow.getPhysicalNumberOfCells(); ++colIndex) {
            Cell cell = fieldNameRow.getCell(colIndex);
            String fieldName = cell.getStringCellValue();
            if (fieldName.contains(".")) {
                String[] fieldNameSplits = fieldName.split("\\.");
                if (fieldNameSplits.length <= 0) continue;
                this.markNeedCoverCol(this.coverProps, colIndex, fieldNameSplits[0]);
                this.markNeedCoverUserCol(colIndex, fieldNameSplits[0], fieldNameSplits[fieldNameSplits.length - 1]);
                this.markModifyMustCol(colIndex, fieldNameSplits[0]);
                continue;
            }
            this.markNeedCoverCol(this.coverProps, colIndex, fieldName);
            this.markModifyMustCol(colIndex, fieldName);
        }
    }

    private void markNeedCoverCol(List<String> coverProps, int colIndex, String colFieldName) {
        for (String coverProp : coverProps) {
            if (!colFieldName.equals(coverProp)) continue;
            this.needCoverCols.add(colIndex);
        }
    }

    private void markNeedCoverUserCol(int colIndex, String fieldName, String fieldProperty) {
        if (this.coverUserFields.contains(fieldName)) {
            if (StringUtils.equals((String)"id", (String)fieldProperty)) {
                this.coverUserIdCols.add(colIndex);
            } else if (StringUtils.equals((String)"number", (String)fieldProperty)) {
                this.coverUserNumCols.add(colIndex);
            } else if (StringUtils.equals((String)"name", (String)fieldProperty)) {
                this.coverUserNameCols.add(colIndex);
            }
        }
    }

    private void markModifyMustCol(int colIndex, String colFieldName) {
        for (String conditionMustField : this.conditionMustFields) {
            if (!colFieldName.equals(conditionMustField)) continue;
            this.modifyMustCols.add(colIndex);
        }
    }

    public void handleRow(SheetHandler.ParsedRow row) {
        SXSSFSheet sheet = this.sheets.get(row.getSheetName());
        if (sheet == null) {
            sheet = this.initSheet(row.getSheetName());
        }
        this.currentParsedRow = row;
        int currRowNum = this.currentParsedRow.getRowNum();
        if (this.isDataSheet) {
            this.handleDataSheet(sheet, currRowNum);
            this.coverBillCreateInfo(sheet, currRowNum);
            return;
        }
        if (this.isDropdownItemsSheet) {
            this.handleDropdownSheet(sheet, currRowNum);
            return;
        }
        this.handleOtherSheet(sheet, currRowNum);
    }

    private SXSSFSheet initSheet(String sheetName) {
        if (this.book == null) {
            this.book = new SXSSFWorkbook(3000);
        }
        SXSSFSheet sheet = this.book.createSheet(sheetName);
        if (this.sheets.isEmpty()) {
            sheet.setColumnWidth(0, 10000);
        }
        this.isDropdownItemsSheet = DROPDOWN_ITEMS_SHEET_NAME.equals(sheetName);
        if (this.isDropdownItemsSheet) {
            int sheetIndex = this.book.getSheetIndex(DROPDOWN_ITEMS_SHEET_NAME);
            sheet.getWorkbook().setSheetHidden(sheetIndex, true);
        }
        this.isDataSheet = DATA_SHEET_NAME.equals(sheetName);
        this.sheets.put(sheetName, sheet);
        return sheet;
    }

    private void handleDataSheet(SXSSFSheet sheet, int currRowNum) {
        SXSSFRow curRow = this.getRow(sheet, currRowNum);
        for (Map.Entry entry : this.currentParsedRow.getData().entrySet()) {
            JSONObject styleObj = (JSONObject)this.currentParsedRow.getStyles().get(entry.getKey());
            int cellIndex = (Integer)entry.getKey();
            SXSSFCell cell = curRow.createCell(cellIndex);
            String value = (String)entry.getValue();
            if (currRowNum == 3) {
                styleObj.put("bg", (Object)IndexedColors.GREY_25_PERCENT.getIndex());
                if (this.modifyMustCols.contains(cellIndex) && value.startsWith("*")) {
                    value = value.replaceFirst("\\*", "");
                }
                if (value.startsWith("*")) {
                    styleObj.put(KEY_COLOR, (Object)IndexedColors.RED.getIndex());
                }
                Map colProperty = (Map)this.getColHolder().getColProperty().get(cellIndex);
                double colWidth = 0.0;
                if (colProperty != null && NumberUtils.isParsable((String)String.valueOf(colProperty.get("colWidth")))) {
                    colWidth = Double.parseDouble(String.valueOf(colProperty.get("colWidth")));
                }
                sheet.setColumnWidth(cellIndex, ImportHelper.calcColumnWidth((String)value, (int)0, (double)colWidth));
            }
            this.setCellVal(cell, value, styleObj);
        }
    }

    private void coverBillCreateInfo(SXSSFSheet sheet, int currRowNum) {
        SXSSFRow sxssfRow = this.getRow(sheet, currRowNum);
        if (currRowNum > 3) {
            this.cover(sxssfRow);
            return;
        }
        if (currRowNum == 3) {
            this.nameRows.put(sheet.getSheetName(), sxssfRow);
        }
        if (currRowNum == 2) {
            this.loadNeedCoverColIndexes((Row)sxssfRow);
        }
    }

    private void handleDropdownSheet(SXSSFSheet sheet, int currRowNum) {
        for (Map.Entry entry : this.currentParsedRow.getData().entrySet()) {
            SXSSFCell cell = this.getRow(sheet, currRowNum).createCell(((Integer)entry.getKey()).intValue());
            cell.setCellType(CellType.STRING);
            cell.setCellValue((String)entry.getValue());
        }
    }

    private void handleOtherSheet(SXSSFSheet sheet, int currRowNum) {
        for (Map.Entry entry : this.currentParsedRow.getData().entrySet()) {
            Integer key = (Integer)entry.getKey();
            JSONObject styleObj = (JSONObject)this.currentParsedRow.getStyles().get(key);
            SXSSFCell cell = this.getRow(sheet, currRowNum).createCell(key.intValue());
            String value = (String)entry.getValue();
            this.setCellVal(cell, value, styleObj);
        }
    }

    public void handleDataValidation(Set<SheetHandler.CellValidation> cellValidations) {
        for (SheetHandler.CellValidation validation : cellValidations) {
            String[] rangeStrs;
            SXSSFSheet sheet = this.sheets.get(validation.getSheetName());
            DataValidationHelper helper = sheet.getDataValidationHelper();
            String refValidation = validation.getValidation();
            if (refValidation == null || refValidation.endsWith("dropdown_items_sheet!#REF!") || (rangeStrs = validation.getRange().toUpperCase().split(" ")).length <= 0) continue;
            for (String rg : rangeStrs) {
                List<Integer> ranges = this.splitRange(rg.split(":"));
                int rangeSize = ranges.size();
                CellRangeAddressList addressList = null;
                if (ranges.contains(-1)) continue;
                if (rangeSize == 2) {
                    addressList = new CellRangeAddressList(ranges.get(1) - 1, ranges.get(1) - 1, ranges.get(0).intValue(), Math.min(16383, ranges.get(0)));
                } else if (rangeSize == 4) {
                    addressList = new CellRangeAddressList(ranges.get(1) - 1, ranges.get(3) - 1, ranges.get(0).intValue(), Math.min(16383, ranges.get(2)));
                }
                if (addressList == null) continue;
                DataValidationConstraint constraint = helper.createFormulaListConstraint(validation.getValidation());
                DataValidation dataValidation = helper.createValidation(constraint, addressList);
                if (dataValidation instanceof XSSFDataValidation) {
                    dataValidation.setSuppressDropDownArrow(true);
                    dataValidation.setShowErrorBox(true);
                } else {
                    dataValidation.setSuppressDropDownArrow(false);
                }
                sheet.addValidationData(dataValidation);
            }
        }
    }

    public void handleSheetComments(Map<String, CommentsTable> comments) {
        if (!comments.isEmpty()) {
            for (Map.Entry<String, CommentsTable> entry : comments.entrySet()) {
                String sheetName = entry.getKey();
                SXSSFSheet sheet = this.book.getSheet(sheetName);
                SXSSFRow row = this.nameRows.get(entry.getKey());
                if (row == null) continue;
                SXSSFDrawing p = sheet.createDrawingPatriarch();
                CommentsTable commentsTable = entry.getValue();
                Iterator cellAddresses = commentsTable.getCellAddresses();
                while (cellAddresses.hasNext()) {
                    XSSFComment comment;
                    CellAddress addr = (CellAddress)cellAddresses.next();
                    SXSSFCell cell = row.getCell(addr.getColumn());
                    if (cell == null || (comment = commentsTable.findCellComment(addr)).getRow() != 3) continue;
                    Comment temp = p.createCellComment((ClientAnchor)new XSSFClientAnchor(0, 0, 0, 0, (int)((short)comment.getColumn()), 3, (short)comment.getColumn() + 2, 5));
                    temp.setString((RichTextString)comment.getString());
                    cell.setCellComment(temp);
                }
            }
            comments.clear();
        }
    }

    private List<Integer> splitRange(String[] subRanges) {
        ArrayList<Integer> ranges = new ArrayList<Integer>();
        try {
            for (String subRange : subRanges) {
                char c;
                int k;
                int j = 0;
                int len = subRange.length();
                for (k = 1; k < len && (c = subRange.charAt(k)) >= 'A' && c <= 'Z'; ++k) {
                }
                ranges.add(this.charsToNumber(subRange.substring(j, k)));
                ranges.add(Integer.parseInt(subRange.substring(k)));
            }
        }
        catch (Throwable e) {
            log.error("splitRange \u53d1\u751f\u5f02\u5e38", e);
        }
        return ranges;
    }

    private int charsToNumber(String letter) {
        if (letter == null || letter.isEmpty()) {
            return -1;
        }
        String upperLetter = letter.toUpperCase();
        if (!upperLetter.matches("[A-Z]+")) {
            return -1;
        }
        long num = 0L;
        long base = 1L;
        for (int i = upperLetter.length() - 1; i >= 0; --i) {
            char ch = upperLetter.charAt(i);
            if ((num += (long)(ch - 65) * (base *= 26L)) <= Integer.MAX_VALUE) continue;
            return -1;
        }
        return (int)num;
    }

    private void setCellVal(SXSSFCell cell, String val, JSONObject styleObj) {
        cell.setCellStyle(this.getCellStyle(styleObj));
        String fmt = styleObj.getString("fmt");
        if (StringUtils.isNotBlank((CharSequence)fmt)) {
            try {
                cell.setCellValue(new BigDecimal(val).doubleValue());
            }
            catch (Throwable e) {
                cell.setCellValue(val);
            }
        } else {
            cell.setCellValue(val);
        }
    }

    public SXSSFRow getRow(SXSSFSheet sheet, int r) {
        SXSSFRow row = sheet.getRow(r);
        if (row == null) {
            row = sheet.createRow(r);
        }
        return row;
    }

    private CellStyle getCellStyle(JSONObject style) {
        String fmt = (String)style.getOrDefault((Object)"fmt", (Object)"@");
        String align = style.getString("align");
        Short bg = style.getShort("bg");
        Short color = style.getShort(KEY_COLOR);
        String styleStr = String.format("%s_-_%d_-_%d_-_%s", fmt, bg, color, align);
        CellStyle cellStyle = this.styles.get(styleStr);
        if (cellStyle == null) {
            cellStyle = this.book.createCellStyle();
            this.styles.put(styleStr, cellStyle);
            cellStyle.setDataFormat(this.book.createDataFormat().getFormat(fmt));
            if (bg != null) {
                cellStyle.setFillForegroundColor(bg.shortValue());
                cellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
            }
            if (color != null) {
                Font font = this.book.createFont();
                font.setColor(color.shortValue());
                cellStyle.setFont(font);
            }
            cellStyle.setAlignment(this.getAlignment(align));
        }
        return cellStyle;
    }

    private HorizontalAlignment getAlignment(String align) {
        try {
            return HorizontalAlignment.valueOf((String)align.toUpperCase());
        }
        catch (Throwable e) {
            return HorizontalAlignment.GENERAL;
        }
    }

    private void cover(SXSSFRow curRow) {
        for (int col : this.needCoverCols) {
            SXSSFCell cell = curRow.getCell(col);
            if (cell == null) continue;
            cell.setBlank();
        }
        this.coverUser(curRow, this.coverUserIdCols, this.currUserId);
        this.coverUser(curRow, this.coverUserNumCols, this.curUserNum);
        this.coverUser(curRow, this.coverUserNameCols, this.curUserName);
    }

    private void coverUser(SXSSFRow curRow, Set<Integer> cols, String coverVal) {
        for (int coverCol : cols) {
            SXSSFCell cell = curRow.getCell(coverCol);
            if (cell == null) continue;
            cell.setCellValue(coverVal);
        }
    }
}

