/*
 * Decompiled with CFR 0.152.
 */
package kd.sys.ricc.business.impt;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import kd.bos.coderule.api.ICodeRuleService;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.entity.property.CreateDateProp;
import kd.bos.entity.property.CreaterProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.entity.property.IFieldHandle;
import kd.bos.entity.property.ModifierProp;
import kd.bos.entity.property.ModifyDateProp;
import kd.bos.fileservice.FileService;
import kd.bos.fileservice.FileServiceFactory;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.service.DispatchServiceHelper;
import kd.bos.mvc.FormConfigFactory;
import kd.bos.mvc.SessionManager;
import kd.bos.orm.query.QFilter;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.sys.ricc.business.datapacket.core.model.SdpOutputParams;
import kd.sys.ricc.business.datapacket.helper.AttachTransHelper;
import kd.sys.ricc.business.impt.BillCoverSheetHandler;
import kd.sys.ricc.business.impt.ExcelImportResult;
import kd.sys.ricc.business.impt.ExcelReader;
import kd.sys.ricc.business.impt.ImportParamAdapter;
import kd.sys.ricc.business.schedule.ScheduleUtil;
import kd.sys.ricc.common.constant.CommonConstant;
import kd.sys.ricc.common.util.CommonUtil;
import kd.sys.ricc.common.util.FileUtils;
import kd.sys.ricc.common.util.StringUtils;
import kd.sys.ricc.common.util.SysParaUtil;
import kd.sys.ricc.common.util.TimeCostUtil;
import kd.sys.ricc.exception.RiccBizException;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;

public class ExcelImportHelper {
    private static final Log logger = LogFactory.getLog(ExcelImportHelper.class);
    private static final String FILE_NAME = "fileName";
    private static final String URL = "url";
    private static final long DEFAULT_TIMEOUT_5MIN = 300000L;
    private static final int EXCEL_DATA_START_ROW_INDEX = 4;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, String> parseXlsxFile(InputStream in, String formId, String fileName) {
        HashMap<String, String> fileInfo = new HashMap<String, String>(2);
        try {
            FileService fileService = FileServiceFactory.getAttachmentFileService();
            String appId = (String)DispatchServiceHelper.invokeBOSService((String)"FormService", (String)"getAppId", (Object[])new Object[]{formId});
            String path = FileUtils.upload2FileService((String)fileName, (String)formId, (String)appId, (FileService)fileService, (InputStream)in);
            fileInfo.put(FILE_NAME, fileName);
            fileInfo.put(URL, path);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    logger.warn("ExcelImportHelper.parseXlsxFile[" + fileName + "]\u5173\u6d41\u5931\u8d25", (Throwable)e);
                }
            }
        }
        return fileInfo;
    }

    public static List<Map<String, String>> parseXlsxFile(String url, String formId, String fileName, List<String> conditionMustFields, List<String> coverUserFields) {
        String path;
        ArrayList<Map<String, String>> fileInfos = new ArrayList<Map<String, String>>();
        FileService fileService = FileServiceFactory.getAttachmentFileService();
        ArrayList<String> coverProps = ExcelImportHelper.getNeedCoverProps(formId);
        coverUserFields.removeAll(coverProps);
        if (coverProps.isEmpty() && conditionMustFields.isEmpty() && coverUserFields.isEmpty()) {
            path = url;
        } else {
            try (InputStream inputStream = fileService.getInputStream(url);
                 ByteArrayOutputStream buffer = new ByteArrayOutputStream();){
                ExcelImportHelper.coverBillCreatorInfo(formId, coverProps, conditionMustFields, coverUserFields, inputStream, buffer);
                String appId = FormMetadataCache.getFormAppId((String)formId);
                path = FileUtils.upload2FileService((String)fileName, (String)formId, (String)appId, (FileService)fileService, (InputStream)new ByteArrayInputStream(buffer.toByteArray()));
            }
            catch (Exception e) {
                logger.error((Throwable)e);
                throw new RiccBizException(String.format(CommonConstant.getImportFileErrorTip(), fileName) + CommonUtil.getExceptionDetailInfo((Throwable)e), (Throwable)e);
            }
        }
        HashMap<String, String> fileInfo = new HashMap<String, String>(2);
        fileInfo.put(FILE_NAME, fileName);
        fileInfo.put(URL, path);
        fileInfos.add(fileInfo);
        return fileInfos;
    }

    public static List<Map<String, String>> parseXlsxZipFile(InputStream in, String formId, List<String> conditionMustFields, List<String> coverUserFields, SdpOutputParams result) {
        ArrayList<Map<String, String>> fileInfos = new ArrayList<Map<String, String>>();
        ArrayList<String> coverProps = ExcelImportHelper.getNeedCoverProps(formId);
        coverUserFields.removeAll(coverProps);
        try (ZipInputStream zipInputStream = new ZipInputStream(in, Charset.forName("GBK"));){
            String appId = (String)DispatchServiceHelper.invokeBOSService((String)"FormService", (String)"getAppId", (Object[])new Object[]{formId});
            FileService fileService = FileServiceFactory.getAttachmentFileService();
            ByteArrayOutputStream buffer = null;
            try {
                ZipEntry nextEntry = zipInputStream.getNextEntry();
                while (nextEntry != null) {
                    String fileName = nextEntry.getName();
                    if (!fileName.endsWith("_attach.json") && !fileName.equals("attach/")) {
                        if (fileName.startsWith("attach/")) {
                            AttachTransHelper.uploadAttachTemp(fileName, zipInputStream, result);
                        } else {
                            if (!fileName.endsWith(".xlsx")) {
                                String msgTpl = ResManager.loadKDString((String)"\u6587\u4ef6\u201c%s\u201d\u65e0\u6cd5\u8bc6\u522b\u4e3aexcel\u6587\u4ef6\uff0c\u8bf7\u91cd\u65b0\u6253\u5305\u8fdb\u884c\u4f20\u8f93\u540c\u6b65\u6216\u8054\u7cfb\u7ba1\u7406\u5458\u8fdb\u884c\u5904\u7406", (String)"ExcelImportHelper_14", (String)"sys-ricc-platform", (Object[])new Object[0]);
                                throw new RiccBizException(String.format(msgTpl, fileName));
                            }
                            buffer = new ByteArrayOutputStream();
                            if (!(coverProps.isEmpty() && conditionMustFields.isEmpty() && coverUserFields.isEmpty())) {
                                ExcelImportHelper.coverBillCreatorInfo(formId, coverProps, conditionMustFields, coverUserFields, zipInputStream, buffer);
                            } else {
                                FileUtils.inputStreamToOutputStream((InputStream)zipInputStream, (OutputStream)buffer);
                            }
                            String path = FileUtils.upload2FileService((String)fileName, (String)formId, (String)appId, (FileService)fileService, (InputStream)new ByteArrayInputStream(buffer.toByteArray()));
                            HashMap<String, String> fileInfo = new HashMap<String, String>(2);
                            fileInfo.put(FILE_NAME, fileName);
                            fileInfo.put(URL, path);
                            fileInfos.add(fileInfo);
                        }
                    }
                    nextEntry = zipInputStream.getNextEntry();
                }
            }
            catch (Exception e) {
                logger.error("parseXlsxZipFile \u53d1\u751f\u5f02\u5e38", (Throwable)e);
                throw new RiccBizException(ResManager.loadKDString((String)"\u538b\u7f29\u6587\u4ef6\u5185\u5bb9\u5904\u7406\u51fa\u73b0\u5f02\u5e38\uff1a", (String)"ExcelImportHelper_0", (String)"sys-ricc-platform", (Object[])new Object[0]), (Throwable)e);
            }
            finally {
                zipInputStream.closeEntry();
                if (null != buffer) {
                    buffer.close();
                }
                in.close();
            }
        }
        catch (IOException e) {
            logger.error("parseXlsxZipFile2 \u53d1\u751f\u5f02\u5e38", (Throwable)e);
            throw new RiccBizException(ResManager.loadKDString((String)"\u538b\u7f29\u6587\u4ef6\u5904\u7406\u51fa\u73b0\u5f02\u5e38\uff1a", (String)"ExcelImportHelper_1", (String)"sys-ricc-platform", (Object[])new Object[0]), (Throwable)e);
        }
        return fileInfos;
    }

    public static ExcelImportResult executeExcelImport(String fileUrl, String fileName, FormShowParameter showParameter) {
        ExcelImportResult result = new ExcelImportResult(fileName);
        String formId = (String)showParameter.getCustomParam("BillFormId");
        String serviceAppId = (String)showParameter.getCustomParam("ServiceAppId");
        String entityDisplayName = (String)showParameter.getCustomParam("ListName");
        Object logId = ExcelImportHelper.createImportlog(entityDisplayName);
        showParameter.setCustomParam("Url", (Object)CommonUtil.checkUrl((String)fileUrl));
        showParameter.setCustomParam("logId", logId);
        String pageId = ExcelImportHelper.openFormView(formId, showParameter);
        IFormView view = SessionManager.getCurrent().getViewNoPlugin(pageId);
        if (view == null) {
            return result.setError(ResManager.loadKDString((String)"\u5bfc\u5165\u5931\u8d25\uff0c\u53ef\u80fd\u662f\u7528\u6237\u6ca1\u6709\u5bf9\u5e94\u9875\u9762\u7684\u6743\u9650\uff0c\u8bf7\u5c1d\u8bd5\u66f4\u6362\u767b\u5f55\u7528\u6237", (String)"ExcelImportHelper_2", (String)"sys-ricc-platform", (Object[])new Object[0]));
        }
        try {
            DispatchServiceHelper.invokeBOSServiceByAppId((String)serviceAppId, (String)"importService", (String)"startImport", (Object[])new Object[]{pageId, logId.toString()});
        }
        catch (Exception e) {
            logger.error("\u8c03\u7528\u5bfc\u5165\u5fae\u670d\u52a1\u53d1\u751f\u5f02\u5e38", (Throwable)e);
            return result.setError(ResManager.loadKDString((String)"\u5bfc\u5165\u51fa\u73b0\u672a\u77e5\u5f02\u5e38\u3002", (String)"ExcelImportHelper_3", (String)"sys-ricc-platform", (Object[])new Object[0])).append(CommonUtil.getExceptionDetailInfo((Throwable)e));
        }
        ExcelImportHelper.wait2ImportEnd(logId, formId, pageId, result);
        if (!result.isSuccess()) {
            return result;
        }
        ExcelImportHelper.parseExcelImportResult(logId, result);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void wait2ImportEnd(Object logId, String formId, String pageId, ExcelImportResult result) {
        logger.info(logId + " start waiting " + System.currentTimeMillis());
        int sleepSecond = 500;
        long start = System.currentTimeMillis();
        int interruptedCount = 0;
        int progress = 0;
        try {
            while (!ExcelImportHelper.isComplete(logId)) {
                block11: {
                    Integer lastProgress = ExcelImportHelper.getLatestProgress(pageId);
                    if (lastProgress > progress) {
                        progress = lastProgress;
                        start = System.currentTimeMillis();
                    } else if (lastProgress == progress && System.currentTimeMillis() - start > 300000L) {
                        throw new RiccBizException("\n" + ResManager.loadKDString((String)"\u6570\u636e\u5bfc\u5165\u7684\u8fdb\u5ea6\u5df2\u7ecf\u957f\u65f6\u95f4\u672a\u53d1\u751f\u53d8\u5316\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u786e\u8ba4\u5bfc\u5165\u4efb\u52a1\u662f\u5426\u5df2\u7ecf\u5f02\u5e38\u7ec8\u6b62\uff0c\u6216\u7a0d\u540e\u53bb\u5355\u636e\u7684\u5217\u8868\u754c\u9762\u67e5\u770b\u5bfc\u5165\u7ed3\u679c", (String)"ExcelImportHelper_4", (String)"sys-ricc-platform", (Object[])new Object[0]));
                    }
                    try {
                        Thread.sleep(sleepSecond);
                    }
                    catch (InterruptedException e) {
                        int n = interruptedCount;
                        interruptedCount = (byte)(interruptedCount + 1);
                        if (n <= 3) break block11;
                        logger.info(logId + " InterruptedException ", (Object)e);
                        throw new RiccBizException("\n" + ResManager.loadKDString((String)"\u4efb\u52a1\u6267\u884c\u5df2\u88ab\u591a\u6b21\u4e2d\u65ad\u3002", (String)"ExcelImportHelper_5", (String)"sys-ricc-platform", (Object[])new Object[0]), (Throwable)e);
                    }
                }
                sleepSecond = ScheduleUtil.getDynamicSleepSecond(sleepSecond, 5000);
            }
        }
        catch (RiccBizException e) {
            logger.error("\u7b49\u5f85\u5bfc\u5165\u4efb\u52a1\u7ed3\u675f\u65f6\u53d1\u751f\u5f02\u5e38", (Throwable)e);
            result.setError(ResManager.loadKDString((String)"\u7b49\u5f85\u5bfc\u5165\u4efb\u52a1\u7ed3\u675f\u65f6\u53d1\u751f\u5f02\u5e38\uff0c", (String)"ExcelImportHelper_6", (String)"sys-ricc-platform", (Object[])new Object[0])).append(e.getMessage()).append(ResManager.loadKDString((String)"\u5bfc\u5165\u65e5\u5fd7id\uff1a", (String)"ExcelImportHelper_7", (String)"sys-ricc-platform", (Object[])new Object[0])).append(logId.toString());
        }
        finally {
            ExcelImportHelper.closeFormView(formId, pageId);
        }
        logger.info(logId + " end waiting " + System.currentTimeMillis());
    }

    private static Integer getLatestProgress(String pageId) {
        JSONObject map;
        Object obj;
        String importLog;
        Integer lastProgress = 0;
        IPageCache cache = SessionManager.getCurrent().getPageCache(pageId);
        if (cache != null && StringUtils.isNotBlank((CharSequence)(importLog = cache.get("Cached_Import_Logger"))) && (obj = (map = JSON.parseObject((String)importLog)).get((Object)"progress")) != null && !"".equals(obj)) {
            try {
                lastProgress = Integer.parseInt(String.valueOf(obj).trim());
            }
            catch (NumberFormatException e) {
                logger.info("ExcelImpl.import.getProgress\u51fa\u73b0\u8f6c\u6362\u95ee\u9898\uff0c\u65e0\u6cd5\u5c06\u83b7\u53d6\u7684progress\u8f6c\u6362\u6210int\uff1a" + obj, (Object)e);
            }
        }
        return lastProgress;
    }

    private static void parseExcelImportResult(Object importLogId, ExcelImportResult result) {
        DynamicObject log = QueryServiceHelper.queryOne((String)"bos_importlog", (String)"id, importstatus, data, total, failed", (QFilter[])new QFilter("id", "=", importLogId).toArray());
        if (log != null) {
            String data = log.getString("data");
            if (!StringUtils.isEmpty((String)data)) {
                JSONObject info = JSON.parseObject((String)data).getJSONObject("info");
                boolean success = true;
                for (Object value : info.values()) {
                    ImportLogger importLogger = (ImportLogger)SerializationUtils.fromJsonString((String)value.toString(), ImportLogger.class);
                    if (importLogger.getFailed() > 0) {
                        success = false;
                    } else if (importLogger.getTotal() <= 0) {
                        success = false;
                    }
                    result.setTotal(importLogger.getTotal());
                    result.setFailed(importLogger.getFailed());
                    result.setSuccess(success);
                    result.append(importLogger.toString());
                }
            } else {
                result.setError("\n" + ResManager.loadKDString((String)"\u5bfc\u5165\u65e5\u5fd7\u4e2d\u6570\u636e\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u89e3\u6790\uff0c\u8bf7\u5230\u5355\u636e\u5217\u8868\u754c\u9762\u67e5\u770b\u5bfc\u5165\u7ed3\u679c\u8fdb\u884c\u786e\u8ba4\uff0c\u5bfc\u5165\u65e5\u5fd7id\uff1a", (String)"ExcelImportHelper_8", (String)"sys-ricc-platform", (Object[])new Object[0])).append(importLogId.toString());
            }
        } else {
            result.setError("\n" + ResManager.loadKDString((String)"\u5bfc\u5165\u65e5\u5fd7\u672a\u6210\u529f\u67e5\u8be2\u5230\uff0c\u8bf7\u5230\u5355\u636e\u5217\u8868\u754c\u9762\u67e5\u770b\u5bfc\u5165\u7ed3\u679c\u8fdb\u884c\u786e\u8ba4\uff0c\u5bfc\u5165\u65e5\u5fd7id\uff1a", (String)"ExcelImportHelper_9", (String)"sys-ricc-platform", (Object[])new Object[0])).append(importLogId.toString());
        }
    }

    public static ExcelImportResult batchExecuteExcelImport(List<Map<String, String>> fileInfos, String formId, String pageEnterParam, String pageType, Map<String, String> excelParams) {
        ExcelImportResult sumResult = new ExcelImportResult(ResManager.loadKDString((String)"\u6279\u91cf\u5bfc\u5165\u7ed3\u679c", (String)"ExcelImportHelper_10", (String)"sys-ricc-platform", (Object[])new Object[0]));
        if (fileInfos == null || fileInfos.isEmpty()) {
            return sumResult.setError(ResManager.loadKDString((String)"\u5bfc\u5165\u7684\u5185\u5bb9\u4e3a\u7a7a", (String)"ExcelImportHelper_11", (String)"sys-ricc-platform", (Object[])new Object[0]));
        }
        FormShowParameter showParameter = ImportParamAdapter.createFormShowParameter4Import(formId, pageType);
        ImportParamAdapter.setExcelParams(formId, showParameter, excelParams);
        ImportParamAdapter.specialFormParameters(pageEnterParam, showParameter);
        if (fileInfos.size() == 1) {
            return ExcelImportHelper.executeExcelImport(fileInfos.get(0).get(URL), fileInfos.get(0).get(FILE_NAME), showParameter);
        }
        for (int i = 1; i <= fileInfos.size(); ++i) {
            Map<String, String> fileInfo = fileInfos.get(i - 1);
            long start = System.currentTimeMillis();
            ExcelImportResult subResult = ExcelImportHelper.executeExcelImport(fileInfo.get(URL), fileInfo.get(FILE_NAME), showParameter);
            sumResult.append(String.format(ResManager.loadKDString((String)"\n\u7b2c%1$d\u6279    \u5bfc\u5165\u8017\u65f6%2$s \n%3$s", (String)"ExcelImportHelper_12", (String)"sys-ricc-platform", (Object[])new Object[0]), i, TimeCostUtil.getUsedTime((long)start, (long)System.currentTimeMillis()), subResult.getReport()));
            if (!subResult.isSuccess()) {
                sumResult.setSuccess(false);
            }
            sumResult.setTotal(sumResult.getTotal() + subResult.getTotal());
            sumResult.setFailed(sumResult.getFailed() + subResult.getFailed());
        }
        return sumResult;
    }

    public static Object createImportlog(String name) {
        MainEntityType objType = EntityMetadataCache.getDataEntityType((String)"bos_importlog");
        DynamicObject dyn = (DynamicObject)objType.createInstance();
        dyn.set("name", (Object)name);
        dyn.set("billstatus", (Object)"C");
        dyn.set("importstatus", (Object)"0");
        dyn.set("createtime", (Object)TimeServiceHelper.now());
        ICodeRuleService coderule = (ICodeRuleService)ServiceFactory.getService(ICodeRuleService.class);
        String billno = coderule.getNumber("bos_importlog", dyn, null);
        dyn.set("billno", (Object)billno);
        dyn = (DynamicObject)SaveServiceHelper.save((IDataEntityType)objType, (Object[])new Object[]{dyn})[0];
        return dyn.getPkValue();
    }

    private static boolean isComplete(Object logId) {
        return QueryServiceHelper.exists((String)"bos_importlog", (QFilter[])new QFilter("id", "=", logId).and("importstatus", "=", (Object)"1").toArray());
    }

    private static String openFormView(String formId, FormShowParameter parameter) {
        FormConfigFactory.createConfig((FormShowParameter)parameter);
        DispatchServiceHelper.invokeBOSServiceByFormId((String)formId, (String)"FormService", (String)"batchInvokeAction", (Object[])new Object[]{parameter.getPageId(), "[{\"key\":\"\",\"methodName\":\"loadData\",\"args\":[],\"postData\":[]}]"});
        return parameter.getPageId();
    }

    private static void closeFormView(String formId, String pageId) {
        DispatchServiceHelper.invokeBOSServiceByFormId((String)formId, (String)"FormService", (String)"batchInvokeAction", (Object[])new Object[]{pageId, "[{\"key\":\"toolbarap\",\"methodName\":\"itemClick\",\"args\":[\"tblclose\",\"close\"],\"postData\":[{},[]]}]"});
    }

    private static void coverBillCreatorInfo(String entityNumber, ArrayList<String> coverProps, List<String> conditionMustFields, List<String> coverUserFields, InputStream in, OutputStream out) {
        try (SXSSFWorkbook wb = new SXSSFWorkbook(3000);){
            if (!(coverProps.isEmpty() && conditionMustFields.isEmpty() && coverUserFields.isEmpty())) {
                ExcelReader excelReader = new ExcelReader();
                excelReader.read(in, new BillCoverSheetHandler(wb, coverProps, conditionMustFields, coverUserFields, entityNumber));
            }
            wb.write(out);
            wb.dispose();
        }
        catch (Exception e) {
            String msg = ResManager.loadKDString((String)"\u5904\u7406excel\u6587\u4ef6\u7684\u5236\u5355\u4eba\u4fe1\u606f\u6216\u6761\u4ef6\u5fc5\u5f55\u5b57\u6bb5\u65f6\u53d1\u751f\u5f02\u5e38\uff1a", (String)"ExcelImportHelper_13", (String)"sys-ricc-platform", (Object[])new Object[0]);
            throw new RiccBizException(msg, (Throwable)e);
        }
    }

    private static ArrayList<String> getNeedCoverProps(String entityNumber) {
        ArrayList<String> coverProps = new ArrayList<String>();
        String coverConfig = SysParaUtil.getBillCreateInfoCoverConfig();
        DataEntityPropertyCollection props = EntityMetadataCache.getDataEntityType((String)entityNumber).getProperties();
        ExcelImportHelper.loadNeedCoverProps(coverConfig, coverProps, props, false);
        return coverProps;
    }

    private static void loadNeedCoverProps(String coverConfig, ArrayList<String> coverProps, DataEntityPropertyCollection props, boolean isEntryProp) {
        for (IDataEntityProperty prop : props) {
            boolean isImportable;
            if (prop instanceof EntryProp) {
                DataEntityPropertyCollection entryProperties = ((EntryProp)prop).getDynamicCollectionItemPropertyType().getProperties();
                ExcelImportHelper.loadNeedCoverProps(coverConfig, coverProps, entryProperties, true);
                continue;
            }
            if (!(prop instanceof IFieldHandle) || !(isImportable = ((IFieldHandle)prop).isImportable())) continue;
            String propName = prop.getName();
            if (prop instanceof CreaterProp || prop instanceof CreateDateProp) {
                if (!"all".equals(coverConfig)) continue;
                coverProps.add(propName);
                continue;
            }
            if (!(prop instanceof ModifierProp) && !(prop instanceof ModifyDateProp)) continue;
            coverProps.add(propName);
        }
    }

    public static Map<String, Object> getImportOpInfo(String entityNumber) {
        List ops = EntityMetadataCache.getDataEntityOperate((String)entityNumber);
        Map importOp = null;
        for (Map op : ops) {
            String opType = (String)op.get("type");
            if (!"importdata".equals(opType)) continue;
            importOp = op;
            break;
        }
        return importOp;
    }
}

